#!/bin/sh
# the next line restarts this script using wish found in the path\
exec wish "$0" "$@"
# If this does not work, change the #!/usr/bin/wish line below
# to reflect the actual wish location and delete all preceeding lines
#
# (delete here and above)
#!/usr/bin/wish
# $Id: logic.tcl 332 2009-12-04 15:44:04Z toby $
#
# Where are the rest of the logic files? -- assume that they are in 
# the same location as this script
# translate up to 20 levels of links, if needed
set scriptname [info script]
set i -1
while {[file type $scriptname] == "link"} {
    if {[incr i] >= 20} {
	error "More than $i links for [info script], giving up"
	exit
    }
    if {[file pathtype [set link [file readlink $scriptname]]] == "absolute"} {
	set scriptname $link
    } {
	set scriptname [file dirname $scriptname]/$link
    }
}

namespace eval logicGUI {
    set settings(home) [file dirname $::scriptname]
}

source [file join $::logicGUI::settings(home) logicGUI.tcl]

set msg ""
if {$logic::status == "fail"} {
    set msg "Unable to initialize the database. Is it installed correctly?"
} elseif {$logic::status == "error"} {
    set msg "Error initiating the logic package. Are the program files compiled properly?"
}
if {$msg != ""} {
    catch {
	append msg "\n\nError message is:\n" $logic::errmsg
    }
    tk_dialog .warn "ICDD init error" $msg error 0 Abort
    exit
}

if {$tcl_platform(platform) == "windows"} {
    set initfile ~/logic.init 
} else {
    set initfile ~/.logic_init 
}

if [file exists $initfile] {
    if [catch {source $initfile} errmsg] {
	tk_dialog .warn "Warning" \
		"Error reading [file nativename $initfile]: $errmsg" {} 0 OK
    }
}

#create a 
#toplevel .logic
#wm withdraw .
#::logicGUI::CreateLogicSubwin .logic

# create the GUI in the main window
::logicGUI::CreateLogicSubwin .
