# write data out in a GSAS fxye file format.
# R. Von Dreele
# 11/1/06

lappend command(writetypes) "GSAS 1 line/point file (.fxye)"
lappend command(writeproc) writegsasfxye

proc writegsasfxye {data} {
    global graph command
    global $data
    set filename [file join $command(pwd) ${data}.fxye]
    if {$command(write_useSaveAs)} {
	set filename [tk_getSaveFile -title "Select output file" -parent . \
			  -initialdir [file dirname $filename] \
			  -initialfile [file tail $filename]]
	if {[string trim $filename] == ""} return
    }

    if {[set ${data}(type)] == "peaks"} {
	# write a peak file
	MyMessageBox -title "Not implemented" -type OK -default ok \
	    -message "Peaks file not implemented for this format"
    } else {
	set fil [open $filename w]
	if {$command(writeunits) == 0} {
	    set ydata [set ${data}(y)]
	    set xdata [set ${data}(x)]
	    set esddata [set ${data}(esd)]
	} else {
	    set ydata [[set ${data}(yvector)] range 0 end]
	    set xdata [[set ${data}(xvector)] range 0 end]
	    set esddata [[set ${data}(esdvec)] range 0 end]
	}
	# write a data file in a gsas format
	puts $fil "Automatically generated file $data from CMPR"
	set ibank 1
	# total number of data points
	set nchan [llength $ydata]
	# starting angle in centi degrees
	set bcoef1 [expr {100.0 * [lindex $xdata 0]} ]
	# step size
	set bcoef2 [expr {100.0 * ([lindex $xdata 1] -  [lindex $xdata 0])} ]
  	# place holder used twice in BANK lin
	set bcoef3 0
	set bnk "BANK"
	set const "CONS"
	set endd "FXYE"
	# BANK line format
	set line [format "%s %2d %8d%8d %s %10.2f%10.2f%2d%2d %s"  \
		      $bnk $ibank $nchan $nchan $const $bcoef1 $bcoef2 $bcoef3 $bcoef3 $endd ]
	puts $fil "$line"
      	# line for debugging
	#puts "$line"
	set i 0
	set j 0
	# print out line by line the position, intensity and esd.
	while { $i <  $nchan } {
            incr i
            set line [format "%15.6g%15.6g% 12.4g" \
			  [expr {100*[lindex $xdata $j]}] \
			  [lindex $ydata $j] \
			  [lindex $esddata $j]]
            incr j 1
            puts $fil "$line"
	}
    }
    close $fil
    return $filename
}
