# The purpose of this file is to write a cmpr project file whereby a user
# can save a working session.  Only datasets that are selected will be saved
# since selecting all datasets is as simple as a right click in the box
# it is not a hassle to save all of the datasets, and this retains some flexibility
# in the files that are saved.  A user does not have to delete data sets if he
# only wants to save some but not others

# In order to make this routine work, it was necessary to add a few lines to the
# WriteFiles proc found in write.tcl.  Instead of looping through all selected
# datasets, and passing each to the write routine, when writeCMPR is called,
# the entire box is sent to the write routine, which then creates a project file
# and then loops through the selected datasets, writing each one to the same file

# as of Nov 10, 2009, this routine is less than 2 weeks old, and may need much more
# testing, so be warned while using it.

# TMM 11/18/2009:
# Right now, list2csv is only used to write the dataset header line. It should be
# expanded to include any lines that might contain the "," character within a value.

# write_cmpr.tcl - by D. Vincent West and Tyrel M. McQueen

# list2csv from http://code.activestate.com/recipes/65433/ on November 18, 2009

# current version: alpha - 0.21
# release date: Nov 18, 2009

lappend command(writetypes) "CMPR Project (.cmpr)"
lappend command(writeproc) writeCMPR
set command(writeCMPR) {listok}

proc list2csv {list {sepChar ,}} {
    set out ""
    set sep {}
    foreach l $list {
	if {[string match "*\[\"$sepChar\]*" $l]} {
		append out $sep\"[string map [list \" \"\"] $l]\"
        } else {
		append out $sep$l
	}
	set sep $sepChar
    }
    return $out
}

proc writeCMPR {datalist} {
    global graph command cellparm
    set filename [file join $command(pwd) newproject.cmpr]
    
    # because this is a project file, we always prompt for a filename
    # as it would be inappropriate to name the project after only a
    # single data set, and there isn't a way to set a project name
    # within the gui
    set filename [tk_getSaveFile -title "Select output file" -parent . \
		      -initialdir [file dirname $filename] \
		      -initialfile [file tail $filename]]
    # TMM: Return an error message, rather than nothing
    if {[string trim $filename] == ""} { 
	return -code error "No Output File Specified!" 
    }
	
    set fil [open $filename w]
    
    puts $fil "CMPR PROJECT FILE"
    puts $fil "created on [clock format [clock seconds]]"
    # TMM: Do you want to loop over only selected datasets? (just checking)
	
    puts $fil "###ENVIRONMENT SETTINGS###"
	
    puts $fil "twothetamax,ymin,ymax,wavelength,fontsize"
    puts $fil [list2csv [ list "$cellparm(twothetamax)" "$cellparm(ymin)" "$cellparm(ymax)" "$cellparm(wavelength)" "$cellparm(fontsize)"]]
    puts $fil "legend,font,ReversePlotOrder,LabelByTitle"
    puts $fil [list2csv [ list "$graph(legend)" "$graph(font)" "$graph(ReversePlotOrder)" "$graph(LabelByTitle)"]]
	
    foreach data $datalist {
	global $data
	puts $fil "###NEW DATASET###"

	#write a peaks dataset		
	if {[set ${data}(type)] == "peaks"} {
			
	    # first we specify the type of data, which is important for
	    # the read routine as there are only two types of data in CMPR
	    puts $fil [list2csv [list "dataset" "${data}" "type" "[set ${data}(type)]"]]
	    
	    # peaks datasets that were created in the EditCell pane automatically are assigned
	    # a laue variable, which is the number of the crystal class "cubic, tetragonal etc.
	    # However, imported peaks files through Logic, or some other means, may not have this
	    # variable assigned, and it is necessary to check.  If this variable is absent, it is
	    # assigned a value of 1, which equals triclinic
	    if {[info exists ${data}(laue)] != 1} { set ${data}(laue) 1 }
	    
	    # next we set the data parameters that only have one value,
	    # the first row are the array indices of $data, and the second
	    # row are the values of those indices
	    puts $fil "title,line,color,symbol,symsize,xlabel,ylabel,cxlabel,cylabel,wavelength,xunits,a,b,c,alpha,beta,gamma,old_a,old_b,old_c,old_alpha,old_beta,old_gamma,laue"
	    puts $fil [list2csv [ list "[set ${data}(title)]" "[set ${data}(line)]" "[set ${data}(color)]" "[set ${data}(symbol)]" "[set ${data}(symsize)]" "[set ${data}(xlabel)]" "[set ${data}(ylabel)]" "[set ${data}(cxlabel)]" "[set ${data}(cylabel)]" "[set ${data}(wavelength)]" "[set ${data}(xunits)]" "[set ${data}(a)]" "[set ${data}(b)]" "[set ${data}(c)]" "[set ${data}(alpha)]" "[set ${data}(beta)]" "[set ${data}(gamma)]" "[set ${data}(old_a)]" "[set ${data}(old_b)]" "[set ${data}(old_c)]" "[set ${data}(old_alpha)]" "[set ${data}(old_beta)]" "[set ${data}(old_gamma)]" "[set ${data}(laue)]"]]
			
	    # now we put in the data parameters for each peak, or each hkl
	    puts $fil "x,y,ttvector,h,k,l,extinctions,dspaces,widths,etas,heights,bkgs"
	    foreach \
		x   [set ${data}(x)] \
		y   [set ${data}(y)] \
		tt	[[set ${data}(ttvector)] range 0 end] \
		h 	[set ${data}(h)] \
		k	[set ${data}(k)] \
		l	[set ${data}(l)] \
		ext [set ${data}(extinctions)] \
		dsp [set ${data}(dspaces)] \
		wid [set ${data}(widths)] \
		eta [set ${data}(etas)] \
		hgt [set ${data}(heights)] \
		bkg [set ${data}(bkgs)] \
		{				
		    # the following if statement is to protect against a CMPR bug which adds
		    # extra bkg values during re-scaling of the peak sets, changing the extincitons
		    # or other modifications, resulting in sets of data where all values are null,
		    # except for bkg, which has a value of 0
		    if { $x == "" } { break }
		    puts $fil [list2csv [ list "$x" "$y" "$tt" "$h" "$k" "$l" "$ext" "$dsp" "$wid" "$eta" "$hgt" "$bkg"]]
		}
	    
	    puts $fil "#--vector data--#"
	    # the xvector and yvector are used to actually draw the peak information on the plots
	    # however, under certain circumstances, the raw data in the arrays above may contain
	    # hkl values for extinct peaks, that are not drawn on the plot, and hence the extinctions
	    # are actually absent from the vector values.  Hence, the number of vector values does not
	    # always line up with the number of hkl values, and they must be parsed separately to avoid
	    # extra null or 0 values in the vector data sets that mess up the plot drawings
	    puts $fil "xvector,xvector,xvector,yvector,yvector,yvector"
	    foreach \
		{xv1 xv2 xv3} [[set ${data}(xvector)] range 0 end] \
		{yv1 yv2 yv3} [[set ${data}(yvector)] range 0 end] \
		{ 
		    # we write the values in triplet because there are three vector points for every hkl
		    puts $fil [list2csv [ list "$xv1" "$xv2" "$xv3" "$yv1" "$yv2" "$yv3"]]
		}
	}
	
	#write an xy dataset
	if {[set ${data}(type)] == "xy"} {
	    
	    # again, we specify the all important data type
	    puts $fil "dataset,${data},type,[set ${data}(type)]"
	    
	    # data parameters with only one value
	    puts $fil "title,line,color,symbol,symsize,wavelength,xunits,xlabel,ylabel,cxlabel,cylabel"
	    puts $fil [list2csv [list "[set ${data}(title)]" "[set ${data}(line)]" "[set ${data}(color)]" "[set ${data}(symbol)]" "[set ${data}(symsize)]" "[set ${data}(wavelength)]" "[set ${data}(xunits)]" "[set ${data}(xlabel)]" "[set ${data}(ylabel)]" "[set ${data}(cxlabel)]" "[set ${data}(cylabel)]"]]
	    
	    # now we set the data parameters for each data point
	    puts $fil "x,y,esd,xvector,yvector,esdvec"
	    foreach \
		x   [set ${data}(x)] \
		y   [set ${data}(y)] \
		e	[set ${data}(esd)] \
		xs  [[set ${data}(xvector)] range 0 end] \
		ys  [[set ${data}(yvector)] range 0 end] \
		ev	[[set ${data}(esdvec)] range 0 end] {				
		    if { $x == "" } { break }
		    puts $fil [list2csv [list "$x" "$y" "$e" "$xs" "$ys" "$ev"]]
		}
	}
	puts $fil "###END DATASET###"
    }
    
    close $fil
    return $filename
}
