      include 'copyrght.def'
C------------------------------------------------------------------------
      integer*4 function psl_strngsrch(ilogic, stringlist,
     $     stringstack, numstrings, fields)
C------------------------------------------------------------------------
C loop through all entries and search for matching strings
C
C ilogic determines the logic to be applied to the tables
C	0	 Match with table
C	2	 Remove new table from old table
C    
C    stringstack contains numstrings strings
C    fields determines which fields are searched
C
      implicit none
      INTEGER*4 ilogic
      CHARACTER*(*) stringlist
      INTEGER*4 stringstack, numstrings             ! pointers, passed thru
      INTEGER*4 fields(6)
C returns the number of valid entries located
C-----------------------------------------------------------------------
      include 'bitops.def'
      include 'pdfdefs.par'
      include 'logic.cmn'
      include 'pdf.cmn'

      integer i,j
      integer*4 nseq, ncrd
      integer npt,dipt,refpt,cdpt
      CHARACTER*20 temp
      CHARACTER*100 TRACE

      include 'pdfread.def'
      INTEGER LENCH
      INTEGER LN
      CHARACTER*(*) subrnm
      PARAMETER (subrnm='psl_StrngSrch')

      nph1 = TBLCLR(TABLE1,N_Cards)
      trace = 'String search: '//stringlist(:lench(stringlist))//' in'
      if (fields(1) .gt. 0) trace(lench(trace)+1:) = ' Formula,'
      if (fields(2) .gt. 0) trace(lench(trace)+1:) = ' Chemical name,'
      if (fields(3) .gt. 0) trace(lench(trace)+1:) = ' Mineral name,'
      if (fields(4) .gt. 0) trace(lench(trace)+1:) = ' Common name,'
      if (fields(5) .gt. 0) trace(lench(trace)+1:) = ' Authors,'
      if (fields(6) .gt. 0) trace(lench(trace)+1:) = ' Coden,'
      trace(lench(trace):lench(trace)) = ' '
      psl_strngsrch = 0
      do I=1,N_cards
         if (tblbittest(TABLE,i,N_cards) .eq. 1) then
            j = ps_readindex(i,ncrd,npt,dipt,refpt,cdpt)
            if (j .ne. 0) then
               psl_strngsrch = -1
               write(temp,*) nseq
               ln = lench(temp)
               call errmsg(subrnm,'readindex for entry '//temp(:ln))
               return
            endif

            j = ps_srchlibs(npt, refpt,
     $           stringstack, numstrings, fields)
            if (j .ge. 1) then
               psl_strngsrch = psl_strngsrch + 1
               CALL TBLBITSET(TABLE1,i,N_cards,1)
            elseif (j .lt. 0) then
               psl_strngsrch = -2
               write(temp,*) nseq,ncrd
               ln = lench(temp)
               call errmsg(subrnm,'srchlibs for entry '//temp(:ln))
               return
            endif
         endif
      enddo

C	write (*,'(A,i6)') 'TABLE = ',tblcount(table,N_Cards)
C	write (*,'(A,i6)') 'TABLE1 = ',tblcount(table1,N_Cards)
C	write (*,'(A,i6)') 'ilogic=',ilogic

      CALL TBLLOGIC(ilogic, trace)
C	write (*,'(2A)') 'after TBLLOGIC, trace=',trace
C	write (*,'(A,i6)') 'TABLE = ',tblcount(table,N_Cards)

      return
      end
