      include 'copyrght.def'
C-----------------------------------------------------------------------
      integer*4 function psl_peaksub(numpeaks, peaklist, errlist,
     $     allflag, intlevel, fastflag, ilogic, wave)
C locate entries based on peak positions
C-----------------------------------------------------------------------
!MS$ATTRIBUTES C, REFERENCE :: psl_peaksub
      implicit none
      integer*4 numpeaks, allflag, intlevel, fastflag, ilogic
      real*4 peaklist(*), errlist(*)
      real*4 wave
C-----------------------------------------------------------------------
C numpeaks is the number of d-spaces in peaklist with search window in errlist
C ilogic determines the logic to be applied to the tables
C	0	 Match with table
C	1	 Add to table
C	2	 Remove from table
C allflag  = 0 all specified peaks must be located; =1 ok to locate any 1 peak
C intlevel  = 00-99 -- use dspXX.bit index file 
C          = 100 -- use 3-strongest
C fastflag = 0 fast search; =1 exact search
C wave     = 0 original input as d-spaces
C          < 0 original input as Q
C          > 0 original input as 2theta angles
C-----------------------------------------------------------------------
	include 'bitops.def'
	include 'pdfread.def'

	include 'pdfdefs.par'

	include 'pdf.cmn'
	include 'logic.cmn'

        integer*4 psrepdi
        real peakfromd
        integer lench
	LOGICAL FLAG,DTOTT,TTTOD,DTOPDF,PDFTOD,DTOIND,INDTOD
        character*100 string
        character*20 tempstr

        integer aindex,i,j,k,status,hit
        real x,err,dmax,dmin
        integer ndsp, INTEN(255), DSP(255)
        real pdmin(255),pdmax(255)
        integer pdf1, pdf2, pdfmin(255), pdfmax(255)
        integer ind, ind1(255), ind2(255)
        integer i1,i2,i3

	do i=numpeaks,1,-1
C is the peak at a valid location in the index?
	  x = peaklist(i)
	  flag = DTOIND(x,ind,N_REG)
	  IF (.not. FLAG) then
	    WRITE (string,'(A,F7.3)') 
	1	' Invalid peak at',peaklist(i)
            call warnmsg('peaksub',string)
	    numpeaks = numpeaks - 1
	    do j=i,numpeaks
	      peaklist(j) = peaklist(j+1)
	      errlist(j) = errlist(J+1)
	    enddo	 
	  ENDIF
	enddo

	IF (NUMPEAKS .eq. 0) THEN
           call errmsg('peaksub','no peaks input for search')
           psl_peaksub = -1
           return
	endif

	do i=1,numpeaks
	  if (fastflag .ne. 0 .and. errlist(i) .le. 0) then
            call warnmsg('peaksub',
     $            'Ignoring Exact mode -- peak error range is 0')
            fastflag = 0
	  ENDIF
C convert peak to index range
          pdmin(i) = peaklist(i) - errlist(i)
          pdmax(i) = peaklist(i) + errlist(i)
	  flag = DTOIND(pdmax(i),ind1(i),N_REG)
	  flag = DTOIND(pdmin(i),ind2(i),N_REG)
	ENDDO

C get the appropriate index file
        if (intlevel .gt. 99) then
           aindex = -1
           call ps_opendsp(status,aindex)
           if (status .ne. 0) then
              call errmsg('peaksub',
     $             'unable to open the 3strongest peak index file')
              psl_peaksub = -2
              return
           ENDIF
        else
           aindex = intlevel
           call ps_opendsp(status,aindex)
           do while (status .ne. 0 .and. aindex .gt. 0)
              aindex = 10 * int((aindex-1)/10.)
              call ps_opendsp(status,aindex)
           enddo
           if (status .ne. 0) then
              call errmsg('peaksub',
     $             'unable to open any peak index file')
              psl_peaksub = -2
              return
           endif
	ENDIF
C--------------------------------------------------------------------------
C----------------------------------------------------------------------
C start FAST search
	IF (allflag .eq. 0) then
C AND together d's -- start with all hits and then eliminate
	  nph1 = TBLSET(TABLE1,N_Cards)
	ELSE
C OR together d's -- start with blank slate
	  nph1 = TBLCLR(TABLE1,N_Cards)
	ENDIF

	DO i=1,numpeaks
          k = ps_readbitlib(ind1(I), table2, N_cards)
	  DO j=ind1(i)+1,ind2(i)
             k = ps_readbitlib(j, table3, N_cards)
             CALL TBLOR(TABLE3,TABLE2,TABLE2,N_Cards)
	  ENDDO
!	  temp = FORMNUM(peaklist(i),3,len)
!	  parm = 'peak @ '//temp(1:len)//' +- '
!	  k = 11 + len
!	  temp = FORMNUM(errlist(i),3,len)
!	  parm = parm(1:k)//temp(1:len)//' (actual range: '
!	  k = k + len + 16
!	  FLAG = INDTOD(ind1(i),ind2(i),DMAX,DMIN,N_REG)
!	  IF (wave .gt. 0) then
C	convert D's to 2T's
!	    flag = DTOTT(DMAX,TTMIN,wave)
!	    flag = DTOTT(DMIN,TTMAX,wave)
!	    dmax = ttmax
!	    dmin = ttmin
!	  ENDIF
!	  temp = FORMNUM(dmin,3,len)
!	  parm = parm(1:k)//temp(1:len)//' to '
!	  k = k + len + 4
!	  temp = FORMNUM(dmax,3,len)
!	  parm = parm(1:k)//temp(1:len)//')'
!	  k = k + len + 1
C count the number of matching cards
!	  CALL TBLCOUNT(TABLE2,N_Lwords,nph2)
!	  write (lo,'(1x,a,i6)') parm(1:k)//'  # entries =',nph2

          IF (allflag .eq. 0) then
C AND together d's
	    CALL TBLand(TABLE1,TABLE2,TABLE1,N_Cards)
	  ELSE
C OR together d's
	    CALL TBLOR(TABLE1,TABLE2,TABLE1,N_Cards)
	  ENDIF
	ENDDO
C now done with the index
	call ps_closebitlib

C if this is /FAST mode, we are done, if not we still have the /EXACT left
	IF (fastflag .eq. 0) goto 100
C----------------------------------------------------------------------
C----------------------------------------------------------------------
C now narrow down the range by applying the /EXACT constraints 
C  Minimum allowable intensity: intlevel
C  convert the peak positions to PDF values
	do 31 i=1,numpeaks
	  flag = dtoPDF(pdf1,pdmin(i))
	  if (.not. flag) goto 31
	  flag = dtoPDF(pdf2,pdmax(i))
	  if (.not. flag) goto 31
	  pdfmin(i) = min(pdf1,pdf2)
	  pdfmax(i) = max(pdf1,pdf2)
 31    ENDDO
C count the number of matching cards
!	CALL TBLCOUNT(TABLE1,N_Lwords,nph1)
!	write (lo,'(a,i6)') ' Before /EXACT constraint: # entries =',nph1
	IF (ilogic .eq. 0) then
	  CALL TBLAND(TABLE,TABLE1,TABLE1,N_Cards)
!	  CALL TBLCOUNT(TABLE1,N_Lwords,nph1)
!	  write (lo,'(a,i6)')
!	1 ' Preapplying MATCH step reduces # of entries to ',nph1
	ENDIF
C-----------------------------------------------------------------------
C   OR logic -- at least one peak must match
	IF (allflag .ne. 0) then
C     clear table2
!           nph2 = TBLCLR(TABLE2,N_Cards)
C     loop through table, check each hit
!           write (*,*) 'pdfmin pdfmax: ',
!     $          (pdfmin(k),pdfmax(k),i=1,numpeaks) 
           do 83 I=1,N_cards
              IF (TABLE1(1 + (I-1)/32) .NE. 0) then 
                 if (tblbittest(TABLE1,i,N_cards) .eq. 1) then
                    k = psrepdi(I, ndsp, INTEN, DSP)
!                    write(*,*) (DSP(j),j=1,ndsp)
C     get the height of the three strongest peaks
                    if (aindex .lt. 0) then
                       i1 = 0
                       i2 = 0
                       i3 = 0
                       do j=1,ndsp
                          if (INTEN(j) .ge. i1) then
                             i1 = INTEN(j)
                          elseif (INTEN(j) .ge. i2) then 
                             i2 = INTEN(j)
                          elseif (INTEN(j) .ge. i3) then 
                             i3 = INTEN(j)
                          endif
                       enddo
C     set intlevel to the third strongest height
                       intlevel = i3
                    endif
                    do j=1,ndsp
                       do k=1,numpeaks
                          if (DSP(j) .ge. pdfmin(k) .and.
     $                         DSP(j) .le. pdfmax(k) .and.
     $                         INTEN(j) .ge. intlevel) goto 83
C     we found a matching peak on this card, now go on to next
                       ENDDO
                    ENDDO
C no peaks matched
                    CALL tblBITSET(TABLE1,I,N_cards,0)
                 endif
              endif
 83        ENDDO
C-----------------------------------------------------------------------
C   AND logic -- all cards must have a match for every peak
	ELSE
C     loop through table, check each hit
           do 84 I=1,N_cards
              IF (TABLE1(1 + (I-1)/32) .NE. 0) then 
                 if (tblbittest(TABLE1,i,N_cards) .eq. 1) then
                    k = psrepdi(I, ndsp, INTEN, DSP)
C     get the height of the three strongest peaks
                    if (aindex .lt. 0) then
                       i1 = 0
                       i2 = 0
                       i3 = 0
                       do j=1,ndsp
                          if (INTEN(j) .ge. i1) then
                             i1 = INTEN(j)
                          elseif (INTEN(j) .ge. i2) then 
                             i2 = INTEN(j)
                          elseif (INTEN(j) .ge. i3) then 
                             i3 = INTEN(j)
                          endif
                       enddo
C     set intlevel to the third strongest height
                       intlevel = i3
                    endif
                    do k = 1,numpeaks
                       hit = 0
                       j = 0
                       do while (j .lt. ndsp .and. hit .eq. 0)
                          j = j + 1
                          if (DSP(j) .ge. pdfmin(k) .and.
     $                         DSP(j) .le. pdfmax(k) .and.
     $                         INTEN(j) .ge. intlevel) hit=1
                       enddo
C          this peak was not matched, reject the card
                       if (hit .eq. 0) then
                          CALL TBLBITSET(TABLE1,I,N_cards,0)
                          goto 84
                       endif
                    ENDDO
                 ENDIF
              ENDIF
 84        ENDDO
        ENDIF
C========================================================================
C now setup the history entry
C========================================================================
C Assemble history line
 100    IF (allflag .eq. 0) THEN
	  string = 'all peaks: '
	ELSE
	  string = '1 peak of: '
	ENDIF

	DO i=1,numpeaks
C determine range used in FAST search
	  IF (fastflag .eq. 0) then
	    FLAG = INDTOD(ind1(i),ind2(i),DMAX,DMIN,N_REG)
	  ELSE
C set actual range for /EXACT search
	    X = peaklist(i) 
	    err = errlist(i)
            dmin = x + err
            dmax = x - err
	  ENDIF
C   convert d's back to angles/Q
          dmin = peakfromd(dmin,wave)
          dmax = peakfromd(dmax,wave)
C round down (by subtracting 0.0005)
          X = (DMAX + DMIN)/2.
          err = abs(dMAX - X) - 0.0005
          write (tempstr,'(f8.2)') X
          j = 1
          do while (tempstr(j:j) .eq. ' ')
             j = j + 1
          enddo
          string(lench(string)+2:) = tempstr(j:lench(tempstr)) // '+-'
          if (err .gt. 0.02) then
             write (tempstr,'(f8.2)') err
          elseif (err .gt. 0.002) then
             write (tempstr,'(f8.3)') err
          else
             write (tempstr,'(f8.4)') err
          endif
          j = 1
          do while (tempstr(j:j) .eq. ' ')
             j = j + 1
          enddo
          string(lench(string)+1:) = tempstr(j:lench(tempstr)) // ','
	ENDDO
	IF (wave .gt. 0) then
          write (tempstr,'(f9.4)') wave
          j = 1
          do while (tempstr(j:j) .eq. ' ')
             j = j + 1
          enddo
          string(lench(string)+2:) = '(2theta @ ' //
     $         tempstr(j:lench(tempstr)) // 'A),'
	ELSEIF (wave .lt. 0) then
          string(lench(string)+2:) = '(Q, A-1),'
	ELSE
	  string(lench(string)+2:) = '(dspace, A),'
	ENDIF
	IF (aindex .eq. -1) THEN
	  string(lench(string)+1:) = ' in 3Strongest'
	ELSE
           j = intlevel
           IF (fastflag .eq. 0) j = aindex
           write (tempstr,'(i2.2)') j
           string(lench(string)+1:) = ' int > ' //tempstr(1:2)//'%'
	ENDIF
	IF (fastflag .eq. 0) then
	  string(lench(string)+2:) = '(Fast)'
	ELSE
	  string(lench(string)+2:) = '(Exact)'
	ENDIF

	CALL TBLLOGIC(ilogic, string)
        psl_peaksub = 0
	END
C-----------------------------------------------------------------------
      real*4 function psl_peakfromd(dspace,wave)
C     convert peak from d-space to two-theta or Q
      implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_peakfromd 
      real*4 dspace, wave
C-----------------------------------------------------------------------
C wave = 0 -- no conversion
C wave < 0 -- convert to Q
C wave > 0 -- convert to 2theta @ wave
C if conversion is not possible, return a negative value.
C-----------------------------------------------------------------------
      real*4 peakfromd
      psl_peakfromd = peakfromd(dspace,wave)
      return
      end
C
C-----------------------------------------------------------------------
      real*4 function psl_peaktod(peak,wave,indflag)
C     convert peak to d-space from two-theta or Q
      implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_peaktod 
      real*4 peak, wave
      integer*4 indflag
C-----------------------------------------------------------------------
C wave = 0 -- no conversion
C wave < 0 -- convert to Q
C wave > 0 -- convert to 2theta @ wave
C if conversion is not possible, return a negative value.
C-----------------------------------------------------------------------
      real*4 peaktod 
      psl_peaktod = peaktod(peak,wave,indflag)
      return
      end
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
      real*4 function peakfromd(dspace,wave)
C     convert peak from d-space to two-theta or Q
      implicit none
      real*4 dspace, wave
C-----------------------------------------------------------------------
C wave = 0 -- no conversion
C wave < 0 -- convert to Q
C wave > 0 -- convert to 2theta @ wave
C if conversion is not possible, return a negative value.
C-----------------------------------------------------------------------
      logical flag, dtott
      if (wave .eq. 0 .and. dspace .gt. 0) then
         peakfromd = dspace
      elseif (wave .eq. 0) then
         peakfromd = -1.
      elseif (wave .lt. 0 .and. dspace .gt. 0) then
         peakfromd = 2. * 3.141592654 / dspace
      elseif (wave .lt. 0) then
         peakfromd = -1.
      else
	 flag = DTOTT(dspace,peakfromd,wave)
         if (.not. flag) peakfromd = -1. 
      endif
      return
      end
C
C-----------------------------------------------------------------------
      real*4 function peaktod(peak,wave,indflag)
C     convert peak to d-space from two-theta or Q
      implicit none
      real*4 dspace, wave
      integer*4 indflag
C-----------------------------------------------------------------------
C wave = 0 -- no conversion
C wave < 0 -- convert to Q
C wave > 0 -- convert to 2theta @ wave
C if conversion is not possible, return a negative value.
C-----------------------------------------------------------------------
      include 'pdf.cmn'
      logical flag, tttod, dtoind
      real peak
      integer ind

      if (wave .eq. 0 .and. peak .gt. 0) then
         dspace = peak
      elseif (wave .eq. 0) then
         dspace = -1.
      elseif (wave .lt. 0 .and. peak .gt. 0) then
         dspace = 2. * 3.141592654 / peak
      elseif (wave .lt. 0) then
         dspace = -1.
      else
	 flag = TTTOD(dspace,peak,wave)
         if (.not. flag) dspace = -1. 
      endif
      peaktod = dspace
      if (indflag .eq. 0 .and. dspace .gt. 0) then
         if (.not. DTOIND(dspace,ind,N_REG)) peaktod = -1
      endif
      return
      end
