      SUBROUTINE READBF (BUFFER, LENBUF, STATUS)
C
C          Reads the EXAIDS data from BUFFER and places it in the
C          standard COMMONs.  BUFFER and LENBUF are sent by the calling
C          program and assumed to have been filled by SK_SCAN.
C
C          By: Mark Holomany     Date: 20-Oct-1986
C
C          Revised: 14-JUL-87 MAH Converted to MSF V4.0
C
C=======================================================================

      IMPLICIT INTEGER(A-Z)

      CHARACTER     FORM, EDTYPE, NUM(10)
      CHARACTER*6   EDNUM
      CHARACTER*22  TYPE
      CHARACTER*80  BUFFER(135)
      LOGICAL       FOUND1

      INCLUDE 'ioret.cmn'
      INCLUDE 'pdfdata.cmn'

      DATA TYPE/'123456789ABCDEFGHIJK+*'/
      DATA NUM/'0','1','2','3','4','5','6','7','8','9'/


      STATUS = 0
      FOUND1 = .FALSE.
      DO 1 I=1,22
1     NUMC(I) = 0

      NCARDS = LENBUF/80
c	print *,' readbf: ncards= ',ncards
c      IF(NCARDS*81 .NE. LENBUF) THEN
c	 print *,' READBF _LENBUF NOT DIVISIBLE BY 80'
c         CALL ERRTXT ('F', 'READBF - LENBUF NOT DIVISIBLE BY 80')
c         STATUS = 1
c         RETURN
c      ENDIF
      CURCRD = 0
C
C      ...INSERT SEQUENCE NUMBERS IN COL 70:71
      DO 4 J=1,68
      ITENS = J/10
      CARDI(J) (70:70) = NUM(ITENS+1)
      IONES = MOD(J,10)
      CARDI(J) (71:71) = NUM(IONES+1)
4     CONTINUE
C
      GO TO 2000

C      ...Too many of one card type
5	print *,' *** TOO MANY CARDS OF TYPE ',TYPE(ITYPE:ITYPE)
c5     CALL ERRTXT ('E',
c     1  '*** TOO MANY CARDS OF TYPE=' // TYPE(ITYPE:ITYPE) // ' ***')
      STATUS = 1
C
C      ... Position card counter in buffer
2000  CONTINUE
10    CURCRD = CURCRD + 1
c	print *,' readbf: curcrd= ',curcrd
      IF(CURCRD .GT. NCARDS) THEN
	 print *,' CARD K NOT FOUND IN READBF'
c         CALL ERRTXT ('F', 'CARD K NOT FOUND IN READBF')
         STATUS = 1
         RETURN
      ENDIF

      ITYPE = INDEX (TYPE, BUFFER(CURCRD)(80:80))
c	print *,' readbf: buffer(curcrd)',buffer(curcrd)
c	print *,' readbf: itype=',itype
      IF(ITYPE.EQ.0) THEN
	  print *,' INVALID CARD TYPE=',BUFFER(CURCRD)(80:80)
c         CALL ERRTXT ('E', 'INVALID CARD TYPE.  TYPE=' //
c     1     BUFFER(CURCRD)(80:80) )
         STATUS = 1
         GO TO 10
      ENDIF

      IF(ITYPE .EQ. 1) FOUND1=.TRUE.

      IF(.NOT. FOUND1) GO TO 10
      GO TO (101,102,103,104,105,106,107,108,109,110,
     *       111,112,113,114,115,116,117,118,119,120,121,122), ITYPE
C

101   IF(NUMC( 1) .GE. MAX( 1)) GO TO 5
      NUMC(1) = NUMC(1) + 1
      CARD1(NUMC(1)) = BUFFER(CURCRD)
c	print *,'readbf: found card type1, write card1'
c	print *,card1
      GO TO 10

102   IF(NUMC( 2).GE.MAX( 2)) GO TO 5
      NUMC(2) = NUMC(2) + 1
      CARD2(NUMC(2)) = BUFFER(CURCRD)
      GO TO 10

103   IF(NUMC( 3).GE.MAX( 3)) GO TO 5
      NUMC(3) = NUMC(3) + 1
      CARD3 = BUFFER(CURCRD)
      GO TO 10

104   IF(NUMC( 4).GE.MAX( 4)) GO TO 5
      NUMC(4) = NUMC(4) + 1
      CARD4 = BUFFER(CURCRD)
      GO TO 10

105   IF(NUMC( 5).GE.MAX( 5)) GO TO 5
      NUMC(5) = NUMC(5) + 1
      CARD5(NUMC(5)) = BUFFER(CURCRD)
      GO TO 10

106   IF(NUMC( 6).GE.MAX( 6)) GO TO 5
      NUMC(6) = NUMC(6) + 1
      CARD6(NUMC(6)) = BUFFER(CURCRD)
      GO TO 10

107   IF(NUMC( 7).GE.MAX( 7)) GO TO 5
      NUMC(7) = NUMC(7) + 1
      CARD7(NUMC(7)) = BUFFER(CURCRD)
      GO TO 10

108   IF(NUMC( 8).GE.MAX( 8)) GO TO 5
      NUMC(8) = NUMC(8) + 1
      CARD8 = BUFFER(CURCRD)
      GO TO 10

109   IF(NUMC( 9).GE.MAX( 9)) GO TO 5
      NUMC(9) = NUMC(9) + 1
      CARD9(NUMC(9)) = BUFFER(CURCRD)
      GO TO 10

110   IF(NUMC(10).GE.MAX(10)) GO TO 5
      NUMC(10) = NUMC(10) + 1
      CARDA = BUFFER(CURCRD)
      GO TO 10

111   IF(NUMC(11).GE.MAX(11)) GO TO 5
      NUMC(11) = NUMC(11) + 1
      CARDB(NUMC(11)) = BUFFER(CURCRD)
      GO TO 10

112   IF(NUMC(12).GE.MAX(12)) GO TO 5
      NUMC(12) = NUMC(12) + 1
      CARDC = BUFFER(CURCRD)
      GO TO 10

113   IF(NUMC(13).GE.MAX(13)) GO TO 5
      NUMC(13) = NUMC(13) + 1
      CARDD = BUFFER(CURCRD)
      GO TO 10

114   IF(NUMC(14).GE.MAX(14)) GO TO 5
      NUMC(14) = NUMC(14) + 1
      CARDE = BUFFER(CURCRD)
      GO TO 10

115   IF(NUMC(15).GE.MAX(15)) GO TO 5
      NUMC(15) = NUMC(15) + 1
      CARDF = BUFFER(CURCRD)
      GO TO 10

116   IF(NUMC(16).GE.MAX(16)) GO TO 5
      NUMC(16) = NUMC(16) + 1
      CARDG = BUFFER(CURCRD)
      GO TO 10

117   IF(NUMC(17).GE.MAX(17)) GO TO 5
      NUMC(17) = NUMC(17) + 1
      CARDH = BUFFER(CURCRD)
      GO TO 10
C
C       ...SEQUENCE NUMBERS REMAIN FIXED
118   IF(NUMC(18).GE.MAX(18)) GO TO 5
      NUMC(18) = NUMC(18) + 1
      CARDI(NUMC(18)) (1:69)  = BUFFER(CURCRD)(1:69)
      CARDI(NUMC(18)) (72:80) = BUFFER(CURCRD)(72:80)
      GO TO 10

119   IF(NUMC(19).GE.MAX(19)) GO TO 5
      NUMC(19) = NUMC(19) + 1
      CARDJ(NUMC(19)) = BUFFER(CURCRD)
      GO TO 10

120   IF(NUMC(20).GE.MAX(20)) GO TO 5
      NUMC(20) = NUMC(20) + 1
      CARDK = BUFFER(CURCRD)
C
      RETURN

121   IF(NUMC(21).GE.MAX(21)) GO TO 5
      NUMC(21) = NUMC(21) + 1
      CARDP = BUFFER(CURCRD)
      GO TO 10

122   IF(NUMC(22).GE.MAX(22)) GO TO 5
      NUMC(22) = NUMC(22) + 1
      CARDS = BUFFER(CURCRD)
      GO TO 10

      END
