	SUBROUTINE PHCD (STRING, SIZE, STATUS)
C
C	   Routine to produce PDF Card Photocomp Interchange Format
C	   string for the C.D. Cell.
C
C	   By: Mark Holomany, JCPDS     Date: 23-Feb-1984
C
C	   Revised:
C	   09-May-84 by MAH -- don't change "SIZE" if there is no SG#

	IMPLICIT INTEGER (A-Z)

	CHARACTER    STRING*(*)
	CHARACTER    XLSYS
	CHARACTER*4  DLABEL
	CHARACTER*9  FIELD
	CHARACTER*12 INSPG,OUTSPG


	INCLUDE 'ioret.cmn'
	INCLUDE 'pdfdata.cmn'
C\$INCLUDE:'IORET.CMN'
C\$INCLUDE:'PDFDATA.CMN'

	STATUS = 0

	START = 1
	XLSYS = CARD1(1)(79:79)
C
C	... Add "a"
	FIELD = CARDE(1:8)
	CALL LEFT(FIELD(1:8),SIZE)
	END = START + 13 + SIZE - 1
	STRING(START:END) = 'C.D. Cell: a=' // FIELD(1:SIZE)
C
C	... Add "b"
	IF(XLSYS.EQ.'A' .OR. XLSYS.EQ.'M' .OR. XLSYS.EQ.'O') THEN
	   FIELD = CARDE(9:16)
	   START = END + 1
	   CALL LEFT(FIELD(1:8),SIZE)
	   END = START + 4 + SIZE - 1
	   STRING(START:END) =  ', b=' // FIELD(1:SIZE)
	ENDIF
C
C	... Add "c"
	IF(XLSYS.NE.'C') THEN
	   START = END + 1
	   FIELD = CARDE(17:24)
	   CALL LEFT(FIELD(1:8),SIZE)
	   END = START + 4 + SIZE - 1
	   STRING(START:END) =  ', c=' // FIELD(1:SIZE)
	ENDIF
C
C	... Add "alpha"
	IF(XLSYS.EQ.'A' .OR.
	1 (XLSYS.EQ.'M' .AND. CARDE(25:31).NE.'  90.00') ) THEN
	   START = END + 1
	   FIELD = CARDE(25:31)
	   CALL LEFT(FIELD(1:7),SIZE)
	   END = START + 6 + SIZE - 1
	   STRING(START:END) =  ', $GA=' // FIELD(1:SIZE)
	ENDIF
C
C	... Add "beta"
	IF(XLSYS.EQ.'A' .OR.
	1 (XLSYS.EQ.'M' .AND. CARDE(32:38).NE.'  90.00') ) THEN
	   START = END + 1
	   FIELD = CARDE(32:38)
	   CALL LEFT(FIELD(1:7),SIZE)
	   END = START + 6 + SIZE - 1
	   STRING(START:END) =  ', $GB=' // FIELD(1:SIZE)
	ENDIF
C
C	...Add "gamma"
	IF(XLSYS.EQ.'A' .OR.
	1 (XLSYS.EQ.'M' .AND. CARDE(39:45).NE.'  90.00') ) THEN
	   START = END + 1
	   FIELD = CARDE(39:45)
	   CALL LEFT(FIELD(1:7),SIZE)
	   END = START + 6 + SIZE - 1
	   STRING(START:END) =  ', $GG=' // FIELD(1:SIZE)
	ENDIF
C
C	... Add "A"
	IF(XLSYS.NE.'C') THEN
	   START = END + 1
	   FIELD = CARDE(46:54)
	   CALL LEFT(FIELD(1:9),SIZE)
	   END = START + 6 + SIZE - 1
	   IF(XLSYS.EQ.'T' .OR. XLSYS.EQ.'H' .OR. XLSYS.EQ.'R') THEN
	      DLABEL = 'c/a='
	   ELSE
	      DLABEL = 'a/b='
	   ENDIF
	   STRING(START:END) =  ', ' // DLABEL // FIELD(1:SIZE)
	ENDIF
C
C	... Add "C"
	IF(XLSYS.EQ.'A' .OR. XLSYS.EQ.'M' .OR. XLSYS.EQ.'O') THEN
	   START = END + 1
	   FIELD = CARDE(55:62)
	   CALL LEFT(FIELD(1:8),SIZE)
	   END = START + 6 + SIZE - 1
	   STRING(START:END) =  ', c/b=' // FIELD(1:SIZE)
	ENDIF
C
C	... Add C.D. Space Group
	IF(NUMC(4).EQ.1 .AND. 
	1 CARD4(1:8).NE.CARD3(1:8) .AND. CARD4(1:8) .NE. ' ') THEN
	   START = END + 1
	   INSPG = CARD4(1:8)
	   CALL PHSPG(INSPG,OUTSPG)
	   L = LENGTH(OUTSPG)
	   END = START + 7 + L - 1
	   STRING(START:END) =  ', S.G.=' // OUTSPG(1:L)
C
C	   .. Add C.D. SG Number
	   IF(CARD4(11:11).NE.'*') THEN	
	      FIELD = CARD4(12:14)
	      CALL LEFT(FIELD(1:3),SIZE)
	      IF(SIZE .GT. 0) THEN
	         START = END + 1
	         END = START + 3 + SIZE - 1
	         STRING(START:END) =  ' (' // FIELD(1:SIZE) // ')'
	      ENDIF
	   ENDIF
	ENDIF
C
C	... Finish up with a period
	END = END + 1
	STRING(END:END) = '.'
	SIZE = END

	RETURN
	END
