	PROGRAM  pdf2fmt
C
C	This program reads a PDF-2 card from stdin and writes a 
C	it as a formatted entry as stdout. 
C       The radiation is passed in the command line, so that the 
C       program may be called from another routine.
C
C	the syntax is:   pdf2fmt 2/1/S/Q/D/W RAD
C
C	   		 where 	2=2theta 
C			 	1=theta  
C				S=sin(theta) / lambda
C				Q=q
C				D=dspace
C				W=explicit wavelength in next field
C				RAD=radiation
C
C
C This version is for UNIX -- note that GETARG has two arguments!
C
C

	IMPLICIT INTEGER (A-Z)
!	INTEGER*2 ic,stat
	INTEGER*4 ic
	INTEGER*4 IA,iargc,ilength
!	real const
	CHARACTER*80 buffer(135)
!	character ISPACG
	character*100 filename
	character argv*8
	character*2 rad

      include '../srclogic/pdf.cmn'
      integer*4 ps_readdbloc

	include 'ioret.cmn'
	include 'pdfdata.cmn'
	include 'cvtsp.cmn'
	include 'counts.cmn'
	INCLUDE 'ret3.cmn'
	INCLUDE 'picds.cmn'

	integer dbln, cdln

	DBSW = 'PDF2'
	CPDFYR = '2000'

c	pdfind=1
c	pdfdat=2
c	ncoden=3
c	nout=6
c	nin=5

C get the database locations and read database sizes
	i = ps_readdbloc(dbloc, cdloc, localloc,
	1    N_cards,lastcrd,lastsub,N_reg,N_elemc )
	if (i .eq. -1) then
	   write (*,*) 
	1	'Unable to determine the locations of ICDD database'
	elseif (i .eq. -2) then
	   write (*,*) 
	1	'Error reading the locations of ICDD database'
	endif
	cdln = lench(cdloc)
	dbln = lench(dbloc)
C
C	lambda/2 for copper radiation... (default)
	CONST=(1.54056/2)
C
C	default 2theta
	ISPACG='2'

C fill array buffer with data from stdin
	nbytes = 0
	do i=1,135
	   read(5,'(a80)',end=1) buffer(i) 
	   nbytes = nbytes + 80
	   if (buffer(i)(80:80) .eq. 'K') goto 1
	enddo
 1	continue
c	print *,buffer

C	decode the command line
C get number of arguments
	IA=iargc()
	IC=1
	if (ia. eq. 0) then
	   write(0,1020)
 1020	   format(' usage:  pdf2fmt <code> [<wave>] < in > out',
	1	/,' <code> = (2,1,D,S,Q)',
	2	/,' <wave> = (cr,fe,co,cu,mo,ag, or a value)')
	   stop
	endif
!	call getarg(ic,argv,stat)
	call getarg(ic,argv)
	read(argv,'(a)')ISPACG
	call upper(ISPACG)
	if (ISPACG .ne. '1' .and. ISPACG .ne. '2'
	1    .and. ISPACG .ne. 'D' .and. ISPACG .ne. 'S'
	2    .and. ISPACG .ne. 'Q') then
	   write(0,*) 'Error: argument ',argv,' is invalid'
	   write(0,1020)
	   stop
	endif

	if (ia .ge. 2) then
		ic = 2
!	   call getarg(ic,argv,stat)
	   call getarg(ic,argv)
	   rad = argv(1:2)
	   call upper(rad)
	   if (rad .eq. 'CR') then
	      const=(2.28962/2)
	   elseif (rad .eq. 'FE') then
	      const=(1.93597/2)
	   elseif (rad .eq. 'CO') then
	      const=(1.78892/2)
	   elseif (rad .eq. 'MO') then
	      const=(0.70932/2)
	   elseif (rad .eq. 'AG') then
	      const=(0.55936/2)
	   elseif (rad .ne. 'CU') then
	      read(argv,'(f8.0)',iostat=i) const
	      if (i .ne. 0) then
		 write(0,*) 'Error: argument ',argv,' is invalid'
		 write(0,1020)
		 stop
	      endif
	      const=const/2
	   endif
	endif

	open (unit=NMINRL, file=dbloc(:dbln)//'stdcodes.tbl',
	2    status='old',iostat=j)
	if (j .ne. 0) open (unit=NMINRL,
	1    file=cdloc(:cdln)//'stdcodes.tbl',
	2    status='old',iostat=j)
	if (j .ne. 0) write (*,*) 'unable to open stdcodes.tbl'

	open (unit=NMINGP, file=dbloc(:dbln)//'mineral.tbl',
	2    status='old',iostat=j)
	if (j .ne. 0) open (unit=NMINGP,
	1    file=cdloc(:cdln)//'mineral.tbl',
	2    status='old',iostat=j)
	if (j .ne. 0) write (*,*) 'unable to open mineral.tbl'

	open (unit=ncoden,
	1    file=dbloc(:dbln)//'picodes.tbl',
	2    status='old',iostat=j)
	if (j .ne. 0) open (unit=ncoden,
	1    file=cdloc(:cdln)//'picodes.tbl',
	2    status='old',iostat=j)
	NPICDS = 0
	if (j .ne. 0) then
	   write (*,*) 'unable to open picodes.tbl'
	else
 80	   read (ncoden,'(a2,i1,a8)',end=81)
	1	PICDS(NPICDS+1), LNTEX2(NPICDS+1), PLTEX2(NPICDS+1)
	   NPICDS = NPICDS +1
	   GOTO 80
	endif

! 80	read (ncoden,'(3x,1x,a2,1x,3x,1x,a8)',end=81)
!	1    PICDS(NPICDS+1), PLTEX2(NPICDS+1)
!	IF (PLTEX2(NPICDS+1) .NE. ' ') THEN
!	   NPICDS = NPICDS +1
!	   do i=1,8
!	      if (PLTEX2(NPICDS)(I:I) .ne. ' ') LNTEX2(NPICDS) = I
!	   enddo
!	   write (*,*)  PICDS(NPICDS),'-"',
!	1	PLTEX2(NPICDS)(:LNTEX2(NPICDS)),'"'
!	ENDIF
!	GOTO 80
 81	close (ncoden)

	open (unit=ncoden,
	1    file=dbloc(:dbln)//'codens.tbl',
	2    status='old',iostat=j,
	3    access='direct',form='formatted',recl=81)
	if (j .ne. 0) open (unit=ncoden,
	1    file=cdloc(:cdln)//'codens.tbl',
	2    status='old',iostat=j,
	3    access='direct',form='formatted',recl=81)
	if (j .ne. 0) then
	   write (*,*) 'unable to open codens.tbl'
	   numcod = 0
	else
C read the number of codens records from the first record (added in prepfiles)
	   read(ncoden,'(6x,i10)',rec=1) NUMCOD
	endif

	call readbf (buffer,nbytes,readbf_status)
	if (readbf_status .eq. 1) goto 999

	call lines

	call prtcrd(nout)

999	continue
	close (pdfind)
	close (pdfdat)
	close (ncoden)
	STOP
	END


