	SUBROUTINE MINSUB (STATUS)
C
C	   Finds the mineral group/subgroup codes on CARD5 in MINERAL.DAT
C	   and returns the expanded text.
C
C		STATUS = 0 if successful
C		       = 1 if error
C
C	   NOTE: This routine bears NO resemblence to the NBS*AIDS83
C	   routine of the same name.  The results, though, are similar.
C
C	   By: Mark Holomany     Date: 16-Oct-1986
C
C========================================================================

	IMPLICIT INTEGER (A-Z)

	CHARACTER*20 NAME
	CHARACTER*28 HOLD
	CHARACTER*3  TEMP
	LOGICAL      GROUP

	COMMON /MINGRP/  GRPNAM(7), SUBNAM(7)
	COMMON /GRPNUM/  NUMGRP
	CHARACTER*20     GRPNAM, SUBNAM
	INTEGER          NUMGRP


!	INCLUDE  'grpind.cmn'
	INCLUDE  'ioret.cmn'
	INCLUDE  'pdfdata.cmn'

C\$INCLUDE:'GRPIND.CMN'
C\$INCLUDE:'IORET.CMN'
C\$INCLUDE:'PDFDATA.CMN'

!	open(unit=99,access='append')
!	write(99,*) CARD5(1)

	HOLD = CARD5(1)(25:52)
	GROUP = .FALSE.
	NUMGRP = 0
	STATUS = 0
C
C	... LOOK FOR 7 POSSIBLE GROUPS AND SUBGROUPS
	DO 4010 I = 1, 28, 4
C
C	... CHECK IF BLANK, IF SO SKIP FIELD
	IF (HOLD(I:I) .EQ. ' ') GO TO 4010
	IF (HOLD(I:I) .EQ. 'm') THEN
C
C	   ... MINERAL GROUP, find text in file, use binary search
C	   ... to find index into file
	   GROUP = .TRUE.
	   NUMGRP = NUMGRP + 1
	   SUBNAM(NUMGRP) = ' '

!	   L = 1
!	   U = NUMCDS
!           
!3000	   IF(L .GT. U) THEN
!C	      .. code not found
!	      NUMGRP = NUMGRP - 1
!	      GROUP = .FALSE.
!	      STATUS = 1
!	      write (99,*) HOLD(I+1:I+3)
!	      GO TO 4010
!	   ENDIF
!	   M = (L + U)/2
!	   IF(HOLD(I+1:I+3) .GT. GRPCDS(M)) THEN
!	      L=M+1
!	   ELSE IF(HOLD(I+1:I+3) .LT. GRPCDS(M)) THEN
!	      U=M-1
!	   ELSE
C
C	      .. found the code, now read file to get expanded text
!	      READ (NMINGP, 705, REC=CODIND(M)) TEMP, GRPNAM(NUMGRP), 
!	1                                       NUMSUB
705	      FORMAT (A3, 3X, A20, 1X, I2)
!	      GO TO 4010
!	   ENDIF
!	   GO TO 3000
C search sequentially -- hell, computers are fast but life is short
	   REWIND (NMINGP)
	   do j=1,99999
	      READ (NMINGP, 705,end=2) TEMP, GRPNAM(NUMGRP), NUMSUB
	      if (TEMP .eq. HOLD(I+1:I+3)) goto 1
	   enddo
C error - not found!
 2	   STATUS = 1
	   goto 4010
	ENDIF
C
C	... Is this a subgroup code?
 1	IF(HOLD(I:I) .EQ. 's') THEN
	   IF(.NOT. GROUP) THEN
	      STATUS = 1
	      GO TO 4010
	   ENDIF
	   GROUP = .FALSE.
C
C	   ..  Get expanded text for subgroup code from file
	   DO 4020 SUB=1,NUMSUB
!	   READ (NMINGP, 720, REC=CODIND(M)+SUB) TEMP, NAME
	   READ (NMINGP, 720) TEMP, NAME
720	   FORMAT (3X, A3, 3X, A20)
   	   IF(TEMP .EQ. HOLD(I+1:I+3)) THEN
	      SUBNAM(NUMGRP) = NAME
	      GO TO 4010
	   ENDIF
4020	   CONTINUE
	ENDIF

!	write(99,*) GRPNAM,SUBNAM

4010	CONTINUE
	GO TO 9000

8000	STATUS = 1
9000	CONTINUE
	RETURN
	END
