	SUBROUTINE LEFT (STRING, SIZE)
C
C	   Routine to left justify the characters in STRING.
C
C		STRING - characters to be left justified
C		SIZE   - returned as:
C		         1.  0, if the STRING is blank
C		         2.  the number of characters in the left
C		             justified field, including any trailing
C		             blanks from the original string.
C
C	   By: Mark Holomany, JCPDS     Date: 13-Feb-1984
C
C
	IMPLICIT  INTEGER (A-Z)
	CHARACTER STRING*(*)
C
C	... If the first character in STRING is non-blank, then return
	IF(STRING(1:1) .NE. ' ') THEN
	   SIZE = LEN(STRING)
	   RETURN
	ENDIF
C
C	... Find first non-blank character
	DO 400 N=1,LEN(STRING)
	IF(STRING(N:N) .NE. ' ') THEN
	   START = N
	   GO TO 10
	ENDIF
400	CONTINUE
C
C	... STRING is blank
	SIZE = 0
	RETURN
C
C	... Left justify the STRING
10	CONTINUE
	SIZE = LEN(STRING) - START + 1

	DO 410 N=1,SIZE
	CHPOS = START + N - 1
410	STRING(N:N) = STRING(CHPOS:CHPOS)

	STRING(SIZE+1:) = ' '

	RETURN
	END
