	SUBROUTINE DOREFS (CODE, ADDON, BOUND, STATUS, STRING, LENR)
C
C	   Gathers and typesets all references coded CODE and places 
C	   the results in STRING.
C
C		CODE   - Reference type code (CARD9)
C		ADDON  - Resets LENR to 0 prior to execution if ADDON is
C		         .FALSE.; uses existing value in LENR and builds
C		         onto the previous contents of STRING
C		BOUND  - Will enforce words not crossing 80-col card
C		         boundaries if .TRUE., will ignore card boundaries
C		         if .FALSE. [also ignores length of reference(s)
C		         in RWU]
C		STATUS - 0 if successful; 1 if an error is found
C		STRING - A character string to receive the typeset
C		         reference(s)
C		LENR   - Length of typeset reference(s) in STRING; 0 if
C		         no references coded CODE found.
C
C	   By: Mark Holomany, JCPDS     Date: 4-Mar-1986
C
C          Revisions:
C           1-Sep-92 MAH Remove any trailing blanks from the reference in
C                    STRING if ADDON is .TRUE.
C
C                      
	IMPLICIT INTEGER (A-Z)
	CHARACTER*2	CODE
	CHARACTER*(*)	STRING     
	CHARACTER*320	TMPSTR
	LOGICAL		ADDON, BOUND, L2AUTH

	INCLUDE 'reftrk.cmn'
	INCLUDE 'ioret.cmn'
	INCLUDE 'pdfdata.cmn'

C\$INCLUDE:'REFTRK.CMN'
C\$INCLUDE:'IORET.CMN'
C\$INCLUDE:'PDFDATA.CMN'

	DATA		L2AUTH /.TRUE./

C	CALL ESTMOD ('DOREFS')

	STATUS = 0
	MAXREF = LEN(STRING)
	SAVLEN = LENR

	IF (ADDON) THEN
C	 ... Remove any trailing blanks from existing reference in STRING
	   NEW_LENR = LENGTH (STRING(1:LENR))
	   LENR = NEW_LENR
	ELSE
	   LENR   = 0
	   SAVLEN = 0
	   REFRWU = 0
	ENDIF
C
	N = 0
3000	N = N + 1
	IF(N .GT. NUMC(9)) GO TO 9000
C
C	... Use only first cards, not continuation cards
	IF(N .GT. 1) THEN
	   IF(CARD9(N-1)(70:70) .EQ. 'C') GO TO 3000
	ENDIF

C
C	... Only process references not previously processed
	IF(CARD9(N)(68:69) .EQ. CODE  .AND.  (.NOT. REFCNT(N))) THEN
C	   .. Get reference with at most 2 authors names
	   CALL PHREF (.FALSE., N, TMPSTR, IRET, L2AUTH)         
	   IF(IRET .GT. 0  .AND.  IRET .NE. 4) THEN
C	      .. Error returned, reference not valid; return error status
	      REFCNT(N) = .FALSE.
	      STATUS = 1
	      GO TO 3000
	   ENDIF
C
C	   .. Got a valid reference
	   NCHAR = LENGTH (TMPSTR)
C
C	   .. Skip if card boundaries are to be ignored
	   IF(.NOT. BOUND) GO TO 200
C
C	   .. Skip if this is an ADDON call and there were >80 characters
C	   .. in the STRING at the beginning of this call
	   IF(SAVLEN .GT. 77) GO TO 200
C
C	   .. Skip if already did it once (77 used to account for "; ")
	   IF(LENR .GT. 77) GO TO 200
C
C	   .. Fixup if a word crosses the card boundary
	   ENCHAR = NCHAR + LENR
	   XN80 = 80 - LENR
	   IF(LENR .GT. 0) THEN
	      XN80 = XN80 - 2
	      ENCHAR = ENCHAR + 2
	   ENDIF
	   IF(ENCHAR .GT. MAXREF) GO TO 8010

C>>>	type *,'addon=',addon
C>>>    type *,'bound=',bound
C>>>	type *,'XN80=',xn80

	   IF(ENCHAR.GT.80 .AND. TMPSTR(XN80:XN80).NE.' ') THEN
	      IF(TMPSTR(XN80+1:XN80+1) .EQ. ' ') THEN
C	         .. col 81 blank
	         CALL LEFT(TMPSTR(XN80+1:NCHAR),SIZE)
	         NCHAR = XN80 + SIZE
	      ELSE
C	         .. col 81 non-blank
	         DO 4010 K=XN80,1,-1
	         IF(TMPSTR(K:K) .EQ. ' ') GO TO 100
4010	         CONTINUE
C	         .. no blanks found in TMPSTR
	         IF(LENR .NE. 0) THEN
	            STRING(LENR+1:80) = ' '
	            LENR = 80
	            GO TO 200
	         ENDIF

100	         CONTINUE
	         DELTA = XN80 - K
	         IF(NCHAR+DELTA .GT. MAXREF) GO TO 8010
	         DO 4020 J=NCHAR,K+1,-1
4020	         TMPSTR(J+DELTA : J+DELTA) = TMPSTR(J:J)
	         TMPSTR(K+1 : XN80) = ' '
	         NCHAR = NCHAR + DELTA
	      ENDIF
	   ENDIF

200	   CONTINUE
	   IF(LENR+NCHAR .GT. MAXREF) GO TO 8010
C	   .. Account for a "; "
	   IF(LENR.GT.0 .AND. LENR+NCHAR+2 .GT. MAXREF) GO TO 8010

	   IF(LENR .EQ. 79) THEN
	      STRING(LENR+1:LENR+1) = ';'
	      LENR = LENR + 1
	   ELSE IF(LENR .GT. 0) THEN
	      STRING(LENR+1:LENR+2) = '; '
	      LENR = LENR + 2
	   ENDIF

cccc	   IF(LENR+NCHAR .GT. LEN(STRING)) THEN
cccc	      CALL ERRTXT ('W', 
cccc	1       'STRING variable smaller than reference; truncated')
cccc	   ENDIF
	   STRING(LENR+1:MIN0(LEN(STRING),LENR+NCHAR)) = TMPSTR(1:NCHAR)
	   LENR = LENR + NCHAR
	ENDIF
	GO TO 3000

8010	CONTINUE
	REFCNT(N) = .FALSE.
	GO TO 3000

9000	CONTINUE
C	CALL DESMOD ('DOREFS')
	RETURN
	END
