	SUBROUTINE ADDFN (NCODE, STATUS)

C=======================================================================
C
C	   Routine to produce PDF Card Photocomp Interchange Format
C	   Cards for Box 5, the free format comments box, of the
C	   new PDF Card format (25&26).  Interchange cards 18-28.
C	                    ---------------
C	   This routine is ONLY used for comments cards with footnotes
C	   on them, ie. 'FN' and 'HK'.  ALL footnote codes must be
C	   defined via TRFNCH prior to calling ADDFN.
C
C	   By: Mark Holomany     Date: 1-May-1985
C	   Revised:
C	   29-Aug-87 MAH Allow PHDSP to be called after this routine.
C	                 Switch logical value of USENEW in call to 
C	                 TRFNCH.
C
C=======================================================================

	IMPLICIT INTEGER (A-Z)

	CHARACTER*4  TMPNUM

	CHARACTER	CHAR
	CHARACTER*3	PICODE

	COMMON /COMCRD/  CCARD, NUMPHC, CHPHC, CDCNT, FSTCRD, LINKCM,
	1                STCRD, NUMCD
	CHARACTER        CCARD*1760
	INTEGER          CDCNT(30), FSTCRD(30), LINKCM(20)
	INTEGER          STCRD(30)

	INCLUDE 'ioret.cmn'
	INCLUDE 'pdfdata.cmn'

C\$INCLUDE:'IORET.CMN'
C\$INCLUDE:'PDFDATA.CMN'

C	CALL ESTMOD ('ADDFN')


	IF(CDCNT(NCODE).LE.0 .OR.
	1  NCODE.GT.NUMCD .OR. NCODE.LT.1) THEN
	   WRITE (TMPNUM, '(I3)') NCODE
C	   CALL ERRTXT ('W', 'No comment cards of type' // TMPNUM)
	   STATUS = 1
	   RETURN
	ENDIF

C
C	... Go to a new line
	CALL CONCAT ('|')

	NB = FSTCRD(NCODE)

10	CONTINUE
C
C	... Translate the footnote character for photocomposition
	CALL TRFNCH
	1  (CARDB(NB) (1:1), .TRUE., IRET, CHAR, PICODE, COUNT)
C	IF(COUNT .GT. 1) THEN
C	   CALL ERRTXT ('W', 
C	1  'Same footnote character used in multiple footnotes.')
C	   CALL ERRTXT ('C', '"' // CARDB(NB) (1:67) // '"')
C	   CALL ERRTXT ('C', 'Character dropped.')
C
C	ELSE IF(IRET .NE. 0) THEN
C	   CALL ERRTXT ('W',
C	1  'Footnote character in comments not referenced elsewhere.')
C	   CALL ERRTXT ('C', '"' // CARDB(NB) (1:67) // '"')
C	   CALL ERRTXT ('C', 'Character dropped.')
C	ENDIF

	LPI = LENGTH(PICODE)
C
C	... Drop the blank after the footnote character, if one exists
	NXTCHR = 2
	IF(CARDB(NB) (2:2) .EQ. ' ') NXTCHR = 3

	DO 4001 NX=NB,19
	LEN = LENGTH( CARDB(NX) (1:67))
	IF(NX .EQ. NB) THEN
	   CALL CONCAT (PICODE(1:LPI) // CARDB(NX) (NXTCHR:LEN) // ' ')
	ELSE
	   CALL CONCAT (CARDB(NX) (1:LEN) // ' ')
	ENDIF
C	.. Col. 70 has a 'C' if the card is Continued
	IF(CARDB(NX) (70:70) .EQ. ' ') GO TO 20
4001	CONTINUE

20	CONTINUE
C	.. Go to new line
	CALL CONCAT ('|')
C
C	... Check for additional comments of this type via the links
	IF(LINKCM(NB) .GT. 0) THEN
	   NB = LINKCM(NB)
	   GO TO 10
	ENDIF

	STATUS = 0
C	CALL DESMOD ('ADDFN')
	RETURN
	END
