/*  To do: construct trace & implement final logic */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program findstring

    This program locates the entries that match a set of strings 
    The resulting entries are applied to the specified bitmap using
    the selected boolean operation.
    This program converts a hit # in a table of entries to a sequence # in the PDF

  Command syntax:
    hit2seq <file> <hits>  returns the sequence # of the first <n> hits in <file>
    hit2seq <file> <start> <end>  returns the sequence # of the hits between <start> and <end> in <file>
*/

int main (int argc, char *argv[]) {
  int error = 0;
  int i,j;
  char ** searchstrings = NULL;
  INTEGER4 ilogic = -1;
  INTEGER4 jlist = -1;
  INTEGER4 searchtype = -1;
  INTEGER4 numstrings = 0;
  int fields[6];
  
  for (i=0;i<6;i++) fields[i]=0;

  if (PSL_INIT() != 0) {
    fprintf(stderr,"error initializing the ICDD database\n");
    return 1;
  }

  j = 2;
  while (j < argc) {
    if (!strcmp(argv[j],"-allof")) {
      if (searchtype != -1) {
	fprintf(stderr,
		"option -allof or -oneof repeated\n");
	error = 1;
      }
      searchtype = 0;
      j++;
      jlist = j;
    } else if (!strcmp(argv[j],"-oneof")) {
      if (searchtype != -1) {
	fprintf(stderr,
		"option -allof or -oneof repeated\n");
	error = 1;
      }
      searchtype = 1;
      j++;
      jlist = j;
    } else if (!strcmp(argv[j],"-and")) {
      if (ilogic == 2) {
	fprintf(stderr,
		"option -and & -remove in conflict\n");
	error = 1;
      }
      ilogic = 0;
    } else if (!strcmp(argv[j],"-remove")) {
      if (ilogic == 0) {
	fprintf(stderr,
		"option -or -and -remove or -not repeated\n");
	error = 1;
      }
      ilogic = 2;
    } else if (!strcmp(argv[j],"-formula")){
      fields[0] = 1;
    } else if (!strcmp(argv[j],"-chemname")){
      fields[1] = 1;
    } else if (!strcmp(argv[j],"-mineral")){
      fields[2] = 1;
    } else if (!strcmp(argv[j],"-common")){
      fields[3] = 1;
    } else if (!strcmp(argv[j],"-authors")){
      fields[4] = 1;
    } else if (!strcmp(argv[j],"-coden")){
      fields[5] = 1;
    } else {
      fprintf(stderr,"unknown option: %s\n",argv[j]);
      error = 1;
    }
    j++;
  }
  
  j = 0;
  for (i=0;i<6;i++) j = j + fields[i];

  if (jlist == -1 || searchtype == -1 || j == 0) {
    fprintf(stderr,"error: required option is missing\n");
    error = 1;
  }

  if (!error) {
    char * strg, * sub_string;
    /*  Make a copy of the argument */
    strg = (char *) malloc((strlen(argv[jlist])+1) * sizeof(char));
    strcpy(strg, argv[jlist]);
    sub_string= strtok(strg, ",");
    while (sub_string != NULL) {
      numstrings++;
      sub_string= strtok(NULL, ",");
    }

    searchstrings = (char **) malloc(numstrings * sizeof(char *));
    /*  now parse it again and this time save the strings */
    strcpy(strg, argv[jlist]);
    i = 0;
    sub_string = strtok(strg, ",");
    while (sub_string != NULL) {
      searchstrings[i] = (char *) malloc((strlen(sub_string)+1) 
					   * sizeof(char));
      strcpy(searchstrings[i], sub_string);
      numstrings = ++i;
      sub_string = strtok(NULL, ",");
    }
    free (strg);
  }

  if (!error) {
    /*  Load the file argument */
    INTEGER4 il = 4, error;
    error = PSL_READBITMAP(argv[1],&il);
    if (error) {      
      fprintf(stderr, "error reading subfile %s\n",argv[1]);
    } else {
      int k,l;
      INTEGER4 j = 0;
      INTEGER4 ns = numstrings;
      char stringlist[256];
      if (searchtype == 0) {
	ns = -ns;
	strcpy(stringlist, "All of (");
      } else {
	strcpy(stringlist, "One of (");
      }
      for (i=0;i<numstrings;i++) {
	k = strlen(stringlist);
	l = strlen(searchstrings[i]);
	if (k+l < 255) strcpy (stringlist+k, searchstrings[i]);
	strcpy(stringlist+k+l, ",");
      }
      strcpy(stringlist+k+l, ")");
      j = PSL_STRNGSRCH(&ilogic, stringlist, searchstrings, &ns, fields);
      error = PSL_SAVEBITMAP(argv[1]);
      if (error) {      
	fprintf(stderr, "error writing subfile %s\n",argv[1]);
      }
      il = 0;
      printf("%d\n",PSL_REPHITS(&il) );
    }
  }

  /*  deallocate the search string stack */
  if (searchstrings != NULL) {
    for (i=0;i<numstrings;i++) {
      free (searchstrings[i]);
    }
    free(searchstrings);
  }

  if (!error) return 0;
  fprintf(stderr, "\nusage:\n");
  fprintf(stderr, "\t findstring <file>\n");
  fprintf(stderr, "\t\t[-allof str1,str2,... | -oneof str1,str2,...]\n");
  fprintf(stderr, "\t\t[-and | -remove]\n");
  fprintf(stderr, "\t\t[-formula] [-chemname] [-mineral] [-common] [-authors] [-coden]\n");
  return 1;
}
