C---------------------------------------------------------------------------
C	PDF1 ENCODE -- PART 3b   for the PDF-2 on DISK/CDROM 
C
C	Program for reading the PDF-1 JCPDS-ICDD NAME data file
C	to create the chemistry and the element count bitmap files.
C
C	            =================================
C	   Written Jan-1995 by Brian H. Toby -- based on 1990 VAX version
C
C-------------------------------------------------------------------------
C-- INPUT ----------------------------------------------------------------
C       FILE	        USE           
C-------------------------------------------------------------------------
C       name.lib	PDF-1 database file with the composition/name 
C 			for each card
C       jcpds.ind	index file, one record per JCPDS card
C
C-- OUTPUT ---------------------------------------------------------------
C       FILE	        USE
C-------------------------------------------------------------------------
C       chem.bit	chemistry index 
C 	elemcnt.bit	index by number of elements
C---------------------------------------------------------------------------
C---------------------------------------------------------------------------
	IMPLICIT NONE
	include 'copyrght.def'
C
	include 'pdfread.def'
	include 'pdfwrite.def'
	include 'bitops.def'
	include 'pdfdefs.par'
	include 'elemsyms.cmn'
C cdloc -- filename (including path) of CDROM 
C dbloc -- path for cdif database files (ending in \)
	CHARACTER*64 cdloc,dbloc,localloc
C=======================================================================
	INTEGER max_words
	PARAMETER (max_words = (max_cards+31)/32)
C  BITMAP INFORMATION
	INTEGER*4 CHEM(max_words,104)
	INTEGER*4 ECOUNT(max_words,MAX_ELEMC)
	CHARACTER*8 filename*80

	INTEGER lastcrd,lastsub,N_reg,N_elemc
	integer n_cards,ipat
	integer lench
	integer i,j,k
	integer npt,dipt,refpt,cdpt
	INTEGER ncrd

	CHARACTER*256	formula, MINNAM, COMMNAM, CHEMNAM
	LOGICAL     CHECKLIST(104)
	INTEGER       NELEMS

	INTEGER	     STATUS
!	integer ibe/0/

	include 'elemsyms.dat'
C---------------------------------------------------------------------------
	read(*,'(A)') dbloc
	read(*,'(A)') cdloc
	read(*,'(A)') localloc
C terminate strings with nulls
	localloc(lench(localloc)+1:) = char(0)
	cdloc(lench(cdloc)+1:) = char(0)
	dbloc(lench(dbloc)+1:) = char(0)
	write (*,'(/,3(A,/))') '========================',
	1    'Beginning program WRCHEM','========================'
	write (*,*) 'Reading files from location ',dbloc(:lench(dbloc))
!	write (*,*) 'CDROM location ',cdloc(:lench(cdloc))
!	write (*,*) 'local AIDS entries ',localloc(:lench(localloc))
!	i = ps_openpdf2 ('pdf2.dat'//char(0),dbloc,cdloc,0)
!	if (i .eq. -1) stop
	i = ps_openindex(dbloc,cdloc)
	if (i .ne. 0) stop 'error on index open'
	i = ps_opennamlib(dbloc,cdloc)
	if (i .ne. 0) stop 'error on name open'
!	i = ps_opendilib(dbloc,cdloc)
!	if (i .ne. 0) stop 'error on di open'
!	i = ps_openreflib(dbloc,cdloc)
!	if (i .ne. 0) stop 'error on ref open'
	open (unit=99,file=dbloc(:lench(dbloc))//'runstat.txt',
     1		status='unknown')
	rewind(99)
	write (99,*) 'Initializing'
	call flush(99)

C read the sizes from the file and overwrite the actual value for N_REGIONS
	OPEN (UNIT=7,FILE=dbloc(:lench(dbloc))//'pdsize.txt',
     1		STATUS='OLD')
	read (7,*)  N_cards,lastcrd,lastsub,N_reg,N_elemc
	N_elemc = MAX_ELEMC
	rewind(unit=7)
	write (7,*) N_cards,lastcrd,lastsub,N_reg,N_elemc
	CLOSE (UNIT=7)

C initialize the bitmaps and counter variables
	DO I=1,104
	   DO J=1,max_words
	    CHEM(J,I) = 0
	  ENDDO
	ENDDO
	DO I=1,MAX_ELEMC
	   DO J=1,max_words
	    ECOUNT(J,I) = 0
	  ENDDO
	ENDDO
C---------------------------------------------------------------------------
C==========================================================================
C
C	... Begin reading the PDF-1 files.
C
	DO 100 IPAT=1,N_CARDS
	   if (mod(ipat,1000) .eq. 0) THEN
	      rewind(99)
	      write (99,*) 'processed ', ipat, ' entries'
	      call flush(99)
	   ENDIF
	   J = IPAT
	   k = ps_readindex(J,ncrd,npt,dipt,refpt,cdpt)
	   ncrd = abs(ncrd)
	   if (k .ne. 0) stop 'error on index read'
	   k = ps_readnamlib(npt,chemnam,commnam,minnam,formula)
	   if (k .ne. 0) stop 'error on name read'
C------------------------------------------------------------------------
C now process the entry
C------------------------------------------------------------------------
C parse the chemical formula
!	   if (ipat .eq. 2893) then
!	      write(*,*) formula(:lench(formula))
!	   endif
	  CALL PARSELEM (FORMULA, NELEMS, CHECKLIST, STATUS)
	  IF(STATUS .NE. 0) THEN
	      write(*,*) 'ERROR FROM PARSELEM WITH ENTRY: ',ncrd
	      write(*,'(1x,2a)') 'Formula: ',FORMULA(:lench(FORMULA))
	      write(*,'(1x,2a)') 'Name:    ',CHEMNAM(:lench(CHEMNAM))
	      GO TO 100
	  ENDIF
!	   if (ipat .eq. 2893) then
!	  write (*,*) FORMULA(:lench(FORMULA)),NELEMS
!	  do I=1,104
!	     if (checklist(i)) write (*,*) I,chsym(i)
!	  enddo
!	   endif
C-----------------------------------------------------------------------
C   Set the bit(s) for the subfile indices
C       Set the appropriate bit in the element count bitmap array
	  J = MIN(MAX_ELEMC,NELEMS+1)
	  call tblbitset(ECOUNT(1,J), ipat, n_cards, 1)
C-------
C   Set the appropriate bits in the chemistry arrays
	  DO J=1,104
	     IF (CHECKLIST(J)) THEN
!		if (j. eq. 4) then 
!		   ibe = ibe + 1
!		   write(*,*) ibe,ipat,ncrd,' ',FORMULA(:lench(FORMULA))
!		endif
		call tblbitset(CHEM(1,J), ipat, n_cards, 1)  
		IF (J.GE.57.AND.J.LE.71)
	1	     call tblbitset(CHEM(1,104), ipat, n_cards, 1)  
		IF (J.EQ.104) THEN
		   DO K=57,71
		      call tblbitset(CHEM(1,K), ipat, n_cards, 1)  
		   ENDDO
		ENDIF
	     ENDIF
	  ENDDO
 100	CONTINUE
C-----------------------------------------------------------------------
	rewind(99)
	write (99,*) 'writing index files'
	call flush(99)
C-----------------------------------------------------------------------
C close the name/INDEX files
C-------------------------------------------------------------------------
	call ps_closeindex
	call ps_closenamlib
!	call ps_closedilib
!	call ps_closereflib
C---------------------------------------------------------------------------
C WRITE OUT THE INDEX FILES
C---------------------------------------------------------------------------
	WRITE(*,1602) N_CARDS
1602	FORMAT (' Total patterns processed:',I6 //,
	1	' Number of patterns by element count')
C show a table of hits by element count & by element

C write the ELEMENT COUNT bitmap
	filename = 'elemcnt.bit'//char(0)
	i = ps_createbitlib(filename, dbloc)
	if (i .ne. 0) then 
	   write (*,*) 'error creating ',filename
	   stop
	endif
	DO I=1,MAX_ELEMC
	   k = ps_writebitlib(i, ecount(1,i), n_cards)
	   k = tblcount(ecount(1,i), n_cards)
	   WRITE(*,'(I4,i10)') I-1,k
	ENDDO
	call ps_closebit

	WRITE(*,'(/A)') ' Number of patterns by element'
C write the CHEMISTRY bitmap
	filename = 'chem.bit'//char(0)
	i = ps_createbitlib(filename, dbloc)
	if (i .ne. 0) then 
	   write (*,*) 'error creating ',filename
	   stop
	endif
	DO I=1,104
	   k = ps_writebitlib(i, chem(1,i), n_cards)
	   k = tblcount(chem(1,i), n_cards)
	   WRITE(*,'(I6,2x,a2,i10)') I,chsym(I),k
	ENDDO
	call ps_closebit

	rewind(99)
	write (99,*) 'DONE'
	close(99)
	write (*,*) 'Normal End of Program'
	END
