	include 'copyrght.def'
C
	SUBROUTINE PDPARSE(status, debug, deleted, sublist, isubs)
	implicit none
      INTEGER*4 status
	CHARACTER*4 SUBLIST(100)
	INTEGER*4 isubs
	logical debug

	include 'pdfwrite.def'
	include 'pdfdefs.par'
	include 'pdfdefs.cmn'
	include 'pdfparse.cmn'
	include 'aidsdefs.cmn'


	CHARACTER*256	formula, MINNAM, COMMNAM, CHEMNAM, NAME
!	CHARACTER*(4*255) fullnam
      INTEGER*4 i1, i2, i3, i4, ic, irel, pdf2t, maxi, ik

	CHARACTER*6	coden
	CHARACTER*5 VOLUME
	CHARACTER*5 page
	CHARACTER*256 AUTHORS

	INTEGER*1 long2byte
	INTEGER*2 long2short
	LOGICAL FLAG,DTOPDF
	INTEGER*1 l1, l2, l3, l4, yearb
	CHARACTER*1	 	NAMCOD

	integer MAXOBS
	PARAMETER (MAXOBS = 501)
	integer     INT(MAXOBS)
	REAL*4    DSP(MAXOBS)
	integer*4 ndsp

	INTEGER*1  IRELbyte(255)
	INTEGER*2  PDF2T2(255)

	logical DELETED
	INTEGER lench
	INTEGER*4 i,j,k
	INTEGER NCRDPREV/0/
	SAVE NCRDPREV
	INTEGER IB, IE
	INTEGER     YEAR

	include 'pdfdefs.dat'
	include 'aidsdefs.dat'

C note for the old CARDn(j) arrays use BF(PC(n)+j-1)
C note for the old CARDn variables use BF(PC(n))
C brief: replace CARD{?}({*}) with BF(PC(\0)+\1-1)
C        then CARD{?} with BF(PC(\0))

C check the integrity of the database
	READ(BF(1)(73:78),'(i6)',err=9919) NCRD
	IF (NCRD .eq. NCRDprev) then
	   write (*,*) 'REPEATED CARD NUMBER: ',NCRD,' at ',NPAT+1
	   GOTO 100
	ELSEIF(NCRD .lt. NCRDprev) then
	   WRITE (*,'(A,i6.6,a,i6.6)') 
	1	'Incorrect order of input cards: ',NCRD,
	2	' follows ',NCRDprev
	   STOP 'PROGRAM STOPPING -- DISASTER'
	ENDIF
	NCRDprev = NCRD

C-----------------------------------------------------------------------
C IS ENTRY FLAGGED AS "DELETED"?
C   handle deleted patterns -- either skip them entirely (if SKIPDEL is TRUE)
C   or process, but flag as deleted
	IF (BF(1)(72:72).NE.'P') THEN
	   IF (SKIPDEL) GO TO 100
	   DELETED = .true.
C does the pattern have a name, a chemical formula and d-spaces? 
C Skip deleted patterns which do not.
	   IF ((NUMC(7).LE.0 .and. NUMC(6) .EQ. 0) .or.
     1			NUMC(18).LE.0) goto 100
	ELSE
	   DELETED = .false.
	ENDIF
C-----------------------------------------------------------------------
C test for ICDD subfile
!	  IF (icddopt .eq. 1) THEN
!	    IF (BF(PC(5))(1:1).NE.'I') GOTO 100
!	  ELSEIF (icddopt .eq. 2) THEN
!	    IF (BF(PC(5))(3:3).NE.'M') GOTO 100
!	  ELSEIF (icddopt .eq. 3) THEN
!	    IF (BF(PC(5))(4:4).NE.'A') GOTO 100
!	  ENDIF


C-----------------------------------------------------------------------
C---GET COMPOUND/MINERAL NAME  (CARD 6)
C	IF (NUMC(6) .lt. 1) goto 950
	MINNAM = ' '
	CHEMNAM = ' '
	COMMNAM = ' '
	J = 1
	DO WHILE (J .le. NUMC(6))
	   NAMCOD = BF(PC(6)+J-1)(69:69)
	   NAME = BF(PC(6)+J-1)(1:67)
 601	   J = J + 1
C this is for names continued over two or more cards
	   IF (J .le. NUMC(6) .and. BF(PC(6)+J-2)(70:70).eq.'C') THEN
C if there is more than one trailing space remove all but one
	      IF (BF(PC(6)+J-2)(67:67) .eq. ' ') THEN
		 i = lench(name) + 1
	      ELSE
		 i = 67
	      ENDIF
	      NAME = NAME(1:i) // BF(PC(6)+J-1)(1:67)
	      goto 601
	   ENDIF
C       get all mineral & zeolite names
	   IF (NAMCOD .EQ. 'M' .or. NAMCOD .EQ. 'Z') THEN
	      IF (minnam .ne. ' ')  THEN
		 minnam = minnam(:lench(minnam)) 
	1	      // ' / ' // NAME(:lench(NAME))
	      ELSE
		 minnam = NAME(:lench(NAME))
	      ENDIF
C get the Chemical name
	   ELSEIF (NAMCOD .EQ. 'P') THEN
C       get the 1st name
	      IF (CHEMNAM .eq. ' ') CHEMNAM = NAME 
C get the Chemical name -- use PDF ("P") name if no other name
	   ELSEIF (NAMCOD .EQ. ' ') THEN
C    get the 1st name
	      IF (CHEMNAM .eq. ' ') CHEMNAM = NAME 
C get the Chemical name for a mineral -- use the N name over the " " if both 
C are present
	   ELSEIF (NAMCOD .EQ. 'N') THEN
	      IF (CHEMNAM .ne. ' ') THEN
		 WRITE (*,'(A)')
	1	      ' Warning using name '//name(:lench(name)),
	2	      '   In preference to '//chemnam(:lench(chemnam)),
	3	      '   For entry '//BF(PC(1))(73:78)
		 CHEMNAM = NAME 
	      ENDIF
C get the 1st Common name
	   ELSEIF (NAMCOD .EQ. 'C') THEN
	      IF (COMMNAM .ne. ' ')  THEN
		 COMMNAM = COMMNAM(:lench(COMMNAM)) 
	1	      // ' / ' // NAME
	      ELSE
		 COMMNAM = NAME
	      ENDIF
C get the 1st Common name
	   ELSEIF (NAMCOD .EQ. 'F') THEN
	      IF (COMMNAM .ne. ' ')  THEN
		 COMMNAM = COMMNAM(:lench(COMMNAM)) 
	1	      // ' / ' // NAME
	      ELSE
		 COMMNAM = NAME
	      ENDIF
	   ELSE
	      write (*,'(3a)') '*** Unrecognized card6 type: "',
	1	   NAMCOD,'"'
	      do k=1,NUMC(6) 
		 write (*,*)BF(PC(6)+k-1)(1:79)
	      enddo
	      do k=1,NUMC(7) 
		 write (*,*)BF(PC(7)+k-1)(1:79)
	      enddo
	      if (NUMC(8) .gt. 0) write (*,*) BF(PC(8))(1:79)
	   ENDIF
	ENDDO
C-----------------------------------------------------------------------
C---GET CHEMICAL FORMULA  (CARD 7)
	formula = ' '
	IF (NUMC(7) .ge. 1) THEN
	  formula = BF(PC(7))(1:67)
	  J = 1
C concatinate continuation cards
	  DO WHILE (NUMC(7) .gt. J .and. BF(PC(7)+J-1)(70:70).eq.'C')
C if there is one or more spaces leave a single blank space
	    IF (BF(PC(7)+J-1)(67:67) .eq. ' ') THEN
	      i = lench(formula) + 1
C but if it ends without a space, do add any blank spaces
	    ELSE
	      i = lench(formula) 
	    ENDIF
     	    formula = formula(:i) // BF(PC(7)+j)(1:67)
	    j = j + 1
	  ENDDO
	ELSE
	  write(*,*) 'Missing formula for entry ',
     1		BF(PC(1))(73:78),j,':  '
	  write(*,'(1x,a)') (BF(PC(7)+j-1),j=1,numc(7))
	ENDIF
C-----------------------------------------------------------------------
C extract the d-spaces from the entry
	IF ((.NOT. DELETED) .or. USEDEL) THEN 
	  CALL GETDI (DSP,INT,NDSP,STATUS,BF(PC(18)),NUMC(18))
	  IF(STATUS .NE. 0) THEN
	    write(*,*) 'ERROR FROM GETDI WITH ENTRY: ',BF(1)(73:78)
	    GO TO 100
	  ENDIF
	ELSE
	  NDSP = 0
	ENDIF
C----------------------------------------------------------------------
C---GET REFERENCE   (CARD 9)
	IF (NUMC(9) .LE. 0) then
	  coden = ' '
	  VOLUME = ' '
	  page = ' '
	  AUTHORS = ' '
	  YEAR=0
	ELSE
	  YEAR=0
C try the reference types by preference
	  do I=1,NUMC(9)
	    if (bf(pc(9)+I-1)(68:69) .eq. ' ') then
		  j = i
		  goto 919
	    endif
	  enddo
	  do I=1,NUMC(9)
	    if (bf(pc(9)+I-1)(68:69) .eq. 'UC') then
		  j = i
		  goto 919
	    endif
	  enddo
	  do I=1,NUMC(9)
	    if (bf(pc(9)+I-1)(68:69) .eq. 'PD') then
		  j = i
		  goto 919
	    endif
	  enddo
	  do I=1,NUMC(9)
	    if (bf(pc(9)+I-1)(68:69) .eq. 'CD') then
		  j = i
		  goto 919
	    endif
	  enddo
	  do I=1,NUMC(9)
	    if (bf(pc(9)+I-1)(68:69) .eq. 'ST') then
		  j = i
		  goto 919
	    endif
	  enddo
C give up -- take the first reference 
	  J = 1
919	  coden = BF(PC(9)+j-1)(1:6)
	  VOLUME = BF(PC(9)+j-1)(7:10)
	  page = BF(PC(9)+j-1)(11:15)
	  AUTHORS = BF(PC(9)+j-1)(22:67)
	  I = 0
        read (BF(PC(9)+j-1)(17:20),'(i4)',err=990) I
990	  IF (I.EQ.0) THEN
	    YEAR = 127
	  ELSEIF (I.GT.2010 .OR. I.LT.1800) THEN
	    WRITE (*,903) I,9,BF(1)(73:78)
903	    FORMAT (' ***** OUT OF RANGE VALUE FOR YEAR -- ',I4,5X,
     1	 ' RECORD: ',I5,5X,' ENTRY: ',A)
	    YEAR = 127
	    write(*,'(1x,A)') BF(PC(9)+j-1)
	  ELSE
	    YEAR = I-1900
	  ENDIF
	  DO WHILE (NUMC(9) .gt. J .and. BF(PC(9)+J-1)(70:70).eq.'C')
C leave a single blank space
	    i = lench(AUTHORS) + 1
     	    AUTHORS(I+1:) = BF(PC(9)+j)(22:67)
	    j = j + 1
	  ENDDO
	ENDIF
C----------------------------------------------------------------------
C increment the pattern counter
	NPAT = NPAT + 1
!	if (NPAT .gt. max_cards) stop 
!     1		'PROGRAM DIMENSIONS EXCEEDED: Increase MAX_CARDS'
C----------------------------------------------------------------------
C Inorganic (In_sub) 
	IF (BF(PC(5))(1:1).EQ.'I') call
	1    tblbitset(misc(1,IN_sub), npat, npat, 1)  
C Organic (Or_sub) 
	IF (BF(PC(5))(2:2).EQ.'O') call
	1    tblbitset(misc(1,OR_sub), npat, npat, 1)  
C Minerals (Mn_sub) 
	IF (BF(PC(5))(3:3).EQ.'M') call
	1    tblbitset(misc(1,Mn_sub), npat, npat, 1)  
C Alloy/Metal/Intermetallic (MA_sub) 
	IF (BF(PC(5))(4:4).EQ.'A') call
	1    tblbitset(misc(1,MA_sub), npat, npat, 1)  
C Deleted entries -- no deleted entries in CD (DL_sub) 
	IF (DELETED) call
	1    tblbitset(misc(1,DL_sub), npat, npat, 1)  
C Local entries (LC_sub) 
	IF (LOCAL) call
	1    tblbitset(misc(1,LC_sub), npat, npat, 1)  
C Look at subfile flags
	DO J=1,NUMC(5)
	  DO 213 IB=6,22,4
	    IE=IB+2
	      if (BF(PC(5)+j-1)(IB:IE) .eq. ' ') goto 213
C Set remaining subfile flags
	    DO I=1,max_sub
	      IF (BF(PC(5)+j-1)(IB:IE).EQ.AIDSdef(I)) THEN
		 call tblbitset(misc(1,SUBREC(I)), npat, npat, 1)  
		 GOTO 213
	      ENDIF
	    ENDDO
C Unassigned -- warn
!	    write(*,*) 'unexpected subfile for entry ',
!     1		BF(PC(5)+j-1)(73:78),j,':  "'//BF(PC(5)+j-1)(IB:IE)//'"'
!	    write(*,'(1x,A)') BF(PC(5)+j-1)
	    DO IK=1,isubs
	       IF (sublist(IK) .EQ. BF(PC(5)+j-1)(IB:IE)) GOTO 213
	    ENDDO
	    ISUBS = ISUBS + 1
	    sublist(ISUBS) = BF(PC(5)+j-1)(IB:IE)
213	  CONTINUE
	ENDDO
C non-ambient conditions?
	IF (BF(PC(1))(52:52) .EQ.'T' .or. BF(PC(1))(52:52) .EQ.'P') 
	1    call tblbitset(misc(1,NAB_sub), npat, npat, 1)  
C----------------------------------------------------------------------
C write out formula, name, mineral name...
	call press(chemnam, i1)
	call press(commnam, i2)
	call press(minnam, i3)
	call press(formula, i4)
	i1 = min(255,lench(chemnam))
	i2 = min(255,lench(commnam))
	i3 = min(255,lench(minnam))
	i4 = min(255,lench(formula))
	l1 = long2byte(i1)
	l2 = long2byte(i2)
	l3 = long2byte(i3)
	l4 = long2byte(i4)
	i = ps_writenamlib(namebyte,l1,l2,l3,l4,
	1    chemnam,commnam,minnam,formula)
!	fullnam = chemnam(:i1) // commnam(:i2) // 
!     1		minnam(:i3) // formula(:i4)
!	J = i1 + i2 + i3 + i4
!	write(iname) l1,L2,L3,L4,fullnam(1:J)

!	namebyte = namebyte + 4 + j

C-----------------------------------------------------------------------
C write a D/I record
C get maximum intensity (N.B. some patterns are scaled to 999 not 100)
	MAXI = INT(1)
	DO k=2,NDSP
	  MAXI = MAX(MAXI, INT(k))
	ENDDO
	IF (MAXI .LE. 0 .and. ndsp .gt. 0) THEN
	  WRITE (*,'(A)') ' ERROR: ',BF(1)(73:78),
	1	'-- maximum intensity is <=0'
	  NDSP = 0
	ENDIF
	ic = NDSP
	ndsp = 0
	do I=1,ic
	   FLAG = DTOPDF(PDF2T,DSP(i))
C skip over multiply indexed lines and limit to 255 peaks
	   IF (i.lt.ic .and. DSP(i).EQ.DSP(i+1)
	1	.and. INT(i).EQ.INT(i+1)) FLAG = .false.
	   IF (ndsp .gt. 255) FLAG = .false.
C convert to GG D/I format
	   IF (FLAG) THEN
C peak in CuKa Ewald sphere
	      ndsp = ndsp + 1
C scale intensities to full scale of 255, if needed
	      irel = INT(i) 
	      if (maxi .gt. 255) IREL = NINT((255./MAXI)*INT(i))
	      IRELbyte(ndsp) = long2byte(IREL)
	      PDF2T2(ndsp) = long2short(PDF2T)
	   ENDIF
	enddo

	l1 = long2byte(NDSP)
	i = ps_writedilib(dibyte,PDF2T2,IRELbyte,l1)
!	WRITE (idi) L1,(PDF2T2(i),i=1,NDSP),(IRELbyte(i),i=1,NDSP)
!	dibyte = dibyte + 1 + NDSP*3
C-----------------------------------------------------------------------
C write a REFERENCE record
	call press(coden, i1)
	call press(VOLUME, i2)
	call press(page, i3)
	call press(AUTHORS, i4)
	i1 = min(255,lench(coden))
	i2 = min(255,lench(VOLUME))
	i3 = min(255,lench(page))
	i4 = min(255,lench(AUTHORS))
	l1 = long2byte(i1)
	l2 = long2byte(i2)
	l3 = long2byte(i3)
	l4 = long2byte(i4)
	yearb = long2byte(year)
	i = ps_writereflib(refbyte, yearb,
	1    l1, coden, l2, volume, l3, page, l4, authors)
!	fullnam = coden(:i1) // volume(:i2) // 
!     1		page(:i3) // authors(:i4)
!	J = i1 + i2 + i3 + i4
!	write(iREF) l1, L2, L3, L4, yearb, fullnam(1:J)
!	REFbyte = REFbyte + 5 + j
C-----------------------------------------------------------------------
	if (debug) then
!	   write (*,'(1x,a)') (bf(j),j=1,BYTES_READ/80)

	   write (*,*) NPAT, ' ',BF(PC(1))(73:78)
	   i1 = min(255,lench(chemnam))
	   i2 = min(255,lench(commnam))
	   i3 = min(255,lench(minnam))
	   i4 = min(255,lench(formula))
	   if (i4 .gt. 0) write (*,*) 'Formula----',FORMULA(:i4)
	   if (i2 .gt. 0) write (*,*) 'Com Name---',commnam(:i2)
	   if (i1 .gt. 0) write (*,*) 'Chem Name--',CHEMNAM(:i1)
	   if (i3 .gt. 0) write (*,*) 'Min. Name--',MINNAM(:i3)
	   i1 = min(255,lench(coden))
	   i2 = min(255,lench(VOLUME))
	   i3 = min(255,lench(page))
	   i4 = min(255,lench(AUTHORS))
	   if (i1 .gt. 0) write (*,*) 'Coden ---',coden(:i1)
	   if (i2 .gt. 0) write (*,*) 'Volume---',volume(:i2)
	   if (i3 .gt. 0) write (*,*) 'Page  ---',Page(:i3)
	   if (year .ne. 127) write (*,*)'year  ---',year+1900
	   if (i4 .gt. 0) write (*,*) 'Authors--',authors(:i4)
	   WRITE (*,'(8(f6.2,i4))') (DSP(i),INT(i),i=1,NDSP)
	endif
C-----------------------------------------------------------------------
	status = 0
	RETURN
100	status = 1
	RETURN
 9919	write (*,*) 'Invalid number'
	write (*,'(1x,a)') (bf(j),j=1,BYTES_READ/80)
	stop
	END
