	include 'copyrght.def'
C
C------------------------------------------------------------------------
	SUBROUTINE PARSELEM (formula, NELEMS, CHECKLIST,  STATUS)
C=======================================================================
C	   Return unique elements in the chemical formula as a character
C	   string, and the number of unique elements.
C
C	   formula       - Character string array of elements
C	   NELEMS        - number of unique elements
C	   CHECKLIST     - logical array, .true. if element is present
C	   STATUS        - 0 if no error, 1 if error
C
C	   By: Mark Holomany. modified by Brian Toby
C
C=======================================================================
	IMPLICIT NONE
	CHARACTER*255 formula
	INTEGER       NELEMS
	LOGICAL     CHECKLIST(104)

	INTEGER       STATUS
C=======================================================================
	CHARACTER     TOKEN*20
	INTEGER LENCH
	INTEGER i,i1,n,size,ln

	include 'elemsyms.cmn'

	include 'elemsyms.dat'

	NELEMS = 0
	STATUS = 0
C drop a leading symbol (if any); terminated by a --
	i1 = 1
	ln = lench(formula)
	DO I=1,ln-1
	  IF (formula(i:i+1) .eq. '--') THEN
	    i1 = I+2
	    goto 100
	  ENDIF
	ENDDO

100	CALL SCANIN (formula(i1:ln), ' ')
C======================================================================

	DO N=1,104
	   CHECKLIST(N) = .FALSE.
	ENDDO

	CALL SCANER(TOKEN,SIZE)
	DO WHILE (SIZE .GT. -1)
C
C	... Element symbol plus optional subscripted number(s)
	   IF(TOKEN(1:1).GE.'A' .AND. TOKEN(1:1).LE.'Z')      THEN
	      IF( (TOKEN(2:2).GE.'a' .AND. TOKEN(2:2).LE.'y') .AND.
	1	   TOKEN(2:2).NE.'x')  THEN
C       .. two character element symbol
		 SIZE = 2
	      ELSE
C       .. one character element symbol
		 SIZE = 1
	      ENDIF

	      DO 4030 N=1,104
		 IF(TOKEN(1:SIZE) .EQ. CHSYM(N)) THEN
		    IF(.NOT. CHECKLIST(N)) THEN
		       NELEMS = NELEMS + 1
		       CHECKLIST(N) = .TRUE.
		    ENDIF
		    GO TO 3000
		 ENDIF
 4030	      CONTINUE
	      
C D and T are equivalent to H
	      IF(TOKEN(1:SIZE).EQ.'D' .OR. TOKEN(1:SIZE).EQ.'T') THEN
		 IF(.NOT. CHECKLIST(1)) THEN
		    NELEMS = NELEMS + 1
		    CHECKLIST(1) = .TRUE.
		 ENDIF
	      ELSEIF(TOKEN(1:SIZE).EQ.'Ln') THEN
		 IF(.NOT. CHECKLIST(104)) THEN
		    NELEMS = NELEMS + 1
		    CHECKLIST(104) = .TRUE.
		 ENDIF
	      ELSE
		 write (*,*) 'PARSELEM Error -- ',
	1	      'Problem with element ',TOKEN(1:SIZE)
C       flag an error but continue
		 STATUS = 1
	      ENDIF
	   ENDIF
C       Get the next element
 3000	   CALL SCANER(TOKEN,SIZE)
	ENDDO
	RETURN
	END
C-----------------------------------------------------------------------
	SUBROUTINE SCANIN(INSTR,DELSTR)
C
C	   Routine to initialize the COMMON /SCNCMN/ used by the
C	   parsing subroutine SCANER.
C
C		INSTR  - A string of 1-255 characters to be parsed by the
C		         scanner.  This string is copied to an internal
C		         work area for use during the parsing.  This
C		         means that changes made to INSTR by the calling
C		         program between the execution of THIS routine
C		         and successive CALLS to SCANER will not modify
C		         the parsing.  Neither does this routine nor
C		         SCANER modify the original copy of INSTR.
C		DELSTR - A string of 1-96 ASCII characters to be used
C		         as field delimiters.  These are stored in DELIM.
C COMMON BLOCK:
C		PTR    - Pointer to the next character to be parsed.
C		NUMDEL - The number of delimiter characters in DELSTR.
C		LENSTR - The length of INSTR.
C		DELIM  - The string of delimiters used by SCANER.
C		STRING - The string that is parsed by SCANER.
C
C	   By: Mark Holomany, JCPDS     Date: 30-Jan-1984
C
C
	IMPLICIT INTEGER (A-Z)
	CHARACTER  INSTR*(*), DELSTR*(*)
	CHARACTER  DELIM*96,STRING*255
	COMMON /SCNCMN/ PTR,NUMDEL,LENSTR,DELIM,STRING

	PTR = 1
	NUMDEL = min(96,LEN(DELSTR))
	DELIM = DELSTR(1:NUMDEL)

	LENSTR = min(255,LEN(INSTR))
	STRING = INSTR(1:LENSTR)

	RETURN
	END
C-----------------------------------------------------------------------
	SUBROUTINE SCANER(TOKEN,SIZE)
C
C	   Routine to scan the STRING and parse it into individual
C	   fields.  Each time SCANER is called it returns the next
C	   field in TOKEN and its length in SIZE.  The field
C	   delimiters are stored in DELIM.  The variables DELIM,
C	   NUMDEL, STRING, LENSTR and PTR are initialized in the
C	   cooperating routine SCANIN.  SCANIN must be called once
C	   before SCANER is called for each string parsed.  Multiple
C	   blanks between fields are compressed down to one.
C
C	   When the field is null, TOKEN is set to blanks.
C	   When no fields remain, TOKEN(1:1) is set to blank, while
C	   the rest of TOKEN is unchanged.
C
C		DELIM  - The string of 1-96 delimiters used by SCANER.
C		NUMDEL - Then number of delimiter characters in DELIM.
C		STRING - The string of 1-255 characters to be parsed.
C		LENSTR - The length of STRING.
C		PTR    - Pointer to the next character to be parsed.
C		TOKEN  - The field returned to the calling program.
C		SIZE   - Length of the TOKEN.  Possible values are:
C		            1-n  a string from one to "n" characters
C		                 long,
C		              0  two successive delimiters resulted in
C		                 a null field of length zero,
C		             -1  the end of the string has been reached,
C		                 no fields remain.
C
C
C	   By: Mark Holomany, JCPDS     Date: 30-Jan-1984
C
C
	IMPLICIT INTEGER (A-Z)
	CHARACTER  TOKEN*(*)
	CHARACTER  DELIM*96,STRING*255
	COMMON /SCNCMN/ PTR,NUMDEL,LENSTR,DELIM,STRING
C
C	... Find the the first non-blank character.
	DO 10 I=PTR,LENSTR
	IF(STRING(I:I) .NE. ' ') GO TO 20
10	CONTINUE
C
C	... No fields remain in the STRING
	PTR = LENSTR
	SIZE = -1
	TOKEN(1:1) = ' '
	RETURN
C
C	... Search for the next delimiter
20	CONTINUE
	START = I
	DO 30 I=START,LENSTR
	IF( INDEX(DELIM(1:NUMDEL), STRING(I:I))  .NE.  0) THEN
	   PTR = I + 1
	   SIZE = I - START
	   IF(SIZE.GE.1) THEN
	      TOKEN = STRING(START:I-1)
	   ELSE
	      TOKEN = ' '
	   ENDIF
	   RETURN
	ENDIF
30	CONTINUE
C
C	... No delimiters remain; therefore the field extends to the
C	... end of the STRING.
	PTR = LENSTR + 1
	SIZE = LENSTR - START + 1
	IF(SIZE.GE.1) THEN
	   TOKEN = STRING(START:LENSTR)
	ELSE
	   TOKEN = ' '
	ENDIF
	RETURN
	END






