#!/bin/sh
# the next line restarts this script using wish found in the path\
exec wish "$0" "$@"
# If this does not work, change the #!/usr/bin/wish line below
# to reflect the actual wish location and delete all preceeding lines
#
# (delete here and above)
#!/usr/bin/wish
# $Id: $
#
# required files 
set pdf2files {codens.tbl mineral.tbl picodes.tbl stdcodes.tbl}
# output files 
set outlist {dsp3s.bit pdsize.txt chem.bit elemcnt.bit di.lib jcpds.ind \
	misc.bit name.lib ref.lib}
#
set settings(script) [info script]
# translate links -- go six levels deep
foreach i {1 2 3 4 5 6} {
    if {[file type $settings(script)] == "link"} {
	set link [file readlink $settings(script)]
	if { [file  pathtype  $link] == "absolute" } {
	    set settings(script) $link
	} else {
	    set settings(script) [file dirname $settings(script)]/$link
	}
    } else {
	break
    }
}
# fixup relative paths
if {[file pathtype $settings(script)] == "relative"} {
    set settings(script) [file join [pwd] $settings(script)]
}

set settings(scriptdir) [file dirname $settings(script)]
set settings(pdf2tbl) [file join [file dirname $settings(scriptdir)] pdf2]

proc ViewLog {filelist} {
    catch {eval destroy [winfo children .log]}
    catch {toplevel .log}
    grid [text .log.1 -relief raised -bd 2 -height 20 -width 80 \
	    -wrap none -font "Courier -12" \
	    -yscrollcommand ".log.s set" \
	    -xscrollcommand ".log.a set"] -column 1 -row 1 -sticky nsew
    grid [scrollbar .log.s -command ".log.1 yview"] -row 1 -column 2 -sticky ns
    grid [scrollbar .log.a -command ".log.1 xview" -orient horizontal] \
	    -column 1 -row 2 -sticky ew
    grid columnconfig .log 1 -weight 1
    grid rowconfig .log 1 -weight 1
    .log.1 delete 0.0 end
    foreach file $filelist {
	set fp [open $file r]
	.log.1 insert end [read $fp]
	close $fp
    }
    grid [button .log.quit -text Done -command exit] \
	    -column 1 -columnspan 2 -row 3 -sticky e
}
proc MakeStat {prog fp} {
    global settings
    set settings(status) "............starting up the program............"
    toplevel .stat
    grid [label .stat.1 -text "Running $prog program"]
    grid [label .stat.stat -textvariable settings(status)]
    grid [button .stat.quit -text Quit -command exit]
    putontop .stat
    after 100 "ShowStat $fp"
}
proc ShowStat {fp} {
    global settings
    seek $fp 0
    set settings(status) [string trim [read $fp]]
    if {[string match -nocase *DONE* $settings(status)]} {
	destroy .stat
    } else {
	after 1000 "ShowStat $fp"
    }
}
proc putontop {w} {
    # center window $w above its parent and make it stay on top
    set wp [winfo parent $w]
    wm transient $w [winfo toplevel $wp]
    wm withdraw $w
    update idletasks
    # center the new window in the middle of the parent
    set x [expr [winfo x $wp] + [winfo width $wp]/2 - \
	    [winfo reqwidth $w]/2 - [winfo vrootx $wp]]
    if {$x < 0} {set x 0}
    set xborder 10
    if {$x+[winfo reqwidth $w] +$xborder > [winfo screenwidth $w]} {
	incr x [expr \
		[winfo screenwidth $w] - ($x+[winfo reqwidth $w] + $xborder)]
    }
    set y [expr [winfo y $wp] + [winfo height $wp]/2 - \
	    [winfo reqheight $w]/2 - [winfo vrooty $wp]]
    if {$y < 0} {set y 0}
    set yborder 25
    if {$y+[winfo reqheight $w] +$yborder > [winfo screenheight $w]} {
	incr y [expr \
		[winfo screenheight $w] - ($y+[winfo reqheight $w] + $yborder)]
    }
    wm geom $w +$x+$y
    wm deiconify $w

    global makenew
    set makenew(OldGrab) ""
    set makenew(OldFocus) ""
    catch {set makenew(OldFocus) [focus]}
    catch {set makenew(OldGrab) [grab current $w]}
    catch {grab $w}
}

proc afterputontop {} {
    # restore focus
    global makenew
    # reset focus & grab
    catch {
	if {$makenew(OldFocus) != ""} {
	    focus $makenew(OldFocus)
	}
    }
    catch {
	if {$makenew(OldGrab) != ""} {
	    grab $makenew(OldGrab)
	}
    }
}




set settings(pdf2) ????
# on windows look for the pdf2 file
if {$tcl_platform(platform) == "windows"} {
    set list {}
    foreach vol [file volumes] {
	if {$vol == "A:/" || $vol == "B:/"} continue
	set list [concat $list [glob -nocomplain [file join $vol pdf2* pdf2.dat]]]
    }
    set prv pdf20000
    # get the most recent version
    foreach item $list {
	set tst [lindex [file split $item] 1]
	if {[string compare -nocase $tst $prv] == 1} {
	    set settings(pdf2) $item
	    set prv $tst
	}
    }
}
foreach file $pdf2files {
    if {![file exists [file join $settings(pdf2tbl) $file]]} {
	tk_dialog .warn "File not found" \
		"Error: file $file not found in distribution directory. This should not happen if the files have been correctly installed." \
		error 0 "Reinstall & try again"
	exit
    }
}

set settings(outdir) [file join [file dirname $settings(scriptdir)] indexfiles]
grid [label .1b -textvariable settings(outdir)] -column 2 -row 1
set bg [.1b cget -bg]
set fg [.1b cget -fg]
grid [label .1a -text "Output directory" -fg $bg -bg $fg] -column 1 -row 1 \
	-sticky ew
grid [button .1c -text Edit \
	-command {destroy .1b; grid [entry .1b -textvariable settings(outdir)] -column 2 -row 1 -sticky ew} \
	] -column 3 -row 1
grid [label .2a -text "Input PDF2 file" -fg $bg -bg $fg] -column 1 -row 2 \
	-sticky ew
grid [label .2b -textvariable settings(pdf2)] -column 2 -row 2
grid [button .2c -text Browse -command {
    set file [tk_getOpenFile -initialfile pdf2.dat -parent .];
    if {$file != ""} {set settings(pdf2) $file}
}] -column 3 -row 2
grid [button .2d -text "Use test data" \
	-command "set settings(pdf2) [list [file join [file dirname $settings(scriptdir)] test/pdf2.dat]]"] -column 4 -row 2

grid [label .3a -text "Local PDF2 file" -fg $bg -bg $fg] -column 1 -row 3 \
	-sticky ew
grid [label .3b -textvariable settings(localpdf2)] -column 2 -row 3
set settings(localpdf2) (none)
grid [button .3c -text Browse -command {
    set file [tk_getOpenFile -initialfile pdf2.dat -parent .];
    if {$file != ""} {set settings(localpdf2) $file}
}] -column 3 -row 3
grid [button .3d -text "clear" \
	-command "set settings(pdf2) (none)"] -column 4 -row 3

grid [label .5a -text "Deleted pattern\ntreatment" -fg $bg -bg $fg] -column 1 -row 4 \
	-sticky ew
grid [frame .5b] -column 2 -columnspan 99 -row 4 -sticky w
grid [checkbutton .5b.1 -text "Include deleted patterns" \
	-variable settings(usedel)] -column 1 -row 1 -sticky w
grid [checkbutton .5b.2 -text "Include peak positions from deleted patterns" \
	-variable settings(delDI)] -column 1 -row 2 -sticky w
set settings(delDI) 0
set settings(usedel) 1

grid [label .6a -text "Write peak\nindexes at" -fg $bg -bg $fg] \
	-column 1 -row 6 -sticky ew
grid [entry .6b -textvariable settings(peakindex)] \
	-column 2 -columnspan 2 -row 6 -sticky ew
grid [label .6c -text "percent"] \
	-column 4 -row 6 -sticky ew
set settings(peakindex) "30, 70"

grid [frame .9] -column 0 -columnspan 99 -row 9
grid [button .9.a -text "Install\nPDF2" \
	-command "set settings(go) 1"] -column 0 -row 0
grid [button .9.b -text "Quit" \
	-command "exit"] -column 1 -row 0 -sticky ns
set settings(go) 0
set OK 0
while {!$OK} {
    tkwait variable settings(go)
    set OK 1; # assume the best

    if {![file exists $settings(pdf2)]} {
	set OK 0
	tk_dialog .warn "File not found" \
		"Error: PDF-2 file $settings(pdf2) not found" \
		error 0 "Try again"
	continue
    }
    set peaklist {}
    set errlist {}
    foreach num [split $settings(peakindex) ", "] {
	if {$num == {}} continue
	if {[catch {expr $num}]} {
	    set OK 0
	    lappend errlist $num
	    continue
	}
	if {$num < 0 || $num > 100} {
	    set OK 0
	    lappend errlist $num
	    continue
	}
	lappend peaklist $num
    }
    if {!$OK} {
	tk_dialog .warn "Invalid peak entry" \
		"Error: value(s) \"$errlist\" are not valid for peak indices" \
		error 0 "Try again"
	continue
    }
    # always generate the "3 strongest" index, 999 terminates the list
    lappend peaklist 0 -1 999
    # fixup relative paths
    if {[file pathtype $settings(outdir)] == "relative"} {
	set settings(outdir) [file join [pwd] $settings(outdir)]
    }
    # make sure the name ends with a slash
    set settings(outdir) [string trim $settings(outdir)]
    if {[string range $settings(outdir) end end] != "/"} {
	append settings(outdir) "/"
    }
    if {[catch {file mkdir $settings(outdir)} errmsg]} {
	set OK 0
	tk_dialog .warn "Could not create directory" \
		"Error: could not create output directory $settings(outdir)\nError message: $errmsg" \
		error 0 "Change & Try again"
	continue
    }
    set notfound {}
    foreach file {pdencode wrchem wrdi} {
	if {[auto_execok [file join $settings(scriptdir) $file]] == ""} {
	    lappend notfound $file
	    set OK 0
	} 
    }
    if {!$OK} {
	tk_dialog .warn "Missing executable" \
		"Error: the following file(s) were missing from directory $settings(scriptdir): ${notfound}. Was LOGIC compiled properly?" \
		error 0 "Compile & Try again"
	continue
    }
}

# cleanup any old files
if {[catch {
    foreach pattern {*.bit pdsize.txt *.lib jcpds.ind *.out} {
	foreach file [glob -nocomplain [file join $settings(outdir) $pattern]] {
	    file delete -force $file
	}
    }
    
    # copy over the pdf2 support files
    foreach file $pdf2files {
	file copy -force [file join $settings(pdf2tbl) $file] $settings(outdir)
    }
} errmsg]} {
    tk_dialog .warn "Error in cleanup" \
	"Error creating/deleting files in directory $settings(outdir). Check protections.\n\nError message: $errmsg" \
	error 0 Sorry
    exit
}


# create input files
set fp [open [file join $settings(outdir) encode.in] w]
puts $fp $settings(outdir)
puts $fp $settings(pdf2)
puts $fp $settings(localpdf2)
if {$settings(usedel)} {
    puts $fp "Y  (Include deleted patterns)"
} else {
    puts $fp "N  (Don't include deleted patterns)"
}
if {$settings(delDI) && $settings(usedel)} {
    puts $fp "Y  (Include D/I tables from deleted patterns)"
} else {
    puts $fp "N  (Don't include D/I tables from deleted patterns)"
}
close $fp

set fp [open [file join $settings(outdir) wrdi.in] w]
puts $fp $settings(outdir)
puts $fp $settings(pdf2)
puts $fp $settings(localpdf2)
foreach num $peaklist {
    puts $fp $num
}
close $fp

file delete -force [file join $settings(outdir) runstat.txt]
set fp [open [file join $settings(outdir) runstat.txt] w]
close $fp
set fp [open [file join $settings(outdir) runstat.txt] r]
fconfigure $fp -blocking 0

MakeStat PDENCODE $fp
exec [file join $settings(scriptdir) pdencode] \
	< [file join $settings(outdir) encode.in] \
	>& [file join $settings(outdir) encode.out] &
tkwait window .stat

close $fp
file delete -force [file join $settings(outdir) runstat.txt]
set fp [open [file join $settings(outdir) runstat.txt] w]
close $fp
set fp [open [file join $settings(outdir) runstat.txt] r]
fconfigure $fp -blocking 0

MakeStat WRCHEM $fp
exec [file join $settings(scriptdir) wrchem] \
	< [file join $settings(outdir) encode.in] \
	>& [file join $settings(outdir) wrchem.out] &
tkwait window .stat

close $fp
file delete -force [file join $settings(outdir) runstat.txt]
set fp [open [file join $settings(outdir) runstat.txt] w]
close $fp
set fp [open [file join $settings(outdir) runstat.txt] r]
fconfigure $fp -blocking 0

MakeStat WRDI $fp
exec [file join $settings(scriptdir) wrdi] \
	< [file join $settings(outdir) wrdi.in] \
	>& [file join $settings(outdir) wrdi.out] &
tkwait window .stat
close $fp

if {[catch {
    # create the PDF-2 source file
    if {$tcl_platform(platform) == "windows"} {
	set file "c:/icddloc.txt"
    } else {
	set file "~/.icdd_files_loc"
    }
    set fp [open $file w]
    puts $fp $settings(outdir)
    puts $fp $settings(pdf2)
    puts $fp $settings(localpdf2)
    close $fp
} errmsg]} {
    tk_dialog .warn "Error with pointer file" \
	"Error creating pointer file $file. This file is essential for LOGIC to run.\n\nError message: $errmsg" \
	error 0 Sorry
    exit
}

# check for required files
set missing {} 
if {![file exists [file join $settings(outdir) $file]]} {
    lappend missing $file
}
if {$missing != ""} {
    tk_dialog .warn "Missing file(s)" \
	    "The following files, that should have been created by the ENCODE programs are missing: $missing.\n\nView the log file and determine what went wrong"\
	    error 0 Sorry
    set ans 0
} else {
    set ans [tk_dialog .warn "View log" \
	    "ENCODE runs completed.\nView log from encode programs?" "" 0 Yes No]
}
if {$ans == 0} {
    ViewLog [list [file join $settings(outdir) encode.out] \
			[file join $settings(outdir) wrchem.out] \
			[file join $settings(outdir) wrdi.out]]

    tkwait window .log
}

exit
