      include 'copyrght.def'
C
C-----------------------------------------------------------------------
	integer*4 function psl_elemsub(ilogic, reqval, optval,
     1			reqelem, reqgrp, optelem, optgrp)
C locate entries based on chemical composition 
C-----------------------------------------------------------------------
	implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_elemsub

	INTEGER*4 ilogic, reqval, optval
	LOGICAL*4 reqelem(103), optelem(103)
	LOGICAL*4 reqgrp(18), optgrp(18)
C-----------------------------------------------------------------------
C ilogic determines the logic to be applied to the tables
C	0	 Match with table
C	1	 Add to table
C	2	 Remove from table
C REQVAL & OPTVAL determine the logic to be applied with the elements
C  REQVAL = 0 all elements in reqelem & reqgrp are required
C         = 1 at least 1 element in reqelem & reqgrp is required
C  OPTVAL = 0 all elements are allowed (ignore optelem & optgrp)
C         = 1 only the selected elements are allowed
C-----------------------------------------------------------------------
	include 'bitops.def'
	include 'pdfread.def'

	include 'pdfdefs.par'

	include 'pdf.cmn'
	include 'logic.cmn'
	include 'elemsyms.cmn'

	CHARACTER*(*) subrnm
	PARAMETER (subrnm='psl_elemsub')

	LOGICAL notallowed(104)
C elements used in groups
	integer   specsym(16,18) 
	integer*4 I,J,i1,ln,lench,K
	CHARACTER*100 TRACE

	include 'elemsyms.dat'
C define elements used in groups
C element "1" symbol 1A - period 1 (Li,Na,K,Rb,Cs,Fr)
	DATA specsym/
     5  3,11,19,37,55,87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "2" symbol 2A - period 2 (Be,Mg,Ca,Sr,Ba,Ra)
     6  4,12,20,38,56,88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "3" symbol 3A - period 3 (B,Al,Ga,In,Tl)
     7  5,13,31,49,81, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "4" symbol 4A - period 4 (C,Si,Ge,Sn,Pb)
     8  6,14,32,50,82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "5" symbol 5A - period 5 (N,P,As,Sb,Bi)
     9  7,15,33,51,83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "6" symbol 6A - period 6 (O,S,Se,Te,Po)
     1  8,16,34,52,84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "7" symbol 7A - period 7 (F,Cl,Br,I,At)
     1  9,17,35,53,85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "8" symbol 8A - period 8 (He,Ne,Ar,Kr,Xe,Rn)
     2 10,18,36,54,86, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "9" symbol 1B - transition metals block 9 (Cu,Ag,Au)
     3 29,47,79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "10" symbol 2B - transition metals block 10 (Zn,Cd,Hg)
     4 30,48,80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "11" symbol 3B - transition metals block 1 (Sc,Y,La,Ac)
     5 21,39,57,89, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "12" symbol 4B - transition metals block 2 (Ti,Zr,Hf)
     6 22,40,72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "13" symbol 5B - transition metals block 3 (V,Nb,Ta)
     7 23,41,73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "14" symbol 6B - transition metals block 4 (Cr,Mo,W)
     8 24,42,74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "15" symbol 7B - transition metals block 5 (Mn,Tc,Re)
     9 25,43,75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
C element "16" symbol 8B - transition metals block 6-8 (Fe-Ni,Ru-Pd,Os-Pt)
     1 26,27,28,44,45,46,76,77,78, 0, 0, 0, 0, 0, 0, 0,
C element "17" symbol LN - Lanthanides (La - Lu)
     4 57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,104,
C element "18" symbol AD - Actinides (Ac-Lr)
     1 89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,0/

C correct for usage of special element symbols
C
C Required element groups:
C   When using the required special element OR together all the real elements
C   comprising the special symbol, except for Ln which already has 
C   its own bitmap
C Warn if a element is included individually and in a group
C
C Optional element groups:
C   for a special symbol set all "real" elements in the group to be ignored 
C   and then remove the special symbol from the list

C! debug code
!	open (unit=99,file='elemsub.out',status='unknown')
!	write (99,*) ' ilogic= ',ilogic
!	if (reqval .eq. 0) write (99,*) ' Following elements required:'
!	if (reqval .ne. 0) write (99,*) ' 1 of these elements required:'
!	DO i=1,103
!	  IF (reqelem(i)) write (99,*) ' required= ',CHSYM(i)
!	ENDDO
!	DO i=1,18
!	  IF (reqgrp(i)) write (99,*) ' required= ',CHSYM(104+i)
!	ENDDO
!	if (optval .eq. 0) write (99,*) ' All elements optional'
!	if (optval .ne. 0) write (99,*) ' Optional elements:'
!	DO i=1,103
!	  IF (optelem(i)) write (99,*) ' optional= ',CHSYM(i)
!	ENDDO
!	DO i=1,18
!	  IF (optgrp(i)) write (99,*) ' optional= ',CHSYM(104+i)
!	ENDDO
!! end debug

C set the elements to be removed
	DO I=1,104
	  notallowed(I) = .true.
	enddo

C remove required elements if they are duplicated in groups 
      DO J=1,18
	  IF (reqgrp(j)) then
	    DO i1=1,16
	      i = specsym(i1,J)
	      if (i .ne. 0) THEN
	        IF (i .le. 103 .and. reqelem(i)) then
		   call warnmsg(subrnm,' Reseting element '//
	1	      CHSYM(i)//' because '//CHSYM(j+104)//
     $                  ' was coded')
	          reqelem(i) = .false.
	        ENDIF
C set the corresponding element as allowed
	        notallowed(I) = .false.
	      ENDIF
	    ENDDO
	  ENDIF

	  IF (optgrp(j)) then
	    DO i1=1,16
	      i = specsym(i1,J)
	      IF (i .ne. 0 .and. i.le.103) notallowed(I) = .false.
	    ENDDO
	  ENDIF
      ENDDO
C if any of the lanthanides are required, then LN is optional
      DO i1=1,16
         i = specsym(i1,17)
         IF (i .le. 103 .and. reqelem(i))  notallowed(104) = .false.
      ENDDO
C is the element either optional or required?
	DO I=1,103
	  IF (optelem(i) .or. reqelem(i)) notallowed(I) = .false.
      ENDDO

C========================================================================
C now perform the chemistry search
C========================================================================
      CALL ps_openchem(i)
      IF (i .ne. 0) THEN
	 call errmsg(subrnm,'Unable to open Chemistry bitmap file')
	 psl_ELEMSUB = -1
	 RETURN
	ENDIF

C 
	IF (REQVAL .eq. 0) THEN
C all selected elements are required -- we will AND together
	   nph1 = TBLSET(TABLE1,N_cards)
	ELSE
C any of the selected elements is required -- we will OR together
	  nph1 = TBLCLR(TABLE1,N_Cards)
	ENDIF

C Do the required groups
      DO J=1,18
	  nph2 = TBLCLR(TABLE2,N_Cards)
	  IF (reqgrp(j)) then
!! debug
!	write (99,*) ' Required group= ',CHSYM(104+j)
	    DO i1=1,16
	      i = specsym(i1,J)
	      IF (i .gt. 0) then
!! debug
!	write (99,*) '  + ',CHSYM(i)
		 k = ps_readbitlib(I, table3, N_cards)
		 IF (k .ne. 0) THEN
		    call errmsg(subrnm,
	1		 'reading PDF Chemistry INDEX file')
		    psl_ELEMSUB = -1
		    RETURN
		 ENDIF
C   OR together the required groups elements as if they were a single entry
		 CALL TBLOR(TABLE3,TABLE2,TABLE2,N_Cards)
	      ENDIF
	   enddo
!! debug
!	write (99,'(A,i6)') 'TABLE2 = ',tblcount(table2,N_Cards)
C now we can treat the group as if we read it directly
	    IF (REQVAL .eq. 0) THEN
C all required elements are required - AND
	      CALL TBLAND(TABLE1,TABLE2,TABLE1,N_Cards)
	    ELSE
C any of the required elements is needed -- OR
	      CALL TBLOR(TABLE1,TABLE2,TABLE1,N_Cards)
	    ENDIF
!! debug
!	write (99,'(A,i6)') 'TABLE1 = ',tblcount(table1,N_Cards)
	  ENDIF
	ENDDO
	DO i=1,103
	  IF (reqelem(i)) THEN
	     k = ps_readbitlib(I, table2, N_cards)
	     IF (k .ne. 0) THEN
		call errmsg(subrnm,'reading PDF Chemistry bitmap')
		psl_ELEMSUB = -1
		RETURN
	     ENDIF
!! debug
!	write (99,*) 'Required Element = ',CHSYM(i)
!	write (99,'(A,i6)') 'TABLE2 = ',tblcount(table2,N_Cards)
	    IF (REQVAL .eq. 0) THEN
C all required elements are required - AND
	      CALL TBLAND(TABLE1,TABLE2,TABLE1,N_Cards)
	    ELSE
C any of the required elements is needed -- OR
	      CALL TBLOR(TABLE1,TABLE2,TABLE1,N_Cards)
	    ENDIF
!! debug
!	write (99,'(A,i6)') 'TABLE1 = ',tblcount(table1,N_Cards)
	  ENDIF
	ENDDO

C now remove all elements that are not allowed
	IF (optval .ne. 0) THEN
	  DO I=1,104
	    IF (notallowed(i)) then
	       k = ps_readbitlib(I, table2, N_cards)
	       IF (k .ne. 0) THEN
		  call errmsg(subrnm,
	1	       'reading PDF Chemistry INDEX file')
		  psl_ELEMSUB = -1
		  RETURN
	       ENDIF
	      CALL TBLNOT(TABLE2,TABLE2,N_Cards)
	      CALL TBLAND(TABLE1,TABLE2,TABLE1,N_Cards)
!	    ELSE
!! debug
!	write (99,*) 'Not Removing Element = ',CHSYM(i)
		ENDIF
	  ENDDO
	ENDIF
C========================================================================
C now setup the history entry
C========================================================================
	call ps_closebitlib
	IF (REQVAL .eq. 0) THEN
	  TRACE = 'Required elements:'
	else
	  TRACE = 'Required elements, one of:'
	endif
	k = 0
	ln = lench(TRACE)+1
	DO i=1,103
	  IF (reqelem(i)) THEN
		k = K + 1
	    if (ln .lt. 70) then 
		  trace(ln+1:) = CHSYM(i)
	      ln = lench(TRACE) + 1
		  trace(ln:) = ','
		endif
	  ENDIF
	ENDDO
	DO i=1,18
	  IF (reqgrp(i)) THEN
		k = K + 1
	    if (ln .lt. 70) then
		  trace(ln+1:) = CHSYM(104+i) 
	      ln = lench(TRACE) + 1
		  trace(ln:) = ','
	    endif
	  ENDIF
	ENDDO
	if (k .eq. 0) then
	   ln = lench(TRACE)
	   if (ln .lt. 70) trace(ln+1:) = 'NONE,'
	endif
	ln = lench(TRACE)
	IF (optval .gt. 0) THEN
	  if (ln .lt. 70) trace(ln+1:) = ' allowed:'
	  k = 0
	  DO i=1,103
	    IF (optelem(i)) THEN
	      ln = lench(TRACE)
	      k = K + 1
	      if (ln .lt. 70) then
	        ln = ln + 1
	        if (K .gt. 1) trace(ln:) = ','
	        trace(ln+1:) = CHSYM(i)
		  endif
	    ENDIF
	  ENDDO
	  DO i=1,18
	    IF (optgrp(i)) THEN
	      ln = lench(TRACE)
		  k = K + 1
	      if (ln .lt. 70) then
		    ln = ln + 1
	        if (K .gt. 1) trace(ln:) = ','
	        if (ln .lt. 70) trace(ln+1:) = CHSYM(104+i)
		  endif
	    ENDIF
	  ENDDO
	  ln = lench(TRACE)
	  if (k .eq. 0) then
	    if (ln .lt. 70) trace(ln+1:) = 'NONE'
	    ln = lench(TRACE)
	  endif
	ELSE
	 if (ln .lt. 70) trace(ln+1:) = ' All others allowed'
	ENDIF

!! debug
!	write (99,'(A,i6)') 'TABLE = ',tblcount(table,N_Cards)
!	write (99,'(A,i6)') 'TABLE1 = ',tblcount(table1,N_Cards)

	CALL TBLLOGIC(ilogic, trace)

!! debug
!	write (99,'(2A)') 'after TBLLOGIC, trace=',trace
!	write (99,'(A,i6)') 'TABLE = ',tblcount(table,N_Cards)
!	close(99)
	psl_elemsub = NPHASE
	RETURN
	END







