#include "copyrght.h"
#include "logicmap.h"
/* ------------------------------------------------------------------ */
/* Clear all entries from bitmap table */
/* ------------------------------------------------------------------ */

INTEGER4 MSFLAG TBLCLR (
	      unsigned INTEGER4 * table,	/* table to store bit map  */
	      INTEGER4 * nentries)	        /* total number of entries */
{
  int i;
  long nwords;
  nwords = (31+*nentries)/32;
  for (i=0; i<nwords; i++)
    table[i] = 0;
  return 0;
}

/* ------------------------------------------------------------------ */
/* Set all entries in bitmap table */
/* ------------------------------------------------------------------ */
INTEGER4 MSFLAG TBLSET (
	      unsigned INTEGER4 * table,	/* table to store bit map  */
	      INTEGER4 * nentries)	        /* total number of entries */
{
  int i,k,nbits;
  unsigned INTEGER4 bitmask;
  k = (*nentries)/32; 
  for (i=0; i<k; i++)
    {
    table[i] = -1;
    }
/* remaining entries, if any */
  nbits = (*nentries) - k*32;
  bitmask = 1;
  for (i=0; i<nbits; i++)
    {
      table[k] |= bitmask;
      bitmask <<= 1;
    }
  return *nentries;
}

/* ------------------------------------------------------------------ */
/* Count the number of entries in bitmap table */
/* ------------------------------------------------------------------ */
INTEGER4 MSFLAG TBLCOUNT (
	      unsigned INTEGER4 * table,	/* table to store bit map  */
	      INTEGER4 * nentries)	        /* total number of entries */
{
  long nhits;
  int i,j;
  unsigned INTEGER4 bitmask; 
  long nwords;

  nhits = 0;
  nwords = (31+*nentries)/32;
  for (i=0; i<nwords; i++)
    if (table[i] == -1)
      nhits += 32;
    else if (table[i] != 0)
      {
	bitmask = 1;
	for (j=0; j<32; j++)
	  {
	    if ((table[i] & bitmask) != 0) nhits++;
	    bitmask <<= 1;
	  }
      }

   return nhits;
}

/* ------------------------------------------------------------------ */
/* duplicate a bitmap table */
/* ------------------------------------------------------------------ */
void MSFLAG TBLCOPY (
	      unsigned INTEGER4 * tablein,	/* table to store bit map  */
	      unsigned INTEGER4 * tableout,	/* table to store bit map  */
	      INTEGER4 * nentries)	        /* total number of entries */
{
  int i;

  long nwords;
  nwords = (31+*nentries)/32;
  for (i=0; i<nwords; i++)
    tableout[i] = tablein[i];
}

/* ------------------------------------------------------------------ */
/* Or together two bitmap tables */
/* ------------------------------------------------------------------ */
void MSFLAG TBLOR (
	      unsigned INTEGER4 * table1,	/* table to store bit map  */
	      unsigned INTEGER4 * table2,	/* table to store bit map  */
	      unsigned INTEGER4 * tableout,	/* table to store bit map  */
	      INTEGER4 * nentries)	        /* total number of entries */
{
  int i;
  long nwords;
  nwords = (31+*nentries)/32;
  for (i=0; i<nwords; i++)
    tableout[i] = table1[i] | table2[i] ;
}

/* ------------------------------------------------------------------ */
/* And together two bitmap tables */
/* ------------------------------------------------------------------ */
void MSFLAG TBLAND (
	      unsigned INTEGER4 * table1,	/* table to store bit map  */
	      unsigned INTEGER4 * table2,	/* table to store bit map  */
	      unsigned INTEGER4 * tableout,	/* table to store bit map  */
	      INTEGER4 * nentries)	        /* total number of entries */
{
  int i;

  long nwords;
  nwords = (31+*nentries)/32;
  for (i=0; i<nwords; i++)
    tableout[i] = table1[i] & table2[i] ;
}

/* ------------------------------------------------------------------ */
/* Inverse (Logical not) of a bitmap table */
/* ------------------------------------------------------------------ */
void MSFLAG TBLNOT (
	      unsigned INTEGER4 * table,	/* table to store bit map  */
	      unsigned INTEGER4 * tableout,	/* table to store bit map  */
	      INTEGER4 * nentries)	/* number of entries */
{
  int i,nbits;
  long nwords;
  unsigned INTEGER4 bitmask;
  nwords = (*nentries)/32; 

  for (i=0; i < nwords; i++)
    tableout[i] = -1 ^ table[i] ;
/* process last word, if any */
  nbits = (*nentries) - nwords*32;
  bitmask = 1;
  tableout [nwords] = table[nwords];
  for (i=0; i<nbits; i++)
    {
      tableout [nwords] ^= bitmask;
      bitmask <<= 1;
    }
}

/* ------------------------------------------------------------------ */
/* Set bit in a bitmap table corresponding to sequence number SEQNO */
/* ------------------------------------------------------------------ */
void MSFLAG TBLBITSET (
	      unsigned INTEGER4 * table,	/* table to store bit map  */
	      INTEGER4 * seqno,	        /* sequence number to set */
	      INTEGER4 * nentries,	        /* number of entries */
	      INTEGER4 * setval)	        /* value (1,0) to set */
{
  int i,nbit;
  long nword;
  unsigned INTEGER4 bitmask;

  if (*seqno > *nentries) return; /* is this a valid number? */

  nword = (-1 + *seqno)/32; 
  nbit = (-1 + *seqno) - nword*32;

  bitmask = 1;
  for (i=0; i<nbit; i++)
      bitmask <<= 1;
  if (*setval == 0) 
    {
      bitmask ^= -1;
      table[nword] &= bitmask;
    }
  else
    table[nword] |= bitmask;
}

/* ------------------------------------------------------------------ */
/* Test a selected bit in a bitmap table                               */
/* ------------------------------------------------------------------ */
INTEGER4 MSFLAG TBLBITTEST (
	      unsigned INTEGER4 * table,	/* table to store bit map  */
	      INTEGER4 * seqno,	        /* sequence number to set */
	      INTEGER4 * nentries)	        /* number of entries */
{
  int i,nbit;
  long nword;
  unsigned INTEGER4 bitmask;

  if (*seqno > *nentries) return -1; /* is this a valid number? */

  nword = (-1 + *seqno)/32; 
  nbit = (-1 + *seqno) - nword*32;

  bitmask = 1;
  for (i=0; i<nbit; i++)
      bitmask <<= 1;
  if ((table[nword] & bitmask) == 0)
    return 0;
  else
    return 1;
}

