      SUBROUTINE MINV(A,N,D,L,M)
C
C  MATRIX INVERSION. COPIED FROM THE I.B.M. SCIENTIFIC SUBROUTINE PACKAG
C
      DIMENSION A(64),L(8),M(8)
      D=1.0
      NK=-N
      DO 80 K=1,N
      NK=NK+N
      L(K)=K
      M(K)=K
      KK=NK+K
      BIGA=A(KK)
      DO 20 J=K,N
      IZ=N*(J-1)
      DO 20 I=K,N
      IJ=IZ+I
   10 IF(ABS(BIGA).GE.ABS(A(IJ))) GO TO 20
      BIGA=A(IJ)
      L(K)=I
      M(K)=J
   20 CONTINUE
      J=L(K)
      IF(J .LE. K) GO TO 35
      KI=K-N
      DO 30 I=1,N
      KI=KI+N
      HOLD=-A(KI)
      JI=KI-K+J
      A(KI)=A(JI)
      A(JI)=HOLD
   30 CONTINUE
   35 I=M(K)
      IF(I .LE. K) GO TO 45
      JP=N*(I-1)
      DO 40 J=1,N
      JK=NK+J
      JI=JP+J
      HOLD=-A(JK)
      A(JK)=A(JI)
      A(JI)=HOLD
   40 CONTINUE
   45 IF (ABS(BIGA) .GT. 0.0001) GO TO 48
      D=0.0
      RETURN
   48 DO 55 I=1,N
      IF(I .EQ. K) GO TO 55
      IK=NK+I
      A(IK)=A(IK)/(-BIGA)
   55 CONTINUE
      DO 65 I=1,N
      IK=NK+I
      HOLD=A(IK)
      IJ=I-N
      DO 65 J=1,N
      IJ=IJ+N
      IF(I .EQ. K) GO TO 65
      IF(J .EQ. K) GO TO 65
      KJ=IJ-I+K
      A(IJ)=HOLD*A(KJ)+A(IJ)
   65 CONTINUE
      KJ=K-N
      DO 75 J=1,N
      KJ=KJ+N
      IF(J .EQ. K) GO TO 75
      A(KJ)=A(KJ)/BIGA
   75 CONTINUE
      D=D*BIGA
      A(KK)=1.0/BIGA
   80 CONTINUE
      K=N
  100 K=(K-1)
      IF(K .LE. 0) GO TO 150
      I=L(K)
      IF(I .LE. K) GO TO 120
      JQ=N*(K-1)
      JR=N*(I-1)
      DO 110 J=1,N
      JK=JQ+J
      HOLD=A(JK)
      JI=JR+J
      A(JK)=-A(JI)
      A(JI)=HOLD
  110 CONTINUE
  120 J=M(K)
      IF(J .LE. K) GO TO 100
      KI=K-N
      DO 130 I=1,N
      KI=KI+N
      HOLD=A(KI)
      JI=KI-K+J
      A(KI)=-A(JI)
      A(JI)=HOLD
  130 CONTINUE
      GO TO 100
  150 RETURN
      END
      SUBROUTINE NORM(A,B,FMAAS)
C-----------------------------------------------------------------------
C  NORM PUTS ZONES INTO THEIR  STANDARD (NORMALISED) FORM..
C  IT LOOKS FOR SYMMETRY AND MAKES  SKEW ZONES  AS NEAR TO RECTANGULAR
C  AS POSSIBLE.    A AND B ARE INTERCHANGED IF  A>B.
C-----------------------------------------------------------------------
      LOGICAL SELF,ENL,TEST
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      IF (TEST) WRITE(IOUT,1) A,B,FMAAS
  10  IF (A .LT. FMINIM) GO TO 65
      IF ( B-A .GE.0.0) GO TO 20
      AA=A
      A=B
      B=AA
  20  IF (ABS(B-FMAAS).GE.FMINEQ) GO TO 30
      AA=A
      A=0.25*B
      B=AA-A
      FMAAS=0.0
      GO TO 10
  30  IF  (   FMAAS.LE. FMINEQ) GO TO 40
      IF  (ABS(A-B).GT. FMINEQ) GO TO 40
      A=0.25*(A+B-FMAAS)
      B=A+0.5*FMAAS
      FMAAS=0.0
      GO TO 10
  40  IF (ABS(A-FMAAS).GT.FMINEQ) GO TO 50
      A=0.25*A
      B=B-A
      FMAAS=0.0
      GO TO 10
  50  IF ((A-FMAAS).GT. 0.0) GO TO 60
      B=A+B-FMAAS
      FMAAS=ABS(FMAAS-2.*A)
      GO TO 10
  60  IF (FMAAS .LT. FMINEQ) FMAAS=0.0
   65 IF (TEST) WRITE(IOUT,2) A,B,FMAAS
      RETURN
    1 FORMAT(15H INPUT OF NORM  , 3F10.2 )
    2 FORMAT(15H OUTPUT         , 3F10.2 )
      END
      SUBROUTINE NORM3
C-----------------------------------------------------------------------
C  THIS SUBROUTINE 'NORMALIZES' THE LATTICES AND PUTS THEM INTO A
C  STANDARD SHAPE
C-----------------------------------------------------------------------
C
      DIMENSION  OLD(6),          IZON(3,6),QVAL(5,5,5)
      INTEGER H,H1
      LOGICAL SELF,ENL,TEST,CHANGE
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      EQUIVALENCE (CEL(1),A),(CEL(2),B),(CEL(3),C),(CEL(4),D),
     *(CEL(5),E),(CEL(6),F),(CEL(8),PED)
C-----------------------------------------------------------------------
C  Changed: 260493  : added NCRT, adapted output.
C  Changed: 071193  : deleted NCRT-output.
C
C
      DO 80 I=1,6
   80 OLD(I)=CEL(I)
C  INITIALIZING *OLD*
      GO TO 100
C
C-----------------------------------------------------------------------
C  THE NEXT PART IS THE OLD PROCEDURE 'MAZEN'
C  MAZEN FINDS THE  VALUES OF D,E AND F IN A LATTICE, WHEN THE COORDINAT
C  OF A,B,AND C HAVE BEEN GIVEN.
C
   10 I1=IZON(H,1)+IZON(K,1)-3
      I2=IZON(H,2)+IZON(K,2)-3
      I3=IZON(H,3)+IZON(K,3)-3
      X=QVAL(I1,I2,I3)
      I1=IZON(H,1)-IZON(K,1)+3
      I2=IZON(H,2)-IZON(K,2)+3
      I3=IZON(H,3)-IZON(K,3)+3
      Y=QVAL(I1,I2,I3)
      Z=(X-Y)/2.0
      GO TO (601,602,603),ISW
C
C-----------------------------------------------------------------------
C  THE FOLLOWING IS THE PROCEDURE 'CHANGE'
C  IF ANY CONSTANT HAS BEEN  CHANGED,THE PROGRAM REPEATS UNTIL NO
C  MORE CHANGES ARE DETECTED.
C-----------------------------------------------------------------------
   20 U=0.0
      DO 30 I=1,6
      U=U+ ABS(CEL(I)   -OLD(I))
      OLD(I)=CEL(I)
   30 CONTINUE
      CHANGE=.FALSE.
      IF (U.GT.0.1 ) CHANGE=.TRUE.
      GO TO (310,610),ISW
C-----------------------------------------------------------------------
C
  100 IF (TEST) WRITE(IOUT,9930) A,B,C,D,E,F,PED
C     write(ncrt,9936) A,B,C,D,E,F,PED
      QMAX=1.0E+6
C--CHECK ON  CERTAIN RELATIONS BETWEEN A,B,C,D,E,F  WHICH MEAN THAT
C--THE LATTICE HAS HIGHER SYMMETRY.
  200 DO 300 II=1,3
      X=A
      A=B
      B=C
      C=X
      X=D
      D=E
      E=F
      F=X
      IF (B .LT. FMINIM) GO TO 1000
      IF (D.GT. 0.0)  GO TO 205
      D=-D
      E=-E
  205 IF (E.GT. 0.0)  GO TO 210
      E=-E
      F=-F
  210 IF (ABS(A-C) .GT. FMINEQ) GO TO 230
      IF (E .LT. FMINEQ) GO TO 230
C  IF A=C .AND. E>0 THEN WE CAN SIMPLIFY
      A=(A+C+E)/4.
      C=A-E/2.
      F=(D+F)/2.
      D=ABS(D-F)
      E=0
  230 IF (ABS(E-A).GT.FMINEQ ) GO TO 240
      A=A/4.
      C=C-A
      E=0.0
      F=F/2.
      D=ABS(D-F)
  240 IF (ABS(E-C).GT.FMINEQ) GO TO 250
      C=C/4.0
      A=A-C
      E=0.0
      D=D/2.
      F=ABS(D-F)
  250 IF (ABS(D) .LE. FMINEQ) D=0.0
      IF (ABS(E) .LE. FMINEQ) E=0.0
      IF (ABS(F) .LE. FMINEQ) F=0.0
  300 CONTINUE
      IF (TEST) WRITE(IOUT,9931) A,B,C,D,E,F,PED
C  REDUCED    ......  REDUCED2 IS ABOUT AT CARD 200
      ISW=1
      GO TO 20
C--TEST ON CHANGES.
  310 IF (CHANGE) GO TO 200
C--CALCULATE  THE Q-VALUES NEAR THE ORIGIN
      DO 400 L1=3,4
      L=L1-3
      DO 390 K1=2,4
      K=K1-3
      DO 380 H1=2, 4
      H=H1-3
      IF (L  .EQ.0 .AND. K .LT.1) GO TO 330
      X=A*FLOAT(H*H)+B*FLOAT(K*K)+C*FLOAT(L*L)+D*FLOAT(K*L)+E*FLOAT(H*L)
     1  +F*FLOAT(H*K)
      IF (X .LT.(-0.1))GO TO 1000
  320 QVAL (H1,K1,L1)=X
      GO TO 380
  330 QVAL(H1,K1,L1)=QMAX
  380 CONTINUE
  390 CONTINUE
  400 CONTINUE
      QVAL(4,3,3) =A
C--NOW FIND THE SMALLEST Q-VALUES.
      N1=0
  410 N1=N1+1
      U=QMAX-10.0
      DO 500 L=3,4
      DO 490 K=2,4
      DO 480 H=2,4
      IF (QVAL(H,K,L).GE.U) GO TO 480
      U=QVAL(H,K,L)
      IZON(N1,3)=L
      IZON(N1,1)=H
      IZON(N1,4)=H
      IZON(N1,2)=K
      IZON(N1,5)=K
  480 CONTINUE
  490 CONTINUE
  500 CONTINUE
      I1=IZON(N1,1)
      I2=IZON(N1,2)
      I3=IZON(N1,3)
      QVAL(I1,I2,I3)=QMAX
      IF (N1.LT.3) GO TO 410
C--CHECK WHETHER THEY ARE IN ONE PLANE.
      II=0
      DO  510 I=1,3
      K=IZON(1,I+1)-3
      L=IZON(2,I+2)-3
      M=IZON(2,I+1)-3
      N=IZON(1,I+2)-3
      J=K*L-M*N
      II=II+J*(IZON(3,I)-3)
  510 CONTINUE
      IF (II .NE. 0) GO TO 520
      N1=2
      GO TO  410
C--CALCULATE THE RECIPROCAL LATTICE AGAIN., TO DETERMINE D,E, AND F.
  520 DO 580 L1=1,5
      L=L1-3
      DO 570 K1=1,5
      K=K1-3
      DO 560 H1=1,5
      H=H1-3
      Q=A*FLOAT(H*H)+B*FLOAT(K*K)+C*FLOAT(L*L)+D*FLOAT(K*L)+E*FLOAT(H*L)
     1  +F*FLOAT(H*K)
      IF (Q .LT.(-0.1)) GO TO 1000
C  IF ANY Q-VALUE IS NEGATIVE,THE LATTICE SHOULD BE DISCARDED
      QVAL(H1,K1,L1)=Q
  560 CONTINUE
  570 CONTINUE
  580 CONTINUE
      I11=IZON(1,1)
      I12=IZON(1,2)
      I13=IZON(1,3)
      I21=IZON(2,1)
      I22=IZON(2,2)
      I23=IZON(2,3)
      I31=IZON(3,1)
      I32=IZON(3,2)
      I33=IZON(3,3)
      B=QVAL(I11,I12,I13)
      A=QVAL(I21,I22,I23)
      C=QVAL(I31,I32,I33)
C  I KNOW, IKNOW,    BUT THIS PIDGIN-FORTRAN WORKS ON ALL MACHINES....
C--NOW FIND D,E AND F.
      ISW=1
      H=1
      K=3
      GO TO  10
  601 D=Z
      ISW=2
      K=2
      GO TO 10
  602 F=Z
      ISW=3
      H=3
      GO TO 10
  603 E=Z
      IF (TEST) WRITE(IOUT,9934) (CEL(I),I=1,6),PED
C  REDUCED2 ETC.
      ISW=2
      GO TO 20
C--TEST ON CHANGES.
  610 IF (CHANGE) GO TO 200
C  REARRANGE IN A CRYSTALLOGRAPHICAL ORDER. FIRST FIND ZERO TERMS.
      L=0
      J=1
       DO 620 I=4,6
      L=L+I
      IF (ABS(CEL(I)) .GT. FMINEQ) GO TO 620
      J=J+1
      K=I
      L=L-I
      CEL(I)=0.0
  620 CONTINUE
C  J COUNTS THE NUMBER OF ZERO ELEMENTS,STARTING AT 1
C  IF ONLY ONE ELEMENT IS ZERO, IT IS INDICATED BY K
C  IF ONLY ONE ELEMENT IS NON-ZERO, IT IS INDICATED BY L
C  IN THE OTHER CASES, ALL ELEMENTS CAN BE TREATED ALIKE.
C          TRICL    MONO ORTHO
      GO TO (750,700,650,800),J
C  THE MONOCLINIC CASE
  650 L=L-3
      IF (L .NE. 2) CALL WISSEL(L,2)
      IF (A .GT. C) CALL WISSEL(1,3)
      E=ABS(E)
      IF (E .LE.A) GO TO 800
      C=C+A-E
      E=A+A-E
      GO TO 200
C  THE SEMI-TRICLINIC CASE (ONE RECIPROCAL ANGLE 90 DEGREES)
  700 K=K-3
      IF (K .NE. 3) CALL WISSEL(K,3)
C  THE TRUE TRICLINIC CASE
  750 IF (D .GE. 0.) GO TO 760
      D=-D
      E=-E
  760 IF (E .GE. 0.) GO TO 770
      E=-E
      F=-F
  770 IF (ABS(A+B+F-D-E) .GT. FMINEQ) GO TO 800
C--THIS IS A MONOCLINIC LATTICE IN DISGUISE.
      E=ABS(A-B)*0.5
      A=(A+B+F)/4.
      B=C-A
      C=A-F/2.
      D=0.0
      F=0.0
      GO TO 200
C  THIS WAS THE TRANSFORMATION OF CERTAIN MONOCLINIC CENTERED LATTICES.
 800  CONTINUE
      IF (TEST) WRITE(IOUT,9935) (CEL(I),I=1,6),PED
C     WRITE(NCRT,9937) (CEL(I),I=1,6),PED
C  REDUCED3  ETC.
      RETURN
 1000 A=0.0
C     write(ncrt,'(/'' Lattice to be deleted'')' )
      RETURN
 9930 FORMAT(11H LATTICE IS, 6F8.1,F8.0)
 9931 FORMAT(11H REDUCED   , 6F8.1,F8.0)
 9934 FORMAT(11H REDUCED2  , 6F8.1,F8.0)
 9935 FORMAT(11H REDUCED3  , 6F8.1,F8.0)
 9936 FORMAT(/,' Input lattice ', 6F8.1,F8.0)
 9937 FORMAT(/,' Output        ', 6F8.1,F8.0)
      END
      SUBROUTINE NTEST(NTST,I)
C  NTEST CAN LIMIT THE TEST OUTPUT TO SMALL PARTS OF THE PROGRAM.
C  IT IS PROBABLY ONLY USEFUL WHEN YOU ARE MODIFYING THE PROGRAM.
C  THE WHOLE PROGRAM IS SUBDIVIDED IN 10 PARTS, EACH WITH ITS OWN
C  TEST OUTPUT.
C
C                                  CALL IS BETWEEN
C    NTST    TEST OUTPUT FOR       LABELS        IN SUBROUTINE
C      1     READER+BEGIN MAIN       11 -  110      READER
C      2     FINZON + EVALU8        450 -  460      AAITO1
C      3     EVALU8 + ONEZON        550 -  670      AAITO1
C      4     REAR                   570 - 1805      AAITO1
C      5     THREED                1860 - 1905      ANITO2
C      6     NORM3                 1910 - 1920      ANITO2
C      7     REFPAR+UNTCEL         2055 - 2060      ANITO2
C      8     REFPAR (2)            3050 - 3052      ANITO2
C      9     UNTCEL + SYMTST       3110 - 3115      ANITO2
C
C  IF YOU WANT YOUR TEST OUTPUT TO CONTINUE AFTER IT HAS STARTED,
C  YOU SHOULD MULTIPLY THE NUMBER GIVEN ABOVE WITH 11,E.G. YOU
C  ENTER 88 IF YOU SUSPECT THAT THE TROUBLE IS IN THE LAST PART OF
C  THE PROGRAM.
C
C              *****************************
C  N.B.        *  NTEST  OVERRULES   TEST  *
C              *****************************
C
C
C  IF YOU HAD SET  *TEST* (COL 50 IN FIRST PARAMETER CARD),THAN THIS
C  PARAMETER IS OVERRULED WHEN YOU SET *NTEST*. THE PHILOSOPHY IS THAT
C  WHEN YOU USE  *NTEST* YOU KNOW EXACTLY WHAT TEST OUTPUT YOU WANT.
C  BY SETTING *TEST* AND NOT USING *NTEST* YOU GET ALL TEST OUTPUT.
C
      LOGICAL TEMP,SELF,ENL,TEST
      CHARACTER*8 TEXT(9)
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      DATA TEXT/' READER ',' FINZON ',' EVALU8 ','  REAR  ',' THREED ',
     2  '  NORM3 ',' REFPAR ',' REFPAR2',' UNTCEL '/
C
C  Changed 260493 : added NCRT+some output.
C  Changed 071193 : deleted NCRT-output.
C
C     WRITE(NCRT, 1) I,TEXT(I)
      IF (I .EQ. 1) TEMP=ENL
C--KEEPS *ENL* FOR THE REST OF THE PROGRAM.
      TEST=.FALSE.
      ENL=TEMP
      IF (NTST .EQ. I) GO TO 50
      IF (NTST .EQ. 99) GO TO 50
      IF (NTST .LT. 20) RETURN
      J=NTST/11
      IF (I .GE. J) GO TO 50
C  THIS MAKES IT POSSIBLE TO OBTAIN ALL TEST OUTPUT AFTER
C  A CERTAIN POINT.
      RETURN
   50 TEST=.TRUE.
      ENL=.TRUE.
      WRITE(IOUT, 2) I,TEXT(I)
C
C     SAVE TEMP
C
      RETURN
    1 FORMAT(/ ' *************************'/
     2         ' Program passes point ',i2,/
     3         ' the next output is mainly from subroutine ',//
     4         ' **************'/
     5         ' *  ',A8,  '  *'/
     6         ' **************' )
    2 FORMAT(15H TEST OUTPUT **,I3,32H **   MAINLY FROM SUBROUTINE  **,
     2  A8, 2H** )
      END
      SUBROUTINE ONEZON(A,B,FMAAS)
C-----------------------------------------------------------------------
C  WHEN TOO MANY LINES AMONG THE FIRST SIX BELONG TO ONE ZONE,
C  THIS SUBROUTINE PRODUCES COMBINATIONS OF ONE LINE OF THE ZONE
C  WITH   A  LINE THAT DOES NOT BELONG TO THE ZONE.
C  THESE COMBINATIONS ARE USED TO ENTER  FINZON  AGAIN.
C-----------------------------------------------------------------------
      DIMENSION ZON(4)
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /TEMRES/ LINCO,NQ2,NINDEX,INDEX(40),ROSTER(150,12)
C     WRITE(IOUT, 1) MAX,LINCO,(INDEX(I),I=1,40)
      ZON(1)=A
      ZON(2)=B
      ZON(3)=A+B+FMAAS
      ZON(4)=A+B-FMAAS
      NEND=4
      IF (ZON(3)-ZON(4) .LT. 0.01) NEND=3
      DO 50 I=1,NEND
      N=0
      DO 40 J=1,MAX
      IF (INDEX(J) .EQ. 1) GO TO 40
      N=N+1
      LINCO=LINCO+1
      ROSTER(LINCO,1)=ZON(I)
      ROSTER(LINCO,2)=OBS(J)
      ROSTER(LINCO,3)=.0
      ROSTER(LINCO,4)=.0
C     WRITE(IOUT, 2) LINCO,(ROSTER(LINCO,K),K=1,4)
      IF (N .EQ. 4) GO TO 50
   40 CONTINUE
   50 CONTINUE
      RETURN
C  1  FORMAT(1H ,2I3,5X,40I2)
C  2  FORMAT(1H ,I3, 4F8.2)
      END
      SUBROUTINE READER(NZ1,NZ2,NR,NSOLMX,WMOL,DOBS,PRNTMR,PRNTLN,
     1  NTST)
C  ---------------------------------------------------------------------
C  .... CHANGE  250386  ADDED OUTPUT ON NSUMM (COMPL. LATT.9801)
C  .... change  260493  added NCRT + some output, zero-error.
C  .... change  071193  DELETED most NCRT-output.
C  last change  080594  improved NCRT-output.
C  ---------------------------------------------------------------------
C----THE FIRST CARD MUST CONTAIN THE NAME OF THE PROBLEM (TITLE).
C    THE NEXT CARDS ARE USUALLY COMPLETELY BLANK. THE PROGRAM
C    THEN TAKES THE DEFAULT VALUES.. IF YOU WANT TO SPECIFY YOUR
C    OWN PARAMETERS, YOU SHOULD DO THIS AS FOLLOWS:
C  COLUMN  FORMAT  NAME   DEFAULT   MEANING
C    1      A1     MAN      0       PRINTS INSTRUCTIONS,UNLESS MAN>7
C                                   Suppresses zero-error if MAN=1 or 8.
C    2      A1     INSTR    0       PRINTS INSTRUCTIONS FOR SPECIAL
C                                   FEATURES IF INSTR=1
C    3      A1     INTENS   0       READS INTENSITIES BESIDES LINE
C                                   POSITIONS IF INTENS=1
C    4      I1     NSOLMX   4       MAXIMUM NR OF SOLUTIONS TO BE PRINTE
C   5- 6    I2     NSYST(1) 0       ORTHORHOMBIC SOLUTION. +1=YES, -1=NO
C   7- 8    I2     NSYST(2) 0       MONOCLINIC SYSTEM.   0 MEANS  INDIFF
C   9-10    I2     NSYST(3) 0       TRICLINIC SYSTEM
C  11-15   F5.2    TOL2    3.0      TOLERANCE ON 2-DIMENSIONAL SEARCH
C  16-20   F5.2    TOL3    4.5      TOLERANCE ON 3-DIMENSIONAL SEARCH
C  21-30   F10.5   WAVEL   1.54060  WAVELENGTH
C  31-32    I2     LINCO    0       NUMBER OF GIVEN LINE COMBINATIONS
C                                   FOR THE 2-DIMENSIONAL SEARCH
C                                   IF LINCO>0, THE LINECOMBINATIONS ARE
C                                   READ (4F10.2) AFTER THE LINES DECK.
C                                   TERMINATION BY A BLANK CARD (OR ZERO
C     33    I1     LZERCK   0       CHECK ON ZERO-ERROR IF LZERCK>0
C     34    I1     K (ENL)  0       ENL: OUTPUT OF INTERMEDIATE RESULTS(
C  35-36    I2     NQ1      3       NQ1 AND NQ2 DETERMINE THE NUMBERS OF
C  37-38    I2     NQ2      6       LINES TO BE USED IN COMBINATIONS
C                                   FOR FINDING ZONES .
C  39-40    I2     NZ1      6       NZ1 AND NZ2 DO THE SAME FOR
C  41-42    I2     NZ2      6       FINDING LATTICES FROM ZONES.
C  43-44    I2     NR       0       REFINEMENT AND EVALUATION RUN ONLY
C                                   IF NR>0. THE DECK OF COMPLETE
C                                   LATTICES TO BE REFINED (6F10.2)
C                                   MUST FOLLOW THE LINES DECK, ALSO
C                                   TERMINATED BY A CARD WITH ZERO OR
C                                   BLANKS IN COLS 1-10.
C  45-46    I2     INDAT    5       NUMBER OF THE UNIT ON WHICH TO READ
C                                   THE LINE POSITIONS.
C  47-48    I2     LIST     1       LIST OF CALCULATED LINES FOR THE FIRST
C                                   *LIST* LATTICES.  SUPPRESS: LIST=-1
C  49-50    I2     J (TEST) 0       TEST OUTPUT IF J .GT. 0
C  51-60   F10.5   WMOL    0.0      MOLECULAR WEIGHT.
C  61-70   F10.5   DOBS    0.0      OBSERVED DENSITY.
C  71-78    F8.5   TOLG    6.0      TOLERANCE ON MATCH BETWEEN CALCULATE
C                                   AND OBSERVED LINES IN HUNDREDTH OF.
C                                   A DEGREE TWOTHETA.
C  79-80    I2     NTST     0       THE NUMBER IN THE MAIN PROGRAM
C                                   WHERE TEST OUTPUT IS GIVEN.
C  ---------------------------------------------------------------------
C    ON THE NEXT CARD, THE FOLLOWING PARAMETERS SHOULD BE ENTERED
C   1-10   F10.5   ZERCOR  0.0      ZEROSHIFT, TO APPLY TO ALL LINES.
C  11-20   F10.5   PRNTMR  4.0      THE MINIMUM VALUE OF THE FIGURE
C                                   OF MERIT OF A LATTICE TO BE PRINTED.
C  21-30   F10.5   PRNTLN  14.      THE MINIMUM NUMBER OF INDEXED LINES
C                                   FOR A LATTICE TO BE PRINTED.
C  31-40   F10.5   ZERREF  >0.1     REFINEMENT OF THE ZERO-POINT ERROR
C                                   IS SUPPRESSED WHEN ZERREF > 0.1  ---
C  ---------------------------------------------------------------------
      LOGICAL SELF,ENL,TEST,ZERREF
      CHARACTER  NAME*80,CARD*80,INTSY*2
      CHARACTER*1 INSTR,INTENS,IONE,IBLA,PLUS*2
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MMAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /TEMRES/ LINCO,NQ2,NINDEX,INDEX(40),ROSTER(150,12)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /THETAS/ ZERTOT,OBSTET(40),SHFTET(40),TETPT(40),TETMT(40)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
      DATA IONE/'1'/,IBLA/' '/,PLUS/'++'/
      INPFIX=INP
      NROSTR=150
C  ---------------------------------------------------------------------
C  ---------------------------------------------------------------------
C  AFTER THE PARAMETER CARD WE MUST ENTER THE LINES,  EITHER AS
C  TWOTHETA, D- OR Q- VALUES.
C  THE PROGRAM WILL FIND OUT WHAT KIND OF VALUES IT HAS.
C  THE NUMBER OF LINES MUST BE AT LEAST 20  AND MUST NOT EXCEED 200.
C  A MAXIMUM OF 40 LINES IS ACTUALLY USED, THE REST IS HARMLESS.
C  ONLY THE FIRST SIX LINES SHOULD BE IN THEIR CORRECT ORDER, THE REST
C  CAN BE ENTERED IN A RANDOM WAY.  EVEN LINES THAT SHOULD BE AMONG
C  THE FIRST SIX CAN BE ENTERED LATER.
C  THE LINES CARDS SHOULD BE TERMINATED BY A BLANK CARD.
C  THE PROGRAM TESTS ON THIS  BLANK CARD AND THEN COUNTS THE NUMBER
C  OF REFLECTIONS.
C  ---------------------------------------------------------------------
 9990 CONTINUE
C  ---------------------------------------------------------------------
C--IF YOU SET LINCO  UNEQUAL  ZERO YOU MUST NOW ADD LINCO CARDS.
C  THERE ARE SEVERAL POSSIBILITIES:
C  A. YOU ENTER TWO Q-VALUES (2F10.5) PER CARD.
C    IN THIS CASE THE PROGRAM TREATS THEM AS ONE OF HIS OWN
C    LINE COMBINATIONS AND TRIES TO FIND THE ANGLE IN FINZON  ETC.
C  B. YOU ENTER THREE CONSTANTS (3F10.5).
C     THE PROGRAM RECOGNIZES THIS AS A COMPLETE ZONE, BUT WILL
C     DETERMINE THE QUALITY OF THIS ZONE. THIS MAY LEAD TO AN
C     UNEXPECTED DOUBLING OF AXES.
C     NOTE: A RECTANGULARZONE MUST BE ENTERED AS  A,B, 0.1  FOR READING
C     IN CORRECTLY.  THE PROGRAM WILL VERY SOON  REPLACE 0.1 BY 0.0
C  C. YOU ENTER 4 VALUES  (4F10.5).  THE FOURTH VALUE IS THE
C     QUALITY OF THE ZONE.  IF YOU SET THIS HIGH ENOUGH, THE ZONE
C     WILL CERTAINLY BE USED IN LATTICE-FINDING.
C     ENTERING A SINGLE DIGIT IN COLUMN 31 ASSURES YOU OF A HIGH QUALITY
C  ---------------------------------------------------------------------
C-----------------------------------------------------------------------
C
C     WRITE(NCRT,'(////''******  READING THE INPUT  *******'')')
      CALL ECHO
      READ(CARD,9901) NAME
      WRITE(NCRT,'('' NAME OF THE PROBLEM: '' / 1x, A70/ 1X,A10/
     * 1X,20(3H---) )' )  NAME
    5 DO 8 I=1,40
    8 INTSY(I)=IBLA
      ENL=.TRUE.
      TEST=.TRUE.
      SELF=.FALSE.
      ZERREF=.TRUE.
      CALL ECHO
C--PARAMETER CARD
      READ(CARD,9902) MAN,INSTR,INTENS,NSOLMX,NSYST,TOL2,TOL3,WAVEL,
     * LINCO,LZERCK,K,NQ1,NQ2,NZ1,NZ2,NR,INDAT,LIST,J,WMOL,DOBS,TOLG,
     3 NTST
      IF ( (MAN .LT. 8) .AND. (INTSY(50) .NE. PLUS)  )  CALL MANUAL
      IF ( (MAN .EQ. 1) .OR. (MAN .EQ. 8) )  ZERREF=.FALSE.
      IF (INSTR .EQ. IONE) CALL INSTRS
   11 CONTINUE
      WRITE(IOUT,9920) NAME
      CALL BIBLIO
C     WRITE(IOUT,9956)
      WRITE(IOUT,9950)
      IF (NSOLMX .EQ. 0) NSOLMX=4
      IF (TOL2.LT. 0.1) TOL2=3.0
      IF (TOL3.LT. 0.1) TOL3=4.5
      IF (WAVEL.LT.0.1) WAVEL=1.54060
      IF ( K   .EQ. 0) ENL =.FALSE.
      IF (NQ1 .EQ. 0) NQ1=3
      IF (NQ2 .EQ. 0) NQ2=6
      IF (NZ1 .EQ. 0) NZ1=6
      IF (NZ2 .EQ. 0) NZ2=6
      IF (INDAT .EQ. 0) INDAT=INP
      IF (LIST .EQ. 0) LIST=1
      IF ( J   .EQ. 0) TEST=.FALSE.
      TOLKEP=TOLG
      IF (TOLG .LT. 0.1) TOLG=6.0
      IF ( (NTST .EQ. 0) .AND. TEST ) NTST=99
      SELF=ENL
      CALL NTEST(NTST,1)
      INTSY(50)=PLUS
      TOLG=0.01*TOLG
      TOLKEP=0.01*TOLKEP
      TWORAD=90./ATAN(1.)
      RRAD=ATAN(1.)/45.
      RAD=1.0/RRAD
      HLFLAM=0.005*WAVEL
      WAVSQR=(0.5*WAVEL)**2
C     write(NCRT, '('' The parameter card translates into : '')')
C     write(NCRT,9902) MAN,INSTR,INTENS,NSOLMX,NSYST,TOL2,TOL3,WAVEL,
C    * LINCO,LZERCK,K,NQ1,NQ2,NZ1,NZ2,NR,INDAT,LIST,J,WMOL,DOBS,TOLG,
C    3 NTST
C  INP WILL BE RESTORED AT THE END OF THE ROUTINE.
C  (SEE FIRST AND LAST STATEMENT)
      INP=INDAT
C
C  READ THE NEXT PARAMETER CARD AND ALL LINES
C
      CALL REDLIN(PRNTMR,PRNTLN,INDAT,INTENS,TOLKEP)
C
C
C     PRINT *,' MMAX IS ',MMAX
      IF (MMAX .LT. 20) GO TO 9990
      IF (FMINIM .LT. 2.0) GO TO 9990
      TOLRAD=0.5*TOLG*RRAD
      DO 20 M=1,MMAX
         Z=ASIN(HLFLAM*SQRT(OBS(M)))
         OBSTET(M)=Z
         TETPT(M)=Z+TOLRAD
         TETMT(M)=Z-TOLRAD
C        PRINT *,' THETA ARRAYS',OBSTET(M),TETPT(M),TETMT(M)
   20 CONTINUE
      IF (LZERCK .GT. 0) CALL ZERCHK
      IF (NQ1 .GT. NQ2) THEN
         I=NQ2
         NQ2=NQ1
         NQ1=I
      END IF
      IF (NZ1 .GT. NZ2) THEN
         I=NZ2
         NZ2=NZ1
         NZ1=I
      END IF
      IF (TEST) ENL=.TRUE.
      IF (.NOT. ENL) WRITE(IOUT,9927)
      IF (ENL .AND. (.NOT. TEST)  ) WRITE(IOUT,9923)
      IF (TEST) WRITE(IOUT, 9924)
      WRITE(IOUT,9922) TOL2,TOL3,TOLG
      IF (ABS(TOLG-0.06) .GT. 1.0E-4) WRITE(IOUT,9928) TOLG
      IF (NR .EQ. 0) GO TO 315
C-----------------------------------------------------------------------
C---READ THE COMPLETE LATTICES (REFINEMENT RUN ONLY)
C-----------------------------------------------------------------------
      WRITE(IOUT ,9941)
      WRITE(NSUMM,9941)
      NNR=NROSTR+1
      I=0
  290 CALL ECHO
      READ(CARD,9940) (CEL(J),J=1,6)
      IF (CEL(1) .LT. 0.01) GO TO 314
      Z=CEL(1)
      I=I+1
      WRITE(NSUMM,9801) I,(CEL(J),J=1,6)
      IF (NNR-I) 290,300,310
  300 WRITE(IOUT,9943) NROSTR
      GO TO 290
  310 DO 312 J=1,6
  312 ROSTER(I,J)=CEL(J)
      ROSTER(I,7)=99
      ROSTER(I,8)=I
      INDEX(40)=I
      CALL RECCEL
      IF (ABS(Z-ROSTER(I,1)) .GT. 0.1 ) THEN
         WRITE(IOUT, 9942) I,(ROSTER(I,J),J=1,6)
         WRITE(NSUMM,9801) I,(ROSTER(I,J),J=1,6)
      END IF
      GOTO 290
  314 NR=I
      IF (NR.GT.NROSTR) NR=NROSTR
      WRITE(IOUT,9944) NR
      IF (LIST .EQ. 1) LIST=NR
C  WITH THE IDEA, THAT YOU WANT TO SEE AS MUCH AS POSSIBLE
C  FROM THE LATTICES THAT YOU ENTERED.
      GO TO 500
  315 IF (LINCO .EQ. 0) GO TO 350
C-----------------------------------------------------------------------
C  THE COMBINATIONS OF LINES WILL BE READ HERE
C-----------------------------------------------------------------------
      NQ1=MMAX
      NQ2=MMAX
      DO 320  I=1,40
      CALL ECHO
      READ(CARD, 9919)   (ROSTER(I,J),J=1,4 )
      IF (ROSTER(I,1) .LT. 0.1) GO TO 330
  320 CONTINUE
  330 LINCO=I-1
      IF (LINCO .EQ. 1) THEN
         WRITE(IOUT,9911)
         MMAX=10
         GO TO 999
      ELSE IF (LINCO .LT. 4) THEN
         WRITE(IOUT,9912) LINCO
      ELSE
         WRITE(IOUT,9931) LINCO
      END IF
      WRITE(IOUT,9917) (I,(ROSTER(I,J),J=1,4),I=1,LINCO)
      GO TO 400
C  THE NUMBER OF COMBINATIONS OF NQ1 AND NQ2 IS  NQ1*(2*NQ2-NQ1+1)/2
C  THIS NUMBER SHOULD NOT BE LARGER THAN 40, AS THERE ARE 5LINES PER
C  COMBINATION, AND ONLY ROOM FOR 200 POSSIBILITIES.
C-----------------------------------------------------------------------
C  THE COMBINATIONS OF LINES WILL BE MADE NOW
C-----------------------------------------------------------------------
  350 WRITE(IOUT,9932) NQ1,NQ2
      DO 370 I=1,NQ1
      DO 360 J=I,NQ2
      IF ( ABS(4.0*OBS(I)-OBS(J)) .LT. 6.0) GO TO 360
      LINCO=LINCO+1
C     PRINT *,' LINCO=',LINCO,'  I RESP J =', I, J
      ROSTER(LINCO,1)=OBS(I)
      ROSTER(LINCO,2)=OBS(J)
  360 CONTINUE
  370 CONTINUE
  400 CONTINUE
      WRITE(IOUT,9933) NZ1,NZ2
  500 CONTINUE
      IF (NSYST(1) .EQ. 1) WRITE(IOUT,9952)
      IF (NSYST(2) .EQ. 1) WRITE(IOUT,9953)
      IF (NSYST(3) .EQ. 1) WRITE(IOUT,9954)
      WRITE(IOUT,9934) WMOL
      WRITE(IOUT,9935) DOBS
  999 INP=INPFIX
      RETURN
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C  THE FOLLOWING CARDS ARE USEFUL FOR TEST PURPOSES:
C     WRITE(IOUT,9945) TOL2,TOL3,TOLG,WAVEL,LINCO,SELF,ENL,TEST,
C    * NQ1,NQ2,NZ1,NZ2 ,NR,INP,WMOL,DOBS
C9945 FORMAT(53H   TOL2  TOL3  TOLG  WAVEL   LINCO   SELF   ENL  TEST,
C    *33H NQ1 NQ2 NZ1 NZ2 NR INP WMOL DOBS/
C    *  3F6.1, F8.5, I8, 3L6,    6I4 ,2F8.5)
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
 9801 FORMAT(/,' LATTICE NR',I3,6F9.3)
 9901 FORMAT(A80)
 9902 FORMAT(I1,2A1,I1,3I2,2F5.2,F10.5, I2,2I1,8I2, 2F10.5,F8.4,I2)
 9911 FORMAT(/,53(1H*)/' **  ERROR,  THE INPUT CONSISTED OF ONLY',
     1 ' ONE ZONE.  **' /' **  THE PROGRAM NEEDS MORE ZONES TO FIND',
     2 ' A LATTICE.**' /' **            PLEASE ENTER MORE ZONES. ',
     3 '            **' / 1H ,53(1H*)  )
 9912 FORMAT(/,54(1H*)/
     1 ' ** THE INPUT CONSISTED OF ONLY ',I1,' ZONES.             **'/
     2 ' ** THESE MUST HAVE AT LEAST ONE COMMON Q-VALUE      **'/
     3 ' ** CLOSE TO THE ORIGIN ,IN ORDER TO FIND A LATTICE. **'/
     4 ' ** PROGRAM CONTINUES, BUT MIGHT NEED MORE ZONES.    **'/
     5 ' ******************************************************'  )
 9917 FORMAT(15H INPUT ZONE NR., I3, 4F8.1)
 9919 FORMAT(3F10.2, F10.1)
 9920 FORMAT(//,51H THIS PROGRAM TRIES TO FIND THE UNIT CELL FROM THE ,
     *18H POWDER PATTERN OF ///20X,A80///26H WITH A METHOD PROPOSED BY,
     *61H  DE WOLFF AND PROGRAMMED BY VISSER (J.APPL.CRYST.2,89(1969))/
     *40H            FORTRAN  VERSION    15        )
 9922 FORMAT(50H (COL 11-15) TOL2, THE TOLERANCE ON THE TRIAL F IS,
     1  F4.1//
     2  50H (COL 16-20) TOL3, THE TOLERANCE ON THE TRIAL D IS , F4.1//
     3  48H (COL 71-78) TOLG, THE TOLERANCE ON TWO THETA IS  ,F6.3,
     4  10H  DEGREES.)
 9923 FORMAT(38H INTERMEDIATE RESULTS ARE PRINTED OUT./
     * 58H PUNCH A 1 IN COLUMN 50 OF THE PARAMETER CARD IF YOU WANT  ,
     * 18H THE TEST OUTPUT.   )
 9924 FORMAT(39H TESTRUN, ALL TEST RESULTS ARE PRINTED.)
 9927 FORMAT(55H ONLY A MINIMUM OF INTERMEDIATE RESULTS WILL BE PRINTED/
     * 59H PUNCH A 1 IN COLUMN 34 OF THE PARAMETER CARD IF YOU WANT  ,
     * 14H MORE OUTPUT.  )
 9928 FORMAT(49H ************************************************/
     1       40H * THE OVERALL TOLERANCE IS CHANGED INTO,F6.3,2H */
     2       49H ************************************************ )
 9931 FORMAT(21H THE PROGRAM WILL USE ,I3,24H GIVEN LINE COMBINATIONS)
 9932 FORMAT(35H THE PROGRAM WILL COMBINE THE FIRST ,I3,
     * 21H LINES WITH THE FIRST  ,I3)
 9933 FORMAT(42H THE PROGRAM WILL TRY TO COMBINE THE FIRST  ,I3,
     * 21H ZONES WITH THE FIRST ,I3)
 9934 FORMAT(30H THE GIVEN MOLECULAR WEIGHT IS,  F10.3)
 9935 FORMAT(30H THE GIVEN OBSERVED DENSITY IS,  F10.4)
 9940 FORMAT( 8F10.2 )
 9941 FORMAT(57H INPUT OF COMPLETE LATTICES FOLLOWS (REFINEMENT RUN ONLY
     1)/)
 9942 FORMAT(18H INPUT LATTICE NR., I3, 8F10.2 )
 9943 FORMAT(41H ** EXCEEDS STORAGE ALLOCATED, ONLY FIRST,I4,
     1  21H WILL BE PROCESSED **/  )
 9944 FORMAT(30H LATTICE INPUT FINISHED, FIRST,I4,18H WILL BE PROCESSED)
 9950 FORMAT(65H *******************************************************
     1*********/  2H *,62X,1H*/ 65H *   ARE YOUR INPUT DATA REALLY THE B
     2EST THAT CAN BE OBTAINED   */2H *,62X,1H*/   65H *****************
     3***********************************************    ///
     480H FINDING THE UNIT CELL  DEPENDS FOR 95 PERCENT ON THE QUALITY O
     5F THE INPUT DATA./118H A RANDOM ERROR OF 0.03 DEGREES TWOTHETA CAN
     6 USUALLY BE TOLERATED, BUT A SYSTEMATIC (ZERO POINT) ERROR OF 0.02
     7 DEGREES/77H IS PROBABLY DISASTROUS.  CHECK YOUR INPUT LINES AGAIN
     8ST THEIR HIGHER ORDERS.//  83H DO NOT USE A DEBIJE-SCHERRER CAMERA
     9  UNLESS THE UNIT CELL TO BE EXPECTED IS SMALL./76H WOULD YOU LIKE
     O TO SOLVE A JIGSAW PUZZLE WHEN HALF THE PIECES ARE MISSING---)
 9952 FORMAT(50H ORTHORHOMBIC LATTICES ARE GIVEN AN EXTRA CHANCE   )
 9953 FORMAT(50H MONOCLINIC   LATTICES ARE GIVEN AN EXTRA CHANCE   )
 9954 FORMAT(50H TRICLINIC    LATTICES ARE GIVEN AN EXTRA CHANCE   )
C9956 FORMAT(50H ATTENTION,  THE INPUT FORMAT HAS BEEN CHANGED
C    1  ,    50H XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  )
C9998 FORMAT(16H END OF PROGRAM   )
      END
      SUBROUTINE REAR
      DIMENSION ZZ(7,2),IJ(2)
C  THIS SUBROUTINE LOOKS FOR THE COMMON ROW IN TWO ZONES . THE EXISTENCE
C  OF TWO EQUAL Q-VALUES IS ENOUGH.
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      J=0
      I=1
   10 ZZ(1,I)=CEL(J+1)
      ZZ(2,I)=CEL(J+2)
      ZZ(3,I)=CEL(J+1)+CEL(J+2)+CEL(J+3)
      ZZ(4,I)=CEL(J+1)+CEL(J+2)-CEL(J+3)
      ZZ(5,I)=CEL(J+3)
      ZZ(6,I)=CEL(J+1)*2.0+CEL(J+3)
      ZZ(7,I)=CEL(J+1)*2.0-CEL(J+3)
      IF (J.GT.1) GO TO 20
      I=2
      J=3
      GO TO 10
   20 DO 50 I=1,4
      DO 40 J=1,4
      IJ(1)=I
      IJ(2)=J
      IF (ABS(ZZ(I,1)-ZZ(J,2)).LT. 1.0 ) GO TO 100
   40 CONTINUE
   50 CONTINUE
      CEL(4)=0.0
      RETURN
  100 CEL(1)=0.0
      DO 150 N=1,2
      L=7-N
      K=IJ(N)
      CEL(1)=0.5*ZZ(K,N)+CEL(1)
      IF (K.GT.1) GO TO 120
      CEL(N+1)=ZZ(2,N)
      CEL(L)   =ZZ(5,N)
      GO TO 150
  120 CEL(N+1)=ZZ(1,N)
      CEL(L)   =ZZ(K+3,N)
  150 CONTINUE
      RETURN
      END
      SUBROUTINE RECCEL
C  CHECKS WHETHER THE INPUT LATTICE IS IN ANGSTROMS AND DEGREES
C  AND CALCULATES A,B,C,D,E,F IF IT IS.
      DIMENSION WAAR(6),WAR(6),CL(6)
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /TEMRES/ LINCO,NQ2,NINDEX,INDEX(40),ROSTER(150,12)
      RAD=57.29578
      NR=INDEX(40)
      DO 10 J=1,6
   10 WAAR(J)=ROSTER(NR,J)
      IF(WAAR(4) .EQ. 0.0 .AND. WAAR(6) .EQ. 0.0) GO TO 150
      IF(ABS(WAAR(5)) .LT. 2.0*SQRT(WAAR(1)*WAAR(3))) GO TO 150
      WRITE(IOUT,9909)(WAAR(J),J=1,6)
C     WRITE(NCRT,'('' A direct lattice was used for input '')')
C     WRITE(NCRT,9909)(WAAR(J),J=1,6)
      A=1.0
      B=2.0
      DO 130 J=1,3
      C=COS(WAAR(J+3)/RAD)
      CL(J)=C
      CL(J+3)=C
      A=A-C*C
      B=B*C
      WAR(J)=WAAR(J)
      WAR(J+3)=WAR(J)
      CEL(J)=WAAR(J+3)/RAD
      CEL(J+3)=CEL(J)
  130 CONTINUE
      FVOL=10000.0/(A+B)
      DO 140 J=1,3
      WAAR(J)=FVOL*(SIN(CEL(J))/WAR(J))**2
      WAAR(J+3)=2.0*FVOL*(CL(J+1)*CL(J+2)-CL(J))/(WAR(J+1)*WAR(J+2))
  140 CONTINUE
      DO 145 J=1,6
  145 ROSTER(NR,J)=WAAR(J)
  150 RETURN
 9909 FORMAT(30H INPUT LATTICE OF DIRECT CELL   ,6F10.4)
      END
