      SUBROUTINE EVALU8(NR,ISW)
C  THIS SUBROUTINE EVALUATES THE LATTICES FOUND IN FINZON,
C  IT TAKES CARE THAT THEY ARE NORMALISED, FINDS OUT WHETHER ANY OF
C  THE AXES SHOULD BE HALVED AND REFINES THE PARAMETERS.
C-----------------------------------------------------------------------
C  Changed: 250493 : added NCRT
C  Changed: 061193 : DELETED NCRT
      INTEGER H
      DIMENSION  HULP(6) ,NOAR(6),NCAR(6)
      LOGICAL RECTAN,REPEAT
      LOGICAL SELF,ENL,TEST,TYP
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /EVALN / NORDER,RECTAN,PROB(40),EVAL(-8:8,0:8),
     *                UPBNDR(40)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      REPEAT=.FALSE.
      A=STORE(NR,1)
      B=STORE(NR,2)
      FMAAS=STORE(NR,3)
      CR=STORE(NR,4)
      CENTR=STORE(NR,6)
      ZERSHF=0.0
   20 TYP=.FALSE.
      REPEAT=.NOT. REPEAT
      IF (TEST) TYP=.TRUE.
      IF (ENL .AND. (ISW .EQ. 2) ) TYP=.TRUE.
      IF (TYP )  WRITE(IOUT, 1 ) NR,A,B,FMAAS,TWORAD*ZERSHF
C--WRITES HEADING, INITIAL VALUES.
      CALL NORM(A,B,FMAAS)
      IF (A .LT. FMINIM) GO TO 130
      D=(A+B+FMAAS)*16.5
      IF (D .GT. OBSPT(MAX) ) D=OBSPT(MAX)
C-----------------------------------------------------------------------
      IF (ISW .EQ. 2)  THEN
         GO TO 125
      ELSE IF (ISW .EQ. 3) THEN
         CALL LSTET(TYP,A,B,FMAAS,ZERSHF,D,NR)
         STORE(NR,9)=ZERSHF
         RETURN
      END IF
      CALL LS(TYP,A,B,FMAAS,ZERSHF,D,NR)
      CALL NORM(A,B,FMAAS)
      IF (TEST) WRITE(IOUT,2) A,B,FMAAS,TWORAD*ZERSHF
      IF (A .LT. FMINIM) GO TO 130
      A=0.25*A
      B=0.25*B
      FMAAS=0.25*FMAAS
      CALL  LS(TYP    ,A,B,FMAAS,ZERSHF,D,NR)
C--FROM HERE UNTIL LABEL 50  WE EVALUATE DIFFERENT FORMULATIONS
C--OF THE ZONE.
      NN=0
      DO 40 I=1,2
      DO 30 J=1,2
      H=I
      K=J
      NN=NN+1
      CALL CRITER(H,K,.FALSE.,CRIT,NO,NC)
      NOAR(NN)=NO
      NCAR(NN)=NC
   30 HULP(NN)=CRIT
   40 CONTINUE
      DO 50 J=1,2
      I=J
      NN=NN+1
      CALL CRITER(I,I,.TRUE.,CRIT,NO,NC)
      NOAR(NN)=NO
      NCAR(NN)=NC
   50 HULP(NN)=CRIT
C     CRTMIN=1.2*FLOAT(NOAR(4))/FLOAT(NCAR(4))
C  THE NEW LATTICE SHOULD BE DECIDEDLY  BETTER THAN THE OLD ONE.
      AA=10.0*HULP(4)
      NN=4
      DO 60 N=1,6
C     CRIT=FLOAT(NOAR(N))/FLOAT(NCAR(N))
C     IF (CRIT .LE. CRTMIN) GO TO  60
C     CRTMIN=CRIT
      IF (HULP(N) .LE. AA) GO TO 60
      AA=HULP(N)
      NN=N
   60 CONTINUE
      CENTR=0.
      IF (TEST) CALL TEXT1(NN,HULP,NOAR,NCAR)
      GO TO (101,102,103,104,105,106),NN
C--CHOOSE THE BEST.
  102 A=4.*A
      FMAAS=2.*FMAAS
      GO TO  101
  103 B=4.*B
      FMAAS=2.*FMAAS
      GO TO  101
  104 A=4.*A
      B=4.*B
      FMAAS=4.*FMAAS
      GO TO 101
  106 CENTR =1.
      GO TO 104
  105 CENTR =1.
  101 IF (FMAAS .LT. 0.01) GO TO 120
      IF (CENTR .LT. 0.5 ) GO TO 120
C  CENTERED SKEW ZONES ARE REFORMULATED HERE AND RECYCLED.
      E=2.*(B-A)
      A=A+B-FMAAS
      B=A+2.*FMAAS
      FMAAS=E
      IF (TEST) WRITE(IOUT, 3) A,B,FMAAS,NR
      IF (REPEAT) GO TO 20
C  AT THE FIRST PASS, REPEAT IS TRUE
  120 CALL  LS(TYP    ,A,B,FMAAS,ZERSHF,D,NR)
      CR= HULP(NN)
      STORE(NR,7)=NOAR(NN)
      STORE(NR,8)=NCAR(NN)
      CALL NORM(A,B,FMAAS)
      IF (TEST) WRITE(IOUT,4) CR
      GO TO 130
  125 CALL LS(TYP,A,B,FMAAS,ZERSHF,D,NR)
  130 STORE(NR,1)=A
      STORE(NR,2)=B
      STORE(NR,3)=FMAAS
      STORE(NR,4)=CR
      STORE(NR,6)=CENTR
      STORE(NR,9)=ZERSHF
      RETURN
    1 FORMAT(10H  ZONE NR , I4,21H     ORIGINAL  VALUES ,3F10.2,F8.4)
    2 FORMAT(21H ZONE REFORMULATED   , 3F10.2,F8.4)
    3 FORMAT(43H0A CENTERED SKEW ZONE HAS BEEN REFORMULATED,3F10.2,I4)
    4 FORMAT(1H ,90X,12HPROBABILITY  ,E12.3)
      END
      SUBROUTINE FINZON(A,B)
C-----------------------------------------------------------------------
C  SEARCH FOR POSSIBLE ZONES, BASED ON LINES A AND B.
C-----------------------------------------------------------------------
C  Changed: 121193 : deleted step 2 in loop on 90,
C                    increased to 2*FMINEQ in loop on 100
C
      INTEGER  H
      DIMENSION  BE(10),IBE(10)
      LOGICAL SELF,ENL,TEST
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /COUNTM/ ITL(0:5000)
C-----------------------------------------------------------------------
      DO 10 I=0,5000
   10 ITL(I)=0
      DO 20 I=1,10
         IBE(I)=0
         CEL(I)=.0
   20    BE(I)=.0
      F2=6.0/TOL2
      RF2=1.0/F2
      FMAAX=1.95*SQRT(A*B)
      LIMT=NINT(F2*FMAAX)
      IF(LIMT.GT.5000) THEN
         IF (ENL) WRITE(IOUT,992) LIMT
  992    FORMAT(/37H ARRAY ITL TOO SMALL, SIZE SHOULD BE , I4)
         LIMT=5000
      END IF
      LASTH=2
      LASTK=2
      MIN=2
      QMAX=OBS(MAX)
      IF (4.*(A+B+FMAAX) .GT. QMAX) THEN
C  RANGE OF H AND K IS NOW NON-STANDARD
         LASTH=INT(SQRT(QMAX/A))
         IF (LASTH .GT. 4) LASTH=4
         LASTK=INT(SQRT(QMAX/B))
         MIN=(4*LASTH*LASTK)/5
         IF (LASTH .EQ. 2  .AND.  LASTK .EQ. 2) GO TO 35
         IF (TEST) WRITE(IOUT,991) A,B,LASTH,LASTK,MIN
      END IF
C  DETERMINATION OF POSSIBLE VALUES OF FMAAS BEGINS HERE.
   35 DO 50 H=1,LASTH
         DO 45 K=1,LASTK
            Y=A*FLOAT(H*H)+B*FLOAT(K*K)
            Z=F2/FLOAT(H*K)
            DO 40 M=1,MAX
               L=NINT( Z*ABS(OBS(M)-Y)  )
               IF(L.LE.LIMT) ITL(L)=ITL(L)+1
   40       CONTINUE
   45    CONTINUE
   50 CONTINUE
C  ALL POSSIBLE VALUES ARE STORED IN ITL
C     IF (TEST) WRITE(IOUT,994) (ITL(J),J=1,LIMT)
C 994 FORMAT('0ARRAY ITL: '/  (40I3)  )
      LIMT=LIMT-6
      KG=NINT(F2*FMINEQ)
      IF (KG .EQ. 0) KG=1
      DO 55 I=1,KG
   55 ITL(0)=ITL(0)+ITL(I)
      ITL(0)=2*ITL(0)
C  THE VALUE ZERO CAN OCCUR ONLY HALF AS MUCH AS NON-ZERO VALUES
      IBE(1)=ITL(0)
      BE(1)=0.
      MIN=1
      NR=1
C  WE NOW TRY TO FIND COINCIDING VALUES (MORE THAN 'MIN' VALUES IN
C  6 SUCCESIVE POSITIONS OF ITL).
C  MANY VALUES (ESPECIALLY THE CORRECT ONES) WILL BE FOUND MORE THAN
C  THAN ONCE. THEREFORE WE MUST STORE AT LEAST 10 VALUES.
C  START OF THE SEARCH IN ITL
      DO 90 I=KG,LIMT
         K=0
         DO 65 L=I,I+5
   65    K=K+ITL(L)
         IF (K .LE. MIN) GO TO 90
         IU=0
         DO 70 L=I,I+5
   70    IU=IU+ITL(L)*L
C........CALCULATION OF THE WEIGHTED MEAN.
         DO 80 L=1,NR+1
            IF (K .GT. IBE(L) ) THEN
               DO 75 N=NR,L,-1
                  IBE(N+1)=IBE(N)
                  BE(N+1)=BE(N)
   75          CONTINUE
C  ALL 'LOWER' VALUES HAVE NOW BEEN SHIFTED ONE POSITION
               IBE(L)=K
               BE(L)=RF2*FLOAT(IU)/FLOAT(K)
               IF (IBE(9) .GT. MIN) MIN=IBE(9)
               NR=NR+1
               IF (NR .GT. 9) NR=9
               GO TO 90
            END IF
   80    CONTINUE
   90 CONTINUE
C     IF (TEST) WRITE(IOUT,993) BE, IBE
C 993 FORMAT(' ARRAYS BE AND IBE:' / ' ',10F8.1,/ ' ',10I8 )
C  NOW SELECT THE 10 MOST FREQUENT VALUES OF FMAAS AND STORE THEM IN BE.
      II=0
      DO 110 I=1,NR-1
         FMAAS=BE(I)
         DO 100 L=I+1,NR
            IF ( ABS(BE(L)-FMAAS) .GE. 2.0*FMINEQ) GO TO 100
C  CHECK ON 'EQUAL' VALUES.  USE THE MEAN.
            FMAAS=0.5*(FMAAS+BE(L))
            BE(L)=100000.
  100    CONTINUE
  101    IF(FMAAS.GE.10000.) GO TO 105
         II=II+1
         CEL(II)=FMAAS
         CEL(II+5)=IBE(I)
C  RETURN THE VALUES FOUND VIA CEL
         IF (II .EQ. 5) RETURN
  105    CONTINUE
  110 CONTINUE
      RETURN
  991 FORMAT( 40X,26H NON-STANDARD ZONE SEARCH   ,2F7.1,
     *12H /H/ FROM 1-,I1,10H K FROM 1-,I1,23H MINIMUM NUMBER OF HITS,I3)
      END
      SUBROUTINE INSTRS
C  PRINTS INSTRUCTIONS FOR THE SPECIAL FEATURES.
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      WRITE(IOUT,10)
      WRITE(IOUT,20)
      WRITE(IOUT,30)
      WRITE(IOUT,40)
      WRITE(IOUT,50)
      WRITE(IOUT,60)
      WRITE(IOUT,70)
      WRITE(IOUT,72)
      WRITE(IOUT,80)
      WRITE(IOUT,90)
      WRITE(IOUT,100)
      WRITE(IOUT,110)
      WRITE(IOUT,120)
      WRITE(IOUT,130)
      WRITE(IOUT,135)
      WRITE(IOUT,140)
      WRITE(IOUT,150)
      WRITE(IOUT,160)
      WRITE(IOUT,180)
      WRITE(IOUT,190)
      WRITE(IOUT,200)
      RETURN
   10 FORMAT(35H  INSTRUCTIONS FOR SPECIAL FEATURES   ,
     1       ' ****  VERSION  15  ***** ' //
     2       1H ,10X,32HCOL  3  **INTENS**                        /
     3       50H  IF YOU WANT TO ENTER INTENSITIES WITH YOUR LINE ,
     4       50HPOSITIONS YOU SHOULD SET INTENS(COL 3) AT 1.      /
     5       50H THE LINE POSITIONS AND INTENSITIES ARE THEN READ ,
     6       50HIN THE FORMAT 8(F7.3,A2,1X),WHICH MEANS THAT THE  /
     7       50H INTENSITIES ARE READ AS CHARACTERS. YOU MAY ENTER,
     8       50H THEM AS A 2-DIGIT FIGURE BUT ALSO AS   VS, W , VW/
     9       50H ETC. YOU COULD ALSO USE THIS TO MARK ONLY THE VER,
     A       50HY WEAK LINES OR SUSPECTED LINES.                  /
     B       50H NO CALCULATIONS ARE CARRIED OUT WITH THE INTENSIT,
     C        4HIES. )
   20 FORMAT(1H ,10X,32HCOL  4  **NSOLMX**                        /
     *       50H NSOLMX IS THE MAXIMUM NUMBER OF SOLUTIONS FOR WHI,
     1       50HCH A LIST OF (INDEXED) REFLECTIONS IS PRINTED.    /
     2       50H THE CORRESPONDING Q-SCHEME IS ONLY PRINTED WHEN  ,
     3       50HINTERMEDIATE RESULTS ARE GIVEN (COL. 34)  .AND.   /
     4       50H THE FIGURE OF MERIT IS LARGER THAN 4.0.          )
   30 FORMAT(1H ,10X,32HCOL 5-6, 7-8, 9-10   **NSYST**            /
     *       50H WHEN YOU ARE REASONABLY SURE THAT THE SOLUTION MU,
     1       50HST BELONG TO A CERTAIN CRYSTAL SYSTEM, YOU CAN    /
     2       50H INDICATE THIS IN COLS 5-10 (3I2). THE COLUMNS SER,
     3       50HVE THE ORTHORHOMBIC, MONOCLINIC AND TRICLINIC     /
     4       50H SYSTEM RESPECTIVELY.  A ZERO MEANS THAT YOU ARE  ,
     5       50HINDIFFERENT (DEFAULT CASE), A +1 INDICATES THAT   /
     6       50H YOU ARE PRETTY SURE THAT THE CORRECT SOLUTION BEL,
     7       53HONGS TO THIS CRYSTAL SYSTEM, A -1 MEANS THE OPPOSITE./
     8       50H THIS OPTION WORKS ONLY ON THE LAST PART OF THE PR,
     9       50HOGRAM AND DOUBLES THE TOLERANCES THERE..          /
     O       50H THIS IS ONLY POSSIBLE FOR ORTHORHOMBIC,MONOCLINIC,
     A       50H AND TRICLINIC LATTICES.                           )
   40 FORMAT(1H ,10X,22H COL 11-15   **TOL2**    /
     *           11X,22H COL 16-20   **TOL3**    /
     *       50H THE TOLERANCE ON THE VALUE OF R (THE TRIAL VALUE ,
     1       50HOF F USED IN THE SEARCH FOR ZONES, SEE MY PAPER,  /
     2       50H EQ. 4) IS GIVEN BY *TOL2*. WHEN YOU HAVE VERY GOO,
     3       50HD DATA (0.01 DEGREE TWOTHETA) ON A FAIRLY LARGE   /
     4       50H UNIT CELL,YOU MIGHT LOWER IT TO 2.5 OR 2.0 .WITH ,
     5       50HA SMALL UNIT CELL YOU MIGHT INCREASE IT SOMEWHAT  /
     6       50H TO SAY 4.0. TOL3 IS THE SAME KIND OF TOLERANCE, B,
     7       50HUT NOW ON THE TRIAL VALUE OF D IN THE SEARCH FOR  /
     8       50H LATTICES (SEE PAPER, PAGE 91).ITS VALUE CAN BE CH,
     9       50HANGED IN THE SAME WAY AS THAT OF TOL2.            )
   50 FORMAT(1H ,10X,32HCOL 31-32  **LINCO**                      /
     *       50H LINCO ENABLES YOU TO ENTER YOUR OWN LINE COMBINAT,
     1       50HIONS OR YOUR OWN ZONES.                           /
     2       44H WHEN LINCO IS NOT ZERO, THE PROGRAM EXPECTS      ,
     3       50H CARDS (AFTER THE LINES CARDS+THE BLANK CARD)     /
     4       50H AND READS THESE IN THE FORMAT  3F10.2,F10.1      /
     4       50H YOU MAY ENTER ANY NUMBER OF ZONES (LESS THAN 40) ,
     5       50HBUT YOU MUST END WITH A BLANK CARD.               /
     5       50H WHEN YOU ENTER ONLY 2 VALUES, THE PROGRAM INTERPR,
     6       50HETS THIS AS A COMBINATION OF LINES, TO BE TRIED   /
     7       50H FOR FINDING ZONES.                               )
   60 FORMAT(50H WHEN YOU ENTER 3 VALUES, THE PROGRAM WILL TREAT  ,
     1       50HTHESE AS  A ZONE AND WILL EVALUATE IT. IF YOU WANT/
     2       50H TO ENTER A RECTANGULAR ZONE, YOU MUST SET ITS THI,
     3       50HRD CONSTANT AT 0.08 , OTHERWISE THE PROGRAM WILL  /
     4       50H TREAT IT AS A LINE COMBINATION.                  )
   70 FORMAT(50H IF YOU WANT TO ENSURE THAT A SPECIFIED ZONE WILL ,
     1       50HBE INCLUDED IN THE SEARCH FOR COMPLETE LATTICES,  /
     2       50H YOU SHOULD ALSO ENTER A HIGH QUALITY FIGURE (FOUR,
     3       50HTH VALUE ON THE CARD), PUNCHING A SINGLE DIGIT IN /
     4       50H COL. 31 ASSURES YOU OF A HIGH QUALITY FIGURE.    /
     5       50H IF THE PROGRAM DOES NOT FIND THE SOLUTION AUTOMAT,
     6       50HICALLY, IT CAN OFTEN BE HELPED BY ADDING ZONES IN /
     7       50H THIS WAY. ZONES WHICH ARE CORRECT, ALTHOUGH HAVIN,
     8       51HG A LOW QUALITY FIGURE, CAN SOMETIMES BE RECOGNISED/
     9       50H IN THE LIST OF INTERMEDIATE RESULTS (K, COL.34)  ,
     *       50HBY THEIR SMALL AREA (I.E. LARGE *A* AND *B*) AND  /
     A       50H GOOD COVERAGE NEAR THE ORIGIN (I.E. MOST OF THE  ,
     B       50HLOW ANGLE CALCULATED LINES HAVE BEEN MATCHED WITH /
     C       50H OBSERVED LINES). ZONES FROM ORIENTED SPECIMENS OR,
     D       50H FIBRES, OR FROM ELECTRON DIFFRACTION STUDIES, CAN/
     E       20H ALSO BE USED.         )
   72 FORMAT(50H N.B.  THE PROGRAM WILL SKIP THE ZONE-FINDING PART,
     1       50H WHENEVER THIS OPTION IS USED.                    /
     2       50H TAKE CARE TO ENTER ENOUGH ZONES (OR LINE COMBINAT,
     3       50HIONS) TO LET THE PROGRAM CONTINUE.                )
   80 FORMAT(1H ,10X,32HCOL 33   ***LZERCK***                     /
     1       50H  YOU CAN ALSO ASK THE PROGRAM TO PERFORM A CHECK ,
     2       50HON ZERO ERRORS (COL. 33). THE SUBROUTINE GIVES    /
     3       20H FULL PARTICULARS.   )
   90 FORMAT(1H )
  100 FORMAT(1H ,10X,32HCOL 43-44   **NR**                        /
     *       50H    WHEN YOU WANT TO ENTER A NUMBER OF TRIAL LATTI,
     1       50HCES OF YOUR OWN, YOU CAN DO THIS BY MAKING NR POS./
     2       50H THE PROGRAM WILL NOW EXPECT CARDS WITH TRIAL LATT,
     4       50HICES AFTER THE INPUT OF THE LINES (+BLANK CARD).  /
     5       50H THERE SHOULD BE 6 DATA PER CARD (FORMAT 6F10.2), ,
     7       50HTHE COEFFICIENTS A,B,C,D,E AND F OF               /
     8       50H  Q=H*H*A+K*K*B+L*L*C+K*L*D+L*H*E+H*K*F           /
     9       50H WHERE Q=10000/(D*D)  (D=INTERPLANAR SPACING IN A)/
     O       50H *****YOU MAY ALSO ENTER THE TRIAL LATTICE AS A DI,
     A       50HRECT LATTICE WITH 6 CONSTANTS IN ANGSTROMS AND (DE,
     B       15HCIMAL) DEGREES. /
     C       50H THE TRIAL LATTICES ARE TERMINATED BY A CARD WITH ,
     D       50HZERO OR BLANK IN COLS 1-10.                       )
  110 FORMAT(1H ,10X,32HCOL 47-48  **LIST**                       /
     *       50H LIST. FOR THE BEST SOLUTION, THE PROGRAM WILL PRO,
     1       50HDUCE A LIST OF ALL OBSERVED AND CALCULATED LINES, /
     2       50H SORTED ON TWOTHETA, UNLESS IT WOULD BE TOO LONG (,
     3       50HMORE THAN 100 CALCULATED LINES). IF YOU WANT THIS /
     4       50H LIST FOR MORE SOLUTIONS, YOU SHOULD ENTER THE NUM,
     5       52HBER THAT YOU WANT IN COL. 48.  YOU CAN ALSO SUPPRESS/
     6       50H THIS OPTION BY MAKING LIST NEGATIVE. DEFAULT=1   )
  120 FORMAT(1H ,10X,32HCOL 71-78   **TOLG**                      /
     *       50H TOLG IS THE TOLERANCE ON THE FIT BETWEEN OBSERVED,
     1       52H AND CALCULATED LINES. IT IS EXPRESSED IN HUNDREDTHS/
     2       52H OF A DEGREE TWOTHETA, E.G. THE DEFAULT VALUE OF 6.0,
     3       50H MEANS THAT A DIFFERENCE OF 0.060 DEGREES TWOTHETA/
     4       50H BETWEEN CALCULATED AND OBSERVED LINES IS JUST ACC,
     5       10HEPTABLE.  /
     6       50H TOLG APPLIES TO BOTH THE ZONE AND LATTICE SEARCHE,
     6       50HS, AND TO THE LATTICE REFINEMENT.                 /
     7       47H FOR VERY ACCURATE DATA IT CAN BE ADVANTAGEOUS ,
     8       47HTO LOWER TOLG TO 4.0 OR 3.5.                   /
     9       50H FOR INACCURATE DATA IT CAN BE INCREASED, BUT SUCH,
     *       50H DATA IS NOT USUALLY WORTH PROCESSING UNLESS THE  /
     A       50H CELL IS VERY SMALL.                              )
  130 FORMAT(1H ,10X,32HCOL  79-80  *NTST**                       /
     *       50H THE TEST OUTPUT CAN BE LIMITED TO THE SUBROUTINE ,
     1       50H WHERE YOU REALLY NEED IT, BY ENTERING A PARAMETER/
     2       50H FOR *NTEST* IN COLUMN 80 OF THE FIRST PARAMETER  ,
     3       50HCARD. (SEE SUBROUTINE FOR DIRECTIONS)             /
     4       50H0IF YOU WANT THE TEST OUTPUT TO CONTINUE UNTIL THE,
     5       50H END OF THE PROGRAM, YOU MUST MULTIPLY THE DESIRED/
     6       50H NUMBER BY 11 AND USE COLUMNS 79 AND 80 OF THE FIR,
     7       50HST PARAMETER CARD. PUNCH E.G. 88 IF THE LAST PART /
     8       50H OF THE PROGRAM GIVES YOU TROUBLE.                //)
  135 FORMAT(1H ,30X,20(1H*) /31X,20H*  ON SECOND CARD  * /
     1       31X, 20(1H*)   )
  140 FORMAT(1H ,10X,32HCOL 01-10  **ZERCOR**                     /
     *       50H **ZERCOR**THE PROGRAM APPLIES THIS CORRECTION TO ,
     1       50HALL LINES. THE CORRECTION IS APPLIED AS IT STANDS,/
     2       50H A POSITIVE CORRECTION IS ADDED TO THE TWOTHETA VA,
     3       50HLUES OF THE LINES.                                /
     4       50H THE CORRECTION MUST BE GIVEN IN DEGREES TWOTHETA,,
     5       50H E.G.  -0.052 SUBTRACTS 0.052 DEGREES FROM THE    /
     6       50H TWOTHETA VALUES OF ALL LINES, EVEN IF YOU ENTERED,
     7       50H D-VALUES.                                        )
  150 FORMAT(1H ,10X,32HCOL 11-20  **PRNTMR**                     /
     *       50H **PRNTMR**THE PROGRAM DOES NOT PRINT ANY LATTICES,
     1       50H THAT HAVE A FIGURE OF MERIT THAT IS BELOW PRNTMR./
     2       51H THE DEFAULT VALUE IS 4.0, WHICH MUST BE CONSIDERED,
     3       50H AS AN ABSOLUTE MINIMUM FOR A LATTICE THAT HAS A  /
     4       50H CHANCE TO IMPROVE ITS PERFORMANCE.               )
  160 FORMAT(1H ,10X,32HCOL 21-30  **PRNTLN**                     /
     *       50H **PRNTLN**THE PROGRAM DOES NOT PRINT ANY LATTICES,
     1       50H THAT HAVE LESS THAN *PRNTLN* INDEXED LINES.      /
     2       50H LATTICES WITH SUCH A LOW NUMBER OF INDEXED LINES ,
     3       50HARE SOMETIMES A SUBLATTICE OF THE TRUE LATTICE.   /
     4       50H A LATTICE CAN ONLY BE CONSIDERED AS SATISFACTORY ,
     5       50HWHEN IT EXPLAINS ALL LINES.                       )
  180 FORMAT(1H ,10X,32HCOL 31-40  **ZERREF**                     /
     *       50H **ZERREF**THE PROGRAM DOES NOT REFINE THE ZERO-ER,
     1       50HROR IF ZERREF > 0.1                               )
  190 FORMAT(1H ,10X,32HCOL 41-50  ** FMAX **                     /
     1       50H **FMAX**THE NUMBER OF LINES THAT IS ACTUALLY USED,
     2       50H IN THE PROGRAM. (NMAX, = NINT(FMAX)  ).          /
     3       50H THE NUMBER OF LINES USED IS SOMETIMES ESSENTIAL  ,
     4       50HFOR THE SUCCES OF THE PROGRAM. THE OPTIMUM NUMBER /
     5       50H IS ABOUT 32, BUT IT CAN BE HIGHER OR LOWER. NMAX ,
     6       50H GIVES THE POSSIBILITY TO DO EXPERIMENTS.         /
     7       50H IF FMAX < 0.1 (BLANK OR ZERO) THEN FMAX=32.0     )
  200 FORMAT(///47H **NOTE**  A USEFUL STRATEGY IS TO IMPROVE THE ,
     1       50HOBSERVED DATA BY USING LINES FOR WHICH 2 OR MORE  /
     2       50H ORDERS HAVE BEEN OBSERVED. THE LOWEST ORDERS CAN ,
     3       50HBE REPLACED BY A MORE ACCURATE VALUE CALCULATED   /
     4       50H FROM THE HIGHER ORDERS, AND SOMETIMES UNOBSERVED ,
     5       50HFIRST OR SECOND ORDER LINES CAN BE INFERRED AND   /
     6       50H ADDED TO THE  *OBSERVED* PATTERN.  LOW ORDER ABSE,
     7       50HNCES IN WELL-ESTABLISHED ZONES CAN BE FILLED IN A /
     8       50H SIMILAR WAY. MULTIPLE ORDERS CAN ALSO BE USED TO ,
     9       50HCHECK FOR ZERO ERRORS IN TWOTHETA.                /
     O       50H SEE ALSO SUBROUTINE ZERCHK.                      )
      END
      SUBROUTINE LISTM
C  THE SUBROUTINE PRODUCES A LIST OF ALL OBSERVED AND CALCULATED
C  LINES, SORTED ON TWOTHETA. IF THE SUCCEEDING VALUES DIFFER
C  MORE THAN THE TOLERANCE(TOLG), A BLANK LINE IS INSERTED.
C
C  .... CHANGE:  19 JULI 1985.  FORMAT 9914
C  .... CHANGE:  250493 :  NCRT, PRINT 3 DECIMALS ON 2THETA
C  LAST CHANGE:  061193 :  NCRT, PRINT DELETED
C
C
      LOGICAL SELF,ENL,TEST,ZERREF
      CHARACTER NAME*80,CARD*80,INTSY*2
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /LINSTR/ NMAX,NCALC,N20,NOTIND,INSTOR(200,3),QSTOR(200)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /THETAS/ ZERTOT,OBSTET(40),SHFTET(40),TETPT(40),TETMT(40)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
C-----------------------------------------------------------------------
      SWAVEL=WAVEL/200.
C--SORT CALCULATED VALUES.
      DO 100 I=1,NCALC
      Q=1.E+6
      DO  60 J=I,NCALC
      IF (QSTOR(J).GT. Q) GO TO 60
      Q=QSTOR(J)
      N=J
   60 CONTINUE
      U=QSTOR(I)
      QSTOR(I)=QSTOR(N)
      QSTOR(N)=U
      DO  80 K=1,3
      INX  =INSTOR(I,K)
      INSTOR(I,K)=INSTOR(N,K)
   80 INSTOR(N,K)= INX
  100 CONTINUE
      NO=1
      NC=1
      UL=0.
      WRITE(IOUT,9903) NMAX,TOLG
      WRITE(IOUT,9904)
      WRITE(NSUMM,9914) NMAX,TOLG
C     WRITE(NCRT ,9914) NMAX,TOLG
C--PRINT QCALC AND QOBS IN ORDER OF TWOTHETA.
  110 CONTINUE
      IF (NO .GT. NMAX) GO TO 115
      IF (NC .GT. NCALC) GO TO 200
      IF (QSTOR(NC) .GT. OBS(NO)) GO TO 200
  115 IF (NC .GT. NCALC) GO TO 300
      W=SQRT(QSTOR(NC))
      U=SWAVEL*W
      W=100./W
      U=TWORAD*ATAN(U/SQRT(1.0-U*U))
      IF (U-UL .GT. TOLG) WRITE(IOUT ,9905)
      IF (U-UL .GT. TOLG) WRITE(NSUMM,9905)
C     IF (U-UL .GT. TOLG) WRITE(NCRT ,9905)
      WRITE(IOUT ,9901) U,W,(INSTOR(NC,K),K=1,3),QSTOR(NC)
      WRITE(NSUMM,9901) U,W,(INSTOR(NC,K),K=1,3),QSTOR(NC)
C     WRITE(NCRT ,9901) U,W,(INSTOR(NC,K),K=1,3),QSTOR(NC)
      UL=U
      NC=NC+1
      GO TO 110
  200 TET=SHFTET(NO)
      U=TWORAD*TET
      D=WAVEL/(2.*SIN(TET))
      Q=100./D
      Q=Q*Q
      IF (U-UL .GT. TOLG) THEN
         WRITE(IOUT ,9905)
         WRITE(NSUMM,9905)
C        WRITE(NCRT ,9905)
      END IF
      IF (NMATCH(NO) .EQ. 0) THEN
         WRITE(IOUT ,9902) U,D, Q ,INTSY(NO)
         WRITE(NSUMM,9902) U,D, Q ,INTSY(NO)
C        WRITE(NCRT ,9902) U,D, Q ,INTSY(NO)
      ELSE
         WRITE(IOUT ,9906) U,D, Q ,INTSY(NO)
         WRITE(NSUMM,9906) U,D, Q ,INTSY(NO)
C        WRITE(NCRT ,9906) U,D, Q ,INTSY(NO)
      END IF
      UL=U
      NO=NO+1
      GO TO 110
  300 RETURN
 9901 FORMAT(1H ,F10.3,F10.3,2X,3I4,F8.1)
 9902 FORMAT(1H ,F10.3,F10.3,14H     *OBSERVED ,F8.1,5X,A2,
     * '  XXXXXXXX')
 9903 FORMAT(52H LIST OF ALL OBSERVED AND CALCULATED LINES UP TO AND,
     *  14H INCLUDING THE, I4,3HST.  /
     1  34H IF THE TWOTHETAS DIFFER MORE THAN  ,F6.3,
     2  37H  DEGREES, A BLANK LINE IS INSERTED.  )
 9904 FORMAT(45H   TWOTHETA       D       H   K   L     Q          )
 9905 FORMAT(3X)
 9906 FORMAT(1H ,F10.3,F10.3,14H     *OBSERVED ,F8.1,5X,A2)
 9914 FORMAT(/// 5X,16('***')/ 5X,
     1  '*   USE THE LIST TO FIND SYSTEMATIC ABSENCES   *'/
     2  5X,16('***') //
     3  ' LIST OF ALL OBSERVED AND CALCULATED LINES UP TO THE',
     4  I4,3HST.  /
     5  34H IF THE TWOTHETAS DIFFER MORE THAN  ,F6.3,
     6  '  DEGREES, '/ ' A BLANK LINE IS INSERTED. ' //
     7  45H   TWOTHETA       D       H   K   L     Q          )
      END
      SUBROUTINE   LS(TYP,A,B,FMAAS, ZERSHF,QCALMX, NR)
C-----------------------------------------------------------------------
C  REFINES THE PARAMETERS (A,B,FMAAS) BY LEAST-SQUARES, PRINTS THE ZONE
C  IF TYP=TRUE  AND FILLS THE ARRAY EVAL FOR THE PROCEDURE  CRITERION.
C  THE ELEMENTS OF  EVAL  REMAIN  ZERO  WHEN Q IS TOO LARGE (Z >QCALMX),
C  THEY BECOME +1 WHEN THE CALCULATED Q-VALUE EXISTS (CORRESPONDS TO
C  AN OBSERVED Q) AND BECOME  -1  IF THE Q-VALUE IS NOT IN THE LIST
C  OF OBSERVED VALUES.VALUES ARE NOW + OR - THE PROBABILITY.
C-----------------------------------------------------------------------
      DIMENSION  REF(4,6),HULP(6),FYN(3)
      INTEGER  H,HG,HMIN, ORDE,ORP1
      LOGICAL SELF,ENL,TEST,RECTAN,TYP
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /EVALN / NORDER,RECTAN,PROB(40),EVAL(-8:8,0:8),
     *                UPBNDR(40)
      COMMON /TEMRES/ LINCO,NQ2,NINDEX,INDEX(40),ROSTER(150,12)
      DO 20 H=1,4
      DO 10 K=1,6
   10 REF(H,K)=0.
   20 CONTINUE
      DO 30 H=-8,8
      DO 25 K=0,8
   25 EVAL(H,K)=0.
   30 CONTINUE
      DO 36 J=1,40
   36 INDEX(J)=0
      NINDEX=0
C-----------------------------------------------------------------------
      HG=NINT( SQRT(QCALMX/A) )
      KG=NINT( SQRT(QCALMX/B) )
      IF (HG .GT. 8) HG=8
      IF (KG .GT. 8) KG=8
      IF (FMAAS .LT. 0.1) THEN
         FMAAS=0.0
         HMIN= 0
         RECTAN=.TRUE.
         ORDE=2
      ELSE
         HMIN=-HG
         RECTAN= .FALSE.
         ORDE=3
      END IF
      IF (TYP)  WRITE(IOUT,1)NR
C--WRITES HEADING,  THE CALCULATION OF Q-VALUES STARTS HERE.
      ORP1=ORDE+1
      DO 70 H=HMIN,HG
         ISPAT=0
         X=A*FLOAT(H*H)
         Y=FMAAS*FLOAT(H)
         DO 60 K=0,KG
            ISPAT=ISPAT+1
            IF (K .EQ. 0  .AND.  H .LE. 0 ) GO TO 60
            Q=X+B*FLOAT(K*K)+Y*FLOAT(K)
            IF (Q .GT.QCALMX) GO TO 65
            IF (TYP) CALL WRISP(ISPAT, Q,0)
            DO 53 I=1,MAX
               IF (Q .GT. UPBNDR(I) ) GO TO 53
               EVAL(H,K)=-PROB(I)
               GO TO 55
   53       CONTINUE
C           WE HAVE DETERMINED THE PROBABILITY.
C           NOW SEE WHETHER THERE IS A FITTING OBSERVED LINE.
   55       CONTINUE
            DO 59 J=1,MAX
               IF (OBSPT(J) .LT. Q) GO TO 59
               IF (OBSMT(J) .GT. Q) GO TO 60
C           THERE IS A FITTING LINE. USE IT FOR THE REFINEMENT.
               INDEX(J)=1
               EVAL(H,K)=-EVAL(H,K)
               IF (TYP)   CALL WRISP(ISPAT,Q,1)
               HULP(1)=H*H
               HULP(2)=K*K
               HULP(3)=H*K
               HULP(ORP1)=OBS(J)-Q
               DO 58 N2=1,ORP1
                  DO  57 N1=1,ORDE
   57             REF(N1,N2)=REF(N1,N2)+HULP(N1)*HULP(N2)
   58          CONTINUE
               GO TO 60
   59       CONTINUE
C  59       IS THE END OF THE LOOP ON THE SEARCH FOR A FITTING  Q
   60    CONTINUE
C  60    IS THE END OF THE LOOP ON K
   65    IF (TYP) CALL WRISP(ISPAT, Q,2)
   70 CONTINUE
C  END OF LOOP ON H (I,NH)
      IF (TEST) THEN
         L=-8
         IF (RECTAN) L=0
         WRITE(IOUT,6)  ((EVAL(I,J),J=0,8),I=8,L,-1)
      END IF
      DO 72 J=1,NQ2
   72 NINDEX=NINDEX+INDEX(J)
C-----------------------------------------------------------------------
C  COUNTS THE NUMBER OF LINES THAT ARE INDEXED  AMONGST THE FIRST
C  NQ2 LINES.
C  REFINEMENT-CORRECTIONS ON ZONE CONSTANTS WILL BE CALCULATED FROM
C  HERE TO 170
C-----------------------------------------------------------------------
      IF (RECTAN) THEN
         Z=REF(1,1)*REF(2,2)-REF(2,1)*REF(1,2)
         IF (ABS(Z) .LT. 0.1 ) THEN
            IF (TEST) WRITE(IOUT,3) NR
            RETURN
         END IF
         FYN(1)=+(REF(1,3)*REF(2,2)-REF(2,3)*REF(1,2))/Z
         FYN(2)=-(REF(1,1)*REF(2,3)-REF(2,1)*REF(1,3))/Z
         GO TO 140
      END IF
      DO 80 H=1,2
         DO 75 K=1,3
   75    REF(K,H+4)=REF(K,H)
   80 CONTINUE
      DO 90 H=1,4
         K=H+1
         L=H+2
         REF(4,H)=REF(1,H)*(REF(2,K)*REF(3,L)-REF(3,K)*REF(2,L))
     1           -REF(2,H)*(REF(1,K)*REF(3,L)-REF(3,K)*REF(1,L))
     2           +REF(3,H)*(REF(1,K)*REF(2,L)-REF(2,K)*REF(1,L))
   90 CONTINUE
      IF (ABS(REF(4,1)) .LT. 1.0) THEN
         IF (TYP) WRITE(IOUT, 3) NR
         RETURN
      END IF
      DO 100 J=1,3
  100 FYN(J)=REF(4,J+1)/REF(4,1)
      FMAAS=FMAAS+FYN(3)
  140 A=A+FYN(1)
      B=B-FYN(2)
      IF (TYP) WRITE(IOUT,4) NR,A,B,FMAAS
      IF (TEST)WRITE(IOUT,5) NINDEX,NQ2
      RETURN
    1 FORMAT(10H0 ZONE NR ,I2,27H PRINTED OUT FOR INSPECTION /
     *42H   *A*  UP THE PAGE,  *B* ACROSS THE  PAGE  )
C   2 FORMAT(// )
    3 FORMAT(' ZONE ',I3,'  NOT REFINED')
    4 FORMAT(5H ZONE,I3,18H AFTER REFINEMENT , 3F10.2 )
    5 FORMAT(//,  I3,
     * 21H LINES FROM THE FIRST,I3,' ARE INDEXED BY THIS ZONE.')
    6 FORMAT(//,11H ARRAY EVAL / (1H ,9E12.3)  )
      END
      SUBROUTINE LSTET(TYP,A,B,FMAAS, ZERSHF,QCALMX, NR)
C-----------------------------------------------------------------------
C  REFINES THE PARAMETERS (A,B,FMAAS) BY LEAST-SQUARES, PRINTS THE ZONE
C  IF TYP=TRUE  AND FILLS THE ARRAY EVAL FOR THE PROCEDURE  CRITERION.
C  THE ELEMENTS OF  EVAL  REMAIN  ZERO  WHEN Q IS TOO LARGE (Z >QCALMX),
C  THEY BECOME +1 WHEN THE CALCULATED Q-VALUE EXISTS (CORRESPONDS TO
C  AN OBSERVED Q) AND BECOME  -1  IF THE Q-VALUE IS NOT IN THE LIST
C  OF OBSERVED VALUES.VALUES ARE NOW + OR - THE PROBABILITY.
C-----------------------------------------------------------------------
      DIMENSION  REF(4,4),HULP(6),FYN(4),WAR(4),HELP1(4),HELP2(4)
      INTEGER  H,HG,HMIN, ORDE,ORP1,ORP2
      LOGICAL SELF,ENL,TEST,RECTAN,TYP
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /EVALN / NORDER,RECTAN,PROB(40),EVAL(-8:8,0:8),
     *                UPBNDR(40)
      COMMON /TEMRES/ LINCO,NQ2,NINDEX,INDEX(40),ROSTER(150,12)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /THETAS/ ZERTOT,OBSTET(40),SHFTET(40),TETPT(40),TETMT(40)
      DO 20 H=1,4
      FYN(H)=0.
      WAR(H)=0.
      DO 10 K=1,4
   10 REF(H,K)=0.
   20 CONTINUE
      DO 30 H=-8,8
      DO 25 K=0,8
   25 EVAL(H,K)=0.
   30 CONTINUE
      DO 36 J=1,40
   36 INDEX(J)=0
      NINDEX=0
C-----------------------------------------------------------------------
      HG=NINT( SQRT(QCALMX/A) )
      KG=NINT( SQRT(QCALMX/B) )
      IF (HG .GT. 8) HG=8
      IF (KG .GT. 8) KG=8
      IF (FMAAS .LT. 0.1) THEN
         FMAAS=0.0
         HMIN= 0
         RECTAN=.TRUE.
         ORDE=2
      ELSE
         HMIN=-HG
         RECTAN= .FALSE.
         ORDE=3
      END IF
      IF (TYP)  WRITE(IOUT,1)NR
C--WRITES HEADING,  THE CALCULATION OF Q-VALUES STARTS HERE.
      ORP1=ORDE+1
      ORP2=ORDE+2
      DO 70 H=HMIN,HG
         ISPAT=0
         X=A*FLOAT(H*H)
         Y=FMAAS*FLOAT(H)
         DO 60 K=0,KG
            ISPAT=ISPAT+1
            IF (K .EQ. 0  .AND.  H .LE. 0 ) GO TO 60
            Q=X+B*FLOAT(K*K)+Y*FLOAT(K)
            IF (Q .GT.QCALMX) GO TO 65
            IF (TYP) CALL WRISP(ISPAT, Q,0)
            DO 53 I=1,MAX
               IF (Q .GT. UPBNDR(I) ) GO TO 53
               EVAL(H,K)=-PROB(I)
               GO TO 55
   53       CONTINUE
C           WE HAVE DETERMINED THE PROBABILITY.
C           NOW SEE WHETHER THERE IS A FITTING OBSERVED LINE.
   55       Z=TETCAL(Q)
            DO 59 J=1,MAX
               IF (TETPT(J) .LT. Z) GO TO 59
               IF (TETMT(J) .GT. Z) GO TO 60
C           THERE IS A FITTING LINE. USE IT FOR THE REFINEMENT.
               INDEX(J)=1
               EVAL(H,K)=-EVAL(H,K)
               IF (TYP)   CALL WRISP(ISPAT,Q,1)
               C=WAVSQR/SIN(2.*Z)
               HULP(1)=1.
               HULP(2)=H*H*C
               HULP(3)=K*K*C
               HULP(4)=H*K*C
               HULP(ORP2)=OBSTET(J)-Z
               DO 58 N2=1,ORP1
                  WAR(N2)=WAR(N2)+HULP(N2)*HULP(ORP2)
                  DO  57 N1=1,ORP1
   57             REF(N1,N2)=REF(N1,N2)+HULP(N1)*HULP(N2)
   58          CONTINUE
               GO TO 60
   59       CONTINUE
C  59       IS THE END OF THE LOOP ON THE SEARCH FOR A FITTING  Q
   60    CONTINUE
C  60    IS THE END OF THE LOOP ON K
   65    IF (TYP) CALL WRISP(ISPAT, Z,2)
   70 CONTINUE
C  END OF LOOP ON H (I,NH)
      IF (TEST) THEN
         L=-8
         IF (RECTAN) L=0
         WRITE(IOUT,6)  ((EVAL(I,J),J=0,8),I=8,L,-1)
      END IF
      DO 72 J=1,NQ2
   72 NINDEX=NINDEX+INDEX(J)
C-----------------------------------------------------------------------
C  COUNTS THE NUMBER OF LINES THAT ARE INDEXED  AMONGST THE FIRST
C  NQ2 LINES.
C  REFINEMENT-CORRECTIONS ON ZONE CONSTANTS WILL BE CALCULATED FROM
C  HERE TO 170
C-----------------------------------------------------------------------
      CALL ARRAY(2,ORP1,ORP1,4,4,REF,REF)
      CALL MINV(REF,ORP1,DETER,HELP1,HELP2)
      CALL ARRAY(1,ORP1,ORP1,4,4,REF,REF)
      IF (ABS(DETER) .LT. 1.0E-6) THEN
         IF (TYP) WRITE(IOUT, 3) NR
         GO TO 200
      END IF
      DO 170 I=1,ORP1
         DO 160 J=1,ORP1
  160    FYN(I)=FYN(I)+REF(I,J)*WAR(J)
  170 CONTINUE
      ZERSHF=FYN(1)
      A=A+FYN(2)*1.E+4
      B=B+FYN(3)*1.E+4
      ZERO=ZERSHF*TWORAD
      IF (ORDE .EQ. 3) FMAAS=FMAAS+FYN(4)*1.E+4
      IF (TYP) WRITE(IOUT,4) NR,A,B,FMAAS,ZERO
      IF (TEST)WRITE(IOUT,5) NINDEX,NQ2
  200 RETURN
    1 FORMAT(10H  ZONE NR ,I2,27H PRINTED OUT FOR INSPECTION /
     *42H   *A*  UP THE PAGE,  *B* ACROSS THE  PAGE  )
C   2 FORMAT(//)
    3 FORMAT(' ZONE ',I3,'  NOT REFINED')
    4 FORMAT(5H ZONE,I3,18H AFTER REFINEMENT , 3F10.2,
     1 '    ZERO SHIFT=',F8.3,' DEGREES TWOTHETA'  )
    5 FORMAT(//,  I3,
     * 21H LINES FROM THE FIRST,I3,26H ARE INDEXED BY THIS ZONE       )
    6 FORMAT(//,11H ARRAY EVAL / (1H ,9E12.3)  )
      END
      SUBROUTINE MANUAL
C  THIS SUBROUTINE PRINTS AN INSTRUCTION MANUAL HOW TO ARRANGE
C  THE INPUT PARAMETERS.
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      WRITE(IOUT,9950)
      WRITE(IOUT,9952)
      WRITE(IOUT,9954)
      WRITE(IOUT,9956)
      WRITE(IOUT,9957)
      WRITE(IOUT,9958)
      WRITE(IOUT,9960)
      WRITE(IOUT,9962)
      WRITE(IOUT,9964)
      WRITE(IOUT,9966)
      WRITE(IOUT,9968)
      WRITE(IOUT,9970)
      WRITE(IOUT,9972)
      WRITE(IOUT,9974)
      WRITE(IOUT,9976)
      WRITE(IOUT,9978)
      WRITE(IOUT,9980)
      WRITE(IOUT,9982)
      RETURN
 9950 FORMAT( 1H ,10X,29H***  INSTRUCTION  MANUAL  ***, 20X,
     * 20H---  VERSION 15  --- //
     2 35H IN CASE OF PROBLEMS, WRITE OR CALL /
     3 '      J.W.VISSER,  HENRY DUNANTLAAN 81, 2614 GL  DELFT,  ',
     4 'THE NETHERLANDS. PHONE/FAX +31 15 123 593 ' / 40X,2HOR /
     5 '      G.G.JOHNSON JR., MATERIALS RESEARCH LAB., PENN. STATE ',
     6 'UNIVERSITY, UNIVERSITY PARK, PA 16802, 814-865-1637',
     7 /40X,2HOR/
     7 120H     R.SHIRLEY, CHEMICAL PHYSICS DEPT., UNIV. OF SURREY, GUIL
     8DFORD, SURREY GU2 5XH, ENGLAND.   PHONE 0483-71281 X449/427)
 9952 FORMAT(50H THIS PROGRAM TRIES TO FIND THE UNIT CELL FROM THE,
     1       50H POWDER PATTERN.  THE PRINCIPLES ARE DESCRIBED IN /
     2       50H A PAPER BY VISSER IN THE JOURNAL OF APPLIED CRYST,
     3       50HALLOGRAPHY (1969) 2, 89.                          //
     4       50H MOST OF THE CALCULATIONS ARE CARRIED OUT IN TERMS,
     5       50H OF Q-VALUES, THESE ARE (100/D)**2 ,WHERE D IS THE/
     6       50H INTERPLANAR DISTANCE IN ANGSTROMS.  ALL VALUES IN,
     7       50H THE PROGRAM ARE EXPRESSED IN QU (Q-UNITS), UNLESS/
     8       30H INDICATED OTHERWISE.            / )
 9954 FORMAT(50H THE INPUT/OUTPUT OF THE PROGRAM IS ON FILES THAT ,
     A       50HYOU HAVE GIVEN. A COPY OF THE INPUT IS ON THE FILE/
     B       50H ITODOC.LST,  WRITTEN LINE BY LINE. (USEFUL CHECK)/
     C       50H ** A SUMMARY OF THE OUTPUT IS WRITTEN ON THE FILE,
     D       50H THAT YOU NAMED. A MORE COMPLETE OUTPUT IS WRITTEN/
     E       50H ONTO THE FILE ITOUT.LST.  THIS FILE SHOULD BE CON,
     F       50HSULTED IN CASE OF AN UNEXPECTED END.              //)
 9956 FORMAT(50H THE USUAL INPUT OF THIS PROGRAM SHOULD CONSIST OF/
     A       50H 1.A TITLE CARD, CONTAINING UP TO 80 CHARACTERS   /
     B       50H 2.A PARAMETER CARD, WHICH MAY BE COMPLETELY BLANK/
     X       50H 3.ANOTHER PARAMETER CARD. CAN ALSO BE BLANK.      /
     C       50H 4.A NUMBER OF LINES CARDS.                       /
     D       50H   THE OPTIMUM NUMBER OF LINES TO BE ENTERED IS SO,
     *       50HMEWHERE BETWEEN 30 AND 35.                        /
     1       50H   THE ABSOLUTE MINIMUM IS 20. THERE IS NO MAXIMUM,
     2       50H, BUT THE PROGRAM WILL USE NOT MORE THAN 40 LINES./
     3       50H ** NOTE ** IF YOU USE AN INPUT FILE, ITS RECORDS ,
     4       50HSHOULD NOT BE LONGER THAN 80 CHARACTERS.          /
     5       50H NOTE**  IF YOU ACTUALLY USE CARDS,  THEY MAY BE L,
     6       50HEFT BLANK.HOWEVER, IN SOME COMPUTER SYSTEMS ONE   /
     7       50H CANNOT GENERATE AN INPUT FILE WITH COMPLETELY BLA,
     8       50HNK LINES, THEY DISAPPEAR WITHOUT A TRACE. IN THAT /
     9       50H CASE, IT IS BETTER TO ENTER A ZERO IN THE FIRST C,
     A       50HOLUMN OF THE SECOND AND THIRD 'CARD'.              )
 9957 FORMAT(/,20('-----'),/
     3       50H   THE LINES SHOULD BE ENTERED IN ASCENDING ORDER ,
     4       50HOF TWOTHETA ( =DESCENDING ORDER OF D).            /
     5       , 20('-----'), //
     6       50H   THEY CAN BE ENTERED AS 2THETA, Q- OR D- VALUES ,
     7       50H IN THE FORMAT  8F10.5                              )
 9958 FORMAT(50H   YOU MAY LEAVE ANY NUMBER OF POSITIONS ON THE CA,
     G       50HRD BLANK. THIS MEANS THAT YOU CAN ALSO ENTER ONLY /
     I       50H   ONE LINE PER CARD,IN ANY OF THE POSITIONS OF 8F,
     J       50H10.5  MOREOVER, ONLY THE FIRST SIX LINES MUST BE  /
     K       50H   IN THEIR CORRECT ORDER. AFTER DETERMINING WHETH,
     L       50HER THESE ARE IN ASCENDING(2THETA,Q) OR DESCENDING /
     M       50H   (D) ORDER, THE PROGRAM WILL SORT ALL LINES.      )
 9960 FORMAT(50H   IF YOU WANT TO DROP A QUESTIONABLE INPUT LINE, ,
     1       50H CHANGE ONLY ITS SIGN (PUNCH A MINUS).            /
     2       50H   THE VALUE WILL REMAIN READABLE, BOTH ON THE CAR,
     3       50HD AND IN THE TEST OUTPUT.                         /
     4       50H 5.A BLANK CARD (OR A ZERO IN COL. 1 IF YOU WISH  ,
     4       50HTO BE MORE EXPLICIT) TO FINISH THE INPUT OF LINES /
     4       50H   OF ONE PROBLEM.                                )
 9962 FORMAT(50H   REPEAT THE POINTS 1-4 AS MANY TIMES AS PROBLEMS,
     1       50H THEN                                             /
     2       50H 6.A CARD CONTAINING THE WORD -- END -- IN THE FIR,
     3       50HST THREE COLUMNS, TO FINISH THE INPUT.            /  )
 9964 FORMAT(///)
 9966 FORMAT(50H THE PARAMETER CARD CAN CONTAIN THE FOLLOWING PARA,
     1       50HMETERS--                                          //
     2       50H COLUMN  FORMAT  NAME   DEFAULT   MEANING         /
     3       50H   1      A1     MAN      0       PRINTS THESE INS,
     4       50HTRUCTIONS, UNLESS MAN=9                           )
 9968 FORMAT(50H   2      A1     INSTR    0       PRINTS INSTRUCTI,
     1       50HONS FOR SPECIAL FEATURES IF INSTR=1               /
     2       50H   3      A1     INTENS   0       READS INTENSITIE,
     3       50HS BESIDES LINE POSITIONS (8(F7.3,A3)) IF INTENS=1 /
     A       50H   4      I1     NSOLMX   4       NUMBER OF SOLUTI,
     B       50HONS PRINTED OUT EXTENSIVELY.                      /
     4       50H  5- 6    I2     NSYST(1) 0       ORTHORHOMBIC SYS,
     5       50HTEM,  +1=YES, -1=NO, 0=INDIFFERENT.               /
     6       50H  7- 8    I2     NSYST(2) 0       MONOCLINIC   SYS,
     7       50HTEM,  +1=YES, -1=NO, 0=INDIFFERENT.               /
     8       50H  9-10    I2     NSYST(3) 0       TRICLINIC    SYS,
     9       50HTEM,  +1=YES, -1=NO, 0=INDIFFERENT.               )
 9970 FORMAT(50H 11-15   F5.2    TOL2    3.0 (QU) TOLERANCE(RANGE),
     6       50H ON 2-DIMENSIONAL SEARCH.                         /
     7       50H 16-20   F5.2    TOL3    4.5 (QU) TOLERANCE(RANGE),
     8       50H ON 3-DIMENSIONAL SEARCH.                         /
     9       50H 21-30   F10.5   WAVEL   1.5406(A)WAVELENGTH      /
     O       50H 31-32    I2     LINCO    0       IF LINCO .GT. 0,,
     O       51H ENTER LINE COMBINATIONS OR ZONES(4F10.2), END WITH/
     A 35X,  55H A BLANK CARD,OR A CARD WITH A ZERO IN THE FIRST COLUMN/
     B       50H    33    I1     LZERCK   0       GIVES A CHECK ON,
     C       50H ZERO-ERRORS WHEN LZERCK > 0                      /
     D       50H    34    I1     K (ENL)  0       GIVES OUTPUT OF ,
     E       50HINTERMEDIATE RESULTS, IF K .GE. 1                   )
 9972 FORMAT(50H 35-36    I2     NQ1      3       NQ1 AND NQ2 DETE,
     1       50HRMINE THE NUMBERS OF LINES TO BE USED IN          /
     2       50H 37-38    I2     NQ2      6           COMBINATIONS,
     3       50H FOR FINDING ZONES.                               /
     4       50H 39-40    I2     NZ1      6       NZ1 AND NZ2 DO T,
     5       50HHE SAME FOR FINDING LATTICES FROM ZONES           /
     6       50H 41-42    I2     NZ2      6                       /
     7       50H 43-44    I2     NR       0       REFINEMENT AND E,
     8       52HVALUATION ONLY IF NR .GT. 0. TRIAL LATTICES REQUIRED/
     9       50H 45-46    I2     INDAT    5       NUMBER OF THE UN,
     O       50HIT ON WHICH TO READ THE LINE POSITIONS            )
 9974 FORMAT(50H 47-48    I2     LIST     1       PRINTS A LIST OF,
     *       50H ALL CALC AND OBS LINES FOR *LIST* LATTICES       /
     A       50H 49-50    I2     J(TEST)  0       TEST OUTPUT IS  ,
     B       50HPRINTED WHEN  J.GE.1                              /
     C       50H 51-60   F10.5   WMOL    0.0      MOLECULAR WEIGHT/
     D       50H 61-70   F10.5   DOBS    0.0      OBSERVED DENSITY/
     E       50H 71-78    F8.4   TOLG    6.0      TOLERANCE ON THE,
     F       50H MATCH BETWEEN CALCULATED AND OBSERVED TWO THETAS./
     G       51H 79-80    I2     NTST     0       NUMBER,INDICATING,
     H       53H WHERE IN THE MAIN PROGRAM,  TEST OUTPUT SHOULD START)
 9976 FORMAT(50H ON SECOND CARD                                   /
     1       50H  1-10   F10.4   ZERCOR  0.0      ZERO CORRECTION ,
     2       50H(DEGREES TWOTHETA), TO BE APPLIED TO ALL LINES    /
     3       50H 11-20   F10.1   PRNTMR  4.0      THE MINIMUM FIGU,
     4       50HRE OF MERIT FOR A LATTICE TO BE PRINTED           )
 9978 FORMAT(50H 21-30   F10.0   PRNTLN  14.      THE MINIMUM NUMB,
     1       50HER OF INDEXED LINES FOR A LATTICE TO BE PRINTED.  )
 9980 FORMAT(50H 31-40   F10.1   ZERREF   0.0     IF ZERREF > 0 , ,
     1       50HTHE ZERO-POINT ERROR WILL NOT BE REFINED.         )
 9982 FORMAT(50H 41-50   F10.1   FMAX     32.0    IF FMAX < 1.0 , ,
     1       52HTHE NUMBER OF LINES USED IS SET AT 32, ELSE AT FMAX.)
      END
