      program itopar
C
C  This program can produce a short file with the input parameters
C     for the ITO (cell-finding) program                            or
C
C  produces input for printing the manual and/or
C     the special instructions                                      or
C
C  modifies the standard default parameters  for the ito-pgm        or
C
C  produces the standard parameter input file with all defaults
C     with their values.
C                   -----------------------
C
C   The output file is named:  Xindex.inp
C
C
C  Version 1,  march 1989.
C  Version 2,  november 1989
C  Version 3,  januari  1990
C  Version 4,  december 1993, small additions  May 1994.
C
C
C
C
      character filnam*10,title*80,parm1*80,parm2*80,buf*80,
     * answ*1,datin(100)*80,tolg*8,zercor*10,prntmr*10,prntln*10,
     * wavel*10,parama*40,paramb*40,paramc*40,paramd*40,
     * ntst*2,nmax*10
      data parama/'9004 0 0 0 3.0  4.5    1.54060 000 3 6 6'/,
     *     paramb/' 6 0 5 1 0   0.0       0.0     6.0     0'/,
     *     paramc/'       0.0       4.0      14.0   0.0    '/,
     *     paramd/'  32.0                                  '/
      inp=5
      iout=6
C  Ask whether to make new file or change existing one.
      write(iout,1)
      read(inp,'(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
C  existing file
         write(iout,2)
         read(inp,'(A10)') filnam
         go to 500
      else
          open(unit=indat,file='xindex.inp',status='new')
   90     write(iout,3)
          read(inp,'(i1)' ) k
          go to (110,120,130,140,150,200),k
C In case the answer is wrong (not 1...6) you are redirected.
          write(iout,51)
          go to 90
      end if
  120 write(iout,16)
C  starting with non-standard parameters is not recommended,
C  and made 'impossible' in this first run.
  110 write(iout,'('' Give the name of the problem'' /)' )
      read(inp,'(A80)' ) title
      write(indat, '(A80)' ) title
      write(indat, '(''9'',79X)' )
      write(indat, '(''0.0'',77X)' )
      go to 220
  130 title=' print manual'
      write(indat, '(A80)' ) title
      write(indat, '(''1'',79X)' )
      go to 160
  140 title=' print instructions '
      write(indat, '(A80)' ) title
      write(indat, '(''91'',78X)' )
      go to 160
  150 title=' print manual and instructions '
      write(indat, '(A80)' ) title
      write(indat, '(''11'', 78X)' )
  160 write(indat, '(''0.0'',77X)' )
      write(indat, '(''END'',77x)' )
      close(unit=indat)
      write(iout,6)
      stop
  200 write(iout,'('' Give the name of the problem'' /)' )
      read(inp,'(A80)' ) title
      write(indat, '(A80)' ) title
      parm1( 1:40)=parama
      parm1(41:80)=paramb
      parm2( 1:40)=paramc
      parm2(41:80)=paramd
      write(indat, '(A80)' ) parm1
      write(indat, '(A80)' ) parm2
  220 close(unit=indat)
      write(iout, 4)
      write(iout, 5)
      write (iout,'(/'' Give ENTER  ( CR )  to continue''/)')
      pause
      write(iout,25)
      write(iout,30)
      stop
C  --------------------------------------------
C
C  Change existing file from here.
C
C  --------------------------------------------
  500 open (unit=indat, file=filnam,status='old')
      read(indat, '(A80)' ) title
      read(indat, '(A80)' ) parm1
      read(indat, '(A80)' ) parm2
      imax=0
      do 510 i=1,100
         read(indat, '(A80)',end=520 ) datin(i)
         imax=i
  510 continue
  520 if (imax .eq. 0)  then
       write(iout, '('' This file does not contain diffraction data''/,
     * '' If you do not have a real input file, change a copy ''/,
     * '' repeat  copy   of demo.dat'' / )' )
       stop
      end if
  530 write(iout,7)
C Ask for: Line combinations OR  zones OR  lattices  OR  something else.
      read(inp, '(I1)' ) k
      go to (610,620,630,650),k
C  redirect if wrong answer given.
      write(iout,51)
      go to 530
  610 write(iout,8)
C  read line combinations; first line ,   second line.
      read(inp, '(F10.2)' ) dat1
      write(iout,9)
      read(inp, '(F10.2)' ) dat2
      write(buf, '(2F10.2,60X)' ) dat1,dat2
      datin(imax)=buf
      imax=imax+1
      write(iout, '('' More combinations?  Y/N '')' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         go to 610
      else
         datin(imax)='0.0        '
         imax=imax+1
         datin(imax)='END     '
         parm1(32:32)='1'
         go to 650
      end if
  620 write(iout, 10)
C  read zones
      read(inp,*) Q1,Q2,F,G
      if (F .lt. 0.08) F=0.08
      write(buf, '(4F10.2,40X)' ) Q1,Q2,F,G
      datin(imax)=buf
      imax=imax+1
      write(iout, '('' More zones?  Y/N ''/)' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         go to 620
      else
         datin(imax)='0.0        '
         imax=imax+1
         datin(imax)='END     '
         parm1(32:32)='1'
         go to 650
      end if
  630 write(iout,11)
C  read complete lattices
      read(inp, *) A,B,C,D,E,F
      write(buf, '(6F10.2,20X)' ) A,B,C,D,E,F
      datin(imax)=buf
      imax=imax+1
      write(iout, '('' More lattices?  Y/N '')' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         go to 630
      else
         datin(imax)='0.0        '
         imax=imax+1
         datin(imax)='END     '
         parm1(44:44)='1'
      end if
  650 write(iout,14)
C
C  From here,  the  answer X  means  EXIT  (close files and stop)
C
  655 write(iout,12)
      write(iout, '('' the tolerance, tolg?  Y/N ''/)' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
      write(iout, '('' Give the tolerance in hundredth of a degree''/)')
         read(inp, '(A8)' ) tolg
         parm1(71:78)=tolg
      else if (answ .eq. 'N' .or. answ .eq. 'n') then
         go to 660
      else if (answ .eq. 'X' .or. answ .eq. 'x' ) then
         go to 720
      else
         write(iout, 51 )
         go to 655
      end if
  660 write(iout,12)
      write(iout, '('' the wavelength, 1.54060 ?  Y/N''/)' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         write(iout, '('' give the new wavelength''/)' )
         read(inp, '(A10)' ) wavel
         parm1(21:30)=wavel
      else if (answ .eq. 'N' .or. answ .eq. 'n') then
         go to 670
      else if (answ .eq. 'X' .or. answ .eq. 'x' ) then
         go to 720
      else
         write(iout, 51)
         go to 660
      end if
  670 write(iout,12)
      write(iout, '('' the zero correction (specim. displ.)?'' ,
     * '' Y/N''/)' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         write(iout, '('' Give the new zero correction''/)' )
         read(inp, '(A10)' ) zercor
         parm2( 1:10)=zercor
      else if (answ .eq. 'N' .or. answ .eq. 'n') then
         go to 675
      else if (answ .eq. 'X' .or. answ .eq. 'x' ) then
         go to 720
      else
         write(iout, 51)
         go to 670
      end if
 675  write(iout,12)
      write(iout, '('' the number of lines to be used?  Y/N''/)' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         write(iout, '('' Give the new number as a real (33.0?) ''/)' )
         read(inp, '(A10)' ) nmax
         parm2(41:50)=nmax
      else if (answ .eq. 'N' .or. answ .eq. 'n') then
         go to 680
      else if (answ .eq. 'X' .or. answ .eq. 'x' ) then
         go to 720
      else
         write(iout, 51)
         go to 675
      end if
 680  write(iout,12)
      write(iout, '('' the merit for printing, prntmr?  Y/N''/)' )
      write(iout,18)
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         write(iout, '('' give the new prntmr''/)' )
         read(inp, '(A10)' ) prntmr
         parm2(11:20)=prntmr
      else if (answ .eq. 'N' .or. answ .eq. 'n') then
         go to 690
      else if (answ .eq. 'X' .or. answ .eq. 'x' ) then
         go to 720
      else
         write(iout, 51)
         go to 680
      end if
  690 write(iout,12)
      write(iout, '('' the minimum number of lines?  Y/N''/)' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         write(iout, '('' give the new prntln''/)' )
         read(inp, '(A10)' ) prntln
         parm2(21:30)=prntln
      else if (answ .eq. 'N' .or. answ .eq. 'n') then
         go to 695
      else if (answ .eq. 'X' .or. answ .eq. 'x' ) then
         go to 720
      else
         write(iout, 51 )
         go to 690
      end if
  695 write(iout,12)
      write(iout, '('' the NTEST parameter ?'' ,
     * '' Y/N''/)' )
      read(inp, '(A1)' ) answ
      if (answ .eq. 'Y' .or. answ .eq. 'y') then
         write(iout, '('' Give the new NTEST parameter''/)' )
         read(inp, '(A2)' ) ntst
         parm1(78:80)=ntst
      else if (answ .eq. 'N' .or. answ .eq. 'n') then
         go to 700
      else if (answ .eq. 'X' .or. answ .eq. 'x' ) then
         go to 720
      else
         write(iout, 51)
         go to 700
      end if
  700 write(iout,13)
C  Says: If you want to change anything else, study the manual+instructions.
      pause ' Read the above, then press ENTER  '
  720 rewind indat
      write(indat,'(A80)' ) title
      write(indat,'(A80)' ) parm1
      write(indat,'(A80)' ) parm2
      write(iout, '(1X,A80)' ) title
      write(iout, '(1X,A80)' ) parm1
      write(iout, '(1X,A80)' ) parm2
      do 750 i=1,imax
         write(indat, '(A80)') datin(i)
         write(iout , '(1X,A80)') datin(i)
  750 continue
      close(unit=indat)
      stop
    1 FORMAT(' Do you want to change an existing input file? Y/N'/)
    2 FORMAT(' Write the name of the file.'/)
    3 FORMAT(' Do you want to:' /,
     * ' 1. Create a standard input file,                   or'/,
     * ' 2. Create a non-standard input file,               or'/,
     * ' 3. Print the manual for the parameters,            or'/,
     * ' 4. Print the instructions for special parameters,  or'/,
     * ' 5. Print both the above.                           or'/,
     * ' 6. Create a standard input file with default '/,
     * '    values spelled out.' //,
     * '  Answer 1,2,3,4,5 or 6 '/ )
    4 FORMAT(' The standard input file for the program consists of:'/
     * ' 1. One record with the name of the problem  (A80) '/,
     * ' 2. One record that begins with  9 and some blanks (i1,3x)'/,
     * ' 3. One record that begins with  0.0 "   "     "    '/,
     * ' 4. Umpteen records with the data  (F10.4, max. 8F10.4 per ',
     *     ' record'/' in order of increasing 2theta (lowest 2theta ',
     *     ' or the highest d  first)'/,
     * ' 5. One record that begins with  0.0  '/,
     * ' 6. One record that begins with END (A3), in case you want to '/
     * '    present only one problem, else restart at 1. '/
     * '    NOTE:  END  in  CAPITALS !!! ')
    5 FORMAT(//' You now have the file  xindex.inp   with records 1,2',
     * ' and 3'/ ' Add steps 4-6 , rename if you want to, ',
     * ' and copy onto  itoinp.dat '/' which is the standard input ',
     * ' file for the program.'/' Run the program.'/,
     * ' The output file (132 character/line) is   itout.lst '/,
     * ' another file will be written onto the screen.' //)
    6 FORMAT(//' You now have the input file   xindex.inp '/,
     * ' copy this file onto  itoinp.dat  which is the standard input'/,
     * ' file of the program and run the program' )
    7 FORMAT(' Do you want to:' /,
     * ' 1. Enter line-combinations (Q-values !!), or'/,
     * ' 2. Enter zones (Q !!),  or'/,
     * ' 3. Enter complete lattices,   or'/,
     * ' 4. Change something else'//,
     * '    Answer 1,2,3 or 4.'/)
    8 FORMAT(' Enter the first  line of the line combination'/)
    9 FORMAT(' Enter the second line of the line combination'/)
   10 FORMAT(' Enter a zone (at least 3 Q-values + a quality figure).'/
     * ' If you give zero as quality figure, the zone will be '/,
     * ' evaluated by the program. If you want to make sure that '/,
     * ' the program will use the zone, give it a high quality '/,
     * ' yourself by entering a fourth value like 99999.'/)
   11 FORMAT(' Enter a lattice; either 6 Q-values or 6 direct values.'/)
   12 FORMAT(' Do you want to change ')
   13 FORMAT(' If you want to change anything else, you should study'/,
     * ' the manual and the instructions carefully and edit the '/,
     * ' input file yourself.'/,
     * ' The number of possible changes is too big to ask for ',
     * ' them all.'/)
   14 FORMAT(//' Whenever you answer X to a question Y/N,'/,
     * ' THE PROGRAM WILL EXIT.   (close files and stop) '// )
   16 FORMAT(// ' Starting with a non-standard set of parameters is',
     * ' NOT'/, ' repeat NOT  recommended.'/,
     * ' This run of the program will give you a standard set of ',
     * ' parameters.'/ ' Please try and run the program first with '/,
     * ' these parameters.'/,
     * ' If you really must start with other parameters, you may run'/,
     * ' this program once more and change the standard set.'//)
   18 FORMAT(' NOTE:  The figure of merit, above which a lattice '/,
     * ' merits printing, is set at the lowest imaginable level ',
     * ' (4.0).'/' There is no sense in settting it any lower. ' / )
   25 FORMAT(
     * ' To add the diffraction data (steps 4-6) you can either '/,
     * '    use your favorite  editing program to add data by hand, or'/
     * '    use COPY xindex.inp + data.dat itoinp.dat, when  data.dat'/,
     * '    contains the diffraction data in a suitable format (F10.4)'/
     * ' Itoinp.dat is a possible input file for the ITO program.'//)
   30 FORMAT(/ ' You have now created the file xindex.inp.  '/
     * ' It is probably wise to give your file a more meaningful name'/
     * ' With the DOS-command REN (from rename) you can give your file'/
     * ' a new, more suitable, name. The ITO-program accepts all names'/
     * ' as names for the input file.' )
   51 FORMAT(' Wrong answer,   try again.')
      END
