      PROGRAM GSAJM
C
C     Program to apply gaussian filter to X7a data.
C     
C     NPTS - NUMBER OF POINTS IN THE SPECTRUM
C     A - INPUT SPECTRUM WITH "ESD"S
C     B - OUTPUT SPECTRUM WITH "BESD"S
C     NPT - NUMBER OF DATA POINTS IN THE FULL WIDTH HALF MAXIMUM
C     INDX - WHAT IS TO BE PERFORMED:
C       1 - PERFORM THE SMOOTHING FUNCTION
C       2 - PERFORM THE DERIVATIVE FUNCTION
C       3 - PERFORM THE SECOND DERIVATIVE FUNCTION
C       4 - PERFORM A PEAK SEARCH
C     SMOOTHING USES A NORMALIZED GAUSSIAN WHOSE INTEGRATED INTENSITY
C     IS 1.0.  DERIVATIVE FILTERS ARE NOT NORMALIZED BUT ARE FORCED
C     TO HAVE INTEGRATED INTENSITIES OF 0.0.
 
      INTEGER IN,OUT,LI,LO
      COMMON/IO/IN,OUT,LI,LO
      INTEGER INDX,NPTS
      REAL TMIN,TMAX,DELT,FWHM,DR2L,SESD
      EXTERNAL MALLOC

!      REAL*4 X(80000),A(80000),ESD(80000),B(80000),BESD(80000)
      INTEGER*4 p_X, p_A, p_ESD, p_B, p_BESD
!      REAL*4 SMO(80000),SMOESD(80000),D1(80000),D2(80000),BACKGRND(80000)
      INTEGER*4 p_SMO, p_SMOESD, p_D1, p_D2, p_BACKGRND
!      REAL*4 TEMP(400016)
      INTEGER*4 p_TEMP
!      REAL XA(50000),YA(50000),DELY(50000),AX(50002),
!     $     BX(50002),CX(50002),DX(50002)
      PARAMETER (IPKS = 50000)
      INTEGER*4 p_XA, p_YA, p_DELY, p_AX, p_BX, p_CX, p_DX

      IN=5
      OUT=2
      LI=5
      LO=6
C
C     THE FWHM OF A GAUSSIAN CURVE IS 2.0*1.18*SIGMA.  THE FACTOR
C     OF 2.0 COMES ABOUT BECAUSE SIGMA IS MEASURED FROM THE CENTER
C     OF THE PEAK TO ITS EDGE.  THE 1.18 ARISES BECAUSE THAT'S THE
C     WIDTH WHERE THE GAUSSIAN REACHES HALF-WAY TO ITS HEIGHT:
C     1.18 = SQRT [2*(LN 2)]
 

C OPEN .INPUT FILE
      READ (IN,*) INDX,NPTS,TMIN,TMAX,DELT,FWHM,DR2L,SESD
 
      IERR = MALLOC(p_X, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_A, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_ESD, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_B, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_BESD, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_SMO, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_SMOESD, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_D1, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_D2, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_BACKGRND, 4*NPTS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_TEMP, 5*4*NPTS+16)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_XA, 4*IPKS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_YA, 4*IPKS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_DELY, 4*IPKS)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_AX, 4*IPKS+2)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_BX, 4*IPKS+2)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_CX, 4*IPKS+2)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'
      IERR = MALLOC(p_DX, 4*IPKS+2)
      IF (IERR .NE. 0) STOP 'Cannot allocate memory'

      CALL GS(INDX,NPTS,TMIN,TMAX,DELT,FWHM,DR2L,SESD,
     1     %val(p_X), %val(p_A), %val(p_ESD), %val(p_B), %val(p_BESD), 
     2     %val(p_SMO), %val(p_SMOESD), %val(p_D1), %val(p_D2),
     3     %val(p_BACKGRND), %val(p_TEMP),
     4     %val(p_XA), %val(p_YA), %val(p_DELY), 
     5     %val(p_AX), %val(p_BX), %val(p_CX), %val(p_DX))

      END

      SUBROUTINE GS(INDX,NPTS,TMIN,TMAX,DELT,FWHM,DR2L,SESD,
     1     X, A, ESD, B, BESD, SMO, SMOESD, D1, D2, BACKGRND, TEMP,
     2     XA, YA, DELY, AX, BX, CX, DX)

      INTEGER INDX,NPTS
      REAL TMIN,TMAX,DELT,FWHM,DR2L,SESD

      INTEGER IN,OUT,LI,LO
      COMMON/IO/IN,OUT,LI,LO
      REAL*4 X(*),A(*),ESD(*),B(*),BESD(*)
      REAL*4 SMO(*),SMOESD(*)
      REAL*4 D1(*),D2(*)
      REAL*4 BACKGRND(*)
      REAL*4 TEMP(*)
      REAL XA(*),YA(*),DELY(*),AX(*),BX(*),CX(*),DX(*)
      INTEGER NSEQ(1000),ITT(1000)
      DIMENSION TTMAX(1000),WIDTH(1000),PKAREA(1000),D2AREA(1000)
      DIMENSION WTTT(1000)
      DIMENSION AMAX(1000)
      REAL*4 FILT(0:49)
      DATA PI/3.1417/
 
C
C     THE FWHM OF A GAUSSIAN CURVE IS 2.0*1.18*SIGMA.  THE FACTOR
C     OF 2.0 COMES ABOUT BECAUSE SIGMA IS MEASURED FROM THE CENTER
C     OF THE PEAK TO ITS EDGE.  THE 1.18 ARISES BECAUSE THAT'S THE
C     WIDTH WHERE THE GAUSSIAN REACHES HALF-WAY TO ITS HEIGHT:
C     1.18 = SQRT [2*(LN 2)]
 

C OPEN .INPUT FILE
!        OPEN(UNIT=IN,FILE='gauss.inp',STATUS='OLD',ERR=999)
!        GO TO 3
!999     WRITE(LO,*)'ERROR OPENING .ASCII FILE = ',FILEIN
!1000    CLOSE(UNIT=IN)
!        STOP
 
  
      READ (IN,*) (X(I),I=1,NPTS)
      READ (IN,*) (A(I),I=1,NPTS)
      READ (IN,*) (ESD(I),I=1,NPTS)
      
C are the intensity numbers too large?
      YMAX = 0.
      DO I=1,NPTS
         IF (A(I) .GT. YMAX) YMAX = A(I)
      ENDDO
      SCALE = 1
      IF (YMAX .GT. 1.E5) THEN
         I = NINT(LOG10(YMAX)) - 4
         SCALE = 10**I
         DO I=1,NPTS
            A(I) = A(I) / SCALE
            ESD(I) = ESD(I) / SCALE
      ENDDO
      ENDIF

      WRITE(LO,*)'READ INDEX AS = ', INDX
      IF (INDX.LT.1.OR.INDX.GT.4) INDX=1
      NPT=NINT(FWHM/DELT)
      
C     OPEN OUTPUT FILE
 
      WRITE (LO,976) NPT
 976  FORMAT (' NPT = ', I5)
      
C     SET UP LIMITS
      
      IFILT=2*NPT+1
      IF (IFILT.GT.99) IFILT=99
      IF (IFILT.LT.3) IFILT=3
      IFILT=IFILT/2
      MIN=1+IFILT
      MAX=NPTS-IFILT
      
      
C     SET UP FILTER
      SIGMA=FLOAT(NPT)/(2.0*1.18)
      CONST=SIGMA*SIGMA
      CONST1=2.0*CONST
      CONST2=1.0/(SQRT(2.0*PI)*SIGMA)
      CONST3=CONST2*(1.0/CONST)
      WRITE (LO,567) NPT,SIGMA,CONST1,CONST2
 567  FORMAT (' NPT,SIGMA,C1,C2 = ', I5,3F10.4)
 
      DO 199 JINDX=1,3
 
         IF (JINDX.EQ.1) THEN
            FILT(0)=CONST2
            DO 12 I=1,IFILT
               EXPON=FLOAT(I*I)/CONST1
               FILT(I)=CONST2*EXP(-EXPON)
 12         CONTINUE
            GO TO 40
         ENDIF
         
         IF (JINDX.EQ.2) THEN
            FILT(0)=0.0
            DO 22 I=1,IFILT
               EXPON=FLOAT(I*I)/CONST1
               FILT(I)=CONST3*FLOAT(I)*EXP(-EXPON)
 22         CONTINUE
            GO TO 40
         ENDIF
                 
         IF (JINDX.EQ.3) THEN
            FILT(0)=0.0
            DO 32 I=1,IFILT
               EXPON=FLOAT(I*I)/CONST1
               WRITE (LO,654) I,CONST1,EXPON
 654           FORMAT (' I,CONST1,EXPON = ', I5,2F10.5)
               FILT(I)=CONST3*((2.0*EXPON)-1.0)*EXP(-EXPON)
               FILT(0)=FILT(0)-2.0*FILT(I) ! TO MAKE SURE SUM IS ZERO
 32         CONTINUE
         ENDIF
 
 40      WRITE(LO,42) IFILT,(FILT(I),I=0,IFILT)
 42      FORMAT (I5,10(/5F10.6))
 
 
C     TAKE CARE OF ENDPOINTS FIRST
           
         DO J=1,(MIN-1)
            IF (JINDX.EQ.1) THEN
               B(J)=A(J)
            ELSE
               B(J)=0.0
            ENDIF
C     BESD(J)=ESD(J)
         ENDDO
         DO J=(MAX+1),NPTS
            IF (JINDX.EQ.1) THEN
               B(J)=A(J)
            ELSE
               B(J)=0.0
            ENDIF
C     BESD(J)=ESD(J)
         ENDDO
         
         
C     NOW REST OF POINTS
         
 
         IF (JINDX.EQ.1.OR.JINDX.EQ.3) THEN
 70         DO 74 I=MIN,MAX
               SUM=FILT(0)*A(I)
               SUMESD=(FILT(0)*FILT(0)*ESD(I)*ESD(I))
               DO 72 J=1,IFILT
                  SUM=SUM+(FILT(J)*(A(I-J)+A(I+J)))
                  SUMESD=SUMESD+(FILT(J)*FILT(J))*
     1                   (ESD(I-J)*ESD(I-J)+ESD(I+J)*ESD(I+J))
 72            CONTINUE
               B(I)=SUM
               BESD(I)=SQRT(SUMESD)
 74         CONTINUE
            GO TO 90
         ENDIF
         
         IF (JINDX.EQ.2) THEN
 80         DO 84 I=MIN,MAX
               SUM=FILT(0)*A(I)
               SUMESD=(FILT(0)*FILT(0)*ESD(I)*ESD(I))
               DO 82 J=1,IFILT
                  SUM=SUM+(FILT(J)*(A(I+J)-A(I-J)))
                  SUMESD=SUMESD+(FILT(J)*FILT(J))*
     1                   (ESD(I-J)*ESD(I-J)+ESD(I+J)*ESD(I+J))
 82            CONTINUE
               B(I)=SUM
               BESD(I)=SQRT(SUMESD)
 84         CONTINUE
         ENDIF
         
 90      IF (JINDX.EQ.1) THEN
            DO I=1,NPTS
               SMO(I)=B(I)
               SMOESD(I)=BESD(I)
            ENDDO
         ENDIF
         
         IF (JINDX.EQ.2) THEN
            DO I=1,NPTS
               D1(I)=B(I)
            ENDDO
         ENDIF
 
         IF (JINDX.EQ.3) THEN
            DO I=1,NPTS
               D2(I)=B(I)
            ENDDO
         ENDIF
           
C     COULD DO CYCLING HERE
C     DO CYCLING ACCORDING TO HOWARD C. HAYDEN  -- COMPUTERS IN PHYSICS,
C     PREMIER ISSUE NOV/DEC (1987) 74-75.


         IF(JINDX.EQ.1) THEN
            OPEN(UNIT=OUT,FILE='gauss.x',STATUS='UNKNOWN')
            WRITE (OUT,*) 'set newx {'
            DO I=1,NPTS
               WRITE (OUT,*) X(I)
            ENDDO
            WRITE (OUT,*) '}'
         ENDIF
         IF(JINDX.EQ.1) OPEN(UNIT=OUT,FILE='gauss.smo',STATUS='UNKNOWN')
         IF(JINDX.EQ.2) OPEN(UNIT=OUT,FILE='gauss.1st',STATUS='UNKNOWN')
         IF(JINDX.EQ.3) OPEN(UNIT=OUT,FILE='gauss.2nd',STATUS='UNKNOWN')
         WRITE (OUT,*) 'set newy {'
         DO I=1,NPTS
            WRITE (OUT,*) B(I)*SCALE
         ENDDO
         WRITE (OUT,*) '}'
         WRITE (OUT,*) 'set newesd {'
         DO I=1,NPTS
            WRITE (OUT,*) BESD(I)*SCALE
         ENDDO
         WRITE (OUT,*) '}'
         CLOSE (UNIT=OUT)
         
!           OPEN (UNIT=OUT,FILE='gauss.o',STATUS='UNKNOWN')
!           DO I=1,NPTS
!              WRITE (OUT,*) X(I),A(I),ESD(I),B(I),BESD(I)
!           ENDDO
!           CLOSE (UNIT=OUT)
           
 
 199  CONTINUE
      WRITE(LO,*)'STOP INDEX AS = ', INDX
      IF (INDX.LE.3) STOP
 
C**************************************************************************************
 
C     IF INDX=4, THEN ASSUME THAT A PEAK SEARCH IS NOW DESIRED
C     AT THIS POINT THE B ARRAY IS EQUIVALENT TO THE D2 ARRAY
 
 
C        WRITE(LO,204)
C204     FORMAT(1H$,' CENTROID TYPE FIT-0,3,5,ETC  (D: NO FIT)  > ')
C        READ(LI,205) IPF
C205     FORMAT(I5)
C        NUM=1 ! SET SIG NUMBER=1 IE 2PT CHANGE IN 2ND DIFF
 
C     BEGINING OF LOOP THRU SECOND DERIVATIVE
 
      WRITE (LO,301)
 301  FORMAT (' TWO-THETA   WIDTH   PKAREA   PKHEIGHT   BACKGRND')
 
C     REPLACE POSITIVE VALUES IN ARRAY WITH 0.0 AND INVERT SIGN
C     SO 2ND PEAKS ARE POSITIVE.  BSUM IS THE AVERAGE VALUE OF
C     THE 2ND DERIVATIVE OVER THE POINTS THAT STILL HAVE + VALUES.
        
      BSUM=0.0
      BESDSUM=0.0
      NP=0
      DO 302 I=1,NPTS
         IF (B(I).GE.0.0) THEN
            B(I)=0.0
         ELSE
            B(I)=-B(I)
            BSUM=BSUM+B(I)
            BESDSUM=BESDSUM+BESD(I)
            NP=NP+1       
         ENDIF
 302  CONTINUE

c      DO 303 I=1,NPTS
c         B(I)=-B(I)
c         BSUM=BSUM+B(I)
c         BESDSUM=BESDSUM+BESD(I)
c 303  CONTINUE

      BSUM=BSUM/FLOAT(NP)
      BESDSUM=BESDSUM/FLOAT(NP)
 
C     FIND MAXIMUM IN DERVIATIVE CURVE -- MUST BE A PEAK?
 
      NPKS=1
 
 305  BMAX=0.0
      DO 306 I=1,NPTS
         IF (B(I).GT.BMAX) THEN
            BMAX=B(I)
            AMAX(NPKS)=A(I)
            ISAVE=I
            TTMAX(NPKS)=X(I)
         ENDIF
 306  CONTINUE
 
C     OBVIOUSLY IF BMAX IS NOT MUCH GREATER THAN THE AVERAGE BESDSUM,
C     THEN IT'S TIME TO QUIT -- ALTHOUGH LOCAL BESD MIGHT VARY A BIT
 
      WRITE (LO,765) NP,BMAX,BSUM,BESDSUM
 765  FORMAT (' NP,BMAX,BSUM,BESDSUM = ',I6,3F15.5)
        
      IF (BMAX.LT.(DR2L*BESDSUM)) GO TO 501
        
C     NOW CLIMB DOWN THE SIDES OF THE PEAK TO THE POINT IT HITS 0.0 OR UNTIL
C     THE DIRECTION REVERSES (OVERLAPPED PEAKS)
      
      DO 308 J=(ISAVE-1),1,-1
         IF (B(J).GT.B(J+1).OR.B(J).EQ.0.0) GO TO 310
 308  CONTINUE
 310  JMIN=J+1
        
      DO 315 J=(ISAVE+1),NPTS,1
         IF (B(J).GT.B(J-1).OR.B(J).EQ.0.0) GO TO 320
 315  CONTINUE
 320  JMAX=J-1
 
      JP=JMAX-JMIN+1
 
      IF (JP.LE.2) GO TO 330    !NOISE
 
      PKAREA(NPKS)=0.0
      D2AREA(NPKS)=0.0
      WPEAK=0.0
      WIDTH(NPKS)=1.18*DELT*JP
      DO J=JMIN,JMAX
         PKAREA(NPKS)=PKAREA(NPKS)+A(J)
         D2AREA(NPKS)=D2AREA(NPKS)+B(J)
         WPEAK=WPEAK+X(J)*A(J)
      ENDDO
      WTTT(NPKS)=WPEAK/PKAREA(NPKS)
      PKAREA(NPKS)=PKAREA(NPKS)/JP !NORMALIZED THE AREA TO ONE DATA POINT
      
C     GET SOME BKG POINTS IN THE VICINITY  -- APPROXIMATE BKG
      JCOUNT=0
      SUMBKG=0.0
      DO 321 J=(JMIN-1),1,-1
         IF (B(J).EQ.0.0) GO TO 321
         SUMBKG=SUMBKG+A(J)
         JCOUNT=JCOUNT+1
         IF (JCOUNT.EQ.10) GO TO 322
 321  CONTINUE
 
 322  DO 323 J=(JMAX+1),NPTS,1
         IF (B(J).EQ.0.0) GO TO 323
         SUMBKG=SUMBKG+A(J)
         JCOUNT=JCOUNT+1
         IF (JCOUNT.EQ.20) GO TO 324
 323  CONTINUE
 324  AVERBKG=SUMBKG/FLOAT(JCOUNT)
      
      ANET=AMAX(NPKS)-AVERBKG
 
 
      IF (ANET.LT.(SESD*ESD(ISAVE))) GO TO 330 !PEAK HEIGHT TOO LOW
C     THIS COULD BE ANOTHER GOOD PLACE TO BAIL OUT OF THE PEAK SEARCH.
        
      NPKS=NPKS+1
        
C     CLEAR THIS PEAK OUT OF B ARRAY
        
 330  DO J=JMIN,JMAX
         B(J)=0.0
      ENDDO
      NP=NP-JP
 
C     RECALCULATE BSUM AND BESDSUM
        
      BSUM=0.0
      BESDSUM=0.0
      DO I=1,NPTS
	IF(B(I).GT.0.0) THEN
           BSUM=BSUM+B(I)
           BESDSUM=BESDSUM+BESD(I)
        ENDIF
      ENDDO

      IF (NP.EQ.0.OR.BSUM.EQ.0.0) GO TO 305
      BSUM=BSUM/FLOAT(NP)
      BESDSUM=BESDSUM/FLOAT(NP)
      GO TO 305
        
C     SORT PEAKS
      
 501  NTPKS=NPKS-1
 
C     SEE WHAT BKG LOOKS LIKE BASED ON D2 POINTS WHICH ARE LESS THAN +-BESDSUM/10
 
      J=0
      DO I=1,NPTS

         IF (ABS(D2(I)).LT.(0.1*BESDSUM)) THEN
            J=J+1
            XA(J)=X(I)
            YA(J)=SMO(I)
            DELY(J)=ESD(I)
         ENDIF
      ENDDO
      JPTS=J
      WRITE (LO,953) JPTS
 953  FORMAT (' JPTS = ', I5)
      S=2000.0                  !stiffness parameter
      CALL SMOSP1(XA,YA,DELY,JPTS,S,AX,BX,CX,DX,TEMP)
      DO 225 I=1,NPTS
         XVAL=X(I)
         CALL SMOSP2(XA,AX,BX,CX,DX,JPTS,XVAL,YVAL,FDRVAL,SDRVAL)
         BACKGRND(I)=YVAL
 225  CONTINUE
      OPEN (UNIT=OUT,FILE='gauss.bkg',STATUS='UNKNOWN')
      WRITE (OUT,*) 'set newx {'
      DO I=1,NPTS
         WRITE (OUT,*) X(I)
      ENDDO
      WRITE (OUT,*) '}'
      WRITE (OUT,*) 'set newy {'
      DO I=1,NPTS
         WRITE (OUT,*) BACKGRND(I)*SCALE
      ENDDO
      WRITE (OUT,*) '}'
      CLOSE (UNIT=OUT)
      
C     SORT PEAKS, GET BACKGROUND, AND WRITE STUFF OUT TO A FILE
        
      DO I=1,NTPKS
         ITT(I)=10000*WTTT(I)
         NSEQ(I)=I
         XVAL=WTTT(I)
         CALL SMOSP2(XA,AX,BX,CX,DX,JPTS,XVAL,YVAL,FDRVAL,SDRVAL)
         BACKGRND(I)=YVAL       ! REUSING ARRAY
         PKAREA(I)=PKAREA(I)-BACKGRND(I)
      ENDDO
 
      CALL SORT(NSEQ,ITT,NTPKS,1)
        
C     AT THIS POINT, PKAREA HAS BEEN CORRECTED FOR BACKGROUND BUT
C     AMAX HAS NOT -- MOSTLY SO IF I PLOT THE AMAX POINTS THEY COME
C     OUT ON OR NEAR THE TOP OF THE PEAK.  DO LOOP BELOW ELIMINATES 
C     ANY PEAK THAT IS BARELY ABOVE BACKGROUND -- COULD BE MADE BETTER.
      
      DO I=1,NTPKS
         J=NSEQ(I)
         IF (AMAX(J).GT.(1.5*BACKGRND(J))) THEN
            WRITE(LO,325)WTTT(J),WIDTH(J),PKAREA(J),AMAX(J),BACKGRND(J)
 325        FORMAT (3F10.4,F10.2,F10.2)
         ENDIF
      ENDDO
      OPEN(UNIT=OUT,FILE='gauss.pks',STATUS='UNKNOWN')
      WRITE (OUT,*) 'set tt {'
      DO I=1,NTPKS
         J=NSEQ(I)
         WRITE (OUT,*) WTTT(J)
      ENDDO
      WRITE (OUT,*) '}'
      WRITE (OUT,*) 'set wid {'
      DO I=1,NTPKS
         J=NSEQ(I)
         WRITE (OUT,*) WIDTH(J)
      ENDDO
      WRITE (OUT,*) '}'
      WRITE (OUT,*) 'set area {'
      DO I=1,NTPKS
         J=NSEQ(I)
         WRITE (OUT,*) PKAREA(J)*SCALE
      ENDDO
      WRITE (OUT,*) '}'
      WRITE (OUT,*) 'set height {'
      DO I=1,NTPKS
         J=NSEQ(I)
         WRITE (OUT,*) AMAX(J)*SCALE
      ENDDO
      WRITE (OUT,*) '}'
      WRITE (OUT,*) 'set bkg {'
      DO I=1,NTPKS
         J=NSEQ(I)
         WRITE (OUT,*) BACKGRND(J)*SCALE
      ENDDO
      WRITE (OUT,*) '}'
      CLOSE(OUT)
      END
 
C*************************************************************************************
 
        SUBROUTINE SORT (NSEQ,ITEM,KDIM,NORDER)
C       SORT ARRAY ITEM AND STORE SEQUENCE IN ARRAY NSEQ.
C       DIMENSION OF ITEM AND NSEQ IS KDIM.
C       NORDER = +1 IMPLIES INCREASING ORDER.
C       NORDER = -1 IMPLIES DECREASING ORDER.
C
        DIMENSION NSEQ(KDIM),ITEM(KDIM)
        N=KDIM-1
        DO 50 I=1,N
        M=I
        K=I+1
        IF(NORDER.EQ.1) GO TO 30
        DO 20 J=K,KDIM
        IF(ITEM(M).LT.ITEM(J)) M=J
20      CONTINUE
        GO TO 45
30      DO 40 J=K,KDIM
        IF(ITEM(M).GT.ITEM(J)) M=J
40      CONTINUE
45      ITEMP=ITEM(M)
        ITEM(M)=ITEM(I)
        ITEM(I)=ITEMP
        ITEMP=NSEQ(M)
        NSEQ(M)=NSEQ(I)
        NSEQ(I)=ITEMP
50      CONTINUE
        RETURN
        END
 
C******************************************************************
 
       SUBROUTINE SMOSP1(X,Y,DELY,N,S,A,B,C,D,TEMP)
       DIMENSION X(N),Y(N),DELY(N),A(N+2),B(N+2),C(N+2),D(N+2),
     1 TEMP(8*(N+2))
        INTEGER IN,OUT,LI,LO
        COMMON/IO/ IN,OUT,LI,LO
C
C       TEMP ASSUMED TO BE AT LEAST  8*(N+2)
C
       DO 10 I = 2,N
       IF( X(I) .GT. X(I-1) ) GO TO 10
       WRITE (LO,5) I,X(I-1),X(I)
5      FORMAT('0SMOSP1 CALLED WITH X IN NON-ASCENDING ORDER',I3,2E16.8)
       RETURN
10     CONTINUE
       DO 20 I = 1,(N+2)
        A(I)=0.0
        B(I)=0.0
        C(I)=0.0
        D(I)=0.0
C       K = (I-1)*N + 2*I-1
C       KK = K + N + 1
C        TEMP(K ) = 0
C        TEMP(KK) = 0
20     CONTINUE
        DO 22 I=1,(8*(N+2))
22      TEMP(I)=0.0
       CALL SM1SP1(X,Y,DELY,N,S,A,B,C,D,TEMP(1),TEMP(N+3),TEMP(2*N+5),
     1 TEMP(3*N+7),TEMP(4*N+9),TEMP( 5*N+11),TEMP(6*N+13),TEMP(7*N+15))
       RETURN
       END
 
C******************************************************************
       SUBROUTINE SM1SP1(X,Y,DYT,NOBS,S,A,B,C,D,DY,R,R1,R2,T,T1,U,V)
       DIMENSION X(NOBS),Y(NOBS),DYT(NOBS),A(NOBS+2),B(NOBS+2),
     1 C(NOBS+2),D(NOBS+2),DY(NOBS+2),R(NOBS+2),R1(NOBS+2),
     2 R2(NOBS+2),T(NOBS+2),T1(NOBS+2),U(NOBS+2),V(NOBS+2)
c        CALL ERRSET(74,.TRUE.,.TRUE.,.FALSE.,.FALSE.,15)
       NN = NOBS
C
C       X    AND Y ARE  U AND V  ARRAYS UNTIL STATEMENT 100
C
      DO 50 I = 1,NN
      U(I+1) = X(I)
      V(I+1) = Y(I)
      DY(I+1) = DYT(I)
50    CONTINUE
      U(1) = 0
      U(NN+2) = 0
      V(1) = 0
      V(NN+2) = 0
      DY(1) = 0
      DY(NN+2) = 0
C
      N1 = 2
      N2=NOBS+1
      NM1=N1-1
      M2 = N2 - 1
      M1 = N1 + 1
      R(NM1)=0.
      R(N1) = 0.
      R1(N2) = 0.
      R2(N2) = 0.
      R2(N2+1) = 0.
      P = 0.
      H = U(M1) - U(N1)
      F = ( V(M1) - V(N1))/H
      DO 100 I = M1,M2
      G = H
      H = U(I+1) - U(I)
      E = F
      F = (V(I+1) - V(I))/H
      A(I) = F - E
      T(I) = 2. * (G + H) / 3.
      T1(I) = H / 3.
      R2(I) = DY(I-1) / G
      R(I) = DY(I+1) / H
 100  R1(I) = - DY(I) / G - DY(I) / H
      U(NM1)=0.
      U(N1) = 0.
      U(N2) = 0.
      U(M2) = 0.
      DO 110 I = M1,M2
      B(I) = R(I) * R(I) + R1(I) * R1(I) + R2(I) * R2(I)
      C(I) = R(I) * R1(I+1) + R1(I) * R2(I+1)
 110  D(I) = R(I) * R2(I+2)
      F2 = - S
C     ** NEXT ITERATION
 115  CONTINUE
      DO 120 I = M1,M2
      R1(I-1) = F * R(I-1)
      R2(I-2) = G * R(I-2)
      R(I) = 1. / (P*B(I) + T(I) - F* R1(I-1) - G* R2(I-2))
      U(I) = A(I) - R1(I-1) * U(I-1) -R2(I-2) * U(I-2)
      F = P * C(I) + T1(I) - H*R1(I-1)
      G = H
 120  H = D(I) * P
      DO 130 I = M2,M1,-1
      U(I) = R(I) * U(I) - R1(I) * U(I+1) - R2(I) * U(I+2)
  130 CONTINUE
      E = 0.
      H=0.
      DO 140 I = N1,M2
      G = H
      H = (U(I+1) - U(I)) / (X(I) - X(I-1))
      V(I) = (H - G) * DY(I) * DY(I)
 140  E = E + V(I) * (H - G)
      G = - H * DY(N2) * DY(N2)
      V(N2) = G
      E = E - G * H
      G = F2
      F2 = E * P * P
C       WRITE (6,999) S,F2,E,P,G
C999    FORMAT (' S,F2,E,P,G = '5F15.4)
!      write (*,*) 'F2,S,G = ',F2,S,G
      IF(F2 .GE. S .OR. F2 .LE. G) GO TO 160
      F = 0.
      H = (V(M1) - V(N1)) / (X(2) - X(1))
      DO 150 I = M1,M2
      G = H
      H = (V(I+1) - V(I)) / (X(I) - X(I-1))
      G = H - G - R1(I-1) * R(I-1) - R2(I-2) * R(I-2)
      F = F + G * R(I) * G
 150  R(I) = G
      H = E - P * F
!      write (*,*) 'H=',H
      IF(H .LE. 0.) GO TO 160
      P = P + (S - F2) / ((SQRT(S/E) + P) * H)
      GO TO 115
C     ** FIN
 160  DO 170 I = N1,N2
      A(I) = Y(I-1) - P*V(I)
 170  C(I) = U(I)
      DO 180 I = N1,M2
      H = X(I) - X(I-1)
      D(I) = (C(I+1) - C(I)) / (3. * H)
 180  B(I) = (A(I+1) - A(I)) / H - (H * D(I) + C(I)) * H
C
c        CALL ERRSET(74,.TRUE.,.TRUE.,.FALSE.,.TRUE.,15)
      RETURN
      END
 
C*******************************************************************
 
       SUBROUTINE SMOSP2(X,A,B,C,D,N,XEVAL,YVAL,FDRVAL,SDRVAL)
       DIMENSION X(N),A(N+2),B(N+2),C(N+2),D(N+2)
       I = 1
       IF ( XEVAL  .LT. X(1)) GO TO 100
       I = N -1
       IF( XEVAL  .GE.  X(N-1)) GO TO 100
       I = 1
 40    IF(XEVAL  .GE.X(I)   .AND.  XEVAL.LE. X(I+1)) GO TO 100
       I = I+1
       GO TO 40
 100   H = XEVAL - X(I)
       I = I+1
       YVAL=((D(I)*H +C(I))*H +B(I))*H+A(I)
       FDRVAL=(3.*D(I)*H +2.*C(I))*H + B(I)
       SDRVAL= 6.*D(I)*H +2.*C(I)
       RETURN
       END
