      SUBROUTINE CELCON 
C 
C      CALCULATE RECIPROCAL CELL CONSTANTS FROM REAL OR RECIPROCAL CELL
C 
      COMMON /CELLS/A,B,C,AL,BE,GA,RCV,RCP(6),VOL,PRCP(6)
      REAL RAD, TMP
      DATA RAD/57.29578/

      A=RCP(1)
      B=RCP(2)
      C=RCP(3)
      AL=COS(RCP(4)/RAD)
      BE=COS(RCP(5)/RAD)
      GA=COS(RCP(6)/RAD)
      SINAL=SQRT(1.0-AL**2)
      SINBE=SQRT(1.0-BE**2)
      SINGA=SQRT(1.0-GA**2) 
      IF (A .GT. 1.0) THEN
C     We have a direct cell
         RCV=A*B*C*SQRT(1.0-AL**2-BE**2-GA**2+2.0*AL*BE*GA)
         RCP(1)=B*C*SINAL/RCV
         RCP(2)=A*C*SINBE/RCV
         RCP(3)=A*B*SINGA/RCV
         RCP(4)=(BE*GA-AL)/(SINBE*SINGA)
         RCP(5)=(AL*GA-BE)/(SINAL*SINGA)
         RCP(6)=(AL*BE-GA)/(SINAL*SINBE)
         VOL=RCP(1)*RCP(2)*RCP(3)*
     $        SQRT(1.0-RCP(4)**2-RCP(5)**2-RCP(6)**2+
     $        2.0*RCP(4)*RCP(5)*RCP(6)) 
      ELSE
C     We have a recipcrocal cell
         VOL=A*B*C*SQRT(1.0-AL**2-BE**2-GA**2+2.0*AL*BE*GA)
         RCP(1)=B*C*SINAL/VOL
         RCP(2)=A*C*SINBE/VOL
         RCP(3)=A*B*SINGA/VOL
         RCP(4)=(BE*GA-AL)/(SINBE*SINGA)
         RCP(5)=(AL*GA-BE)/(SINAL*SINGA)
         RCP(6)=(AL*BE-GA)/(SINAL*SINBE)
         RCV=RCP(1)*RCP(2)*RCP(3)*
     $        SQRT(1.0-RCP(4)**2-RCP(5)**2-RCP(6)**2+
     $        2.0*RCP(4)*RCP(5)*RCP(6)) 
C     Swap the values
         TMP = RCP(1)
         RCP(1) = A
         A = TMP
         TMP = RCP(2)
         RCP(2) = B
         B = TMP
         TMP = RCP(3)
         RCP(3) = C
         C = TMP
         TMP = RCP(4)
         RCP(4) = AL
         AL = TMP
         TMP = RCP(5)
         RCP(5) = BE
         BE = TMP
         TMP = RCP(6)
         RCP(6) = GA
         GA = TMP
      ENDIF
C 
C     CALCULATE CROSS PRODUCTS OF RECIPROCAL CELL PARAMETERS
C 
      PRCP(1)=RCP(1)**2*0.25
      PRCP(2)=RCP(2)**2*0.25
      PRCP(3)=RCP(3)**2*0.25
      PRCP(4)=RCP(1)*RCP(2)*RCP(6)*0.25 
      PRCP(5)=RCP(1)*RCP(3)*RCP(5)*0.25 
      PRCP(6)=RCP(2)*RCP(3)*RCP(4)*0.25 
      RETURN
      END 
