# read ascii XY data files
#
# Modified to read x,y or x,y,esd and skip points where y < 0
# Will also read numbers separated by commas, and/or spaces
#
#----------------------------------------------------------------
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -xyd
# proc to use 
set command(-xyd)  readXYdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "XY data (ascii)"
# proc for this entry
lappend command(readproc) ReadXYd
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {dat pks csv peaks jones}
    # definitions for these data types
    set command(ReadXYd_dat_type) "XY data"
    set command(ReadXYd_pks_type) "XY peaks"
} else {
    lappend command(filterlist) {dat jones DAT JONES pks peaks PEAKS csv}
    # definitions for these data types
    set command(ReadXYd_dat_type) "XY data"
    set command(ReadXYd_DAT_type) "XY data"
    set command(ReadXYd_jones_type) "XY data"
    set command(ReadXYd_JONES_type) "XY data"
    set command(ReadXYd_pks_type) "XY peaks"
    set command(ReadXYd_peaks_type) "XY peaks"
    set command(ReadXYd_PEAKS_type) "XY peaks"
}

proc ReadXYd {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readXYdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)

}
proc readXYdata {filename} {

    #puts "opening XY Data file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data

	# Great!! Now we are positioned to read the data.
	set peaks 0
	# does this file contain peaks?
	if {[string index \
		[string tolower [file extension $filename]] 1] == "p"} {
	    # yes -- the file extension begins with ".p"
	    set peaks 1
	} else {
	    gets $fp header
	    if {$header == "CMPR peaks file"} {
		set peaks 2
		gets $fp title
		gets $fp header
		set header [split $header ","] 
		set units [string trim [lindex $header 0]]
	    } else {
		seek $fp 0
	    }
	}
	if {$peaks > 0} {
	    set data [initpeaks $data]
	    global ${data}
	    if {$peaks == 1} {
		gets $fp ${data}(title)
		gets $fp wave
		if {$wave == 0} {
		    set ${data}(xlabel) "d-space"
		    set ${data}(xunits) "dspace"
		} elseif {$wave < 0} {
		    set ${data}(xlabel) "Q"
		    set ${data}(xunits) "Q"
		} else {
		    set ${data}(xlabel) "2theta"
		    set ${data}(xunits) "2theta"
		    set ${data}(wavelength) $wave
		}
	    } else {
		set ${data}(xlabel) $units
		set ${data}(xunits) $units
		if {$units == "2theta"} {
		    set ${data}(wavelength) [lindex \
			 [split [string trim [lindex $header 6]] "="] 1]
		}
	    }
	    set ptsread 0
	    # Now, read the rest of the file.
	    # until we get to the last data point, an end-of-file or error
	    set i 0
	    while {[gets $fp line] >= 0} {
		incr lnum
		incr ptsread
		# change commas to blanks 
		regsub -all , $line " " line
		if {$lnum > $::command(maxlines)} {
		    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
		}
		catch {
		    set x 0
		    set x [expr [lindex $line 0]]
		}
		set y 0
		if {[catch {
		    set y [expr [lindex $line 1]]
		}]} {set y 1}
		catch {
		    set wid {}
		    set wid [expr [lindex $line 2]]
		}
		catch {
		    set h 100
		    set h [expr [lindex $line 3]]
		}
		catch {
		    set bkg 0
		    set bkg [expr [lindex $line 4]]
		}
		catch {
		    set eta {}
		    set eta [expr [lindex $line 5]]
		}
		lappend ${data}(x) $x
		lappend ${data}(y) $y
		lappend ${data}(widths) $wid
		lappend ${data}(etas) $eta
		lappend ${data}(heights) $h
		lappend ${data}(bkgs) $bkg
	    }
	    resetdata $data
	} else {
	    # Initialize the data structure.
	    set data [initdata $data]
	    global ${data}
	    set ${data}(xlabel) "2theta"
	    set ${data}(xunits) "2theta"
	    set ${data}(ylabel) "counts"
	    
	    # No missing points
	    set ${data}(skip) 0
	    set ptsread 0

	    # Now, read the rest of the file.
	    # until we get to the last data point, an end-of-file or error
	    set i 0
	    while {[gets $fp line] >= 0} {
		incr lnum
		incr ptsread
		# change commas to blanks 
		regsub -all , $line " " line
		if {$lnum > $::command(maxlines)} {
		    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
		}
		set yyyy -1
		catch {
		    set xxxx [expr [lindex $line 0]]
		    set yyyy [expr [lindex $line 1]]
		}
		set yyyyesd -1
		catch {
		    set yyyyesd [expr [lindex $line 2]]
		}
		# set the esd
		if {$yyyyesd < 0} {
		    if {$yyyy <= 0} {
			set yyyyesd 1
		    } else {
			set yyyyesd [expr sqrt(1.0 * $yyyy )] 
		    }
		}
		# skip negative or garbled points
		if {[lindex $line 1] >= 0 && $yyyy >= 0} {
		    lappend ${data}(x)   $xxxx
		    lappend ${data}(y)   $yyyy		
		    lappend ${data}(esd) $yyyyesd
		} else {
		    # there are skipped points
		    set ${data}(skip) 1
		}
		incr ptsread
	    }
	}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "XY Data error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} 
    #puts "$ptsread valid points read"
    return {}
}
 
#-- 
#Alistair McGhie [DuPont Exp. Sta.  Wilm. De. 19880-0228]

