#-----------------------------------------------------------------
# read X7A ASCII data files
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -x7a
# proc to use 
set command(-x7a) readcoxdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "BNL X7A File"
# proc for this entry
lappend command(readproc) ReadCox
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {dat x7a}
} else {
    lappend command(filterlist) {dat DAT x7a X7A}
}
# definitions for these data types
set command(ReadCox_x7a_type) "X7A data"
set command(ReadCox_X7A_type) "X7A data"
set command(ReadCox_dat_type) "X7A data"
set command(ReadCox_DAT_type) "X7A data"


proc ReadCox {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readcoxdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readcoxdata {filename} {

    #puts "opening X7A file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]

	# Skip the first 4 lines of the cox file since they
	# really aren't needed.  All we really want is
	# the final angle
	
	for {set i 0} {$i<7} {incr i} {
	    incr lnum
	    set eof [gets $fp line]
	    if {$eof < 0} {return "early end-of-file"} 
	    # use the first line as the title whatever it is
	    if {$i == 0} {set title $line}
	}
	
	# Now, read the last few lines before the real data
	
	for {set i 0} {$i<9} {incr i} {
	    incr lnum
	    set eof [gets $fp line]
	    if {$eof < 0} {
		return "early end-of-file"
	    } 
	}
	
	# Great!! Now we are positioned to read the data.  We need to normalize
	# the data and calculate esds.  We will use the first datapoint
	# in the file as our reference.   We will normalize everything to
	# the IO of this reading.
	
	# Initialize the data structure.
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}
	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "scaled counts"
	
	# No missing points
	set ${data}(skip) 0
	set ${data}(title) $title
	set ptsread 0

	# Now, read the rest of the file.  Continue reading 
	# until we get to the last data point, an end-of-file or error
	set firstpass 1
	set i 0
	while {[gets $fp line] >= 0} {
	    incr lnum
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }
	    set angle [lindex $line 0]
	    #	set ctime [lindex $line 1]
	    set count [lindex $line 2]
	    set mon   [lindex $line 3]
	    if $firstpass {
		set firstpass 0
		set firstmon $mon
	    }
	    #	set isum  [lindex $line 4] 
	    # puts $angle
	    lappend ${data}(x) $angle
	    lappend ${data}(y) [expr 1.0*$count*$firstmon/(1.0*$mon)]
	    # allow Harlow's negative values
	    set esd 0
	    catch {set esd [expr sqrt($count)*$firstmon/(1.0*$mon)]}
	    lappend ${data}(esd) $esd
	    incr ptsread
	}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "X7A error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} test
    #puts "$ptsread valid points read"
    return {}
}
