# for simplicity, which is a good thing, the CMPR file will be rigidly constructed
# After all, this file type will be used by one program only, and all of the data
# that needs to be read by another program can already be done so through the other
# write routines, and the plots can be output to GRACE and CSV files.  This is not
# a multipurpose file, so we can comfortably take the liberty of knowing that it is
# rigidly simple, which will make life easier when reading that file

# as of Nov 10, 2009, this routine is less than 2 weeks old, and may need much more
# testing, so be warned while using it.

# read_cmpr.tcl - by D. Vincent West and Tyrel M. McQueen

# csv2list from http://code.activestate.com/recipes/65433/ on November 18, 2009

# current version: alpha - 0.21
# release date: Nov 18, 2009

#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -cmpr
# proc to use 
set command(-cmpr) readCMPR

#------- define a dialog box entry --------------------------------
# menu label
lappend command(readtypes) "CMPR Project (multiple datasets)"
# proc for this entry
lappend command(readproc) readCMPR

# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {cmpr}
    # definitions for these data types
    set command(readCMPR_CMPR_type) "CMPR Project with Multiple Datasets"
} else {
    # add both cases for UNIX
    lappend command(filterlist) {cmpr CMPR}
    # definitions for these data types
    set command(readCMPR_CMPR_type) "CMPR Project with Multiple Datasets"
    set command(readCMPR_cmpr_type) "CMPR Project with Multiple Datasets"
}

proc readCMPR {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readCMPRproject $file]
    donewait
    if {$ret != ""} {return $ret}
    # TMM If we were called from the command line, $command(read_filelist) may not be defined.
    # TMM In that case, we must also call displaylist manually, as we were not called from read.tcl
    if { $command(read_filelist) == "" } {
        displaylist
    } else {
	showlastentry $command(read_filelist)
	
	# DVW the settings for the graph legend are properly read through the read routine, but must be
	# updated through this call so that the new values are actually used
	graphlegend
    }
    
}

proc csv2list {str {sepChar ,}} {
    regsub -all {(\A\"|\"\Z)} $str \0 str
    set str [string map [list $sepChar\"\"\" $sepChar\0\" \"\"\"$sepChar \"\0$sepChar \"\" \" \" \0 ] $str]
    set end 0
    while {[regexp -indices -start $end {(\0)[^\0]*(\0)} $str -> start end]} {
	set start [lindex $start 0]
	set end   [lindex $end 0]
	set range [string range $str $start $end]
	set first [string first $sepChar $range]
	if {$first >= 0} {
	    set str [string replace $str $start $end [string map [list $sepChar \1] $range]]
        }
        incr end
    }
    set str [string map [list $sepChar \0 \1 $sepChar \0 {} ] $str] 
    return [split $str \0]
}

proc readCMPRproject {filename} {
	global graph cellparm
	
	#open the file
	set fp [open $filename r]
	
	# go through the file line by line, which, given the way cmpr files are written
	# only waste the first 2 lines, which are descriptive
	while {[gets $fp line] >= 0} {
		# when we encounter the environment settings, parse them
		if { $line == "###ENVIRONMENT SETTINGS###" } {
			set indices [csv2list [gets $fp]]
			set values [csv2list [gets $fp]]
			foreach index $indices value $values {
				set cellparm($index) $value
			}
			
			set indices [csv2list [gets $fp]]
			set values [csv2list [gets $fp]]
			foreach index $indices value $values {
				set graph($index) $value
			}
		}
	
		# when we encounter a new dataset, begin parsing the dataset
		if {$line == "###NEW DATASET###"} {
		
			# the first line of the data set contains the datset name and type, both with labels
			foreach {index1 value1 index2 value2} [csv2list [gets $fp]] {
				set data $value1
				set type $value2
			}
			
			# first initialize the dataset with the name of the dataset
			if { $type == "peaks" } {
				set data [initpeaks $data]
			} elseif { $type == "xy" } {
				set data [initdata $data]
				
			# output an error if the type is neither peaks nor xy
			} else { return -code error "Unrecognized Dataset type in cmpr File!" }
			
			global ${data}
			set ${data}(type) $type
			
			# now we read in the data parts that only have a single value.  The first
			# line is are the data array indices, and the second line are their values
			# this behavior is identical for both peaks and xy data
			set indices [csv2list [gets $fp]]
			set values [csv2list [gets $fp]]
			foreach index $indices value $values {
				set ${data}($index) $value
			}
			
			# now we read in the data parts that have multiple values, again we set the 
			# data array indices using the first line, and all subsequent lines are the
			# values, until we get to the indicator line that the dataset has ended			
			set indices [csv2list [gets $fp] ","]			
			set counter 0
			
			# in reading the data, we must distinguish petween reading peaks, and reading
			# xy data, because they are handled differently in setting the actual data
			if { $type == "peaks" } {
				# read and set the peaks data
				
				# we have to reset the lists needed for setting the vector values in each loop
				set xvector ""; set yvector ""; set ttvector "";
				
				while { [set line [gets $fp]] != "#--vector data--#"} {
					set values [csv2list $line]
					foreach index $indices value $values {
						if {$index == "ttvector"} {
							lappend ttvector $value
						} else {lappend ${data}($index) $value}
					}
				}
				
				#skip over the column labels for the vector data
				gets $fp
				
				while { [set line [gets $fp]] != "###END DATASET###"} {
					set values [csv2list $line ","]
					foreach {x1 x2 x3 y1 y2 y3} $values {
						lappend xvector $x1
						lappend xvector $x2
						lappend xvector $x3
						lappend yvector $y1
						lappend yvector $y2
						lappend yvector $y3
					}
				}
				#resetdata $data				
				[set ${data}(xvector)] set $xvector
				[set ${data}(yvector)] set $yvector
				[set ${data}(ttvector)] set $ttvector
				
			} else {
				# read and set the xy data
				
				# we have to reset the lists needed for setting the vector values in each loop
				set xdata ""; set ydata ""; set esd ""; set xvector ""; set yvector ""; set esdvector "";
				
				while { [set line [gets $fp]] != "###END DATASET###"} {
					set values [csv2list $line ","]
					foreach {x y e xs ys es} $values {						
						lappend xdata $x
						lappend ydata $y
						lappend esd $e
						lappend xvector $xs
						lappend yvector $ys
						lappend esdvec $es
					}
				}
				#resetdata $data
				set ${data}(x) $xdata
				set ${data}(y) $ydata
				set ${data}(esd) $esd
				[set ${data}(xvector)] set $xvector
				[set ${data}(yvector)] set $yvector
				[set ${data}(esdvec)] set $esdvec	
			}
			
			# the last step is to make sure the data is displayed in the plot window
			lappend graph(plotlist) $data
		}
	}
	
    catch {close $fp} test
	return {}
}
