# $Revision: 332 $ $Date: 2009-12-04 09:44:04 -0600 (Fri, 04 Dec 2009) $
set helplist(Read) {\
Reads a file in a variety of formats. Select the appropriate 
file format and the select a file. Files can be read either 
by clicking the "Read" button or by double-clicking on the file.

Refer to the HTML documentation for information about adding 
support for new formats.
}
set command(readtypes) ""
set command(readproc) ""
set command(cmdopt) {}
set command(filterlist) {}
# a command to do nothing
set FilePane(command) {llength}
set FilePane(filter) {*}

proc pleasewait {{message {}} {statusvar {}} {parent .} {button ""}} {
    if {$parent == "."} {
	set root ""
    } else {
	set root $parent
    }
    set ::PleaseWaitWindow ${root}.msg
    catch {destroy $::PleaseWaitWindow}
    toplevel $::PleaseWaitWindow
    wm transient $::PleaseWaitWindow [winfo toplevel $parent]
    pack [frame $::PleaseWaitWindow.f -bd 4 -relief groove] -padx 5 -pady 5
    pack [message $::PleaseWaitWindow.f.m -text "Please wait $message"] -side top
    if {$statusvar != ""} {
	pack [label $::PleaseWaitWindow.f.status -textvariable $statusvar] -side top
    }
    if {$button != ""} {
	pack [button $::PleaseWaitWindow.f.button -text [lindex $button 0] \
		-command [lindex $button 1]] -side top
    }
    wm withdraw $::PleaseWaitWindow
    update idletasks
    # place the message on top of the parent window
    set x [expr [winfo x $parent] + [winfo width $parent]/2 - \
	    [winfo reqwidth $::PleaseWaitWindow]/2 - [winfo vrootx $parent]]
    if {$x < 0} {set x 0}
    set y [expr [winfo y $parent] + [winfo height $parent]/2 - \
	    [winfo reqheight $::PleaseWaitWindow]/2 - [winfo vrooty $parent]]
    if {$y < 0} {set y 0}
    wm geom $::PleaseWaitWindow +$x+$y
    update
    wm deiconify $::PleaseWaitWindow
    global makenew
    set makenew(OldGrab) ""
    set makenew(OldFocus) ""
    # save focus & grab
    catch {set makenew(OldFocus) [focus]}
    catch {set makenew(OldGrab) [grab current $::PleaseWaitWindow]}
    catch {grab $::PleaseWaitWindow}
    update
}

# clear the wait message
proc donewait {} {
    global makenew
    catch {destroy $::PleaseWaitWindow}
    # reset focus & grab
    catch {
	if {$makenew(OldFocus) != ""} {
	    focus $makenew(OldFocus)
	}
    }
    catch {
	if {$makenew(OldGrab) != ""} {
	    grab $makenew(OldGrab)
	}
    }
    unset ::PleaseWaitWindow
}

lappend menulist(file) Read
lappend menulist(pages) Read

# make the notebook page used for reading data
proc MakeRead {page}  {
    global command tcl_platform
    grid [frame $page.a] -column 0 -row 0 -sticky new
    pack [label $page.a.1a -text {Dataset(s)}] -side top
    pack [label $page.a.1b -text {previously read:}] -side top
    pack [frame $page.a.2 ] -side top 
    set command(read_filelist) $page.a.2
    makeselectbox $page.a.2
#    grid [frame $page.b] -column 1 -row 0 -sticky new
#    set fmtbox $page.b
    grid [canvas $page.b \
	    -scrollregion {0 0 5000 500} -width 50 -height 200 \
	    -yscrollcommand "$page.yscroll set" -bg lightgrey] \
	    -sticky  news -row 0 -column 1
    grid [scrollbar $page.yscroll -orient vertical \
	    -command "$page.b yview"] \
	    -sticky ns -row 0 -column 2
    set fmtbox [frame $page.b.f]
    $page.b create window 0 0 -anchor nw  -window $fmtbox
    grid [frame $page.c -bd 2 -relief groove] -column 3 -row 0 -sticky new
    grid columnconfigure $page 3 -weight 1
    grid [label $fmtbox.0 -text "File format"] -column 0 -row 0 -columnspan 2
    set num 1
    foreach item $command(readbuttons) cmd $command(readbuttonproc) {
	grid [button $fmtbox.b$num \
		-text $item -command $cmd  -anchor w] \
		-column 0 -row $num -sticky w
	incr num
    }
    foreach type $command(readtypes) \
	    filter $command(filterlist) \
	    cmd $command(readproc) {
	grid [radiobutton $fmtbox.$num \
		-variable command(readtype) -value $num -text $type \
		-command "readpageconfig $page $cmd \"$filter\""  -anchor w] \
		-column 0 -row $num -sticky w
	incr num
    }
    getFilePane $page.c Read 1 [pwd] "Select one or more files to read"
    # set up resize proc, in case it is best to move later
    proc ResizeRead {} "update idletasks; $page.b config -scrollregion \[grid bbox $fmtbox]; $page.b config -width \[lindex  \[grid bbox $fmtbox] 2]"
    # disable the Read button until a format is selected
    $page.c.c config -state disabled
}

# update the notebook page used for reading data
proc PostPageRead {page} {
    updateselectbox $page.a.2
    ResizeRead
} 

# called when a filetype is selected: update the filename filter 
# in the dialog box.
#
proc readpageconfig {page cmd filter} {
    global command tcl_platform FilePane
    # enable the Read button
    $page.c.c config -state normal
    set FilePane(command) doread 
    set command(readcmd) $cmd
    if {[llength $filter] == 1} {
	set FilePane(filter) "*.[string trim $filter]"
    } else {
	set filterrule ""
	foreach f $filter {
	    if {$filterrule == ""} {
		set filterrule "*.\{"
	    } else {
		append filterrule ","
	    }
	    append filterrule "[string trim $f]"
	}
	append filterrule "\}"
	set FilePane(filter) $filterrule
    }
    FilePaneSelChoose
}

# Note that the proc that actually do reading are located in files 
# named read_*.tcl -- they must be read before MakeRead is called
proc doread {filelist} {
    global graph command
    set graph(plotlist) ""
    foreach file $filelist {
	set ret [$command(readcmd) $file]
	if {$ret != ""} {
	    tk_dialog .err "Read Error" "Error reading file\n$file:\n$ret" \
		    error 0 OK
	}
    }
    displaylist
}

#------------------------------------------------------------------------------
# get a file from a dialog box in a frame or toplevel
#------------------------------------------------------------------------------
proc getFilePane {bx button multiple "path {}" "title {}" \
	"width 30" "height 10"} {
    # =================================================== 
    # bx -- toplevel or frame to use
    # button -- text for buttton
    # multiple -- use 1 to allow multiple selections; 
    #                 0 for single selection
    # path -- default starting path
    # title -- title line on top of dialog
    #
    # action to perform is set in FilePane(command)
    # initial file filter is in FilePane(filter)
    # =================================================== 
    global FilePane tcl_platform
    if {$multiple && $title == ""} {set title "Select one or more files"}
    if {$title == ""} {set title "Select a file"}
    # for windows, get a list of local drives
    global tcl_platform
    if {$tcl_platform(platform) == "windows"} {
	set FilePane(volumes) [file volume]
    }
    # build the dialog
    set FilePane(box) $bx
    grid [label $bx.0 -text $title] -column 0 -row 0 
    grid [frame $bx.top] -column 0 -row 1 -columnspan 3 -sticky ew
    grid [label $bx.top.a -text "Directory" ]  -column 0 -row 0
    grid [frame $bx.fil] -column 0 -row 2 -columnspan 3 -sticky ew
    grid [label $bx.fil.a -text "Filter" ]  -column 0 -row 0
    grid [entry $bx.fil.e -textvariable FilePane(filter) -width 25] \
	    -column 1 -row 0
    if {[string trim $path] == ""} {
	set path [pwd]
    } elseif {$tcl_platform(platform) == "windows"} {
	# change backslashes to something sensible
	regsub -all {\\} $path / path
	# allow entry of D: for D:/ and D:TEST for d:/TEST
	if {[string first : $path] != -1 && \
		[string first :/ $path] == -1} {
	    regsub : $path :/ path
	}
    }
    set FilePane(ButtonMenu) [tk_optionMenu $bx.top.d FilePane(DirButton) $path]
    grid $bx.top.d -column 1 -row 0
    grid columnconfigure $bx.top 1 -weight 1
    set FilePane(DirButton) $path
    # the icon below is taken from tk8.0/tkfbox.tcl
    set upfolder [image create bitmap -data {
#define updir_width 28
#define updir_height 16
static char updir_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00,
   0x20, 0x40, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x01, 0x10, 0x00, 0x00, 0x01,
   0x10, 0x02, 0x00, 0x01, 0x10, 0x07, 0x00, 0x01, 0x90, 0x0f, 0x00, 0x01,
   0x10, 0x02, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01,
   0x10, 0xfe, 0x07, 0x01, 0x10, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x01,
   0xf0, 0xff, 0xff, 0x01};}]

    set cmd {set FilePane(DirButton) [file dirname $FilePane(DirButton)];FilePaneSelChoose}
    grid [button $bx.b -image $upfolder \
	    -command $cmd] -column 1 -row 0 -columnspan 2 -sticky ew
    listbox $bx.files -relief raised -bd 2 \
	    -yscrollcommand "$bx.scroll set" \
	    -height $height -width $width
    if {$multiple} {$bx.files config -selectmode extended}
    scrollbar $bx.scroll -command "$bx.files yview"
    FilePaneSelChoose
    grid $bx.files -column 0 -row 3 -sticky news -columnspan 2
    grid columnconfig $bx 0 -weight 1
    grid columnconfig $bx 1 -weight 1
    grid rowconfig $bx 3 -weight 1
    grid $bx.scroll -column 2 -row 3 -sticky ns
    grid [button $bx.c -command {$FilePane(command) [FilePaneGetFileList]} \
	    -text $button] -column 0 -row 4 -columnspan 2
    bind $bx.files <Double-Button-1> FilePaneDoubleClick
    bind $bx <KeyPress-Prior> "$bx.files yview scroll -1 page"
    bind $bx <KeyPress-Next> "$bx.files yview scroll 1 page"
    bind $bx <KeyPress-Up> "$bx.files yview scroll -1 unit"
    bind $bx <KeyPress-Down> "$bx.files yview scroll 1 unit"
    bind $bx <KeyPress-Home> "$bx.files yview 0"
    bind $bx <KeyPress-End> "$bx.files yview end"
    bind $bx.fil.e <Return> FilePaneSelChoose
}

# select the current file as the new directory
proc FilePaneDoubleClick {} {
    global FilePane
    set frm $FilePane(box)
    set files $frm.files
    set select [$files curselection]
    if {$select == ""} return
    if {[llength $select] == 1} {
	set select [$files get $select]
	if {[string range $select end end] == "/"} {
	    set l [string length $select]
	    set select [string range $select 0 [incr l -1]]
	}
	if {$select == "<Parent>"} {
	    set FilePane(DirButton) [file dirname $FilePane(DirButton)]
	    FilePaneSelChoose
	    return
	} elseif [file isdirectory \
		[set newfile [file join $FilePane(DirButton) $select]]] {
	    if {$select != "."} {
		set FilePane(DirButton) $newfile
		FilePaneSelChoose
	    }
	    return
	}
    }
    $FilePane(command) [FilePaneGetFileList]
    return
}

# fill the file box with the current directory contents,
proc FilePaneSelChoose {} {
    global FilePane tcl_platform command
    set frm $FilePane(box)
    set files $frm.files

    # check for a directory in the filter field: use it
    set filter [$frm.fil.e get]
    set dirname [file dirname $filter]
    if {$dirname != "."} {
	set filter [file tail $filter]
	$frm.fil.e delete 0 end
	$frm.fil.e insert 0 $filter
	if {[file isdirectory $dirname]} {
	    set FilePane(DirButton) $dirname
	} else {
	    MyMessageBox -parent [winfo toplevel $frm] -title "Bad directory" \
		-message "Sorry, directory $dirname was not found in [pwd]" \
		-icon warning -type Ignore -default ignore
	}
    }
    if {$FilePane(DirButton) == "."} {set FilePane(DirButton) [pwd]}
    if {[string trim $filter] == ""} {set filter *}
    set filter [join $filter ,]

    $files delete 0 end

    # insert a list of directories
    $files insert end "<Parent>"
    set filelist [glob -nocomplain \
	    [file join $FilePane(DirButton) *] ]
    foreach file [lsort -dictionary $filelist] {
	if {[file isdirectory $file]} {
	    $files insert end "[file tail $file]/"
	}
    }

    # insert a spacer
    $files insert end "---------"

    # insert a list of files
    set filelist [glob -nocomplain \
	    [file join $FilePane(DirButton) \{$filter\}] ]
    foreach file [lsort -dictionary $filelist] {
	if {![file isdirectory $file]} {
	    $files insert end [file tail $file]
	}
    }

    # insert a directory list into the directory menubutton
    $FilePane(ButtonMenu) delete 0 end
    set list ""
    set dir ""
    foreach subdir [file split $FilePane(DirButton)] {
	set dir [file join $dir $subdir]
	if {[file exists $dir]} {set list [linsert $list 0 $dir]}
    }
    # for windows, add the list of local drives
    if {$tcl_platform(platform) == "windows"} {
	foreach item $FilePane(volumes) {
	    lappend list $item
	}
    }
    # add the initial directory, if defined & exists & not already present
    if {[array name command initwd] != ""} {
	if {[file exists $command(initwd)] && [file isdirectory $command(initwd)]} {
	    if {[lsearch $list $command(initwd)] == -1} {
		lappend list $command(initwd)
	    }
	}
    }
     
    foreach path $list {
	$FilePane(ButtonMenu) add command -label $path \
		-command "[list set FilePane(DirButton) $path]; FilePaneSelChoose"
    }
    update idletasks
    ResizeNotebook
    return
}

# this returns a list of selected files
proc FilePaneGetFileList {} {
    global FilePane
    set frm $FilePane(box)
    set files $frm.files
    set selectlist [$files curselection]
    if {$selectlist == ""} return
    set filelist {}
    foreach select $selectlist {
	set select [$files get $select]
	if {[string range $select end end] == "/"} continue
	set file [file join $FilePane(DirButton) $select]
	if {[file isdirectory $file]} continue
	if {[file exists $file]} {lappend filelist $file}
    }
    return $filelist
}
