;****************************************************
; The software provided here is released by the National
; Institute of Standards and Technology (NIST), an agency of
; the U.S. Department of Commerce, Gaithersburg MD 20899,
; USA.  The software bears no warranty, either expressed or
; implied. NIST does not assume legal liability nor
; responsibility for a User's use of the software or the
; results of such use.
; 
; Please note that within the United States, copyright
; protection, under Section 105 of the United States Code,
; Title 17, is not available for any work of the United
; States Government and/or for any works created by United
; States Government employees. User acknowledges that this
; software contains work which was created by NIST employees
; and is therefore in the public domain and not subject to
; copyright.  The User may use, distribute, or incorporate
; this software provided the User acknowledges this via an
; explicit acknowledgment of NIST-related contributions to
; the User's work. User also agrees to acknowledge, via an
; explicit acknowledgment, that any modifications or
; alterations have been made to this software before
; redistribution.
;****************************************************
;	tally13 -- program to monitor (tally) disk I/O requests on
;	disks attached to an Intel PC via the BIOS Int 13.
;	Author: Dr. James R. Lyle
;	Usage: tally13
;****************************************************
			.model	tiny
			version	m510
			P386
.code
cr			equ		0ah
lf			equ		0dh
doscall		equ		21h
dos_tsr		equ		3100h
set_i17		equ		2517h
set_i13		equ		2513h
get_i13		equ		3513h
print_cmd	equ		9h
cr		equ		0ah
lf		equ		0Dh
;****************************************************
; Print a message
;****************************************************
print 		MACRO	message
			lea		dx,message
			mov		ah,9
			int		21h
			ENDM
px	 		MACRO	message
			push	ax dx ds cs
			pop		ds
			lea		dx,message
			mov		ah,9
			int		21h
			pop		ds dx ax
			ENDM


;****************************************************
;****************************************************
decode	MACRO	from ; from is a byte register with the digit pair
	mov	AH,from	; move digits to AH
	shr	AX,4	; shift left digit into low bits & right digit into AL
	shr	AL,4	; move right digit into low bits
	or	AX,3030H ; convert to ASCII, leave in AX
	ENDM
get_date MACRO	string	; get a date, put in string
	mov		AH,04H	; setup for date BIOS service
	int		1AH	; get the date mm in DH
	decode		DH	; decode the month
	mov		string,AH	; save month in string
	mov		string+1,AL
	decode		DL		; day is in DL
	mov		string+3,AH	; save day of month
	mov		string+4,AL
	decode		CL		; year is in CL
	mov		string+6,AH	; save year digits
	mov		string+7,AL
	ENDM

get_time MACRO	string			; get current time from BIOS
	mov		AH,02H		; setup for time service
	int		1AH		; get the time
	decode		CH		; hours is in CH
	mov		string,AH	; save hours
	mov		string+1,AL
	decode		CL		; minutes is in CL
	mov		string+3,AH	; save minutes
	mov		string+4,AL
	decode		DH		; seconds is in DH
	mov		string+6,AH	; save seconds
	mov		string+7,AL
	ENDM
;****************************************************
;****************************************************
			org		100h
start:
			jmp		install
;****************************************************
;	DISK REQUEST
;		AL	MBZ for write command
;		AH	Command, 42 = read, 43 = write
;		DL	Drive ID
;		DS  	DAP segment
;		SI  	DAP offset 
;****************************************************
;	DISK ADDRESS PACKET (DAP)
;		0	Must be 16
;		1	MBZ
;		2	# of sectors to read/write
;		3	MBZ
;		4-5 	Data area segment
;		6-7	Data area offset
;		8-	Sector LBA (64 bit value)
;****************************************************


query_get	proc
	mov	DH,0	; put Function in AL
	sub	DX,80h	; get drive index relative to 80h
	shl	DX,1	; double (indexing words)
	mov	SI,DX	; move DX to SI
	mov	BX,CS:DriveTab[SI]		;BX -> tally table for drive
	mov	AL,AH	; move cmd ot AL
	mov	AH,0	; zero out AH
	shl	AX,1	; double
	mov	SI,AX	; SI -> tally for command
	mov	CX,CS:[BX+SI]	; put tally in CX
	ret
	endp	query_get
cmd_inc		proc
	call	query_get	; get tally value (in CX)
	inc	cx		; add one to tally for cmd on drive
	mov	CS:[BX+SI],CX	; save it back
	ret
	endp	cmd_inc



never_mind:
			pop		AX
not_hard_drive:
			popf				; restore flags
			jmp		CS:bios_old
tally_service:
			pushf				; save flags
			cmp		dl,7Fh
			jbe		not_hard_drive		; no match, not hard drive
			push	AX
			mov		AH,CS:is_active
			cmp		AH,0
			je		never_mind
			pop		AX
			popf				; restore flags

			push	si
			call		cmd_inc	; add one to tally for cmd on drive
			pop		si
			pop		bx	; fix up the stack
			pop		cx
			pop		dx
			and		dx,0FFFEh	; Return OK (carry flag zero)
			push 		dx cx bx
			mov		ah,0
			iret
query_service:
			cmp		DL,1
			ja		do_query
			mov		CS:is_active,DL
			mov		AX,0CCFFh
			iret
do_query:
			push	si
			call		query_get
			pop		si
			iret


;****************************************************
; Resident data area
;****************************************************
is_active	db		0
bios_old 	label	dword
biosoff 	dw		0
biosseg 	dw		0

D80	dw	256 dup (0)
D81	dw	256 dup (0)
D82	dw	256 dup (0)
D83	dw	256 dup (0)
D84	dw	256 dup (0)
DriveTab dw D80,D81,D82,D83,D84



install:
			get_date date		; add date to signoff line
			get_time time		; add time to signoff line

			mov		ax,get_i13			; get DISK BIOS interrupt vector
			int		doscall

			mov		biosoff,bx			; save offset of DISK handler
			mov		biosseg,es			; and segment

			lea		dx,tally_service	; set address of new disk service
			mov		ax,set_i13		;
			int		doscall

			lea		dx,query_service
			mov		ax,set_i17
			int		doscall

			print	signon			; print signoff message

;			lea		dx,usage			; calculate resident part size
			lea		dx,install			; calculate resident part size
			add		dx,110h				; don't forget PSP
			mov		cx,4
			shr		dx,cl				; size is in paragraphs!!!
			inc		dx					; round up by 1
			mov		ax,dos_tsr			; get ready to TSR
			int		doscall				; Now TSR


;****************************************************
; non-resident data area
;****************************************************

signon 		db		'Monitor BIOS interrupt 13h (disk service)',cr,lf
			db		??filename,' compiled on '
			db		??date,' at ',??time,cr,lf
 			db		'@(#) Version 1.1 Created 07/29/03 at 07:28:05',cr,lf
signoff		db		'Now ('
date		db		'99/99/99 at '
time		db		'99:99:99) Going . . .  TSR',cr,lf,'$'
			end		start
