static char *SCCS_ID = "@(#) sig-log.cpp Version 1.1 Created 10/30/03 at 10:17:12";

/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/

/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/


/******************************************************************************
*
*
*  SIG-LOG records operator observations of A/V signals from a SWB tool
*
******************************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <time.h>



/******************************************************************************

The main routine
	The commands in each category are defined in wb-defs.h
******************************************************************************/

int main (int np, char **p)
{

	char ans,buffer[80];
	int	i;

	FILE	*wb_log = stdout;
	static time_t from; /* program start time */

	time(&from);


	if (np != 4) {
   	printf ("Usage: %s Case Host User\n",p[0]);
		return 1;
	}
	wb_log = fopen("A:\\SIG-LOG.TXT","w");
	if (wb_log == NULL){
		printf ("%s: could not open log file\n");
		return 1;
	}
	fprintf (wb_log,"CMD: %s",p[0]);
	for (i = 1; i < np; i++) fprintf (wb_log," %s",p[i]);
	fprintf (wb_log,"\n");

	fprintf (wb_log,"Case: %s\n",p[1]);
	fprintf (wb_log,"Date: %s\n",ctime(&from));
	fprintf (wb_log,"Version: %s\n\tCompiled on %s at %s\n",
		SCCS_ID,__DATE__,__TIME__);
	fprintf (wb_log,"Operator: %s\n",p[3]);
	fprintf (wb_log,"Host: %s\n",p[2]);
	fprintf (wb_log,"\n");
	ans = ' ';
	do {
		printf ("Was a audio/visual signal observed [y|n]? ");
      fgets (buffer,80,stdin);
		sscanf (buffer,"%c",&ans);
	}
	while ((ans != 'y') && (ans != 'n'));
	fprintf (wb_log,"SIGNAL: %c\n",ans);

	
	return 0;
}
