static char *SCCS_ID = "@(#) t-off.cpp Version 1.1 Created 08/02/03 at 16:24:48";

/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/

/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/


/******************************************************************************
*
*  Test-hdl works with the TALLY13 TSR program to test int 13 based hard drive
*  software write block tools. The TALLY13 program intercepts all commands passed
*  by a SWB tool under test and keeps a count of the number of times each command
*  is sent to each hard drive. The TALLY13 program can also be quered about the
*  current count of each command sent to each hard drive. The query interface is
*  implemented by using int 17h (normally the printer).
*
*  T-OFF Turns off the TALLY13 monitor and blocking function
*
******************************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <time.h>



/******************************************************************************

The main routine
	The commands in each category are defined in wb-defs.h
******************************************************************************/

int main (int np, char **p)
{

	int		i			/* loop index */;
	unsigned int		is_active; /* indicates that tally13 TSR active */
	/* definitions of command sets (categories) */

	FILE	*wb_log = stdout;
	static time_t from; /* program start time */

	time(&from);


	if (np != 4) {
   	printf ("Usage: %s Case Host User\n",p[0]);
		return 1;
	}
	wb_log = fopen("A:\OFF-LOG.TXT","w");
	if (wb_log == NULL){
		printf ("%s: could not open log file\n");
		return 1;
	}
	fprintf (wb_log,"CMD: %s",p[0]);
	for (i = 1; i < np; i++) fprintf (wb_log," %s",p[i]);
	fprintf (wb_log,"\n");

	fprintf (wb_log,"Case: %s\n",p[1]);
	fprintf (wb_log,"Date: %s\n",ctime(&from));
	fprintf (wb_log,"Version: %s\n\tCompiled on %s at %s\n",
		SCCS_ID,__DATE__,__TIME__);
	fprintf (wb_log,"Operator: %s\n",p[3]);
	fprintf (wb_log,"Host: %s\n",p[2]);
	fprintf (wb_log,"\n");

	/* Deactivate tally13*/
	asm {
		mov	dl,0
		int	0x17
		mov	is_active,ax
	}
	if (is_active != 0xCCFF){
		printf ("Test Harness is not active\n");
		return 1;
	}
	return 0;
}
