#if !defined(AFX_DEVICETREEVIEW_H__EA2D0EA4_50C7_4A3C_AD61_09D7B6EAB157__INCLUDED_)
#define AFX_DEVICETREEVIEW_H__EA2D0EA4_50C7_4A3C_AD61_09D7B6EAB157__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DeviceTreeView.h : header file
//

#include "afxcview.h"
#include "afxtempl.h"
#include "WriteblockerDoc.h"
#include "StorageDevices.h"
#include "NetworkDrives.h"

/////////////////////////////////////////////////////////////////////////////
// CDeviceTreeView view

class CDeviceTreeView : public CTreeView
{
protected:
	CDeviceTreeView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CDeviceTreeView)

// Attributes
public:

// Operations
public:
	void PopulateLocalDevicesTree();
	void PopulateNetworkDrivesTree();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDeviceTreeView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CDeviceTreeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void LoadImageList();
	void DeleteChildren(HTREEITEM hTreeItem);

	// Generated message map functions
protected:
	//{{AFX_MSG(CDeviceTreeView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnRclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDeviceWriteblock();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	// routines to manage local devices tree
	HTREEITEM AddLocalController(PCONTROLLER_DEVICE pController);
	int GetImageIndex(PCONTROLLER_DEVICE pController);
	HTREEITEM GetLocalControllerInsertionPos(PCONTROLLER_DEVICE pController);

	HTREEITEM AddLocalStorageDevice(PSTORAGE_DEVICE pStorageDevice, HTREEITEM hController);
	int GetImageIndex(PSTORAGE_DEVICE pStorageDevice);

	void RemoveLocalDevice(DEVINST dnDevInst);
	HTREEITEM FindLocalDevice(DEVINST dnDevInst);

	// routines to manage network drives tree
	HTREEITEM AddNetworkDrive(PNETWORK_DRIVE pNetworkDrive, char cDriveLetterToDisplay);
	int GetImageIndex(PNETWORK_DRIVE pNetworkDrive);
	void RemoveNetworkDrive(char cDriveLetter);
	HTREEITEM FindNetworkDrive(char cDriveLetter);

	// event notification routines
	void ProcessLocalDeviceEvent(PMEDIA_EVENT pMediaEvent);
	void ProcessNetworkDriveEvent(PMEDIA_EVENT pMediaEvent);

	int GetChildrenCount(HTREEITEM hTreeItem);
	BOOL IsLocalDevice(HTREEITEM hTreeItem);
	BOOL IsNetworkDrive(HTREEITEM hTreeItem);

	// attributes
	CTreeCtrl* m_pTreeCtrl;
	HTREEITEM m_hLocalDevices;
	HTREEITEM m_hNetworkDrives;
	CImageList m_ImageList;
	CMap<UINT, UINT, int, int> m_ImageMap;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DEVICETREEVIEW_H__EA2D0EA4_50C7_4A3C_AD61_09D7B6EAB157__INCLUDED_)
