// {F2D484F4-6331-49f8-BB9D-BEE22CAFC7BA}
DEFINE_GUID(GUID_SWB_TEST_SUITE, 
0xf2d484f4, 0x6331, 0x49f8, 0xbb, 0x9d, 0xbe, 0xe2, 0x2c, 0xaf, 0xc7, 0xba);
//
// GUID definition are required to be outside of header inclusion pragma to avoid
// error during precompiled headers.
//
#if !defined(_SWBTS_H_)
#define _SWBTS_H_
#include <ntddk.h>

// Define the test suite device type

#define SWBTS_DEVICE_TYPE			0x8000

// Define the IOCTL codes for the test suite device

#define IOCTL_SWBTS_IRP_PASSTHRU	CTL_CODE(SWBTS_DEVICE_TYPE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS) 			   
#define IOCTL_SWBTS_IRP_CATCH_ON	CTL_CODE(SWBTS_DEVICE_TYPE, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SWBTS_IRP_CATCH_OFF	CTL_CODE(SWBTS_DEVICE_TYPE, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Define custom NTSTATUS values

#define STATUS_SWBTS_CAUGHT             ((NTSTATUS)0x3FFF00000)

/**

_IRP_DESCRIPTOR

This descriptor is used by user mode programs to construct kernel mode IRP's and execute them
via the Software Write Blocker test Suite's kernel mode drivers. This descriptor is passed to
the kernel mode driver with the DeviceIoControl function. The descriptor is used with the
IOCTL_IRP_PASSTHROUGH device control code.

Members

	IoStackLocation - an IO_STACK_LOCATION structure containing a user mode copy of the
					  I/O request to be issued by the test suite's kernel mode driver.
    IoStatusBlock	- an IO_STATUS_BLOCK structure to be filled in by the test suite device
					  kernel mode driver upon completion of the I/0 request
**/

typedef struct _IRP_PASSTHRU_DESCRIPTOR
{
	IO_STACK_LOCATION		IoStackLocation;
	IO_STATUS_BLOCK			IoStatusBlock;
} IRPD, *PIRPD;


#endif
