// Writeblocker.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Writeblocker.h"
#include "MainFrm.h"
#include "WriteblockerDoc.h"
#include "WriteblockerView.h"
#include "StorageDevices.h"
#include "NetworkDrives.h"
#include "DriversInterface.h"

//DPA - removed - not provided by FBI/BAH
#include "..\..\..\..\..\COTS Utilities\HTML Help\Include\htmlhelp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WRITEBLOCKER_HELP_FILE			"Writeblockerhelp.chm"

CStorageDevices LocalDevices;			// used to track local devices
CNetworkDrives NetworkDrives;			// used to track network drives
CDriversInterface DriversInterface;		// Interface to the Drivers

/////////////////////////////////////////////////////////////////////////////
// CWriteblockerApp

BEGIN_MESSAGE_MAP(CWriteblockerApp, CWinApp)
	//{{AFX_MSG_MAP(CWriteblockerApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(IDM_HELP_CONTENTS, OnHelpContents)
	ON_COMMAND(IDM_HELP_SEARCH, OnHelpSearch)
	ON_COMMAND(IDM_HELP_INDEX, OnHelpIndex)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWriteblockerApp construction

CWriteblockerApp::CWriteblockerApp()
{
	m_szWorkingDir[0] = '\0';

	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWriteblockerApp object

CWriteblockerApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CWriteblockerApp initialization

BOOL CWriteblockerApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CWriteblockerDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CWriteblockerView));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOWMAXIMIZED);
	m_pMainWnd->UpdateWindow();

	// store working directory
	if (GetCurrentDirectory(sizeof(m_szWorkingDir), m_szWorkingDir)) {
		if (m_szWorkingDir[strlen(m_szWorkingDir)-1] != '\\')
			strcat(m_szWorkingDir, "\\");
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CListBox	m_VersionList;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_VERSION_LIST, m_VersionList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CString csVersion;
	char szDriversVersion[100] = "";

	// retrieve and display the versions of drivers and dll
	DriversInterface.GetDriversVersion ( &szDriversVersion[0] );

	csVersion.Format("NTWBFS.SYS\t\t%s", szDriversVersion);
	m_VersionList.AddString(csVersion);

	csVersion.Format("NTWBPM.SYS\t\t%s", szDriversVersion);
	m_VersionList.AddString(csVersion);

	csVersion.Format("OSR-HOOK.SYS\t\t%s", szDriversVersion);
	m_VersionList.AddString(csVersion);

	m_VersionList.AddString("OSR-RECOGNIZER.SYS\tFDDK-V4.2");

	m_VersionList.AddString("OSR-FILTER.SYS\t\tFDDK-V4.2");
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// App command to run the dialog
void CWriteblockerApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CWriteblockerApp message handlers


void CWriteblockerApp::OnHelpContents() 
{
	char szHelpFile[_MAX_PATH];

	// get location of help file
	sprintf(szHelpFile, "%s%s", m_szWorkingDir, WRITEBLOCKER_HELP_FILE);

	// display help file
	HWND hWnd = HtmlHelp(GetDesktopWindow(), szHelpFile,
		HH_DISPLAY_TOC, NULL);
}

void CWriteblockerApp::OnHelpSearch() 
{
	HH_FTS_QUERY Query;
	char szHelpFile[_MAX_PATH];

	// get location of help file
	sprintf(szHelpFile, "%s%s", m_szWorkingDir, WRITEBLOCKER_HELP_FILE);

	// display help file
	memset(&Query, 0, sizeof(Query));
	Query.cbStruct = sizeof(Query);

	HWND hWnd = HtmlHelp(GetDesktopWindow(), szHelpFile,
		HH_DISPLAY_SEARCH, (DWORD) &Query);
}

void CWriteblockerApp::OnHelpIndex() 
{
	char szHelpFile[_MAX_PATH];

	// get location of help file
	sprintf(szHelpFile, "%s%s", m_szWorkingDir, WRITEBLOCKER_HELP_FILE);

	// display help file
	HWND hWnd = HtmlHelp(GetDesktopWindow(), szHelpFile,
		HH_DISPLAY_INDEX, NULL);
}
