#include <srb.h>

// {F2D484F4-6331-49f8-BB9D-BEE22CAFC7BA}
DEFINE_GUID(GUID_SWB_TEST_SUITE, 
0xf2d484f4, 0x6331, 0x49f8, 0xbb, 0x9d, 0xbe, 0xe2, 0x2c, 0xaf, 0xc7, 0xba);
//
// GUID definition are required to be outside of header inclusion pragma to avoid
// error during precompiled headers.
//
#if !defined(_SWBTS_H_)
#define _SWBTS_H_

/**

This structure is used by user mode programs to construct and execute kernel mode IRP's.
The Software Write Blocker Test Suite application passes this structure as a common input
and output buffer in a DeviceIoControl request to the test suite's upper filter driver. The
device control code for this request is IOCTL_IRP_PASSTHRU, a custom code implemented by the
test suite's upper filter driver. The upper filter driver holds the IOCTL request and constructs
a kernel mode IRP from the data in the input buffer. The kernel mode IRP is then passed down the
device stack to lower drivers in place of the original IOCTL. When the substitute IRP completes
the upper filter driver overwrites the original contents of the IOCTL input buffer with the final
contents of the IO_STATUS_BLOCK and IO_STACK_LOCATION of the substitute IRP. It then completes
the DeviceIoControl request. The user mode application can then interrogate the results returned
in the USER_IRP structure to determine the disposition of the generated IRP.

   Members
   -------

   IoStatusBlock   - an IO_STATUS_BLOCK structure to be filled in by the kernel mode
                     driver upon completion of the I/0 request.

   IoStackLocation - an IO_STACK_LOCATION structure containing a user mode copy of an
					 IRP to be issued by the test suite's kernel mode driver. It is
					 overwritten by the kernel driver with the final status of the
					 kernel mode IRP.
   Parameters      - a structure containing IRP function dependent parameters

**/


typedef struct _USER_IRP
{
   IO_STATUS_BLOCK                      IoStatus;
   IO_STACK_LOCATION                    IoStack;
   union
   {
      struct
      {
         SCSI_REQUEST_BLOCK		Srb;
         UCHAR                          SenseInfo[128];
         UCHAR                          Data[512];
      } Scsi;
   } Parameters;
} USER_IRP, *PUSER_IRP;

// Test suite device type and IOCTL codes

#define SWBTS_DEVICE_TYPE			0x8000
#define IOCTL_IRP_PASSTHRU CTL_CODE(SWBTS_DEVICE_TYPE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS) 			   

// Custom NTSTATUS values - SWBTS Facility Code = FFF

#define STATUS_SWBTS_CAUGHT             ((NTSTATUS) 0x2FFF0000L)

// The following arrays contain lists of IRP major functions by test category

unsigned char IRP_WRITE[] =
{
	IRP_MJ_CREATE, 			IRP_MJ_WRITE,	     		IRP_MJ_SET_INFORMATION,
	IRP_MJ_SET_EA,			IRP_MJ_SET_VOLUME_INFORMATION, 	IRP_MJ_DIRECTORY_CONTROL,
	IRP_MJ_INTERNAL_DEVICE_CONTROL,	IRP_MJ_SET_SECURITY,		IRP_MJ_SET_QUOTA
};

unsigned char IRP_READ[] = {IRP_MJ_READ};

unsigned char IRP_CONTROL[] =
{
	IRP_MJ_CLOSE,			IRP_MJ_FLUSH_BUFFERS,		IRP_MJ_SHUTDOWN,
	IRP_MJ_LOCK_CONTROL,		IRP_MJ_CLEANUP,			IRP_MJ_POWER,
	IRP_MJ_SYSTEM_CONTROL,		IRP_MJ_DEVICE_CHANGE,		IRP_MJ_PNP
};

unsigned char IRP_INFO[] =
{
	IRP_MJ_QUERY_INFORMATION,	IRP_MJ_QUERY_EA,			IRP_MJ_QUERY_VOLUME_INFORMATION,
	IRP_MJ_QUERY_SECURITY,		IRP_MJ_QUERY_QUOTA
};

unsigned char IRP_MISC[] =
{
	IRP_MJ_CREATE_NAMED_PIPE,	IRP_MJ_CREATE_MAILSLOT
};

#endif // _SWBTS_H_
