// Install.cpp : implementation file for installing the drivers
//
// PROGRAMMER:		CJS
// DATE:      		May 20, 1998
// DESCRIPTION:		This installs the drivers by adding the reqistry keys and copying
//					the *.sys files to the appropriate directory.
//
// REVISIONS:                                                        
//			inits	mm/dd/yy	description
//      	-----	--------	-------------------------------------------
//   		cjs		05/20/98	Initial write
//			ejs		03/25/99	seperate FS & PM
//			ejs		04/20/99	Added code to allow to select the install from dir from Command Line
//

#include "stdafx.h"
#include "WriteBlocker.h"
#include "CommonFunctions.h"
#include "ntwbfs.h"
#include "StorageDevices.h"
#include "Uninstall.h"
#include "Install.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CStorageDevices LocalDevices;

/////////////////////////////////////////////////////////////////////////////
// CInstall dialog


CInstall::CInstall(CWnd* pParent /*=NULL*/)
	: CDialog(CInstall::IDD, pParent)
{
	m_csDriverSourceDir = "None";
	//{{AFX_DATA_INIT(CInstall)
	m_AutolockNetworkDrives = FALSE;
	m_AutolockPhysicalMedia = FALSE;
	//}}AFX_DATA_INIT
}


void CInstall::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInstall)
	DDX_Check(pDX, IDC_INSTALL_AUTOLOCKNETWORKDRIVES_CHECK, m_AutolockNetworkDrives);
	DDX_Check(pDX, IDC_INSTALL_AUTOLOCKPHYSICALMEDIA_CHECK, m_AutolockPhysicalMedia);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInstall, CDialog)
	//{{AFX_MSG_MAP(CInstall)
	ON_BN_CLICKED(IDOK, OnInstallButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInstall message handlers

void CInstall::OnInstallButton() 
{
	CUninstall Uninstall;
	CString csText;
	bool bSuccessRegistry = TRUE;

	UpdateData(TRUE);
		
	// install OSR-Filter driver
	if (!(bSuccessRegistry = InstallOSRFilter())) {

		csText.Format("%s did not install correctly.\nOSR-Filter did not install.\nThe install program aborted.",
			WRITEBLOCKER_APP_NAME);
		MessageBox(csText, WRITEBLOCKER_APP_NAME, MB_ICONERROR | MB_OK);
	}

	// if previous driver installed successfully
	if (bSuccessRegistry) {

		// install OSR-Hook driver
		if (!(bSuccessRegistry = InstallOSRHook())) {

			csText.Format("%s did not install correctly.\nOSR-Hook did not install.\nThe install program aborted.",
				WRITEBLOCKER_APP_NAME);
			MessageBox(csText, WRITEBLOCKER_APP_NAME, MB_ICONERROR | MB_OK);
		}
	}

	// if previous driver installed successfully
	if (bSuccessRegistry) {

		// install OSR-Recognizer driver
		if (!(bSuccessRegistry = InstallOSRRecognizer())) {
			
			csText.Format("%s did not install correctly.\nOSR-Recognizer did not install.\nThe install program aborted.",
				WRITEBLOCKER_APP_NAME);
			MessageBox(csText, WRITEBLOCKER_APP_NAME, MB_ICONERROR | MB_OK);
		}
	}
	
	// if previous driver installed successfully
	if (bSuccessRegistry) {

		// install NTWBFS driver
		if (!(bSuccessRegistry = InstallNTWBFS(m_AutolockPhysicalMedia,
			m_AutolockNetworkDrives))) {

			csText.Format("%s did not install correctly.\nNTWBFS did not install.\nThe install program aborted.",
				WRITEBLOCKER_APP_NAME);
			MessageBox(csText, WRITEBLOCKER_APP_NAME, MB_ICONERROR | MB_OK);
		}
	}
	
	// if previous driver installed successfully
	if (bSuccessRegistry) {

		// install NTWBPM driver
		if (!(bSuccessRegistry = InstallNTWBPM(m_AutolockPhysicalMedia))) {

			csText.Format("%s did not install correctly.\nNTWBPM did not install.\nThe install program aborted.",
				WRITEBLOCKER_APP_NAME);
			MessageBox(csText, WRITEBLOCKER_APP_NAME, MB_ICONERROR | MB_OK);
		}
	}

	// if all Write Blocker drivers installed successfully, prompt user to 
	// reboot
	if (bSuccessRegistry) {
		csText.Format("%s drivers were installed properly.\n\nDo you want to reboot now?",
			WRITEBLOCKER_APP_NAME);

		if (MessageBox(csText, WRITEBLOCKER_APP_NAME, MB_ICONINFORMATION | 
			MB_YESNO) == IDYES)
			ShutdownRestartSystem();
	}

	// set indication that Write Blocker drivers have been installed
	if (bSuccessRegistry) {
		CDialog::OnOK();
		return;
	}

	// if an error occurred then uninstall any drivers that have been installed
	Uninstall.UninstallDriver("SYSTEM\\CurrentControlSet\\Services\\OSR-FILTER","OSR-Filter", "OSR-Filter.sys");
	Uninstall.UninstallDriver("SYSTEM\\CurrentControlSet\\Services\\OSR-RECOGNIZER","OSR-Recognizer", "OSR-Recognizer.sys");
	Uninstall.UninstallDriver("SYSTEM\\CurrentControlSet\\Services\\NTWBFS","NTWBFS", "NTWBFS.SYS");
	Uninstall.UninstallDriver("SYSTEM\\CurrentControlSet\\Services\\OSR-HOOK","OSR-HOOK", "OSR-Hook.sys");
	Uninstall.UninstallDriver("SYSTEM\\CurrentControlSet\\Services\\NTWBPM","NTWBPM", "NTWBPM.SYS");

	CDialog::OnOK();
}

// Functions for Odds and Ends
//
bool CInstall::InstallRegistryServiceKey(const _TCHAR * szKeyName, 
								  DWORD dwDriverType, DWORD dwDriverStart,
								  const _TCHAR * szGroupName, DWORD dwDriverErrorControl,
								  const _TCHAR * szDisplayName, DWORD dwDriverTag)
{
	HKEY hKey;
	LONG dStatus = ERROR_SUCCESS;

	// open the driver registry key (e.g., SYSTEM\CurrentControlSet\Services\
	// NTWBFS",-- if it doesn't exists, create it
	if ((RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKeyName, 0, KEY_ALL_ACCESS, 
		&hKey)) != ERROR_SUCCESS) {

		 if (RegCreateKey(HKEY_LOCAL_MACHINE, szKeyName, &hKey) != ERROR_SUCCESS)
			return FALSE;
	}
	
	// write "Type" value to registry
	dStatus = RegSetValueEx(hKey, "Type", 0, REG_DWORD, (LPBYTE) &dwDriverType, 
		sizeof(dwDriverType));

	// if "Type" value written successfully, write "Start" value
	if (dStatus == ERROR_SUCCESS) {

		dStatus = RegSetValueEx(hKey, "Start", 0, REG_DWORD,
			(LPBYTE) &dwDriverStart, sizeof(dwDriverStart));
	}

	// if "Start" value written successfully, write "Group" value
	if (dStatus == ERROR_SUCCESS) {
	
		dStatus = RegSetValueEx(hKey, "Group", 0, REG_SZ,
			(CONST BYTE *) szGroupName, (DWORD) (_tcslen(szGroupName) + 1));
	}
	
	// if "Group" value written successfully, write "ErrorControl" value
	if (dStatus == ERROR_SUCCESS) {
	
		dStatus = RegSetValueEx(hKey, "ErrorControl", 0, REG_DWORD,
			(LPBYTE) &dwDriverErrorControl, sizeof(dwDriverErrorControl));
	}

	// if "ErrorControl" value written successfully, write "DisplayName" value
	if (dStatus == ERROR_SUCCESS) {
		
		dStatus = RegSetValueEx(hKey, "DisplayName", 0, REG_SZ,
			(CONST BYTE *) szDisplayName, (DWORD) (_tcslen(szDisplayName) + 1));
	}

	// if "DisplayName" value written successfully, write "Tag" value
	if (dStatus == ERROR_SUCCESS) {

		dStatus = RegSetValueEx(hKey, "Tag", 0, REG_DWORD,
			(LPBYTE) &dwDriverTag, sizeof(dwDriverTag));
	}
	
	RegCloseKey(hKey);

	return ((dStatus == ERROR_SUCCESS) ? TRUE : FALSE);
}

bool CInstall::InstallRegistryParameterKeyforNTWBFS(const _TCHAR * szKeyName,
													BOOL bAutoLockLocalDrives,
													BOOL bAutoLockNetworkDrives)
{
	HKEY hParamKey;
	DWORD dwValue;
	LONG dStatus = ERROR_SUCCESS;
	
	// open the "Parameters" registry key for NTWBFS -- if it doesn't exists, 
	// create it
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKeyName, 0, KEY_ALL_ACCESS, 
		&hParamKey) != ERROR_SUCCESS) {

		if (RegCreateKey(HKEY_LOCAL_MACHINE, szKeyName, &hParamKey) != ERROR_SUCCESS)
			return FALSE;
	}

	//
	// During testing, we noticed that the HKLM\System registry file was
	// getting corrupted on various occasions, possibly due to us writing to 
	// the registry.  NTWBFS was changed so that we no longer write this value.
	// Therefore, we need to disable it here too.
	//
	/*// write "AutoLockLocalDrives" value to registry
	dwValue = bAutoLockLocalDrives ? NTWBFS_AUTOBLOCK_SPEC : NTWBFS_AUTOBLOCK_NONE;
	dStatus = RegSetValueEx(hParamKey, "AutoLockLocalDrives", 0, REG_DWORD, 
		(LPBYTE) &dwValue, sizeof(dwValue));*/
	
	// if "AutoLockLocalDrives" value written successfully, write 
	// "AutoLockNetworkDrives" value to registry
	if (dStatus == ERROR_SUCCESS) {
	
		dwValue = bAutoLockNetworkDrives ? 1 : 0;
		dStatus = RegSetValueEx(hParamKey, "AutoLockNetworkDrives", 0, 
			REG_DWORD, (LPBYTE) &dwValue, sizeof(dwValue));
	}

	//
	// During testing, we noticed that the HKLM\System registry file was
	// getting corrupted on various occasions, possibly due to us writing to 
	// the registry.  NTWBFS was changed so that we no longer write this value.
	// Therefore, we need to disable it here too.
	//
	// if "AutoLockNetworkDrives" value written successfully
	/*if (dStatus == ERROR_SUCCESS) {
		char szSystemDrive[8];

		// At this point, LocalDevices doesn't know which drive numbers
		// correspond to which devices since it relies on the Write Blocker
		// drivers for this info and if we're installing Write Blocker then the
		// drivers haven't been loaded yet.  Therefore, we can't don't know
		// which partitions reside on the system drive.  However, LocalDevices 
		// does know the system drive letter.  We'll only write the system
		// drive letter rather than all the drive letters that have been
		// assigned to the system partition.  This is OK though since NTWBFS
		// doesn't read this value on startup.  NTWBFS will query NTWBPM to 
		// determine the system drive letters and then update this value.
		sprintf(szSystemDrive, "%c", LocalDevices.GetSystemDriveLetter());

		dStatus = RegSetValueEx(hParamKey, "ExcludeBootDrive", 0, REG_SZ,
			(LPBYTE)szSystemDrive, strlen(szSystemDrive) + 1);
	}*/

	RegCloseKey(hParamKey);

	return ((dStatus == ERROR_SUCCESS) ? TRUE : FALSE);
}

bool CInstall::InstallRegistryParameterKeyforNTWBPM(const _TCHAR * szKeyName, 
								  BOOL bAutoLock, LPBYTE lpbExclude)
{
	HKEY hParamKey;
	LONG dStatus = ERROR_SUCCESS;
	
	// open the "Parameters" registry key for NTWBPM -- if it doesn't exists, 
	// create it
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, szKeyName, 0, KEY_ALL_ACCESS, 
		&hParamKey) != ERROR_SUCCESS) {

		if (RegCreateKey(HKEY_LOCAL_MACHINE, szKeyName, &hParamKey) != ERROR_SUCCESS)
			return FALSE;
	}	

	//
	// During testing, we noticed that the HKLM\System registry file was
	// getting corrupted on various occasions, possibly due to us writing to 
	// the registry on bootup via NTWBPM.  NTWBPM was changed so that we no
	// longer write this value.  Therefore, we need to disable it here too.
	//
	/*// write "Exclude" value to registry
	dStatus = RegSetValueEx(hParamKey, "Exclude", 0, REG_SZ,
		(LPBYTE)lpbExclude, ((WORD)lstrlen((LPSTR)lpbExclude) + 1) * sizeof(TCHAR));*/

	// delete the "Unblocked" registry subkey so that we can start with an 
	// empty one - we'll create one in a little bit
	RegDeleteKey(hParamKey, "Unblocked");

	RegCloseKey(hParamKey);

	// if "Exclude" value written successfully
	if (dStatus == ERROR_SUCCESS) {
		HKEY hUnblockedKey;
		char szUnblockedKey[256];
		DWORD dwMediaCount = 0;

		// get name of "Unblocked" registry subkey for NTWBPM
		sprintf(szUnblockedKey, "%s\\Unblocked", szKeyName);

		// create the "Unblocked" registry subkey
		if (RegCreateKey(HKEY_LOCAL_MACHINE, szUnblockedKey, &hUnblockedKey) 
			!= ERROR_SUCCESS)
			return FALSE;

		// write "Count" value to registry - we're setting the initial media 
		// count for unblocked drives to zero
		dStatus = RegSetValueEx(hUnblockedKey, "Count", 0, REG_DWORD, 
			(LPBYTE) &dwMediaCount, sizeof(dwMediaCount));

		RegCloseKey(hUnblockedKey);

		// if "Count" value written successfully
		if (dStatus == ERROR_SUCCESS) {

			// if we're not supposed to auto-lock any physical media, add each
			// media to the "Unblocked" registry subkey
			if (!bAutoLock) {
				CONTROLLER_DEVICE Controller;

				// step through our list of controllers
				if (LocalDevices.GetFirstController(&Controller)) {
					STORAGE_DEVICE StorageDevice;

					do {

						// step through this controller's list of storage
						// devices
						if (LocalDevices.GetFirstStorageDevice(Controller.dnDevInst,
							&StorageDevice)) {

							do {
								// add the device to the "Unblocked" registry
								// subkey - calling AutoBlockDevice will
								// automatically update the "Count" value
								LocalDevices.AutoBlockDevice(StorageDevice.dnDevInst,
									FALSE);
							} while (LocalDevices.GetNextStorageDevice(&StorageDevice));
						}
					} while (LocalDevices.GetNextController(&Controller));
				}
			}
		}
	}

	return ((dStatus == ERROR_SUCCESS) ? TRUE : FALSE);
}

bool CInstall::AddNTWBPMToUpperFilters(char* szDeviceClassGUID)
{
	HKEY hKey;

	// open registry key for device class
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, szDeviceClassGUID, 0, 
		KEY_ALL_ACCESS, &hKey ) == ERROR_SUCCESS ) {
		char* pszCurrValue = NULL;
		char* pszNewValue;
		DWORD dwDataType, dwNewValueLen, dwCurrValueLen = 0;
		WORD wNTWBPMLen = strlen(NTWBPM_DRIVER_NAME);

		// get length of data in "UpperFilters" registry value
		RegQueryValueEx(hKey, "UpperFilters", NULL, &dwDataType, NULL,
			&dwCurrValueLen);

		if (dwCurrValueLen > 0) {
			char* pChar;

			dwNewValueLen = dwCurrValueLen + wNTWBPMLen + 1;
			pszNewValue = new char[dwNewValueLen];

			// "NTWBPM" will be the first string in the multi-string
			strcpy(pszNewValue, NTWBPM_DRIVER_NAME);

			pChar = pszNewValue + wNTWBPMLen + 1;

			pszCurrValue = new char[dwCurrValueLen];

			// get value of "UpperFilters" registry value
			if (RegQueryValueEx(hKey, "UpperFilters", NULL, &dwDataType,
				(BYTE*) pszCurrValue, &dwCurrValueLen) == ERROR_SUCCESS) {

				// append current value to new value
				memcpy(pChar, pszCurrValue, dwCurrValueLen);
			}
			else
				*pChar = '\0';

			delete[] pszCurrValue;
		}
		else {
			// allocate buffer to hold new value
			dwNewValueLen = wNTWBPMLen+2;
			pszNewValue = new char[dwNewValueLen];

			strcpy(pszNewValue, NTWBPM_DRIVER_NAME);

			// this is a multi-string so it has to be double null-terminated
			pszNewValue[wNTWBPMLen+1] = '\0';
		}

		// set new value for "UpperFilters"
		RegSetValueEx(hKey, "UpperFilters", 0, REG_MULTI_SZ, 
			(BYTE*) pszNewValue, dwNewValueLen);

		delete[] pszNewValue;

		RegCloseKey(hKey);

		return TRUE;
	}

	return FALSE;
}

bool CInstall::InstallCopySystemFile(char szSystemFileToCopy[])
{
	char szTemp[_MAX_PATH];
	CString csSource, csDestination;

	// check if Write Blocker drivers directory is specified
	if (m_csDriverSourceDir != "None")
		csSource = m_csDriverSourceDir;
	// else if not specified, drivers directory should be located beneath the
	// directory that the Write Blocker app is running from
	else {
		char szDrive[_MAX_DRIVE], szPath[_MAX_PATH];

		// get full path of Write Blocker app
		GetModuleFileName(NULL, szTemp, sizeof(szTemp));

		// split full path into drive letter and path name
		_splitpath(szTemp, szDrive, szPath, NULL, NULL);

		// get path of drivers directory
		csSource.Format("%s%sDrivers\\", szDrive, szPath);
	}
	
	csSource += szSystemFileToCopy;

	// get Windows directory
	GetWindowsDirectory(szTemp, MAX_PATH);
	
	// get destination path to copy the driver file to
	csDestination.Format("%s\\System32\\Drivers\\%s", szTemp, 
		szSystemFileToCopy);

	// remove any attributes that may prevent the copy
	SetFileAttributes(csDestination, FILE_ATTRIBUTE_NORMAL);
 
	return (CopyFile(csSource, csDestination, FALSE) != 0);
}

bool CInstall::InstallOSRFilter()
{
	// install registry service key for OSR-Filter
	if (InstallRegistryServiceKey("SYSTEM\\CurrentControlSet\\Services\\OSR-Filter", 
								  SERVICE_FILE_SYSTEM_DRIVER, 
								  SERVICE_SYSTEM_START,
								  "Base", 
								  SERVICE_ERROR_NORMAL,
								  "OSR-Filter", 
								  0xA)) {

		// copy driver to \System32\drivers directory
		if (InstallCopySystemFile("OSR-FILTER.SYS"))
			return TRUE;
	}

	return FALSE;
}

bool CInstall::InstallOSRHook()
{
	// install registry service key for OSR-Hook
	if (InstallRegistryServiceKey("SYSTEM\\CurrentControlSet\\Services\\OSR-Hook", 
								  SERVICE_FILE_SYSTEM_DRIVER, 
								  SERVICE_SYSTEM_START,
								  "Base", 
								  SERVICE_ERROR_NORMAL,
								  "OSR-Hook", 
								  0xB)) {

		// copy driver to \System32\drivers directory
		if (InstallCopySystemFile("OSR-HOOK.SYS"))
			return TRUE;
	}

	return FALSE;
}

bool CInstall::InstallOSRRecognizer()
{
	// install registry service key for OSR-Recognizer
	if ( InstallRegistryServiceKey("SYSTEM\\CurrentControlSet\\Services\\OSR-Recognizer", 
								  0x8, 
								  SERVICE_SYSTEM_START,
								  "Base", 
								  SERVICE_ERROR_NORMAL,
								  "OSR-Recognizer", 
								  0x9)) {

		// copy driver to \System32\drivers directory
		if (InstallCopySystemFile("OSR-RECOGNIZER.SYS"))
			return TRUE;
	}

	return FALSE;
}

bool CInstall::InstallNTWBFS(BOOL bAutoLockLocalDrives, BOOL bAutoLockNetworkDrives)
{
	// install registry service key for NTWBFS	
	if (InstallRegistryServiceKey("SYSTEM\\CurrentControlSet\\Services\\NTWBFS", 
								  SERVICE_FILE_SYSTEM_DRIVER, 
								  SERVICE_AUTO_START,
								  "Base", 
								  SERVICE_ERROR_NORMAL,
								  "NTWBFS", 
								  0xC)) {

		// install "Parameters" subkey for NTWBFS
		if (InstallRegistryParameterKeyforNTWBFS("SYSTEM\\CurrentControlSet\\Services\\NTWBFS\\Parameters", 
			bAutoLockLocalDrives, bAutoLockNetworkDrives)) {

			// copy driver to \System32\drivers directory
			if (InstallCopySystemFile("NTWBFS.SYS"))
				return TRUE;
		}
	}

	return FALSE;
}

bool CInstall::InstallNTWBPM(BOOL bAutoLockLocalDrives)
{
	// install registry service key for NTWBPM
	/*if (InstallRegistryServiceKey("SYSTEM\\CurrentControlSet\\Services\\NTWBPM", 
								  SERVICE_KERNEL_DRIVER, 
								  SERVICE_SYSTEM_START,
								  "Filter", 
								  SERVICE_ERROR_NORMAL,
								  "NTWBPM", 
								  0x1)) {*/
	if (InstallRegistryServiceKey(
					"SYSTEM\\CurrentControlSet\\Services\\NTWBPM", 
					SERVICE_KERNEL_DRIVER, 
					SERVICE_BOOT_START,
					"System Bus Extender", 
					SERVICE_ERROR_NORMAL,
					"NTWBPM", 
					0xA)) {

		BYTE Exclude[10];

		// NTWBPM doesn't rely on this value anymore.  On bootup, NTWBPM will 
		// update this value with what it thinks is the system partition.  
		// We'll just write dummy values here.  Exclude[1] and Exclude[2] 
		// identifies the system drive number.  Exclude[3] and Exclude[4] 
		// identifies the system partition number.
		Exclude[0] = NTWBFS_DRVTYPE_HD + '0';
		Exclude[1] = '0';
		Exclude[2] = '0';
		Exclude[3] = '0';
		Exclude[4] = '1';
		Exclude[5] = '\0';

		// install "Parameters" subkey for NTWBPM
		if (InstallRegistryParameterKeyforNTWBPM("SYSTEM\\CurrentControlSet\\Services\\NTWBPM\\Parameters", 
			bAutoLockLocalDrives, (LPBYTE) Exclude)) {

			// add NTWBPM to list of UpperFilters for CDROM class drivers
			if (AddNTWBPMToUpperFilters(REGKEY_CDROM_CLASS)) {
		
				// add NTWBPM to list of UpperFilters for disk class drivers
				if (AddNTWBPMToUpperFilters(REGKEY_DISKDRIVES_CLASS)) {

					// copy driver to \System32\drivers directory
					if (InstallCopySystemFile("NTWBPM.SYS"))
						return TRUE;
					else {
						CUninstall::RemoveNTWBPMFromUpperFilters(REGKEY_DISKDRIVES_CLASS);
						CUninstall::RemoveNTWBPMFromUpperFilters(REGKEY_CDROM_CLASS);
					}
				}
				else
					CUninstall::RemoveNTWBPMFromUpperFilters(REGKEY_CDROM_CLASS);
			}
		}
	}

	return FALSE;
}

BOOL CInstall::Install(CString szdir)
{
	m_csDriverSourceDir = szdir;

	// if necessary, append trailing backslash to path
	if (m_csDriverSourceDir[m_csDriverSourceDir.GetLength()-1] != '\\')
		m_csDriverSourceDir += '\\';

	if(!InstallOSRFilter()) {

#ifdef _DEBUG
		MessageBox("OsrFilt", NULL, MB_OK);
#endif
		return FALSE;
	}
	else if(!InstallOSRHook()) {

#ifdef _DEBUG
		MessageBox("OsrHook", NULL, MB_OK);
#endif
		return FALSE;
	}
	else if(!InstallOSRRecognizer()) {

#ifdef _DEBUG
		MessageBox("OsrRec", NULL, MB_OK);
#endif
		return FALSE;
	}
	else if(!InstallNTWBFS(FALSE, FALSE)) {

#ifdef _DEBUG
		MessageBox("NTWBFS", NULL, MB_OK);
#endif
		return FALSE;
	}
	else if(!InstallNTWBPM(0)) {

#ifdef _DEBUG
		MessageBox("NTWBPM", NULL, MB_OK);
#endif
		return FALSE;
	}

	return TRUE;
}
