static char *SCCS_ID[] = {"@(#) try_write.c Linux Version 1.3 created 12/14/11 at 16:08:54",__DATE__,__TIME__};
static char *test_version = "*** DEV VERSION ";

/*
 *
 * The software provided here is released by the National
 * Institute of Standards and Technology (NIST), an agency of
 * the U.S. Department of Commerce, Gaithersburg MD 20899,
 * USA.  The software bears no warranty, either expressed or
 * implied. NIST does not assume legal liability nor
 * responsibility for a User's use of the software or the
 * results of such use.
 *
 * Please note that within the United States, copyright
 * protection, under Section 105 of the United States Code,
 * Title 17, is not available for any work of the United
 * States Government and/or for any works created by United
 * States Government employees. User acknowledges that this
 * software contains work which was created by NIST employees
 * and is therefore in the public domain and not subject to
 * copyright.  The User may use, distribute, or incorporate
 * this software provided the User acknowledges this via an
 * explicit acknowledgment of NIST-related contributions to
 * the User's work. User also agrees to acknowledge, via an
 * explicit acknowledgment, that any modifications or
 * alterations have been made to this software before
 * redistribution.
 * --------------------------------------------------------------------
 *
 * Revision History:
 * 2011 May Ben Livelsberger - Created
 *
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <ctype.h>
#include "ataraw.h"
#ifdef HAVE_ERR_H
#include <err.h>
#endif

#ifndef HAVE_ERR
#include <stdarg.h>
void err(int eval,const char *fmt,...)
{
  va_list ap;
  va_start(ap,fmt);
  vfprintf(stderr,fmt,ap);
  va_end(ap);
  fprintf(stderr,": %s\n",strerror(errno));
  exit(eval);
}
#endif

const char *progname="main"; 

void usage()
{
  fprintf(stderr,"Usage: %s [-options] <device>     send all SCSI or ATA write\n",progname);
  fprintf(stderr,"\t\tcommands to device. try_write will try to guess whether\n\t\tdevice is SCSI or ATA.\n");
  fprintf(stderr,"Options:\n -a\tforce ATA write commands to be sent\n");
  fprintf(stderr," -s\tforce SCSI write commands to be sent\n");
  fprintf(stderr," -d\tprint extra debugging information\n\n");
  exit(1);
}

int main(int argc,char **argv)
{
  static time_t from;
    int opt;
    int force_ata = 0;
    int force_scsi = 0;
    int run_ata = 0;
    int run_scsi = 0;
    int result,i,write_cnt = 0;
    uint64_t sector_number;
    u_char buffer[SECTOR_SIZE];
    u_char rw_multiple_buffer[16*SECTOR_SIZE];    

    if (SCCS_ID[0][0] == '%') SCCS_ID[0] = test_version;
    progname = argv[0];
    time(&from);

    /* print all the file version and compilation info */
    printf ("%s %s%s\n",progname,ctime(&from),SCCS_ID[0]);
    //printf ("try_write %s\n",SCCS_ID[0]);
    printf ("compiled %s %s with gcc Version %s\n",__DATE__,
	    __TIME__,__VERSION__);
    printf ("%s%s%s\n",WRAPPER_C_ID,ATARAW_C_ID,ATARAW_H_ID);

    /* print the command line */
    printf("cmd: ");
    for(i=0; i<argc; i++) {
      printf(" %s", argv[i]);
    }
    printf("\n");


    while((opt=getopt(argc,argv,"das"))!=-1){
      switch(opt){
	// -d option for debug mode  
      case 'd':
	ataraw_debug = 1;
	break;
      case 'a':
	force_ata = 1;
	break;
      case 's':
	force_scsi = 1;
	break;
      default:
	usage();
      }
    }

    argc -= optind;
    argv += optind;

    if(argc<1) usage();

    const char *device = argv[0];

    argv++;
    argc--;

    int fd = open(device,O_RDONLY);
    if(fd<0){
      perror(device);
      exit(1);
    }

    /* Does fd refer to an ATA device or to a SCSI device? */
    int ext_cmd_support = 1; //default to "unsupported"
    int device_type = chk_device_type( fd );
    if ( device_type == ATA_RAW_ATA_DEVICE ){
      /* extended (48-bit) commands supported? */
      ext_cmd_support = chk_48bit_feature_support(fd);
      if( ext_cmd_support == ATA_RAW_ERR )
	err(1,"chk_48bit_feature_support() FAILED, RETURN CODE: %d\n",ext_cmd_support );
      printf("%s device type:\tATA\n", device);
      if( ext_cmd_support == 0 )
	printf("48-bit Address Feature Set:     SUPPORTED\n"); 
      else
	printf("48-bit Address Feature Set:     NOT SUPPORTED\n"); 
    } else if ( device_type == ATA_RAW_SCSI_DEVICE ){
      printf("%s device type:\tSCSI\n", device);
    } else {
      err(1,"%s:\tinvalid device -- SCSI, ATA command sets not supported\n", device );
    }

    /* select which write commands (ATA and/or SCSI) will be executed */
    if ( force_ata ){
      printf("*** forcing ata... ***\n\n");      
      run_ata = 1;
    }
    if ( force_scsi ){
      printf("*** forcing scsi... ***\n\n");
      run_scsi = 1;
    }
    if ( !( force_ata || force_scsi ) ){ // if we're not forcing ata or forcing scsi, then let device type determine which reads get executed
      if ( device_type == ATA_RAW_ATA_DEVICE )
	run_ata = 1;    
      else
	run_scsi = 1;
    }

  /* print column headers */
  printf("Opcode\tCommand Name\t\tReturn Code\n");    

    if ( run_ata ){
      /* if ATA, Goal: to issue each defined ATA write command */

      /* issue WRITE DMA - write "0000000 " pattern to sector 0xCA00 */
      sector_number = 51712;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_dma(fd,(int) sector_number,1,buffer);
      printf("CAh\tWRITE DMA\t\treturn code: %d\n",result);
      write_cnt++;

      // come back to...
      /* WRITE LONG (0x32)- sector 0x3200 */
      /*     sector_number = 12800; */
      /*     for (i=0; i<512; i+=8){ */
      /*       strncpy((char*) &buffer[i],"0000000 ",8); */
      /*     } */
      /*     ataraw_debug = 1; */
      /*     result = ata_write_long(fd,(int) sector_number,buffer); */
      /*     printf("32h\tWRITE LONG\treturn code: %d\n",result); */
      /*     write_cnt++; */

      /* issue WRITE DMA QUEUED - write "0000000 " pattern to sector 0xCC00 */
      sector_number = 52224;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_dma_queued(fd,(int) sector_number,buffer);
      printf("CCh\tWRITE DMA QUEUED\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE SECTOR(S)- write a "0000000 " pattern to sector 0x3000 */
      sector_number = 12288;
      /* fill buffer with a "0000000 " pattern.  */
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_sector(fd,(int) sector_number,1,buffer);
      printf("30h\tWRITE SECTOR(S)\t\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE MULTIPLE - write a "0000000 " pattern to sector 0x0000 C500 */
      //printf("pre-WRITE MULTIPLE\n");
      sector_number = 50432;
      for (i=0; i<8192; i+=8){
      	strncpy((char*) &rw_multiple_buffer[i],"0000000 ",8);
      }
      //printf("WRITE MULTIPLE a\n");
      result = ata_write_multiple(fd,(int) sector_number,16,rw_multiple_buffer);
      //printf("WRITE MULTIPLE b\n");
      printf("C5h\tWRITE MULTIPLE\t\treturn code: %d\n",result);
      write_cnt++;
      //printf("post-WRITE MULTIPLE\n");
      /**
       * ATA-3 write commands
       */
      /* WRITE VERIFY (0x3C)- sector 0x3C00 */
      sector_number = 15360;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_verify(fd,(int) sector_number,1,buffer);
      printf("3Ch\tWRITE VERIFY\t\treturn code: %d\n",result);
      write_cnt++;

      /* WRITE DMA w/o retries (0xCB)- sector 0xCB00 */
      sector_number = 51968;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_dma_no_retry(fd,(int) sector_number,1,buffer);
      printf("CBh\tWRITE DMA w/o retries\treturn code: %d\n",result);
      write_cnt++;

      /* WRITE LONG w/o retries(0x33)- sector 0x3200 */
      /* WRITE SECTOR(S) w/o retries (0x31)- sector 0x3100 */
      sector_number = 12544;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_sector_no_retry(fd,(int) sector_number,1,buffer);
      printf("31h\tWRITE SECTOR(S) w/o retries\treturn code: %d\n",result);
      write_cnt++;

      // Jim says come back for these.  find the laziest way to see if they're implemented or not
      // check back in on this but I'm pretty sure I've done the research and
      // that we don't care about any of the CFA commands.
      /* CFA ERASE SECTORS */
      /* CFA WRITE MULTIPLE W/O ERASE (0xCD) - sector 0xCD00 */
      sector_number = 52480;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_cfa_write_mult_wo_erase(fd,(u_long) sector_number,1,buffer);
      printf("CDh\tCFA WRITE MULT WITHOUT ERASE\treturn code: %d\n",result);
      write_cnt++;

      /* CFA WRITE SECTORS W/O ERASE (0x38) - sector 0x3800 */
      sector_number = 14336;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_cfa_write_sector_wo_erase(fd,(u_long) sector_number,1,buffer);
      printf("38h\tCFA WRITE SECTORS WITHOUT ERASE\treturn code: %d\n",result);
      write_cnt++;

      // Jim says leave this one as well
      /* SECURITY ERASE UNIT */
      /* SERVICE */


      /*
       *  EXT write commands
       */

      /* issue WRITE DMA EXT - write "0000000 " pattern to sector 0x1035 0000 */
      sector_number = 271908864;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_dma_ext(fd,sector_number,1,buffer);
      printf("35h\tWRITE DMA EXT\t\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE DMA QUEUED EXT- write "0000000 " pattern to sector 0x1036 0000*/
      sector_number = 271974400;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_dma_queued_ext(fd,sector_number,buffer);
      printf("36h\tWRITE DMA QUEUED EXT\treturn code: %d\n",result);
      write_cnt++;

      /* /\* issue WRITE FPDMA QUEUED - write "0000000 " pattern to sector 0x1061 0000*\/ */
      /* sector_number = 274792448; */
      /* for (i=0; i<512; i+=8){ */
      /* 	strncpy((char*) &buffer[i],"0000000 ",8); */
      /* } */
      /* result = ata_write_fpdma_queued(fd,sector_number,buffer); */
      /* printf("61h\tWRITE FPDMA QUEUED\treturn code: %d\n",result); */
      /* write_cnt++; */

      /* issue WRITE DMA FUA EXT - write "0000000 " pattern to sector 0x103D 0000 */
      sector_number = 272433152;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_dma_fua_ext(fd,sector_number,1,buffer);
      printf("3Dh\tWRITE DMA FUA EXT\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE DMA QUEUED FUA EXT - write "0000000 " pattern to sector 0x103E 0000 */
      sector_number = 272498688;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_dma_queued_fua_ext(fd,sector_number,buffer);
      printf("3Eh\tWRITE DMA QUEUED FUA EXT return code: %d\n",result);
      write_cnt++;

      /* issue WRITE STREAM DMA EXT - write "0000000 " to sector 0x103A 0000 */
      sector_number = 272236544;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_stream_dma_ext(fd,sector_number,1,buffer);
      printf("3Ah\tWRITE STREAM DMA EXT\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE SECTOR(S) EXT- write "0000000 " pattern to sector 0x1034 0000 */
      sector_number = 271843328;
      for (i=0; i<512; i+=8){
      	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = ata_write_sector_ext(fd,sector_number,1,buffer);
      printf("34h\tWRITE SECTOR(S) EXT\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE MULTIPLE EXT - write "0000000 " pattern to sector 0x1039 0000 */
      sector_number = 272171008;
      for (i=0; i<8192; i+=8){
      	strncpy((char*) &rw_multiple_buffer[i],"0000000 ",8);
      }
      result = ata_write_multiple_ext(fd,sector_number,16,rw_multiple_buffer);
      printf("39h\tWRITE MULTIPLE EXT\treturn code: %d\n",result);
      write_cnt++;

      /* WRITE MULTIPLE FUA EXT - write "0000000 " pattern to sector 0x10CE 0000 */
      sector_number = 281935872;
      for (i=0; i<8192; i+=8){
      	strncpy((char*) &rw_multiple_buffer[i],"0000000 ",8);
      }
      result = ata_write_multiple_fua_ext(fd,sector_number,16,rw_multiple_buffer);
      printf("CEh\tWRITE MULTIPLE FUA EXT\treturn code: %d\n",result);
      write_cnt++;

/*       /\* issue WRITE STREAM EXT- write "0000000 " pattern to sector 0x103B 0000 *\/ */
/*       sector_number = 272302080; */
/*       for (i=0; i<512; i+=8){ */
/* 	strncpy((char*) &buffer[i],"0000000 ",8); */
/*       } */
/*       result = ata_write_stream_ext(fd,sector_number,1,buffer); */
/*       printf("3Bh\tWRITE STREAM EXT\treturn code: %d\n",result); */
/*       write_cnt++; */

      /* WRITE LOG EXT */
    }
    if ( run_scsi ){
      /* if SCSI, Goal: issue each defined SCSI read command */    

      /**
       * SCSI write commands...
       *
       */

      /* issue WRITE 6 - write "0000000 " pattern to sector 0x0A10 */
      sector_number = 2576;
      for (i=0; i<512; i+=8){
	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = scsi_write_6(fd, sector_number, buffer);
      printf("0Ah\t(scsi) WRITE 6\t\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE 10 - write "0000000 " pattern to sector 0x102A 0010 */
      sector_number = 271187984;
      for (i=0; i<512; i+=8){
	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = scsi_write_10(fd, sector_number, buffer);
      printf("2Ah\t(scsi) WRITE 10\t\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE 12 - write "0000000 " pattern to sector 0x10AA 0010 */
      sector_number = 279576592;
      for (i=0; i<512; i+=8){
	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = scsi_write_12(fd, sector_number, buffer);
      printf("AAh\t(scsi) WRITE 12\t\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE 16 - write "0000000 " pattern to sector 0x108A 0010 */
      sector_number = 277479440;
      for (i=0; i<512; i+=8){
	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = scsi_write_16(fd, sector_number, buffer);
      printf("8Ah\t(scsi) WRITE 16\t\treturn code: %d\n",result);
      write_cnt++;

      /* issue WRITE 32 - write "0000000 " pattern to sector 0x107F 0B10 */
      sector_number = 276761360;
      for (i=0; i<512; i+=8){
	strncpy((char*) &buffer[i],"0000000 ",8);
      }
      result = scsi_write_32(fd, sector_number, buffer);
      printf("7Fh\t(scsi) WRITE 32\t\treturn code: %d\n",result);
      write_cnt++;
    }

    printf("\n%d write command(s) issued\n",write_cnt);
    log_close(from);
    close(fd);
    return 0;
}
