/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
static char *SCCS_ID[] = {"@(#) logfmp.c Linux Version 1.2 Created 01/27/09 at 08:13:27",
				__DATE__,__TIME__};
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
# include <stdio.h>
# include <time.h>
# include <string.h>
# include <malloc.h>
# include <fcntl.h>
# define CASE 1
# define AHOST 2
# define OP 3
# define DRIVE 4
# define THOST 5
/*****************************************************************
 Log basic test case information

*****************************************************************/


/*****************************************************************
Print instructions about running cmd and options
*****************************************************************/
void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s case analysis-host user label <test-host>\n",p);
}

main (int np, char **p)
{
	static time_t	from; /* start time */
	FILE		*log; /* the log file */

	time(&from);
	printf ("\n%s\n %s\ncompiled at %s on %s\n", p[0],SCCS_ID[0],
		__TIME__,__DATE__);

/*****************************************************************
Decode the command line
*****************************************************************/

	if (np < 5) {
		print_help(p[0]);
		return 1;
	}
	log = fopen("case.txt","w");

	fprintf (log,"Case: %s\n",p[CASE]);
	fprintf (log,"Analysis host: %s\n",p[AHOST]);
	fprintf (log,"User: %s\n",p[OP]);
	fprintf (log,"Disk: %s\nTest host: %s\n",p[DRIVE],
		((np >= 6) && (strlen(p[THOST]) > 0))?p[THOST]:"none");
	fprintf (log,"Date: %s\n",ctime(&from));

	log = stdout;
	fprintf (log,"Case: %s\n",p[CASE]);
	fprintf (log,"Analysis host: %s\n",p[AHOST]);
	fprintf (log,"User: %s\n",p[OP]);
	fprintf (log,"Disk: %s\nTest host: %s\n",p[DRIVE],
		((np >= 6) && (strlen(p[THOST]) > 0))?p[THOST]:"none");
	fprintf (log,"Date: %s\n",ctime(&from));

	return 0;
}
