#!/usr/bin/python
# -*- coding: utf-8 -*-
############################################################

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################

import os
os_info = os.uname()
ver = "Tool: @(#) set_up.py Version 1.18 created 05/23/18 at 16:08:51\n"+"OS: %s Version %s\n"%(os_info[0],os_info[2])
take_out = '''
<li>The CFTT Federated Testing Boot CD
(that you already downloaded from www.cftt.nist.gov/federated-testing.html)
'''
need_01 = '''
<h2 style="color: #0e375d;">The following
is a list of what you need:</h2>
<ul>
<li>"Analysis PC" - A computer or virtual machine (vm) to run the Federated
Testing Forensic Tool Testing Environment. 
<li>"Test PC" - If you are testing a software tool, the computer you will use to run the tool. If you are testing a standalone hardware device, the hardware device itself.
<!-- <li> It is easier if you have two PCs for the testing process,
but if you can't, one is fine. If you do use two PCs for the testing,
designate one as an 'Analysis PC' (PC to run this CD)
and one as a 'Test PC' (PC to run your disk imaging tool).
If you only have one PC, while the PC is booted from the CD it is the 'Analysis PC', but
while booted into the tool run time environment the PC is the 'Test PC'. -->
<!-- <li> A dedicated removable (flash) drive for saving log files and test
instructions for all test cases. 
<ul>
<li>The drive should be prepared once before any test cases are run.
Subsequent tests do not require you to reformat the drive. 
<li>The log drive needs to be formatted FAT and have its "file system label" set to
"FT-LOGS" using the 
 <a href = "/formatyourthumb.php?ref=di">
Format Your Log Drive 
</a> page.
</ul> -->
<li>Dedicated removable flash drive (log drive) for storing test log files and other test
information for your tests (see <a href = "/formatyourthumb.php?ref=di">
Format Your Log Drive</a> for more information). 
'''
need_end = '''
</ul>
'''
#<li>For test cases FT-DI-01-ATA28 & FT-DI-01-SATA28 the source drive must be smaller
#than 137 GB (131GiB).
#<p>***** THE VAR is %(var)s SSS ****<p>
#<li>For test cases FT-DI-01-ATA48 & FT-DI-01-SATA48 the source drive must be larger
#than 137 GB (131GiB).
#<li>The same size conditions apply to the source drives for FT-DI-07 ATA & SATA test cases.
#The source drive must be a <b>%(iface)s</b> drive since this case is testing
#the acquisition of %(iface)s drives.
need_src_if = '''
<li>Source drive (to be acquired by the tool you are testing). The source
drive must be a %(iface)s drive since this case is testing
the acquisition of %(iface)s drives.
You need to follow our procedure (below) using the <strong>cftt-di</strong>
tool to write known content to each
source drive before acquiring the drive.
SSS
<li>Write blocker for accessing the source drive after the drive is
setup with known content.
'''
#<li>Write blocker for accessing the source drive after the drive is
#setup with known content. The blocker must be able
#to connect to the <strong>hard drive via the %(iface)s interface.</strong> The blocker
#can connect <strong>to the Analysis PC by any interface</strong>.
need_src = '''
<li>Source drive (to be acquired by the tool you are testing).
You need to follow our procedure (below) using the <strong>cftt-di</strong> tool to write known content to each
source drive before acquiring the drive.
<li>Write blocker for the source drive. The blocker can connect
to either the Test PC or the Analysis PC through any interface.
'''
need_src_5_9 = need_src.replace('drive (','drive to contain a type %(var)s partition (')
#need_src_5_9 = need_src_5_9%{'var':var}
need_10_only = '''
<li>Select one variation from FT-DI-01 to repeat and note the size of the image file created
during the test run.
<li>A media-target drive (e.g., removable drive, OS boot drive, network share)
with a partition that does not have sufficient space to save the image file
created during this test run. (The goal is to force an error message by
the imaging tool.)
'''
need_11_only = '''
<li>Select one variation from FT-DI-02 to repeat.
<li>Destination drive <strong>smaller than imaged source</strong> to be used as a target for 
the restore operation.
<li>A bridge or other method for attaching the destination so that the drive is
writable.
<li>Media-target drive that contains the image file from the selected FT-DI-02 variation.
<li>Source drive that was used to create the image file
used in selected variation of FT-DI-02.
(The source drive is used for the comparison of the restored destination to the original source).
<li>Write blocker for source drive and a write blocker for the
destination drive (for the step for comparing the destination
to the source)
'''
need_save_img = '''
<li>A media-target drive (e.g., removable drive, OS boot drive, network share)
with sufficient space to save the image file created during this test run. 
The drive should be prepared once before any test cases are run.
If the media-target drive is not yet formatted, do so now and use it until you run
out of space. After the current media-target drive runs out of space, select and
format a new media-target drive.
Do not reformat the drive once you start saving image files. 
Each media drive must have a unique name. Assign 91 to the first media-target drive
you set up and 92, 93, and so forth to additional media-target drives.
If using a removable drive, write the name on a label and attach it to the outside
of the drive. This is used to track where the drive is used in testing.
'''
need_use_img = '''
<li>Media-target drive that contains the image file created during
FT-DI-%(othercase)s-%(pc)s(var)s
<li>Source drive used in FT-DI-%(othercase)s-%(pc)s(var)s
<li>Write blocker for source drive and a write blocker for the
destination drive (for the step for comparing the destination
to the source)
'''
need_dst = '''
<li>Destination drive (to be used as a target for 
cloning or restoring by the tool you are testing)
<li>A bridge or other method for attaching the destination so that the drive is
writable.
'''
need_dst_wb = need_dst + '''
<li>Write blocker for source drive and a write blocker for the
destination drive (for the step for comparing the destination
to the source)
'''
setup_ready = '''
<h2 style="color: #0e375d;">No Source Drive Setup Needed</h2>
'''
setup_start_p = '''
<h2 style="color: #0e375d;">
Source Drive Setup Steps: Procedure for writing content, creating a UGLY partition and hashing</h2>
'''
setup_start = '''
<h2 style="color: #0e375d;">
Source Drive Setup Steps: Procedure for writing content and hashing</h2>
'''
setup_start_p = setup_start.replace(' and',', creating a partition and')

#<li>While the Analysis PC is powered off, attach any fixed drives
#(ATA, SCSI, etc.) to the Analysis PC.
setup_prolog_12 = '''
<p>
If you still have the source drive for the variation of test case FT-DI-07 you selected to repeat,
'''
setup_prolog = '''
<p>
If you already have used <strong>cftt-di</strong>
to set up a source drive and that drive is suitable for this case,
'''
setup_body = '''
then
that drive can be used with this case and you can skip these steps.
Otherwise, you need to use the <strong>cftt-di</strong> tool to write known content to a
source drive and hash the drive.
<ol>
<li>Select a drive to use as a source drive.
Each source drive must have a unique name. Assign A1 to the first source drive
you set up and A2, A3 so forth to additional source drives.
Write the name on a label and attach it to the outside
of the drive. This is used to track where the drive is used in testing.
Case is ignored, e.g., A1 is the same as a1. 
<li> While the Analysis PC is powered off, if the source drive must be
attached to the PC before booting, then attach the drive now.
Usually drives attached to the PC by either the ATA or SCSI interface need to be attached
before booting the PC.
Sometimes drives attached by the USB interface
 interfere with booting and should be attached after booting is
finished.
<li>Boot the Analysis PC with the CFTT Federated Testing Boot CD
<li>Open a terminal window by clicking on the terminal icon in the
tool bar (you are automatically the root user).
<li> If the system clock time is not correct,
 <a href =
	"/diskimaging/commonprocedures.php?display=clock">
reset </a> the system clock on the PC to current date and time.
<li> Attach the FT-LOGS log drive and <em>mount the device by clicking on the
device icon in the tool bar</em>.
'''
# If this fails manually <a href =
#	"/diskimaging/commonprocedures.php?display=mountpartition">
#	mount </a> the log drive.
setup_base = setup_prolog + setup_body
setup = setup_start + setup_base
setup_p = setup_start_p + setup_base.replace(' and hash the drive',
', create a partition and hash the partition')

wipe_src = '''
<li>If not already attached, attach the source drive to the Analysis PC 
so that the drive can be written to; any interface may
be used. For example, connected via a read/write bridge.
<li>
 <a href = "/diskimaging/commonprocedures.php?display=view">
List </a>
attached devices and determine the Linux device name (e.g., sdb) of the source drive.
<li>Write known content to the source drive.
<br><br>
The following figure shows an Analysis PC, booted from the Federated Testing CD,
writing known content to a source drive and recording a description of the source
drive to the FT-LOGS log drive.
<p>
<img src="graphics/wipe.jpg">
<ul>
<p>
<li>In a terminal window type: <tt>cftt-di</tt> then press return/enter
<li>Create user/host profile, if asked or if current profile needs revision.
You will be asked for three things:
<ol>
<li> Your name. This is used to identify who is operating the computer. If more than
one person is running the tests, you need to change the profile when you
change operators.
<li>The computer used to run the NIST CD.
<li>The computer used to run the tool you are testing.
</ol>
You will be asked to confirm the values entered and you can reenter if you see
a problem.
<li>Select the "write known content" option 
 by typing the code on the left ("1") followed by return/enter
<ul>
<li>A list of the drives already set up will be shown.
You should enter a new source drive id (not one of the ones listed).
The new source device's drive id should be from the sequence: A1, A2, etc.
that is not listed as already setup.
<li><strong>cftt-di</strong> will print a list of attached devices and the
size in sectors and mega/giga/kilo bytes. You should be able to identify
the device you want to use by the size. Device /dev/sda is usually a boot
drive with an installed OS. If you select a device with
an installed OS, it will be overwritten.
Select the source device by typing the code to the left of the source's 
Linux device name, e.g.,
a, b, c etc.
<li>You will be prompted to enter the type of device.
<li>You will be prompted to confirm that you want to write known content,
i.e., wipe the device.
<li>This step may take several hours depending on the size of the drive.
The process will give progress feedback.
</ul>
</ul>
%(partition)s
'''
hash_src = '''
<li>Compute reference hashes of the source drive.
<br><br>
The following figure shows an Analysis PC, booted from the Federated Testing CD,
reading content from a source drive, computing hash values and
recording the hashes of the source drive to the FT-LOGS log drive. The write blocker
shown is not necessary and is optional.
<p>
<img src="graphics/hash.jpg">
<p>
<ul>
<li>In a terminal window type: <tt>cftt-di</tt> then press return/enter
<li>Create user/host profile, if asked or if current profile needs revision.
You will be asked for three things:
<ol>
<li> Your name. This is used to identify who is operating the computer. If more than
one person is running the tests, you need to change the profile when you
change operators.
<li>The computer used to run the NIST CD.
<li>The computer used to run the tool you are testing.
</ol>
You will be asked to confirm the values entered and you can reenter if you see
a problem.
<li>Select the "Compute reference hash values" option by typing the code on the left ("2")
followed by return/enter
<ul>
<li>Enter the source device's drive id, e.g., A1, A2, etc
<li><strong>cftt-di</strong> will print a list of attached devices.
Select the source device (or source device partition in cases 05 & 07) by typing the code to the left of the source's 
Linux device name, e.g.,
a, b, c, a2, c1, etc. for /dev/sda, /dev/sdb, /dev/sdc, /dev/sda2, /dev/sdc1, etc.
You can choose from either a full drive (a, b, c, etc) or a partition (a3, b1, c4, etc).
<li>This step may take several hours depending on the size of the drive. The process will give progress feedback.
</ul>
</ul>
<li>The source is now ready for use. Remove the source drive from the Analysis PC.
From now on a write blocker should always
be used with the drive.
</ol>
'''
setup_src_base = wipe_src + hash_src
setup_rm = '''
<p>Seting up removable media is similar to setting up fixed media. Keep in mind the following
additional considerations:
<br>
<ul>
<li> There must be a device attached to the PC computer to access the removable media.
<li> Examples include: CompactFlash card, Secure Digital card, floppy disk, etc.
<li> Be sure that media (sd card, compact flash card, etc) is in the media access device.
<li> For federated testing, removable flash drives are not considered removable media.
<li> Removable flash drives are considered hot swapable fixed media because no
"reader" device is required to access the flash drive.
<li> Otherwise, treat removable media just like fixed media.
</ul>
'''
mk_part = '''
<li><a href =
	"/diskimaging/mediasetup.php?menuexpand=mediasetup&display=partition">
	Create a partition</a>
 of type %(var)s on the source drive. The partition can be any size, but remember that smaller partitions 
 image faster.
'''

#print '================================'
#print setup_src_base
#print '================================'
setup_src_q = setup_src_base%{'partition':mk_part}
setup_src_p = setup_src_q.replace('hashes of the source drive','hashes of the source drive partition')
#<li> While the Analysis PC is powered off, attach any fixed drives
#(ATA, SCSI, etc.) to the Analysis PC.
su_boot_analysis = '''
<li> While the Analysis PC is powered off, if the source drive must be
attached to the PC before booting, then attach the drive now.
Usually drives attached to the PC by either the ATA or SCSI interface need to be attached
before booting the PC.
Sometimes drives attached by the USB interface
 interfere with booting and should be attached after booting is
finished.
<li> Use CFTT boot CD to boot PC into the analysis environment.
<li>Open a terminal window by clicking on the terminal icon in the
tool bar (you are automatically the root user).
<li> If the system clock time is not correct, reset to current date and time.
<li> Attach the FT-LOGS log drive and mount the device by clicking on the
device icon in the tool bar.
'''
# If this fails manually <a href =
#	"/diskimaging/commonprocedures.php?display=mountpartition">
#	mount </a> the log drive.

caveat = '<p>CAUTION: This is the general method, refer to the specific test case for exact instructions<p>'
media_setup = caveat + setup + wipe_src%{'partition': mk_part%{'var':'"case variation"'}+'(if called for)'}+hash_src
setup_src = setup_src_base%{'partition':''}
#	'faultysectors' : create_faulty_sectors,
create_faulty_sectors = '''
<h2>Creating Faulty Sectors</h2>
<p> Test case DI-15 evaluates the behavior of an imaging tool if bad
or faulty sectors are encountered.
Running this test requires preparing a source drive with known bad sectors. This
is accomplished with the Linux <tt>hdparm</tt> command wrapped in a C-shell script.
The following items should be kept in mind:</p>
<ul>
<li> Select a SATA or ATA test drive.</li>
<li> It may take some trial-and-error to get a connection that allows creation of faulty sectors.
Connecting the test drive directly to the PC with either
an ATA or a SATA interface is the most likely method to work. However, a USB interface may work via SCSI / ATA Translation (SAT). We have had success with
a USB 3.0 to 2.5" SATA III Hard Drive Adapter Cable connecting a SATA drive to a PC
through a USB port.</li>
<li> If any other interface (e.g., USB or Firewire) or a bridge
is involved, you might or might not be able to create a faulty sector.</li>
<li> The setup is similar to the usual source drive setup, but there are differences:
<ul>
<li> You need two identical sized drives. These are referred to as the
	<em>reference drive</em> and the <em>bad sector drive</em>.
	All sectors on the reference drive are readable,
	but one sector on the bad sector drive
	is faulty.
	The bad sector drive is imaged by the tool you want to test onto a clone drive.
	The reference drive is then compared to the clone drive to identify differences.</li>
<li> It is not necessary to hash any of the drives. Hashing is not really useful here 
since the drives are not likely to have the exact same content.</li>
</ul></li>
<li> Overview of setup -- there are three tasks to create the bad sector drive and
the reference drive.
<ul>
<li>Write known content to the bad sector drive with <strong>cftt-di</strong>.</li>
<li>Create faulty sector on bad sector drive</li>
<li>Write known content to the reference drive with <strong>cftt-di</strong>.</li>
</ul></li>
</ul>
<p>
Steps to create a faulty sector drive:
<ol>
<h2>Wipe the bad sector drive</h2>
'''+su_boot_analysis+'''
<li>Use <strong>EE-bad</strong> as the label for the bad sector drive
'''+wipe_src%{'partition':''}+'''
<h2>Create the bad sector</h2>
<li>Determine the device name of the bad sector drive, e.g., /dev/sdz
<li>Run the script to make a faulty sector:<strong> bad.csh /dev/sdz</strong>
<li>Substitute the actual device name for /dev/sdz
<li>The bad.csh script creates a log file (/tmp/bad-log.txt) that should be copied
to the setup/EE-bad directory on the log device (/media/cftt/FT-LOGS/setup/EE-bad).
<p>
<h2>Wipe the reference drive</h2>
'''+su_boot_analysis+'''
<li>Use <strong>EE-ref</strong> as the label for the reference drive
'''+wipe_src%{'partition':''}+'''
<li>Setup is complete
</ol>

'''
media_10 = '''
<p>
Format the media-target drive to have a smaller size than the selected image file.
Check the size of the image file created for the variation of FT-DI-01 you selected to
repeat. Select a media-target drive to save the image file for the source drive you
will acquire during this test. Partition and format the media-target drive to be
smaller than the size of the image file created in the variation of FT-DI-01 you selected to repeat.
<br>
'''

#	print setup_map[case_head]%{'var':variation}
#print '======================='
setup_di_01 = (need_01+need_src_if+need_save_img+need_end+setup+setup_src)
setup_di_02 = (need_01+need_dst+need_use_img%{'othercase':'01','pc':'%'}+need_end+setup_ready)
setup_di_03 = (need_01+need_src+need_save_img+need_end+setup+setup_src)
setup_di_04 = (need_01+need_dst+need_use_img%{'othercase':'03','pc':'%'}+need_end+setup_ready)
setup_di_05 = (need_01+need_src_5_9+need_save_img+need_end+setup_p+setup_src_p)
setup_di_06 = (need_01+need_dst+need_use_img%{'othercase':'05','pc':'%'}+need_end+setup_ready)
setup_di_07 = (need_01+need_src_if+need_dst_wb+need_end+setup+setup_src)
setup_di_08 = (need_01+need_src+need_dst_wb+need_end+setup+setup_src)
setup_di_09 = (need_01+need_src_5_9+need_dst_wb+need_end+setup_p+setup_src_p)
setup_di_10 = (need_01+ need_src+ need_10_only+ need_end+
setup_start+media_10+ setup_base+ setup_src)
#setup_start+"<ol><li>Format image drive smaller than selected image"+ setup_base+ setup_src)
setup_di_11 = (need_01+
	need_11_only+
	need_end+setup_ready)
setup_di_12 = (need_01+need_src.replace('Source','Select one variation from FT-DI-07 to repeat.<li>Source')
	+need_dst_wb.replace('or restore','').replace('(to','''
	<strong>smaller than the source drive</strong>
	 (to
	''')
	+need_end+setup_start+setup_prolog_12+setup_body+setup_src)
setup_di_13 = (need_01+'<li>Select one of the FT-DI-01 variations'+
	'<li>Media-target drive that contains the image file created during the '+
	'variation of FT-DI-01 you selected.'+need_end+setup_ready)
setup_di_14 = (need_01+'<li>Select a source drive used in one of the FT-DI-01 or FT-DI-07 variations.'+
	'''<li>Write blocker for the source drive. The blocker can connect
	to the Test PC through any interface.
	'''+
	need_end+setup_ready)
setup_di_15 = (need_01+need_src+need_dst_wb+'''
	<li>Reference drive that is the same size as the bad sector drive 
	(for comparison to destination)'''+need_end+create_faulty_sectors)

html_head = '''
<html>
<TITLE>Test Setup</TITLE>
<body><H1>Test Setup for Disk Imaging</H1>
<P>Federated Testing<P>Disk Imaging Tool Setup<p> 
'''
html_tail = '''
</body>
</html>
'''
if __name__ == '__main__':
	dribble = open ("/tmp/gen.html","w")
	dribble.write (html_head)
	dribble.write ("<h1>FT-DI-01</h1>\n")
	dribble.write ( setup_di_01%{'var':'XYZ','iface':'ABC'})
	dribble.write ("<h1>FT-DI-02</h1>\n")
	dribble.write ( setup_di_02%{'var':'XYZ'})
	dribble.write ("<h1>FT-DI-03</h1>\n")
	dribble.write ( setup_di_03%{'var':'XYZ'})
	dribble.write ("<h1>FT-DI-04</h1>\n")
	dribble.write ( setup_di_04%{'var':'XYZ'})
	dribble.write ("<h1>FT-DI-05</h1>\n")
	dribble.write ( setup_di_05%{'var':'XYZ'})
	dribble.write ("<h1>FT-DI-06</h1>\n")
	dribble.write ( setup_di_06%{'var':'XYZ'})
	dribble.write ("<h1>FT-DI-07</h1>\n")
	dribble.write ( setup_di_07%{'var':'XYZ','iface':'usb'})
	dribble.write ("<h1>FT-DI-08</h1>\n")
	dribble.write ( setup_di_08%{'var':'XYZ'})
	dribble.write ("<h1>FT-DI-09</h1>\n")
	dribble.write ( setup_di_09%{'var':'XYZ'})
	dribble.write ("<h1>FT-DI-10</h1>\n")
	dribble.write ( setup_di_10%{'var':'$$$'})
	dribble.write ("<h1>FT-DI-11</h1>\n")
	dribble.write ( setup_di_11%{'var':'$$$'})
	dribble.write ("<h1>FT-DI-12</h1>\n")
	dribble.write ( setup_di_12%{'var':'$$$'})
	dribble.write ("<h1>FT-DI-13</h1>\n")
	dribble.write ( setup_di_13%{'var':'$$$'})
	dribble.write ("<h1>FT-DI-14</h1>\n")
	dribble.write ( setup_di_14%{'var':'$$$'})
	dribble.write ("<h1>FT-DI-15</h1>\n")
	dribble.write ( setup_di_15%{'var':'$$$'})
	dribble.write ( create_faulty_sectors )
	dribble.write (html_tail)
#	print setup_di_01%{'var':'XYZ'}
#	print '======================='
#	print setup_di_02%{'var':'XYZ'}
#	print '======================='
#	print setup_di_07
#	print '=========  D O N E  =============='
#	print dir()
#	vlist = dir()
#	dribble.write("<h1>Micro Procedures</h1>"+'\n')
#	for var in vlist:
#		print var,type(vars()[var]),type(vars()[var]) is str
#		if type(vars()[var]) is str:
#			dribble.write("<h2>"+var+"</h2>"+'\n')
#			dribble.write(eval(var))
##########################################################
#html_head = '''
#<html>
#<TITLE>Federated Testing Setup Procedures</TITLE>
#<body><H1>Setup Procedures for Disk Imaging</H1>
#<P>Federated Testing<P>Disk Imaging Tool Setup<p> 
#'''
#html_tail = '''
#</body>
#</html>
#'''
if __name__ == '__main__':
	dribble = open ("/tmp/gen-setup.html","w")
	dribble.write (html_head)
	print '=========  D O N E  =============='
	print dir()
	vlist = dir()
	dribble.write("<h1>Micro Procedures</h1>"+'\n')
#	for var in vlist:
#		print var,type(vars()[var]),type(vars()[var]) is str
#		if type(vars()[var]) is str and var[0:3] == "tk_":
#			dribble.write("<h2>"+var+"</h2>"+'\n')
#			dribble.write(eval(var))
	for var in vlist:
		print var,type(vars()[var]),type(vars()[var]) is str
		if type(vars()[var]) is str:
			dribble.write("<h2>"+var+"</h2>"+'\n')
			dribble.write("<ol>\n")
			dribble.write(eval(var))
			dribble.write("</ol>\n")
	dribble.write (html_tail)
