#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
import os
import time
from subprocess import (Popen,PIPE)


#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################

os_info = os.uname()
ver = "Tool: @(#) fmt-logs.py Version 1.2 created 07/14/15 at 08:44:41\n"+"OS: %s Version %s\n"%(os_info[0],os_info[2])
if len(sys.argv) != 2:
	print "No device specified"
	exit(1)
target = sys.argv[1].replace('/dev/','')

p_lsblk = Popen("lsblk -b",shell=True,stderr=PIPE, stdout=PIPE)

seen = False
mount_ok = False
is_err = False
for line in p_lsblk.stdout:
	if -1 != line.find(target): seen = True

if not seen:
	err_log = open('/tmp/fmt-err-log.txt','w')
	err_log.write("No /dev/%s device found\n"%(target))
	exit(1)

# do umount here... if device is mounted, can not do anything w/ it until we unmount it
cmd = "umount /dev/" + target
p_umount = Popen(cmd,shell=True,stderr=PIPE, stdout=PIPE)

dev = open ('/dev/'+target,"wb")
buff = '\0'*512
dev.write(buff)
dev.close()
print "Partition table of /dev/%s erased, ready to format as FT-LOGS"%(target)
time.sleep(1)

is_err = False
cmd = "mkdosfs -I -n FT-LOGS /dev/" + target
#print cmd
p_mkfs = Popen(cmd,shell=True,stderr=PIPE, stdout=PIPE)
for line in p_mkfs.stderr:
	if is_err == False:
		err_log = open('/tmp/fmt-err-log.txt','w')
	err_log.write(line+'\n')
#	print line,
	is_err = True
if not is_err:
	print "<br>Format complete"
	print "<br><br><p>Success! Your log drive is now ready to be used!</p>"
else:
	print "<p><b>Error:</b> <i>fmt-logs.py</i> encountered an error configuring /dev/%s</p>"%target
	
	
	
