<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS - Readme / Help";
$page_h1 = "String Search Readme / Help";
include "ft_ss_head.php";
include_once('../include/ss-global.php');
?>
<div style="padding: 1em 1em 0.5em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
	  <p>This page is divided into 5 parts:
      <ol>
        <li><a href="#introduction">Introduction</a>,</li>
        <li><a href="#needtoknow">What You Need to Know About Your Search Tool Prior to Testing</a>,</li>
        <li><a href="#testcases">Test Cases</a>,</li>
<!--        <li><a href="#need">What You Will Need</a>,</li>-->
        <li><a href="#parameters">Overview of Parameters Addressed in the String Search Test Cases</a>, and </li>
	    <li><a href="#faqs">FAQs</a>.</li>
      </ol>
      </p><br>

<a name="introduction"></a>
<h2 style="font-size:1.7em; color:#008000"><b>Introduction</b></h2>
<p>This String Search test suite is designed to test a forensic string search tool's ability to find target strings located in active files, deleted (but recoverable) files, unallocated space, and in meta-data. This test suite is paired with a data set download from <a href="https://www.cfreds.nist.gov">www.cfreds.nist.gov</a> (see instructions in step 1 on the String Search <a href="string-search.php">home page</a>). The data set download contains 2 image files or data sets. One image is for testing search tools on Microsoft Windows type file systems (FAT, ExFAT and NTFS) and unallocated storage space. The other test image is for testing searching UNIX-like file systems (ext4, APFS, and OSX). You can choose to test your string search tool using one or both images. If your tool includes more than one search engine, e.g., indexed, live, or physical, you can choose to test one or more of your tool's search engines.</p><br>

<a name="needtoknow"></a>
<!--<h2>Overview of What You Need to Know About the Search Tool</h2>
<h2>Things you need to be aware of:</h2>-->
<!--<h2 style="font-size:1.7em; color:#008000"><b>Overview of What You Need to Know About Your Search Tool</b></h2>-->
<!--<h2 style="font-size:1.7em; color:#008000"><b>Familiarizing Yourself with Your Search Tool Prior to Testing</b></h2>-->
<!--<h2 style="font-size:1.7em; color:#008000"><b>Overview of What You Need to Know About Your Search Tool Prior to Testing</b></h2>-->
<h2 style="font-size:1.7em; color:#008000"><b>What You Need to Know About Your Search Tool Prior to Testing</b></h2>
<!--<p> You need to become familiar with the capabilities of the tool before you try
to test the tool. In particular, you need to know how to do the following:-->
<p>Prior to testing a string search tool, you need to be familiar with its capabilities. In particular, you need to know how to do the following:
<ul>
<li> configure a search to either ignore case or match case;
<li> configure a search to either match a whole word or a substring;
<li> configure a search to look for UTF-8, UTF-16BE and UTF-16LE; and 
<li> configure a search to use a particular search method (also called a search engine),
e.g., as indexed, live or physical.
<li> Note: each vendor has original terminology and it may be unclear the search method being used.
In general, if a tool requires a lengthy step to <i>process</i> an image before it
can be searched, this is an indexed search. A tool that allows searching without
a preprocessing step or takes a long time to search for a keyword is usually a live search.
<!--For example, Autopsy does an indexed search;
X-Ways <i>Logical Search</i> is a live search, <i>Indexed Search</i> is an indexed search.
X-Ways offers a third search engine, <i>Physical Search</i>; FTK offers both indexed and live. -->
</ul>
<br>

<a name="testcases"></a>
<h2 style="font-size:1.7em; color:#008000"><b>Test Cases</b></h2>
<p>There are 25 test cases that can be run to test a string search tool. Search option settings, e.g., Ignore Case, Match Case, Whole Words, ASCII, Unicode, etc., are varied across the test cases to achieve tests with the most permutations.</p>
<p>This table presents a description of the test cases for testing string search tools.</p>
<table class="bordered_table" style="position:relative;top:-13px;" bgcolor="#FFFFFF" >
	<tr><th style="width: 155px;"><b>Test Case</b></th><th><b>Description</b></th></tr>
<?php
// Print a table of test cases and test case descriptions (drives)
foreach($full_case_desc as $key => $value){
	if (in_array($key, $ignore_for_unix)){ // print an astericks for Win-only tests
		echo '<tr><td>'.$key.'<b>*</b></td><td>'.$value.'</td></tr>';
	} else {
		echo '<tr><td>'.$key.'</td><td>'.$value.'</td></tr>';
	}				
}			
?>									
</table>
<p><img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:0px 0;"> NOTE: test cases listed with an "<b>*</b>" only apply to the Windows data set.</p>
<!--<p><b>*</b>Note: some tests only apply to the Windows data set; these tests are not run for the UNIX data set.</p><br>-->

<a name="parameters"></a>
<h2 style="font-size:1.7em; color:#008000"><b>Overview of Parameters Addressed in the String Search Test Cases</b></h2>
<p>The following are the main parameters that are addressed across the string search test cases:</p>
  <ul>
  <li>String Location: active file, deleted (but recoverable) file, unallocated space,
  and meta-data.</li>
  <li>Search Method (aka search engine): indexed, live or physical.</li>
  <li>String Encoding: ASCII, UTF-8, UTF-16BE and UTF-16LE.</li>
  <li>Language: in addition to English, strings representative of diacritical marks (German, French, Spanish), 
	  non-Latin characters (Russian), right-to-left presentation (Arabic), and Asian languages (Chinese, Japanese 
	  and Korean).</li>
  <li>Fragmented File: string that spans two disjoint file fragments.</li>
  <li>Logical Operations: combine search results with logical operators <b>and</b>,
  <b>or</b>, and <b>not</b>.</li>
  <li>Stemming: match inflected forms derived from a word stem, e.g., a search for <i>run</i> should
  also match <i>runs</i>, <i>running</i> and <i>ran</i>.</li>
  <li>Embedded Formatting: string with embedded formatting in MS Word and HTML documents.</li>
</ul>
<br>

<a name="faqs"></a>
<h2 style="font-size:1.7em; color:#008000"><b>FAQs</b></h2>
<p><i>Add FAQs here.</i></p>
<!--<ol>
<li><b>Q</b>: ?<br>
<b>A</b>: </li>
</ol>-->

<?php
/*
*/
//include "ft_ss_home_links.php";
?>
<br>

</div>	
<?php
	include "ft_ss_tail.php";
?>

