#!/usr/bin/python
# -*- coding: utf-8 -*-
############################################################

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################

# 1) stripped out some <P>s that were affecting display of text
# 2) added code to print link to the visual guide for each test case

############################################################
#from ft_di_01 import *
#from ft_di_03 import *
#from ft_di_05 import *
#from ft_di_10 import *
#from ft_di_13 import *
from set_up import *
from ft_di_run import *
#from ft_di_desc import *
from ft_di_desc import *
os_info = os.uname()
ver = "Tool: @(#) sap_di.py Version 1.9 created 11/30/15 at 09:08:33\n"+"OS: %s Version %s\n"%(os_info[0],os_info[2])
############################################################
############################################################
s = "<P>C R A P<P>"
setup_map = {
"FT-DI-01":setup_di_01,
"FT-DI-02":setup_di_02,
"FT-DI-03":setup_di_03,
"FT-DI-04":setup_di_04,
"FT-DI-05":setup_di_05,
"FT-DI-06":setup_di_06,
"FT-DI-07":setup_di_07,
"FT-DI-08":setup_di_08,
"FT-DI-09":setup_di_09,
"FT-DI-10":setup_di_10,
"FT-DI-11":setup_di_11,
"FT-DI-12":setup_di_12,
"FT-DI-13":setup_di_13,
"FT-DI-14":setup_di_14,
"FT-DI-15":setup_di_15}

run_map = {
"FT-DI-01":run_di_01,
"FT-DI-02":run_di_02,
"FT-DI-03":run_di_03,
"FT-DI-04":run_di_04,
"FT-DI-05":run_di_05,
"FT-DI-06":run_di_06,
"FT-DI-07":run_di_07,
"FT-DI-08":run_di_08,
"FT-DI-09":run_di_09,
"FT-DI-10":run_di_10,
"FT-DI-11":run_di_11,
"FT-DI-12":run_di_12,
"FT-DI-13":run_di_13,
"FT-DI-14":run_di_14,
"FT-DI-15":run_di_15}

eval_map1 = {
"FT-DI-01":eval_di_01,
"FT-DI-02":eval_di_02,
"FT-DI-03":eval_di_03,
"FT-DI-04":eval_di_04,
"FT-DI-05":eval_di_05,
"FT-DI-06":eval_di_06,
"FT-DI-07":eval_di_07,
"FT-DI-08":eval_di_08,
"FT-DI-09":eval_di_09,
"FT-DI-10":eval_di_10,
"FT-DI-11":eval_di_11,
"FT-DI-12":eval_di_12,
"FT-DI-13":eval_di_13,
"FT-DI-14":eval_di_14,
"FT-DI-15":eval_di_15}

#print setup_map['FT-DI-01']

case_dict_old = {
"FT-DI-01":
"Acquire a drive to an image file. Test acquisition over selected interface.",
"FT-DI-02":"Restore an image file to a destination clone.",
"FT-DI-03":'''Acquire a removable media device to an image file. 
Test acquisition of selected removable media type. ''',
"FT-DI-04":'''Restore an image file of removable media to a destination clone.
''',
"FT-DI-05":"Acquire a partition to an image file. Test acquisition of selected partition type. ",
"FT-DI-06":"Restore a partition image file to a destination clone.",
"FT-DI-07":"Acquire a drive to a destination clone. Test acquisition over selected interface.",
"FT-DI-08":"Acquire a removable media device to a destination clone. Test Acquisition of selected removable media type.",
"FT-DI-09":"Acquire a partition to a destination clone. Test acquisition of selected partition type.",
"FT-DI-10":"Acquire a drive to an image file without enough space for the image file.",
"FT-DI-11":"Restore an image file to a destination clone without enough space.",
"FT-DI-12":"Acquire a drive to a destination clone without enough space.",
"FT-DI-13":"Compute the hash value of the acquired data within an image file.",
"FT-DI-14":"Compute the hash value of a drive.",
"FT-DI-15":"Acquire a drive with a faulty sector to a destination clone."}

def wrap_case (testcase,check_dco,check_hpa):
	#print '<h1>TEST CASE %s </h1>' % (testcase)
	tc = testcase.split('-')
	case_head = testcase[0:8]
	if len(testcase) > 8: variation = testcase[9:]
	else : variation = ""
	iface = variation.replace('28','').replace('48','')
#	if ifase == 'FW': iface = 'FireWire'
#	print 'Case head:',case_head,"<P>"
	if case_head in case_dict:
#		print case_dict[case_head],"<P>"
		print "<h1>",case_dict[case_head],"</h1>"
	else:
		print "<p>Unknown case:",testcase
#	print '<h2><a name = %s>Setting up Test Case %s </a></h2>' % (testcase,testcase)
	if case_head == "FT-DI-01" or case_head == "FT-DI-03" or case_head == "FT-DI-05" or case_head == "FT-DI-10":
#		print '<p><img src="/images/document-24x24.png" style="margin:0px 0;">'
#		print '<a href="guides/FT-DI-01_03_05_10.pdf" target="_blank">Click to '
#		print 'open the visual guide for test cases FT-DI-01, 03, 05 &amp; 10</a></p>'
		print '<p><a href="guides/FT-DI-01_03_05_10.pdf" target="_blank"><img src="/images/document-24x24.png" style="margin:0px 0;">'
		print 'Click to '
		print 'open the visual guide for test cases FT-DI-01, 03, 05 &amp; 10</a></p>'
	if case_head == "FT-DI-02" or case_head == "FT-DI-04" or case_head == "FT-DI-06" or case_head == "FT-DI-11":
		print '<p><a href="guides/FT-DI-02_04_06_11.pdf" target="_blank"><img src="/images/document-24x24.png" style="margin:0px 0;"> Click to '
		print 'open the visual guide for test cases FT-DI-02, 04, 06 &amp; 11</a></p>'
	if case_head == "FT-DI-07" or case_head == "FT-DI-08" or case_head == "FT-DI-09" or case_head == "FT-DI-12":
		print '<p><a href="guides/FT-DI-07_08_09_12.pdf" target="_blank"><img src="/images/document-24x24.png" style="margin:0px 0;"> Click to '
		print 'open the visual guide for test cases FT-DI-07, 08, 09 &amp; 12</a></p>'
	if case_head == "FT-DI-13" or case_head == "FT-DI-14":
		print '<p><a href="guides/FT-DI-13_14.pdf" target="_blank"><img src="/images/document-24x24.png" style="margin:0px 0;"> Click to '
		print 'open the visual guide for test cases FT-DI-13 &amp; 14</a></p>'
	if case_head == "FT-DI-15":
		print '<p><a href="guides/FT-DI-15.pdf" target="_blank"><img src="/images/document-24x24.png" style="margin:0px 0;"> Click to '
		print 'open the visual guide for test case FT-DI-15</a></p>'
	print '<h2 style="color: #0e375d;">Setting up Test Case %s </h2>' % (testcase)
	this_case = setup_map[case_head]%{'var':variation,'iface':
	variation.replace('28','').replace('48','').replace('FW','FireWire')}
	small_drive = '<li>The source drive must be smaller than 137 GB (131GiB).'
	large_drive = '<li>The source drive must be larger than 137 GB (131GiB).'
	if variation == 'SATA28' or variation == 'ATA28':
		print this_case.replace('SSS',small_drive)
	elif variation == 'SATA48' or variation == 'ATA48':
		print this_case.replace('SSS',large_drive)
	else: print this_case.replace('SSS','')
#	print '<h2><a name="%s_procedures">Procedure for Running Test Case %s</a></h2>'%(testcase,testcase)
	print '<h2 style="color: #0e375d;">Procedure for Running Test Case %s</h2>'%(testcase)
	print '<ol>'
	if case_head in run_map:
		print run_map[case_head]%{'var':variation,
		'case':testcase.lower(),
		'caseupper':testcase.upper(),
		'iface':iface.replace('FW','FireWire')}
	else: print "can't find",case_head
#	print run_map['FT-DI-01']
	print '</ol>'
#	print '<h2><a name="%s_eval">Evaluating Test Case %s</a></h2>' % (testcase,testcase)
	print '<h2 style="color: #0e375d;">Evaluating Test Case %s</h2>' % (testcase)
#	print eval_di_01
	print '<p>'
	print eval_map[case_head]%{'var':variation}

spacer='''
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
'''
spacer='''
<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
'''
report_header_text = '''
<p>Tool Name: %s
<br>Tool Version: %s
<br>Vendor: [INSERT]
<br><br>
<br>Agency conducting test: [INSERT]
<br>Contact: [INSERT]
<br>Report date:  [INSERT]
<br>Authored by:  [INSERT]
<br>Reviewed by/date:  [INSERT]
<br>Approved by/date : [INSERT]
<br>
<h2>Tool Description</h2>
 [INSERT]
<h2>Results Summary</h2>
<h3>Observations:</h3>
 [INSERT]
<h3>Concerns:</h3>
 [INSERT]
<h3>Tool Limitations:</h3>
 [INSERT]
<h3>Recommendations:</h3>
 [INSERT]
<h2>Test Environment</h2>
<br>Hardware:  [INSERT]
<br>OS: [INSERT]
<br>Software: [INSERT]
<h2>Test Results by Case</h2>
'''

results_by_case = {
'01' : '''
<br>Source drive reference hash values  [INSERT]
<br>Hash values reported by tool under test  [INSERT]
''',
'02' : '''
<br>Total number of sectors imaged [INSERT]
<br>Number of sectors that differ  [INSERT]
''',
'03' : '''
<br>Source drive reference hash values  [INSERT]
<br>Hash values reported by tool under test  [INSERT]
''',
'04' : '''
<br>Total number of sectors imaged [INSERT]
<br>Number of sectors that differ  [INSERT]
''',
'05' : '''
<br>Source drive reference hash values  [INSERT]
<br>Hash values reported by tool under test  [INSERT]
''',
'06' : '''
<br>Total number of sectors imaged [INSERT]
<br>Number of sectors that differ  [INSERT]
''',
'07' : '''
<br>Total number of sectors imaged [INSERT]
<br>Number of sectors that differ  [INSERT]
''',
'08' : '''
<br>Total number of sectors imaged [INSERT]
<br>Number of sectors that differ  [INSERT]
''',
'09' : '''
<br>Total number of sectors imaged [INSERT]
<br>Number of sectors that differ  [INSERT]
''',
'10' : '<br>Message indicating not enough space [INSERT]',
'11' : '<br>Message indicating not enough space [INSERT]',
'12' : '<br>Message indicating not enough space [INSERT]',
'13' : '''
<br>Source drive reference hash values  [INSERT]
<br>Hash values reported by tool under test  [INSERT]
''',
'14' : '''
<br>Source drive reference hash values  [INSERT]
<br>Hash values reported by tool under test  [INSERT]
''',
'15' : '''
<br>Total number of sectors imaged [INSERT]
<br>Number of sectors that differ  [INSERT]
'''
}


def report_header (t,tv):
	print spacer
#	print "============== REPORT HEADER =================="
	print '<h1><a name = test_report>Test Report for disk imaging tool:',t,'Version:',tv,'</h1>'
	print report_header_text%(t,tv)

def case_report (testcase,check_dco,check_hpa):
#	print "============== CASE REPORT ==================",testcase
	print '<h3>Test case %s</h3>' % testcase
	var = testcase.split('-')
#	print "Index on:",var
	print eval_map[testcase[0:8]]
	print "<br>"
	print results_by_case[var[2]]

#print "main check"
if __name__ == '__main__':
	print "Is MAIN"
	wrap_case('FT-DI-01-SATA28',False,False)
	case_report('FT-DI-01-USB',False,False)
