<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS Home";
$page_h1 = "String Search Testing Home";
$isSsHome = 1; // setting this variable will help ft_ss_head.php in rendering the page as we call it next...
include "ft_ss_head.php";
?>
<p>Welcome to the Federated Testing for Forensic String Search Tools. These pages
  will guide you in testing a forensic string search
  tool.
  Use the selections from the left hand menu at any time to navigate to different
  parts of the testing process or to return to this page.</p>
  <h2>Overview</h2>
  <p>These are the main parameters that are addressed across test cases:</p>
  <ul>
  <li>
  String Location: Active File, Deleted (but recoverable) file, Unallocated Space,
  and Meta-Data.
  </li>
  <li>
  Search Method (aka search engine): Indexed, Live or Physical.
  </li>
  <li>
  String Encoding: ASCII, UTF-8, UTF-16BE and UTF-16LE.
  </li>
  <li>
  Language: In addition to English,
  strings representative of diacritical marks (German, French, Spanish), non-Latin characters
   (Russian),
  right-to-left presentation (Arabic), and Asian languages (Chinese, Japanese and Korean).
  </li>
  <li>
  Fragmented File: String that spans two disjoint file fragments.
  </li>
  <li>
  Logical Operations: Combine search results with logical operators <b>and</b>,
  <b>or</b> and <b>not</b>.
  </li>
  <li>
  Stemming: Match inflected forms derived from a word stem, e.g., a search for <i>run</i> should
  also match <i>runs</i>, <i>running</i> and <i>ran</i>.
  </li>
  <li>
  Embedded Formatting: String with embedded formatting. MS Word and HTML.
  </li>
  </ul>

<br>
<?php
/*
*/
include "ft_ss_home_links.php";
?>
<?php
	include "ft_ss_tail.php";
?>

