   <?php

/******************************************************
 ******************************************************
 		LISTING OF TEST ACTIONS FOR EACH TEST CASE
 ******************************************************
 ******************************************************/
//List of Core Test Cases
$sqlite_core_tests = array("SFT-01" => "SQLite header parsing",
		   "SFT-02" => "SQLite Schema Reporting",
		   "SFT-03" => "SQLite Recoverable Rows",
		   "SFT-04" => "SQLite Data Element metadata",
		   "SFT-05" => "SQLite Schema Data Reporting",
		   "SFT-06" => "Recovered Row Metadata",
		   "SFT-07" => "SQLite Recovered Data Information",
		   "SFT-08" => "Journal Sequencing/wal timelining");
   
//TEST ACTIONS DETAILED LISTING FOR TEST CASES	 
$SFT_01_WAL = array("SQLITE3 SFT-01-WAL",		 
	 "PRAGMA journal_mode = WAL",
	 "PRAGMA encoding = UTF-8",
	 "PRAGMA PAGE_SIZE = 4096",
	 "Create Table",
	 "Populate with 100 rows of data");
//	 "Create 100 Rows of Data within Table");
//	 "Read header and validate: Page Size, Journal Mode, Number of Pages and Encoding.",
//	 "If files have changed, investigate each set of test actions to determine where the change occurred.");

$SFT_01_PERSIST = array("SQLITE3 SFT-01-PERSIST",
	 "PRAGMA journal_mode = PERSIST",
	 "PRAGMA encoding = UTF-16be",
	 "PRAGMA PAGE_SIZE = 1024",
	 "Create Table",
	 "Populate with 100 rows of data");

$SFT_01_OFF = array("SQLITE3 SFT-01-OFF",
	 "PRAGMA journal_mode = OFF",
	 "PRAGMA encoding = UTF-16le",
	 "PRAGMA PAGE_SIZE = 8192",
	 "Create Table",
	 "Populate with 100 rows of data");

$SFT_02_WAL = array("SQLITE3 SFT-02-WAL",
         "PRAGMA journal_mode = WAL",
	 "Create Table with 5 or more columns",
	 "Populate with 100 rows of data",
	 "Validate table and column names plus number of rows");
//	 "Create 100 Rows of Data within Table");
//	 "Validate table names, column names and number of rows");
//	 ".quit");
//	 "If files have changed, investigate each set of test actions to determine where the change occurred.");

$SFT_02_PERSIST = array("SQLITE3 SFT-02-PERSIST",
         "PRAGMA journal_mode = PERSIST",
	 "Create Table with 5 or more columns",
	 "Populate with 100 rows of data",
	 "Validate table and column names plus number of rows");

$SFT_02_OFF = array("SQLITE3 SFT-02-OFF",
         "PRAGMA journal_mode = OFF",
	 "Create Table with 5 or more columns",
	 "Populate with 100 rows of data",
	 "Validate table and column names plus number of rows");

$SFT_03_WAL = array("SQLITE3 SFT-03-WAL",
	 "PRAGMA journal_mode=WAL",
	 "Create table with 100 or more rows",	 
	 "Delete 10% of rows",
	 "Modify 10% of rows");
//	 "Execute Hard Stop (e.g., CTRL+C)");
//	 "Perform SQLITE data recovery");
//	 "Validate reporting of 100 deleted rows and 100 modified rows.");
//	 ".quit");
//	 "If files have changed, investigate each set of test actions to determine where the change occurred.");

$SFT_03_PERSIST = array("SQLITE3 SFT-03-PERSIST",
	 "PRAGMA journal_mode=PERSIST",
	 "Create table with 100 or more rows",	 
	 "Delete 10% of rows",
	 "Modify 10% of rows");

$SFT_03_OFF = array("SQLITE3 SFT-03-OFF",
	 "PRAGMA journal_mode=OFF",
	 "Create table with 100 or more rows",	 
	 "Delete 10% of rows",
	 "Modify 10% of rows");

$SFT_04_WAL = array("SQLITE3 SFT-04-WAL",
	 "Use the file SQLITE3 SFT-03-PERSIST.sqlite",
	 "PRAGMA journal_mode=WAL",
	 "Perform data recovery",	 
	 "Verify the source filename");

$SFT_04_PERSIST = array("SQLITE3 SFT-04-PERSIST",
	 "Use the file SQLITE3 SFT-03-PERSIST.sqlite",
	 "PRAGMA journal_mode=PERSIST",
	 "Perform data recovery",	 
	 "Verify the source filename");

$SFT_04_OFF = array("SQLITE3 SFT-04-OFF",
	 "Use the file SQLITE3 SFT-03-OFF.sqlite",
	 "PRAGMA journal_mode=PERSIST",
	 "Perform data recovery",	 
	 "Verify the source filename");

$SFT_05_WAL = array("SQLITE3 SFT-05-WAL",
	 "Create table with 5 or more columns with a primary key",
	 "Use column datatypes = Int, Float, Text Blob, Boolean",
	 "Populate table with 100 data rows",
	 "Report data creation for the column dataypes");

$SFT_05_PERSIST = array("SQLITE3 SFT-05-PERSIST",
	 "Create table with 5 or more columns with a primary key",
	 "Use column datatypes = Int, Float, Text Blob, Boolean",
	 "Populate table with 100 data rows",
	 "Report data creation for the column dataypes");

$SFT_05_OFF = array("SQLITE3 SFT-05-OFF",
	 "Create table with 5 or more columns with a primary key",
	 "Use column datatypes = Int, Float, Text Blob, Boolean",
	 "Populate table with 100 data rows",
	 "Report data creation for the column dataypes");

$SFT_06_WAL = array("SQLITE3 SFT-06-WAL",
	 "Use the file SQLITE3 SFT-03-WAL.sqlite",
	 "PRAGMA journal_mode=WAL",
	 "Perform data recovery",	 
	 "Verify the source filename",
	 "Verify updated or deleted row changes");

$SFT_06_PERSIST = array("SQLITE3 SFT-06-PERSIST",
	 "Use the file SQLITE3 SFT-03-WAL.sqlite",
	 "PRAGMA journal_mode=WAL",
	 "Perform data recovery",	 
	 "Verify the source filename",
	 "Verify updated or deleted row changes");

$SFT_06_OFF = array("SQLITE3 SFT-06-OFF",
	 "Use the file SQLITE3 SFT-03-WAL.sqlite",
	 "PRAGMA journal_mode=WAL",
	 "Perform data recovery",	 
	 "Verify the source filename",
	 "Verify updated or deleted row changes");

$SFT_07_WAL = array("SQLITE3 SFT-07-WAL",
	 "Use the file SQLITE3 SFT-03-WAL.sqlite",
	 "PRAGMA journal_mode=WAL",
	 "Perform data recovery",	 
	 "Verify data offset and length in recovered rows",
	 "Verify table name of recovered rows");

$SFT_07_PERSIST = array("SQLITE3 SFT-07-PERSIST",
	 "Use the file SQLITE3 SFT-03-WAL.sqlite",
	 "PRAGMA journal_mode=PERSIST",
	 "Perform data recovery",	 
	 "Verify data offset and length in recovered rows",
	 "Verify table name of recovered rows");

$SFT_07_OFF = array("SQLITE3 SFT-07-OFF",
	 "Use the file SQLITE3 SFT-03-WAL.sqlite",
	 "PRAGMA journal_mode=OFF",
	 "Perform data recovery",	 
	 "Verify data offset and length in recovered rows",
	 "Verify table name of recovered rows");

$SFT_08_WAL = array("SQLITE3 SFT-08-WAL",
	 "Use these 2 file SQLITE3 SFT-03-WAL.sqlite",
	 "and SQLITE3 SFT-03-WAL.sqlite-wal",
	 "PRAGMA journal_mode=WAL",
	 "Perform data recovery",	 
	 "Order recovered transactions within the -wal journal file",
	 "Record any changes.");

$SFT_08_PERSIST = array("SQLITE3 SFT-08-PERSIST",
 	"Use these 2 file SQLITE3 SFT-03-WAL.sqlite",
	 "and SQLITE3 SFT-03-WAL.sqlite-wal",
	 "PRAGMA journal_mode=WAL",
	 "Perform data recovery",	 
	 "Order recovered transactions within the -wal journal file",
	 "Record any changes.");

$SFT_08_OFF = array("SQLITE3 SFT-08-OFF",
 	 "Use these 2 file SQLITE3 SFT-03-WAL.sqlite",
	 "and SQLITE3 SFT-03-WAL.sqlite-wal",
	 "PRAGMA journal_mode=WAL",
	 "Perform data recovery",	 
	 "Order recovered transactions within the -wal journal file",
	 "Record any changes.");


// TEST ACTION LISTINGS FOR EACH OF THE CORE TESTS. Maps to table definitions
$SFT_01 = array($SFT_01_WAL,
	$SFT_01_PERSIST,
	$SFT_01_OFF);

$SFT_02 =array($SFT_02_WAL,
	$SFT_02_PERSIST,
	$SFT_02_OFF);

$SFT_03 = array($SFT_03_WAL,
	$SFT_03_PERSIST,
	$SFT_03_OFF);
	
$SFT_04 = array($SFT_04_WAL,
	$SFT_04_PERSIST,
	$SFT_04_OFF);

//$SFT_05 = array($SFT_05_Schema_Data_Reporting);
$SFT_05 = array($SFT_05_WAL,
	$SFT_05_PERSIST,
	$SFT_05_OFF);

$SFT_06 = array($SFT_06_WAL,
	$SFT_06_PERSIST,
	$SFT_06_OFF);

$SFT_07 = array($SFT_07_WAL,
	$SFT_07_PERSIST,
	$SFT_07_OFF);
	
$SFT_08 = array($SFT_08_WAL,
	$SFT_08_PERSIST,
	$SFT_08_OFF);
	

		 
/******************************************************
 ******************************************************
 		RECORD TABLES FOR REPORTING
 ******************************************************
 ******************************************************/
$rpSFT_01_WAL = array("Variation" => "SFT-01-Header Parsing WAL",
	 "Page Size" => "4096",
	 "Journal_Mode" => "WAL",
	 "UTF8" => "UTF8",
	 "UTF16BE" => "UTF16BE",
	 "UTF16LE" => "UTF16LE",
	 "Number of Pages" => '100');

$rpSFT_01_PERSIST = array("Variation" => "SFT-01-Header Parsing PERSIST",
	 "Page Size" => "1024",
	 "Journal_Mode" => "PERSIST",
	 "UTF8" => "UTF8",
	 "UTF16BE" => "UTF16BE",
	  "UTF16LE" => "UTF16LE",
	 "Number of Pages" => '100');

$rpSFT_01_OFF = array("Variation" => "SFT-01-Header Parsing OFF",
	 "Page Size" => "8192",
	 "Journal_Mode" => "OFF",
	 "UTF8" => "UTF8",
	 "UTF16BE" => "UTF16BE",
	  "UTF16LE" => "UTF16LE",
	 "Number of Pages" => '100');

$rpSFT_02_WAL = array("Variation" => "SFT-02-Schema Reporting WAL",
	 "tname" => "Table Name",
	 "cname" => "Column Name",
	 "rnum" => "Number of Rows");
	 
$rpSFT_02_PERSIST = array("Variation" => "SFT-02-Schema Reporting PERSIST",
	 "tname" => "Table Name",
	 "cname" => "Column Name",
	 "rnum" => "Number of Rows");

$rpSFT_02_OFF = array("Variation" => "SFT-02-Schema Reporting OFF",
	 "tname" => "Table Name",
	 "cname" => "Column Name",
	 "rnum" => "Number of Rows");

$rpSFT_03_WAL = array("Variation" => "SFT-03-Recoverable Rows WAL",
	 "delete" => "Deleted",
	 "modify" => "Modified");

$rpSFT_03_PERSIST = array("Variation" => "SFT-03-Recoverable Rows PERSIST",
	 "delete" => "Deleted",
	 "modify" => "Modified");

$rpSFT_03_OFF = array("Variation" => "SFT-03-Recoverable Rows OFF",
	 "delete" => "Deleted",
	 "modify" => "Modified");

$rpSFT_04_WAL = array("Variation" => "SFT-04-Data Element Metadata WAL",
	 "emdelete" => "Deleted",
	 "emmodify" => "Modified");

$rpSFT_04_PERSIST = array("Variation" => "SFT-04-Data Element Metadata PERSIST",
	 "emdelete" => "Deleted",
	 "emmodify" => "Modified");

$rpSFT_04_OFF = array("Variation" => "SFT-04-Data Element Metadata OFF",
	 "emdelete" => "Deleted",
	 "emmodify" => "Modified");

$rpSFT_05_WAL = array("Variation" => "SFT-05-Schema Data Reporting WAL",
	 "prikey" => "Primary Key",
	 "int" => "Int",
	 "float" => "Float",
	 "text" => "Text",
	 "blob" => "BLOB",
	 "bool" => "Boolean");

$rpSFT_05_PERSIST = array("Variation" => "SFT-05-Schema Data Reporting PERSIST",
	 "prikey" => "Primary Key",
	 "int" => "Int",
	 "float" => "Float",
	 "text" => "Text",
	 "blob" => "BLOB",
	 "bool" => "Boolean");

$rpSFT_05_OFF = array("Variation" => "SFT-05-Schema Data Reporting OFF",
	 "prikey" => "Primary Key",
	 "int" => "Int",
	 "float" => "Float",
	 "text" => "Text",
	 "blob" => "BLOB",
	 "bool" => "Boolean");

$rpSFT_06_WAL = array("Variation" => "SFT-06-Recovered Row Metadata WAL",
	 "srcfile" => "Source File",
	 "status" => "Modified, Deletion");

$rpSFT_06_PERSIST = array("Variation" => "SFT-06-Recovered Row Metadata PERSIST",
	 "srcfile" => "Source File",
	 "status" => "Modified, Deletion");

$rpSFT_06_OFF = array("Variation" => "SFT-06-Recovered Row Metadata OFF",
	 "srcfile" => "Source File",
	 "status" => "Modified, Deletion");

$rpSFT_07_WAL = array("Variation" => "SFT-07-Recovered Row Info WAL",
	 "offset" => "File offset",
	 "rrtname" => "Recovered Row Table Name");
	 
$rpSFT_07_PERSIST = array("Variation" => "SFT-07-Recovered Row Info PERSIST",
	 "offset" => "File offset",
	 "rrtname" => "Recovered Row Table Name");
	 
$rpSFT_07_OFF = array("Variation" => "SFT-07-Recovered Row Info OFF",
	 "offset" => "File offset",
	 "rrtname" => "Recovered Row Table Name");

$rpSFT_08_WAL = array("Variation" => "SFT-08-Journal Sequencing Wal Timeline WAL",
	 "jourseq" => "Journal Sequencing",
	 "waltime" => "Wal Timelining");

$rpSFT_08_PERSIST = array("Variation" => "SFT-08-Journal Sequencing Wal Timeline PERSIST",
	 "jourseq" => "Journal Sequencing",
	 "waltime" => "Wal Timelining");

$rpSFT_08_OFF = array("Variation" => "SFT-08 Journal Sequencing Wal Timeline OFF",
	 "jourseq" => "Journal Sequencing",
	 "waltime" => "Wal Timelining");



/******************************************************
 ******************************************************
 		README FULL TEST CASE DESCRIPTIONS
 ******************************************************
 ******************************************************/

$full_case_desc = array("SFT-01 Header Parsing" => "This test case verifies that the tool provides the following  attributes as contained in the SQLite header: Page Size, Journal Mode Information, Number of Pages, Text Encoding (i.e. UTF-8, UTF-16 Little Endian, UTF-16 Big Endian).",
	"SFT-02 SQLite Schema Reporting" => "This test case verifies that the tool provides a listing of all: (1. Tables, 2. Column names for each table, and 3. Row information for each table.",
	"SFT-03 Recoverable Rows" => "This test case verifies that the tool reports the file name (e.g., source) and recovered information for all recoverable rows (e.g., deleted and updated: SQLite database file and SQLite database journal mode file (e.g., - journal, -wal).",
	"SFT-04 Data Element Metadata" => "This test case verifies that the tool reports the file name (e.g., source) for all recovered data elements: SQLite database file, and SQQLite database journal mode file (e.g., -journal, -wal).",
	"SFT-05 Schema Data Reporting" => "This test case verifies that the tool reports the SQLite metadatafor, all create table statements, type (e.g., Storage Class, datatype or affinity) for each column, and identify which column is the primary key for each table in the database.",
	"SFT-06 Recovered Rows Metadata" => "This test case verifies that the tool reports the recovered row because of either a deletion or an update within the database file, or the associated journal mode file (e.g., -journal,-wal).",
	"SFT-07 Recovered Data Information" => "This test case verifies that the tool reports the following metatdata for each recoverable data elements: 1. Offset within the file, and 2. Identify the table name associated with the row.",				  
	"SFT-08 Journal Sequencing/wal timelining" => "This test verifies that the tool reports the sequence of transactions in the associated -wal file.",);


/* Call this function with a given search engine, data set, the path to where the se's results 
   are stored, and the list of test cases the user selected to run to find out if all the test 
   cases have been run for that data set-search engine combination...     
	 */
function is_se_tested($ds, $se, $base, $testcases) {
	
	global $d_dict, $ignore_for_unix;

	$is_tested = TRUE;
	
	foreach ($testcases as $testcase){
		if (!((strcmp($ds,'UNIX') == 0) and (in_array($testcase, $ignore_for_unix)))){ // some test cases don't apply to the UNIX data set... skip/ignore/don't print these if we're testing the UNIX data set
			// if any of the cases is missing a log file, then more tests need to be run 
			if (!file_exists($base.'/'.$testcase.'.txt')){
				$is_tested = FALSE;
			}
		}
	}
	
	return $is_tested;
}	 
		

?>