<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS Be Aware";
$page_h1 = "Overview of What You Need to Know About the Search Tool";
include "ft_ss_head.php";
?>
    <p>
	  <h2>Things you need to be aware of:</h2>
	  <p> You need to become familiar with the capabilities of the tool before you try
	  to test the tool. In particular, you need to know how to do the following:
	  <ul>
	  <li> configure a search to either ignore case or match case,
	  <li> configure a search to either match a whole word or a substring,
	  <li> configure a search to look for UTF-8, UTF-16BE and UTF-16LE,
	  <li> configure a search to use a particular search method (also called search engine),
	  e.g., as either indexed, live or physical.
	  A tool may offer more than one search engine, in which case the ones you use should be tested.
	  <li> Each vendor has original terminology and it may be unclear the search method being used.
	  In general, if a tool requires a lengthy step to <i>process</i> an image before it
	  can be searched, this is an indexed search. While a tool that allows searching without
	  a preprocessing step or it takes a long time to search for a keyword it is usually a live search.
	  For example, Autopsy does an indexed search;
	  X-Ways <i>Logical Search</i> is a live search, <i>Indexed Search</i> is an indexed search.
	  X-Ways offers a third search engine, <i>Physical Search</i>; FTK offers both indexed and live. 
	  </ul>
      <br>
    </p>
<?php
/*
*/
include "ft_ss_home_links.php";
?>
<br>
<?php
	include "ft_ss_tail.php";
?>

