<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS Get Data Set";
$page_h1 = "Selecting String Search Data Set";

include "ft_ss_need_logs.php";

if($ftlogs_mounted==1){ // we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php  
	// (via ft_ss_need_logs.php). If the drive's not mounted, suppress/do not print the rest of this page.
	/* <h1>Select Data Set for Testing the Tool</h1> */
 	$mess = $_GET["mess"];
	if ($mess == "xx"){
		printf ("<p><b>You can't <i>Run A Test Case</i> until you select a Test Data Set</b></p>\n");
	}
	if ($need_ds == 1){
		printf ('<h2>No Current Data Set Selected, please select one.</h2>');
	} else {
		printf ('<p>Current Data Set: <b>%s</b></p>',$ds[0]);
 		printf ("<p>You can keep testing with the current data set or specify a different ".
			"data set.</p>\n");
	}
?>
<div style="padding: 1em 1em 0.5em 1em; background: #eeeeee url(" images="" ui-bg_highlight-soft_100_eeeeee_1x100.png")="" 50%="" top="" repeat-x;"="">
<form method="POST" action="/stringsearch/ft_ss_update.php">
<p>There are two test data sets that can be downloaded to test 
a search tool. The Windows based data set has three formatted
partitions (FAT32, ExFAT and NTFS), a unformatted partition and
some strings in locations unreachable by normal file system access.
The second test image has three UNIX-like formatted partitions (OSX Journaled,
OSX Case Sensitive, APFS (Apple File System) and Linux ext4).</p>
<p>You need to select a data set from the list below:</p>
<p><input type="radio" name="DataSet" checked="checked" value="Windows"> Windows: FAT, ExFat and NTFS</p>
<p><input type="radio" name="DataSet" value="UNIX"> UNIX: ext4, APFS (Apple File System), OSX Journaled and OSX Case-sensitive</p>
<br>
	</div>
<input type="hidden" name="what" value="DataSet">
<br>
<input value="Record Selected Data Set" type="submit"> </form>
<br>
<?php
} // endif($ftlogs_mounted==1)
include "ft_ss_tail.php";
?>
