<?php
	include_once 'functions.php';

	if (isset($_GET['presskey_sbs'])) {
		addRemovePresskey('../../base_files/Start-Both-Servers.bat', $_GET['presskey_sbs'] == 'yes');
		addRemovePresskey('../../Start-Both-Servers.bat', $_GET['presskey_sbs'] == 'yes');
		
		startServers('../../base_files/set-path.bat', $_GET['startservers_sp'] == 'yes');
		startServers('../../set-path.bat', $_GET['startservers_sp'] == 'yes');
		
		setSafemode($_GET['safe_mode'] == 'yes');
		
		setShortopentag($_GET['short_open_tag'] == 'yes');
		
		header('Location: index.php');
	}
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
	<title>Lighty2Go Settings</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-15">
	<link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
	<h1>Lighty2Go Settings</h1>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get">
		<fieldset>
			<legend>Lighty2Go program settings</legend>
			<p>Do you want both servers to be started when Lighty2Go is launched?</p>
			<p class="description">Both LightTPD and MySQL will be started 
				automatically when you run Start-Lighty2Go.exe. Depending on the 
				setting below you might have to press a key twice for the servers 
				to start.</p>
			<input type="radio" name="startservers_sp" value="yes" id="sp_yes" <?php echo isStartingservers() ? 'checked="checked"' : '';?>>
			<label for="sp_yes">Yes</label>
			<input type="radio" name="startservers_sp" value="no" id="sp_no" <?php echo !isStartingservers() ? 'checked="checked"' : '';?>>
			<label for="sp_no">No</label>

			<p>Do you want to press a key after each server when starting both?</p>
			<p class="description">Displays the "Press any key to continue..."
				message and waits for you to press a key after starting LightTPD
				and again after starting MySQL.</p>
			<input type="radio" name="presskey_sbs" value="yes" id="sbs_yes" <?php echo hasPresskey() ? 'checked="checked"' : '';?>>
			<label for="sbs_yes">Yes</label>
			<input type="radio" name="presskey_sbs" value="no" id="sbs_no" <?php echo !hasPresskey() ? 'checked="checked"' : '';?>>
			<label for="sbs_no">No</label>
		</fieldset>

		<fieldset>
			<legend>PHP settings</legend>
			<p>Do you want to have safe mode on?</p>
			<p class="description">The PHP safe mode is an attempt to solve the 
				shared-server security problem. It is architecturally incorrect 
				to try to solve this problem at the PHP level, but since the 
				alternatives at the web server and OS levels aren't very realistic, 
				many people, especially ISP's, use safe mode for now.</p>
			<input type="radio" name="safe_mode" value="yes" id="s_m_yes" <?php echo isSafemode() ? 'checked="checked"' : '';?>>
			<label for="s_m_yes">Yes</label>
			<input type="radio" name="safe_mode" value="no" id="s_m_no" <?php echo !isSafemode() ? 'checked="checked"' : '';?>>
			<label for="s_m_no">No</label>

			<p>Do you want to use short php open tags?</p>
			<p class="description">This will allow the &lt;? tag. Otherwise, only 
				&lt;?php and &lt;script&gt; tags are recognized. NOTE: Using short 
				tags should be avoided when developing applications or libraries 
				that are meant for redistribution, or deployment on PHP servers 
				which are not under your control, because short tags may not be 
				supported on the target server. For portable, redistributable code,
				be sure not to use short tags.</p>
			<input type="radio" name="short_open_tag" value="yes" id="s_o_t_yes" <?php echo isShortopentag() ? 'checked="checked"' : '';?>>
			<label for="s_o_t_yes">Yes</label>
			<input type="radio" name="short_open_tag" value="no" id="s_o_t_no" <?php echo !isShortopentag() ? 'checked="checked"' : '';?>>
			<label for="s_o_t_no">No</label>
		</fieldset>

		<p>Please restart Lighty2Go after pressing "Save" to make sure all settings are in use.</p>
		<input type="submit" value="Save">
	</form>
	<p class="link"><a href="http://127.0.0.1">Return to the Lighty2Go test page.</a></p>
</body>
</html>