<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS - Home";
$page_h1 = "String Search Testing Home";
$isSsHome = 1; // setting this variable will help ft_ss_head.php in rendering the page as we call it next...
include "ft_ss_head.php";
?>
<div style="padding: 1em 1em 0.5em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<p>Welcome to the Federated Testing test suite for forensic string search tools. The following steps will guide you in testing a forensic string search tool. Use the selections from the left hand menu 
at any time to navigate to different parts of the testing process or to return to this page. Visit the 
<a href="readmehelp.php">Readme / Help</a> page to learn more about the testing process, testing string search tools, and FAQs.</p>

<ol>
	<!--      <li>Select and download the string search test images from the <i>Federated Testing String Search</i>
section of the CFReDS website, https://www.cfreds.nist.gov.
There are two test images (.dd files).
one image is for testing search tools on
Microsoft Windows type file systems (FAT, ExFAT 
and NTFS) along with a block of unallocated storage space. The other 
test image is for testing searching UNIX-like file systems (OSX, APFS and ext4).
An HTML file is also included in the download. This file should be opened in
a browser on the test computer. The file can be used for entering search
target strings by copy and paste. This is helpful for entering non-English
text as a search target string.
</li>-->
<li>Download the String Search data set from the <i>Federated Testing Test Data Sets</i>
section of the CFReDS website, <a href="https://www.cfreds.nist.gov">www.cfreds.nist.gov</a>. Copy the data set to your test computer 
(the computer where your forensic string search tool is installed). Unzip the data set and familiarize yourself with the contents. There are two test images (.dd files), one for testing search tools on
Microsoft Windows type file systems (FAT, ExFAT 
and NTFS) and one 
 for testing searching on UNIX-like file systems (ext4, APFS, and OSX), and other files that are used in the testing process.<!--
A string-search-test-cases.html HTML file is also included in the download. This file should be opened in
a browser on the test computer. The file can be used for entering search
target strings by copy and paste. This is helpful for entering non-English
text as a search target string. The ft-ss-07-Norm-strings.txt file should be used to copy and paste the target strings for test case FT-SS-07-Norm. The Expected Results by ID file can be printed and used to record the test results of each test case to paper as an intermediate step to recording the results in this test suite.--></li>
<!-- <li>Use the '<a href="/formatyourthumb.php?ref=ss">Format Your Log Drive FT-LOGS</a>' 	page to prepare a flash drive for storing test logs.</li> -->
<li>Generate the list of tests to run for the tool using the <a href="customizetest.php">
<i>'Generate Test Cases &amp; Start Testing'</i></a> pages. <font color="red"><b></b></font></li>
<li>Run each test to test the tool. At this point, you may prefer to print the <i>Expected Results by ID - mm-dd Data Set.pdf</i> file included in the data set download and use it to record the test results of each test case to paper as an intermediate step to recording the results in this test suite. If you have to reboot your computer, use 
<a href="selectdataset.php">
<i>'Continue Testing'</i></a> to return to running the tests.</li>

<li>Use the '<?php
// if doing dev work on mac, want to pass /tmp as path to log drive; if on Linux,
// pass /media/FT-LOGS 
$mac = '/FedTest/cgi-bin';
//$linux = '/FedTest/cgi-bin';
$prtpath = get_cgipath(TRUE);
if (file_exists($mac)){
  // if on mac, 
  //echo '<a href="/generatefinalreport.php?ref=ss&path=\FedTest\media\cftt\FT-LOGS">';
  echo '<a href="/generatefinalreport.php?ref=ss&path='.$prtpath.'">';
} else {
  // else, on linux,
  //echo '<a href="/generatefinalreport.php?ref=ss&path=\FedTest\media\cftt\FT-LOGS">';
  echo '<a href="/generatefinalreport.php?ref=ss&path='.$prtpath.'">';
}
?>Generate a Test Report</a>' page to create a draft test report.  It will be 
saved to the FT-LOGS logging directory. Some sections of the report will need to be completed by the tester.</li>
<li>(Optional) Submit the test report and the testing log files to CFTT to share with the forensics community! See <a href="../shareyourresults.php?ref=ss"><i> 
'Share Your Results'</i></a> for instructions on how to share the test results.
<font color="red"></font></li>
</ol>
</p>
<br>
</div>

<?php
/*
*/
//include "ft_ss_home_links.php";
?>
<?php
	include "ft_ss_tail.php";
?>

