<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>CFTT Federated Testing CD - test a Mobile Device tool</title>
<link rel="stylesheet" type="text/css" href="../css/reset.css" media="screen" />
<link rel="stylesheet" type="text/css" href="../css/main_style.css" media="screen" />
<link rel="stylesheet" type="text/css" href="../css/layout.css" media="screen" />
</head>
<body id="menu1">
	<div id="mainWrapper">
		<div id="topBannerContainer">
			<div id="logoContainer">
  				<img src="../images/banner.png" alt="CFTT Federated Testing - NIST">
			</div>
            <!-- Menu Starts-->
			<div id="menuContainer">
<?php
include '../include/global.php';
print_main_horizontal_menu_contents();
?>
    		</div>
            <!-- Menu Ends-->
		</div>
		<!-- TopBanner Ends-->
 
		<!-- Main Content Starts-->	
		<div id="subContentContainer">
		  <div id="leftContent">
		    <div id="leftLinks">
			  <div>
<?php
include '../include/mdt-global.php';
?>
		      </div>
		    </div>
		  </div>			
		  <div id="rightContent">
<!--		    <div id="breadcrumb"><a href="../Federated_Testing_Home_Page.php">Home</a> > Test a disk imaging tool</div>-->
		    <div id="breadcrumb"><a href="../Federated_Testing_Home_Page.php" class="nav">Home</a> &gt; <a href="/mobiledevice/mdt.php" class="nav"> Mobile Device Testing Home</a> &gt; Entering Tool Name and Version</div>

<?php
	$continue = 1;

	// is_ftlogs_mounted() returns the path to where we should store log files (e.g.,  
	// /tmp or /media/FT-LOGS). It also checks if the user has mounted their log drive.
	// is_ftlogs_mounted() will return 0/false and print an error message if the 
	// user's log drive is not mounted
	
	// csr $path = is_ftlogs_mounted(FALSE);
	$path = is_ftlogs_mounted(TRUE);
	$filename = 'mdt-config.txt';

    if (!$path) { 
		// if the user's log drive isn't mounted, don't continue
		$continue = 1;
	}

	// if the user's log drive isn't mounted, don't continue
	if ($continue){
		//$path = '/FedTest/media/cftt/FT-LOGS';
		echo "<h1>Entering Tool Name and Version (2 of 2)</h1>";

		// see if we can open the config file
		if ($handle = fopen($path."/".$filename, 'w')){
			
			// grab/declare any variables from $_POST
			extract($_POST);
			// make sure/check the user entered a value for tool name on the previous page
			if ($toolname == ""){
				echo "<p><b>Error:&nbsp;</b> <i><b>No value entered for \"tool name.\" Please use the browser's back button to return to the previous page and enter the name of the tool you're testing.</b></i></p>";
				$continue = 0;					
			}
			// make sure/check the user entered a value for tool version on the previous page
			if ($toolversion == ""){
				echo "<p><b>Error:&nbsp;</b> <i><b>No value entered for \"tool version.\" Please use the browser's back button to return to the previous page and enter the version of the tool you're testing.</b></i></p>";
				$continue = 0;					
			}

			// if the user didn't enter a tool name or version, don't continue
			if ($continue){
				// write tool name and version to the config file
				fwrite($handle, $toolname."\n");
				fwrite($handle, $toolversion."\n");

				echo "'".$filename."' written to '".$path."' <br><br>";
				echo '<div style="padding: 0em 1em .25em .5em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">';
				echo '<p>Tool name: &nbsp;&nbsp;&nbsp;<i>'.$toolname.'</i></p>';
				echo '<p>Tool version: <i>'.$toolversion.'</i></p>';
				echo '</div><br>	';
				echo '<p>Click <a href="ft_mdt_get_device.php">Create/Edit Mobile Device List</a> to continue to the next step and record your test devices.</p>';
	//			echo '<p>Click to <a href="mdt.php">return to the Mobile Device Home Page</a></p>';
			}
			fclose($handle);
		} else {
			echo "<p><b>Error: <i>".basename($_SERVER['PHP_SELF'])."</i> encountered ";
			echo "an error trying to write to ".$path."/".$filename.".</b></p>";	
		}
	}
?>
		</div>
		<div class="push"></div>
	</div>
   <!-- Footer Starts-->
        <?php
     $fn = $_SERVER["SCRIPT_FILENAME"];
          print_footer_contents($fn);
        ?>
    <!-- Footer Ends-->
</div></body></html>
