#!/FedTest/cgi-bin/python
import json

#th {
#	   border-collapse: collapse;
#	   border: 1px solid black;
#	   text-align: center;
#	   } 
#	table, th, td {
#	   border-collapse: collapse;
#	   border: 1px solid black;
#	   } 


head = """
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <meta content="text/html; charset=UTF-8"
 http-equiv="Content-Type">
  <title>SQLite Data Recovery Test Module</title>
  <meta content="Federated_Testing_SQLite_Test_Module"
 name="description">
	<style>
	em.x {color: green;font-size: 100%;font-style:italic;font-weight:bold;}
	em.p {bgcolor: green;font-size: 100%;font-weight:bold;}

	#intable {
		width:325px;
	}
	#resultab {
		width:105px;
	}

body {
counter-reset: chapter;
}

h1 {
counter-increment: chapter;
counter-reset: section;
}

h2 {
counter-increment: section;
counter-reset: sub;
}

h3 {
counter-increment: sub;
}

h1:before {
content: counter(chapter) " ";
}
h2:before {
content: counter(chapter) "." counter(section) " ";
}

h3:before {
content: counter(chapter) "." counter(section) "." counter(sub) " ";
}

	</style>
</head>
<body>
"""
report_title = """
<div>
<h1 style="text-align:center; color:green;">SQLite Testing</h1>
</div>
"""
report_introduction ="""
<div>
<h1>Introduction</h1>
<p>
The Computer Forensics Tool Testing (CFTT) program is a joint project of the Department of Homeland Security (DHS), the National Institute of Justice (NIJ), and the National Institute of Standards and Technology Special Program Office (SPO) and Information Technology Laboratory (ITL). CFTT is supported by other organizations, including the Federal Bureau of Investigation, the U.S. Department of Defense Cyber Crime Center, U.S. Internal Revenue Service Criminal Investigation Division Electronic Crimes Program, and the U.S. Department of Homeland Security&#39;s Bureau of Immigration and Customs Enforcement, U.S. Customs and Border Protection and U.S. Secret Service. The objective of the CFTT program is to provide measurable assurance to practitioners, researchers, and other applicable users that the tools used in computer forensics investigations provide accurate results. Accomplishing this requires the development of specifications and test methods for computer forensics tools and subsequent testing of specific tools against those specifications.  
</p>
<p>
Test results provide the information necessary for developers to improve tools, users to make informed choices, and the legal community and others to understand the tools&#39; capabilities. The CFTT approach to testing computer forensics tools is based on well-recognized methodologies for conformance and quality testing. Interested parties in the computer forensics community can review and comment on the specifications and test methods posted on the CFTT Web site (https://www.cftt.nist.gov/).
</p>
<p>
This document reports the results from testing the tool listed in &quot;Test Results for SQL Data Recovery&quot; for SQLite data recovery including: displaying recovered SQLite database information, identifying, categorizing and reporting Write-Ahead Log (WAL), Rollback Journal data and sequence WAL journal data.

Test results from other tools can be found on the DHS S&T-sponsored digital forensics web page, https://www.dhs.gov/science-and-technology/nist-cftt-reports.
</p>
</div>
"""

report_read_instructions="""
<div>
<h2>How to Read This Report</h2>
<p>
This report is divided into four sections. Section 1 identifies and provides a summary of any significant anomalies observed in the test runs. This section is sufficient for most readers to assess the suitability of the tool for the intended use. Section 2 lists testing environment and SQLite data objects used for testing. Section 3 provides an overview of the test case results reported by the tool
</p>
<h2>Test Results for SQLite Data Recovery</h2>
</div>
"""
report_section1_header="""
<div>
<h1>Results Summary</h1>
<p>
The tool
"""
report_section1="""
 was tested for its ability to report recovered SQLite database information. Except for the following noted anomalies for the listed test cases, the tool was able to report and recover all supported data objects completely and accurately. 
</p>
</div>
"""

report_section2a="""
<div>
<h1>Testing Environment</h1>
<p>
This section describes the selected test execution environment, and the data objects populated for SQLite data recovery. 
</p>
</div>
<div>
<h2><i>Execution Environment</i></h2>
<p> """

report_section2b="""
</p>
</div>
<div>
<h2><i>SQLite Data</i></h2>
<p>
The tool
"""
report_section2_data="""
was measured by its ability to report recovered SQLite database information.  <span style=\"color:green\">SQLite versions 3.19.0 (Android) and 3.32.3 (iOS) </span>were used when creating the SQLite databases.  These versions are the most current versions running on Android and iOS.  Table 2 below defines the SQLite data tested per each test case.
</p>
</div>
"""
report_section3_header= """
<div>
<h1>Test Results</h1>
This section provides the test case results reported by the tool.  Section 3.1 identifies the PRAGMA journal mode (i.e., WAL, PERSIST, OFF), test cases and associated data checked within individual test cases. 
The tool
"""
report_section3_body="""
 was tested for its ability to report recovered SQLite database information.
<p>
The Test Cases column in sections 3.1 are comprised of two sub-columns that define a particular test category and individual sub-categories that are verified when testing.  The results are as follows:
<ol>
<li>As Expected: the SQLite data recovery tool returned expected test results.</li>
<li>Not As Expected: the SQLite data recovery tool failed to return expected test results.</li>
<li>NA: Not Applicable - the test case was not performed.</li>
</ol>
</p>
<div>
<h2> SQLite Data Recovery </h2>
SQLite data recovery was testing with the tool
"""
report_section3_recovery= """ 

All test cases were successful with the exception of the following.
<p>
NOTES TAKEN
</p>
See Table 3 below for more details.

</div>
"""

#The files used in this script.
#htmlfile = "c:\FedTest\media\sqliteReport.html"
htmlfile = "\FedTest\media\cftt\FT-LOGS\sqliteReport.html"
jsnfile = "\FedTest\HTDOCS\sqlite\sqliterptdata.json" # file generated from the web tool
testcasejson = "\FedTest\HTDOCS\sqlite\sqlitedata.json" #data for the description table

#htmlfile = "../media/sqliteReport.html"
#jsnfile = "../HTDOCS/sqlite/sqliterptdata.json" # file generated from the web tool
#testcasejson = "../HTDOCS/sqlite/sqlitedata.json" #data for the description table
#JSON report data. File is generated from the web tool. Once reporting is complete this python code generate the 
#final report
#print("readfile")
with open(jsnfile) as json_file:
	reportdata = json.load(json_file)
	pretty_json = json.dumps(reportdata)
json_file.close()
print(pretty_json)

#may need this way format for python2
#with open('reportresults2.json','r') as json_file:
#	reportdata = [json.loads(line) for line in json_file]
#json_file.close()

#print(type(reportdata))
#print(type(reportdata[1]))
length = len(reportdata)
#print(length)
j = 0
#Setting table cell variables that will pull table data from json file SFT01
SFT01WALHeader =""
SFT01WALpgsize, SFT01PERSISTpgsize, SFT01OFFpgsize = ("","","")
SFT01WALjmode, SFT01PERSISTjmode , SFT01OFFjmode = ("","","")
SFT01WALutf8, SFT01PERSISTutf8, SFT01OFFutf8 = ("","","")
SFT01WALutf16be, SFT01PERSISTutf16be, SFT01OFFutf16be = ("","","")
SFT01WALutf16le, SFT01PERSISTutf16le, SFT01OFFutf16le = ("","","")
#Setting for table cell variables for SFT02
SFT02WALHeader = ""
SFT02WALtabname, SFT02PERSISTtabname, SFT02OFFtabname=("","","")
SFT02WALcolname, SFT02PERSISTcolname, SFT02OFFcolname=("","","")
SFT02WALrownum, SFT02PERSISTrownum, SFT02OFFrownum=("","","")
#Setting for table cell variables for SFT03
SFT03WALHeader=""
SFT03WALdel, SFT03PERSISTdel, SFT03OFFdel=("","","")
SFT03WALmod, SFT03PERSISTmod, SFT03OFFmod=("","","")
#Setting for SFT04
SFT04WALHeader=""
SFT04WALdel, SFT04PERSISTdel, SFT04OFFdel=("","","")
SFT04WALmod, SFT04PERSISTmod, SFT04OFFmod=("","","")
#Setting for SFT05
SFT05WALHeader=""
SFT05WALprikey, SFT05PERSISTprikey, SFT05OFFprikey=("","","")
SFT05WALint, SFT05PERSISTint, SFT05OFFint=("","","")
SFT05WALfloat, SFT05PERSISTfloat, SFT05OFFfloat=("","","")
SFT05WALtext, SFT05PERSISTtext, SFT05OFFtext=("","","")
SFT05WALblob, SFT05PERSISTblob, SFT05OFFblob=("","","")
SFT05WALbool, SFT05PERSISTbool, SFT05OFFbool=("","","")
#SFT06
SFT06WALHeader=""
SFT06WALsrcfile, SFT06PERSISTsrcfile, SFT06OFFsrcfile=("","","")
SFT06WALstatus, SFT06PERSISTstatus, SFT06OFFstatus=("","","")
#SFT07
SFT07WALHeader="" 
SFT07WALoffset, SFT07PERSISToffset, SFT07OFFoffset=("","","")
SFT07WALrrtname, SFT07PERSISTrrtname, SFT07OFFrrtname=("","","")
#SFT08
SFT08WALHeader=""
SFT08WALjournal, SFT08PERSISTjournal, SFT08OFFjournal=("","","")
SFT08WALwaltime, SFT08PERSISTwaltime,SFT08OFFwaltime=("","","")
#tooldata
tooldata = {}
#Notes
notes = {}
#Test Environment
testenv ={}

#extract all the data from json
toolname = ""
toolver = ""
toolsup = ""
tooladd = ""
toolcont = ""
toolww = ""
for i in reportdata:
#	print(i)
 #   print(reportdata[1])
	for key in reportdata[j]:
		print("THE KEYS " + key)
		if (key == "Tool Tested") :
			toolname = reportdata[j].get('Tool Tested')
			toolver = reportdata[j].get('Software Version')
			toolsup = reportdata[j].get('Supplier')
			tooladd = reportdata[j].get('Address')
			toolcont =  reportdata[j].get('Contact Number')
			toolww =  reportdata[j].get('WWW')
			#tooldata["Tool Tested"] = reportdata[j].get('Tool Tested')
			#tooldata['Software Version'] = reportdata[j].get('Software Version')
			#tooldata['Supplier']= reportdata[j].get('Supplier')
			#tooldata['Address'] = reportdata[j].get('Address')
			#tooldata['Contact Number'] =  reportdata[j].get('Contact Number')
			#tooldata['www'] =  reportdata[j].get('WWW')
			testenv['Operating System'] = reportdata[j].get('OS')
			testenv['OS version'] = reportdata[j].get('OSversion')
			testenv['testdate'] = reportdata[j].get('testdate')
		if (key == 'SFT_01_WAL' or key == 'SFT_01_PERSIST' or key == 'SFT_01_OFF'):
			print(key[7:])
			if (key[7:] == 'WAL'):
				SFT01WALHeader = reportdata[j].get('SFT01')
				SFT01WALpgsize = reportdata[j].get('pgsize')
				SFT01WALjmode = reportdata[j].get('jmode')				
				SFT01WALutf8 = reportdata[j].get('utf8')
				SFT01WALutf16be = reportdata[j].get('utf16be')
				SFT01WALutf16le = reportdata[j].get('utf16le')
				notes["note1W"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'PERSIST'):
				SFT01PERSISTpgsize = reportdata[j].get('pgsize')
				SFT01PERSISTjmode = reportdata[j].get('jmode')
				SFT01PERSISTutf8 = reportdata[j].get('utf8')
				SFT01PERSISTutf16be = reportdata[j].get('utf16be')
				SFT01PERSISTutf16le = reportdata[j].get('utf16le')
				notes["note1P"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'OFF'):
				SFT01OFFpgsize = reportdata[j].get('pgsize')
				SFT01OFFjmode = reportdata[j].get('jmode')
				SFT01OFFutf8 = reportdata[j].get('utf8')
				SFT01OFFutf16be = reportdata[j].get('utf16be')
				SFT01OFFutf16le = reportdata[j].get('utf16le')
				notes["note1O"] = (reportdata[j].get('comment')).strip()
			
			title1 = "<b>SFT-01:</br>" + SFT01WALHeader + "</b></br>"
		#setting SFT_02 variables
		if (key == 'SFT_02_WAL' or key == 'SFT_02_PERSIST' or key == 'SFT_02_OFF'):
#			print(key[7:])
			if (key[7:] == 'WAL'):
				SFT02WALHeader = reportdata[j].get('SFT02')
				SFT02WALtabname = reportdata[j].get('tabname')
				SFT02WALcolname = reportdata[j].get('colname')
				SFT02WALrownum = reportdata[j].get('rownum')
				notes["note2W"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'PERSIST'):
				SFT02PERSISTtabname = reportdata[j].get('tabname')
				SFT02PERSISTcolname = reportdata[j].get('colname')
				SFT02PERSISTrownum = reportdata[j].get('rownum')
				notes["note2P"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'OFF'):
				SFT02OFFtabname = reportdata[j].get('tabname')
				SFT02OFFcolname = reportdata[j].get('colname')
				SFT02OFFrownum = reportdata[j].get('rownum')
				notes["note2O"] = (reportdata[j].get('comment')).strip()
			title2 = "<b>SFT-02:</br>" + SFT02WALHeader + "</b></br>"
		#populated SFT03 variables
		if (key == 'SFT_03_WAL' or key == 'SFT_03_PERSIST' or key == 'SFT_03_OFF'):
#			print(key[7:])
			if (key[7:] == 'WAL'):
				SFT03WALHeader = reportdata[j].get('SFT03')
				SFT03WALdel = reportdata[j].get('del')
				SFT03WALmod = reportdata[j].get('mod')
				notes["note3W"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'PERSIST'):
				SFT03PERSISTdel = reportdata[j].get('del')
				SFT03PERSISTmod = reportdata[j].get('mod')
				notes["note3P"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'OFF'):
				SFT03OFFdel = reportdata[j].get('del')
				SFT03OFFmod = reportdata[j].get('mod')
				notes["note3O"] = (reportdata[j].get('comment')).strip()
			title3 = "<b>SFT-03:</br>" + SFT03WALHeader + "</b></br>"
		#populated SFT04 variables
		if (key == 'SFT_04_WAL' or key == 'SFT_04_PERSIST' or key == 'SFT_04_OFF'):
#			print(key[7:])
			if (key[7:] == 'WAL'):
				SFT04WALHeader = reportdata[j].get('SFT04')
				SFT04WALdel = reportdata[j].get('emdel')
				SFT04WALmod = reportdata[j].get('emmod')
				notes["note4W"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'PERSIST'):
				SFT04PERSISTdel = reportdata[j].get('emdel')
				SFT04PERSISTmod = reportdata[j].get('emmod')
				notes["note4P"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'OFF'):
				SFT04OFFdel = reportdata[j].get('emdel')
				SFT04OFFmod = reportdata[j].get('emmod')
				notes["note4O"] = (reportdata[j].get('comment')).strip()
			title4 = "<b>SFT-04:</br>" + SFT04WALHeader + "</b></br>"				
		#setting variables for SFT05
		if (key == 'SFT_05_WAL' or key == 'SFT_05_PERSIST' or key == 'SFT_05_OFF'):
#			print(key[7:])
			if (key[7:] == 'WAL'):
				SFT05WALHeader = reportdata[j].get('SFT05')
				SFT05WALprikey = reportdata[j].get('prikey')
				SFT05WALint = reportdata[j].get('int')
				SFT05WALfloat = reportdata[j].get('float')
				SFT05WALtext = reportdata[j].get('text')
				SFT05WALblob = reportdata[j].get('blob')
				SFT05WALbool = reportdata[j].get('bool')
				notes["note5W"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'PERSIST'):
				SFT05PERSISTprikey = reportdata[j].get('prikey')
				SFT05PERSISTint = reportdata[j].get('int')
				SFT05PERSISTfloat = reportdata[j].get('float')
				SFT05PERSISTtext = reportdata[j].get('text')
				SFT05PERSISTblob = reportdata[j].get('blob')
				SFT05PERSISTbool = reportdata[j].get('bool')
				notes["note5P"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'OFF'):
				SFT05OFFprikey = reportdata[j].get('prikey')
				SFT05OFFint = reportdata[j].get('int')
				SFT05OFFfloat = reportdata[j].get('float')
				SFT05OFFtext = reportdata[j].get('text')
				SFT05OFFblob = reportdata[j].get('blob')
				SFT05OFFbool = reportdata[j].get('bool')
				notes["note5O"] = (reportdata[j].get('comment')).strip()
			title5 = "<b>SFT-05:</br>" + SFT05WALHeader + "</b></br>"
		#SFT06
		if (key == 'SFT_06_WAL' or key == 'SFT_06_PERSIST' or key == 'SFT_06_OFF'):
#			print(key[7:])
			if (key[7:] == 'WAL'):
				SFT06WALHeader = reportdata[j].get('SFT06')
				SFT06WALsrcfile = reportdata[j].get('srcfile')
				SFT06WALstatus = reportdata[j].get('status')
				notes["note6W"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'PERSIST'):
				SFT06PERSISTsrcfile = reportdata[j].get('srcfile')
				SFT06PERSISTstatus = reportdata[j].get('status')
				notes["note6P"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'OFF'):
				SFT06OFFsrcfile = reportdata[j].get('srcfile')
				SFT06OFFstatus = reportdata[j].get('status')
				notes["note6O"] = (reportdata[j].get('comment')).strip()
			title6 = "<b>SFT-06:</br>" + SFT05WALHeader + "</b></br>"
		#SFT07
		if (key == 'SFT_07_WAL' or key == 'SFT_07_PERSIST' or key == 'SFT_07_OFF'):
#			print(key[7:])
			if (key[7:] == 'WAL'):
				SFT07WALHeader = reportdata[j].get('SFT07')
				SFT07WALoffset = reportdata[j].get('offset')
				SFT07WALrrtname = reportdata[j].get('rrtname')
				notes["note7W"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'PERSIST'):
				SFT07PERSISToffset = reportdata[j].get('offset')
				SFT07PERSISTrrtname = reportdata[j].get('rrtname')
				notes["note7P"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'OFF'):
				SFT07OFFoffset = reportdata[j].get('offset')
				SFT07OFFrrtname = reportdata[j].get('rrtname')
				notes["note7O"] = (reportdata[j].get('comment')).strip()
			title7 = "<b>SFT-07:</br>" + SFT07WALHeader + "</b></br>"
		#SFT08
		if (key == 'SFT_08_WAL' or key == 'SFT_08_PERSIST' or key == 'SFT_08_OFF'):
#			print(key[7:])
			if (key[7:] == 'WAL'):
				SFT08WALHeader = reportdata[j].get('SFT08')
				SFT08WALjournal = reportdata[j].get('journal')
				SFT08WALwaltime = reportdata[j].get('waltime')
				notes["note8W"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'PERSIST'):
				SFT08PERSISTjournal = reportdata[j].get('journal')
				SFT08PERSISTwaltime = reportdata[j].get('waltime')
				notes["note8P"] = (reportdata[j].get('comment')).strip()
			if (key[7:] == 'OFF'):
				SFT08OFFjournal = reportdata[j].get('journal')
				SFT08OFFwaltime = reportdata[j].get('waltime')
				notes["note8O"] = (reportdata[j].get('comment')).strip()
			title8 = "<b>SFT-08:</br>" + SFT08WALHeader + "</b></br>"
	j = j + 1
#write the first sections of the document
html_file = open(htmlfile,'w')

#html_file.write('<!DOCTYPE html>' + '\n')
#html_file.write('<html>' + '\n')
#html_file.write('<body>' + '\n')
html_file.write(head)
html_file.write(report_introduction)
html_file.write(report_read_instructions)

##################
#creates the table for tool information in section 2
#toolname = ''
#toolver = ''
#print(tooldata)
	
#for key in tooldata :
#		value = testcase['ToolDescription'][key]
#	if (key == 'Tool Tested') :
#		toolname = tooldata[key]
		
#	html_file.write('<table style=\"width:100%\" border=\"0\">' + '\n')
#	html_file.write('<tr>' + '\n')
#	html_file.write('<td style=\"width:35%;padding:10px\">'+key+':</td>' + '\n')
#	html_file.write('<td>'+str(tooldata[key])+'</td>' + '\n')
#	html_file.write('</tr>' + '\n')
#	html_file.write('</table>')
	
html_file.write('<table style=\"width:70%\" border=\"0\">' + '\n')
html_file.write('<tr>' + '\n')
#html_file.write('<td style=\"width:35%;padding:10px\">'+key+':</td>' + '\n')
html_file.write('<td style=\"width:35%\">Test Tool: </td>'+'\n')
html_file.write('<td>'+toolname+'</td>'+'\n')
html_file.write('</tr>'+'\n')
html_file.write('<tr>'+'\n')
html_file.write('<td>Tool Version: </td>'+'\n')
html_file.write('<td>'+toolver+'</td>'+'\n')
html_file.write('</tr>'+'\n')
html_file.write('<tr>'+'\n')
html_file.write('<td>Tool Supplier: </td>'+'\n')
html_file.write('<td>'+toolsup+'</td>'+'\n')
html_file.write('</tr>'+'\n')
html_file.write('<tr>'+'\n')
html_file.write('<td>Contact Info: </td>'+'\n')
html_file.write('<td>'+toolcont+'</td>'+'\n')
html_file.write('</tr>'+'\n')
html_file.write('<tr>'+'\n')
html_file.write('<td>Tool Address: </td>'+'\n')
html_file.write('<td>'+tooladd+'</td>'+'\n')
html_file.write('</tr>'+'\n')
html_file.write('<tr>'+'\n')
html_file.write('<td>WWW:</td>'+'\n')
html_file.write('<td>'+toolww+'</td>'+'\n')
html_file.write('</tr>'+'\n')
html_file.write('</table>')


html_file.write(report_section1_header + " " + toolname)
html_file.write(report_section1)

#print(notes); These notes are in the report summary section
rptnotes = {}
index = ""
entry = ""
for key in notes:
#	print("THE VALUES " + val);
	if (notes[key] == "Skipped") or (len(notes[key]) == 0):
#		print("FILTERED " + notes[key])
		index = key
#		print(index)
		#entry = val
	else:
		print("NOTES " + notes[key])
		if ((key == "note1W") or (key == "note1P") or (key == "note1O")) :
			rptnotes["sft01"] = "<p><b>SFT-01 Header Parsing</b></p>"
			rptnotes[key] = "&emsp;"+ notes[key] + "</br>"
		if ((key == "note2W") or (key == "note2P") or (key == "note2O")) :
			rptnotes["sft02"] = "<p><b>SFT-02 Schema Reporting</b></p>"
			rptnotes[key] = "&emsp;" + notes[key] + "</br>"
		if ((key == "note3W") or (key == "note3P") or (key == "note3O")) :
			rptnotes["sft03"] = "<p><b>SFT-03 Recoverable Rows</b></p>"
			rptnotes[key] = "&emsp;" + notes[key] + "</br>"
		if ((key == "note4W") or (key == "note4P") or (key == "note4O")) :
			rptnotes["sft04"] = "<p><b>SFT-04 Data Element Reporting Source File</b></p>"
			rptnotes[key] = "&emsp;" + notes[key] + "</br>"
		if ((key == "note5W") or (key == "note5P") or (key == "note5O")) :
			rptnotes["sft05"] = "<p><b>SFT-05 Schema Data Reporting</b></p>"
			rptnotes[key] = "&emsp;" +notes[key] + "</br>"
		if ((key == "note6W") or (key == "note6P") or (key == "note6O")) :
			rptnotes["sft06"] = "<p><b>SFT-06 Recovered Row Metadata</b></p>"
			rptnotes[key] = "&emsp;" + notes[key] + "</br>"
		if ((key == "note7W") or (key == "note7P") or (key == "note7O")) :
			rptnotes["sft07"] = "<p><b>SFT-07 Recovered Data Information</b></p>"
			rptnotes[key] = "&emsp;" + notes[key] + "</br>"
		if ((key == "note8W") or (key == "note8P") or (key == "note8O")) :
			rptnotes["sft08"] = "<p><b>SFT-08 Journal Sequencing WAL Timelining</b></p>"
			rptnotes[key] = "&emsp;" + notes[key] + "</br>"

#print(len(rptnotes))
print(rptnotes)
html_file.write('<div>')
if len(rptnotes) == 0:
	html_file.write("No notes where entered for the test cases.")
else:
	for key in rptnotes:
		if (key == "sft01"):
			html_file.write(rptnotes["sft01"]); 
		if ((key == "note1W") or (key == "note1P") or (key == "note1O")):
			html_file.write(rptnotes[key]); 
		if (key == "sft02"):
			html_file.write(rptnotes["sft02"]); 
		if ((key == "note2W") or (key == "note2P") or (key == "note2O")):
			html_file.write(rptnotes[key]); 
		if (key == "sft03"):
			html_file.write(rptnotes["sft03"]); 
		if ((key == "note3W") or (key == "note3P") or (key == "note3O")):
			html_file.write(rptnotes[key]);
		if (key == "sft04"):
			html_file.write(rptnotes["sft04"]); 
		if ((key == "note4W") or (key == "note4P") or (key == "note4O")):
			html_file.write(rptnotes[key]); 
		if (key == "sft05"):
			html_file.write(rptnotes["sft05"]); 
		if ((key == "note5W") or (key == "note5P") or (key == "note5O")):
			html_file.write(rptnotes[key]); 
		if (key == "sft06"):
			html_file.write(rptnotes["sft06"]); 
		if ((key == "note6W") or (key == "note6P") or (key == "note6O")):
			html_file.write(rptnotes[key]); 
		if (key == "sft07"):
			html_file.write(rptnotes["sft07"]); 
		if ((key == "note7W") or (key == "note7P") or (key == "note7O")):
			html_file.write(rptnotes[key]); 
		if (key == "sft08"):
			html_file.write(rptnotes["sft08"]); 
		if ((key == "note8W") or (key == "note8P") or (key == "note8O")):
			html_file.write(rptnotes[key]); 

html_file.write('</div>')
#This is the end of the processing of the notes stored in the sqliterptdata.json file. 
#This section prints the test case description table from the file sqlitedata.json.
#The data in this file doesn't change

#html_file.write(report_section2a + " " + toolname)
html_file.write(report_section2a)
html_file.write("The tool " +toolname +" was tested  on this Operating System ")
html_file.write(testenv['Operating System']+ " " + testenv ['OS version']+".")
html_file.write(report_section2b) 
html_file.write(report_section2_data)

#####################
#read contents of json file. Each line holds SQLite describing the testing data which will be  presented in a table
#This data is static and is stored in a json file. 

with open(testcasejson,'r') as json_file:
#    for line in json_file:
#        table = [json.loads(line)]
    table = [json.loads(json_file.read())]
    
#	table = [json.loads(line) for line in json_file]
json_file.close()

#for testcase in table:
#	print(testcase)
#	print(type(testcase))

data = ""
actionlist = ['SFT-01 SQLite Header Parsing','SFT-02 Schema_Reporting', 'SFT-03 SQLite Recoverable Rows', 'SFT-04 SQLite Data Element Metadata', 'SFT-05 SQLite Schema Data Reporting', 'SFT-06 Recovered Row Metadata', 'SFT-07 SQLite Recovered Data Information', 'SFT-08 Journal Sequence-WAL timeline']
html_file.write('<table style=\"width:85%\" border=\"1\">' + '\n')
html_file.write('<th> Test Case </th>')
html_file.write('<th> Data </th>')
for testaction in actionlist:
	for testcase in table:
		for key in testcase[testaction]:
			data = data + key +'<br>'
			#value = testcase['ToolDescription'][key]

		html_file.write('<tr>' + '\n')
		html_file.write('<td style=\"width:35%;padding:10px\">'+testaction+'</td>' + '\n')
		html_file.write('<td><i>'+data+'</i></td>' + '\n')
		html_file.write('</tr>' + '\n')
		data=""
html_file.write('</table>')

html_file.write(report_section3_header + " " + toolname)
html_file.write(report_section3_body + " " + toolname)
html_file.write(report_section3_recovery)
#######################

#TABLE WITH REPORTED DATA. This reads the data from the sqliterptdata.json file.
html_file.write('<table style=\"width:85%\" border=\"1\">' + '\n')
html_file.write('<tr><th> Test Case </th>')
html_file.write('<th> WAL </th>')
html_file.write('<th> PERSIST </th>')
html_file.write('<th> OFF </th></tr>')
#html_file.write('<tr><td> Table Name </td>')	
#SFT01
#html_file.write("<tr><td>"+ SFT01WALHeader + "</td></tr>")
html_file.write("<tr><td>"+title1+"Page Size</td><td>" + SFT01WALpgsize + "</td><td>" +SFT01PERSISTpgsize+ "</td><td>" +SFT01OFFpgsize+ "</td></tr>")
html_file.write("<tr><td>"+title1+"Journal Mode</td><td>" +SFT01WALjmode + "</td><td>" +SFT01PERSISTjmode+ "</td><td>" +SFT01OFFjmode + "</td></tr>")
html_file.write("<tr><td>"+title1+"UTF-8</td><td>" +SFT01WALutf8 + "</td><td>" +SFT01PERSISTutf8+ "</td><td>" +SFT01OFFutf8 + "</td></tr>")
html_file.write("<tr><td>"+title1+"UTF-16BE</td><td>" +SFT01WALutf16be + "</td><td>" +SFT01PERSISTutf16be+ "</td><td>" +SFT01OFFutf16le + "</td></tr>")
html_file.write("<tr><td>"+title1+"UTF-16LE</td><td>" +SFT01WALutf16le + "</td><td>" +SFT01PERSISTutf16le+ "</td><td>" +SFT01OFFutf16le + "</td></tr>")
#SFT02
#html_file.write("<tr><td>"+ SFT02WALHeader + "</td></tr>")
html_file.write("<tr><td>"+title2+"Table Name</td><td>" +SFT02WALtabname + "</td><td>" +SFT02PERSISTtabname+ "</td><td>" +SFT02OFFtabname+ "</td></tr>")
html_file.write("<tr><td>"+title2+"Column Name</td><td>" +SFT02WALcolname + "</td><td>" +SFT02PERSISTcolname + "</td><td>" +SFT02OFFcolname+ "</td></tr>")
html_file.write("<tr><td>"+title2+"Number of Rows</td><td>" +SFT02WALrownum + "</td><td>" +SFT02PERSISTrownum + "</td><td>" +SFT02OFFrownum + "</td></tr>")
#SFT03
#html_file.write("<tr><td>"+ SFT03WALHeader + "</td></tr>")
html_file.write("<tr><td>"+title3+"Deleted</td><td>" +SFT03WALdel + "</td><td>" +SFT03PERSISTdel +"</td><td>" +SFT03OFFdel + "</td><tr>")
html_file.write("<tr><td>"+title3+"Modified</td><td>" +SFT03WALmod + "</td><td>" +SFT03PERSISTmod + "</td><td>" +SFT03OFFmod + "</td><tr>")
#SFT04
#html_file.write("<tr><td>"+ SFT04WALHeader + "</td></tr>")
html_file.write("<tr><td>"+title4+"Deleted</td><td>" +SFT04WALdel + "</td><td>" +SFT04PERSISTdel +"</td><td>" +SFT04OFFdel + "</td><tr>")
html_file.write("<tr><td>"+title4+"Modified</td><td>" +SFT04WALmod + "</td><td>" +SFT04PERSISTmod + "</td><td>" +SFT04OFFmod + "</td><tr>")
#SFT05
#html_file.write("<tr><td>"+ SFT05WALHeader + "</td></tr>")
html_file.write("<tr><td>"+title5+"Primary Key<td>" +SFT05WALprikey + "</td><td>" +SFT05PERSISTprikey+"</td><td>" +SFT05OFFprikey + "</td></tr>")
html_file.write("<tr><td>"+title5+"Int<td>" +SFT05WALint + "</td><td>" +SFT05PERSISTint + "</td><td>" +SFT05OFFint + "</td></tr>")
html_file.write("<tr><td>"+title5+"Float<td>" +SFT05WALfloat + "</td><td>" +SFT05PERSISTfloat +"</td><td>" +SFT05OFFfloat + "</td></tr>")
html_file.write("<tr><td>"+title5+"Text<td>" +SFT05WALtext + "</td><td>" +SFT05PERSISTtext + "</td><td>" +SFT05OFFtext + "</td></tr>")
html_file.write("<tr><td>"+title5+"BLOB<td>" +SFT05WALblob + "</td><td>" +SFT05PERSISTblob +"</td><td>" +SFT05OFFblob + "</td></tr>")
html_file.write("<tr><td>"+title5+"Boolean<td>" +SFT05WALbool + "</td><td>" +SFT05PERSISTbool + "</td><td>" +SFT05OFFbool + "</td></tr>")
#SFT06
#html_file.write("<tr><td>"+ SFT06WALHeader + "</td></tr>")
html_file.write("<tr><td>"+title6+"Source Filename</td><td>" +SFT06WALsrcfile + "</td><td>" +SFT06PERSISTsrcfile +"</td><td>" +SFT06OFFsrcfile + "</td><tr>")
html_file.write("<tr><td>"+title6+"Status: Modified, Deletion</td><td>" +SFT06WALstatus + "</td><td>" +SFT06PERSISTstatus + "</td><td>" +SFT06OFFstatus + "</td><tr>")
#SFT07
#html_file.write("<tr><td>"+ SFT07WALHeader + "</td></tr>")
html_file.write("<tr><td>"+title7+"File offset</td><td>" +SFT07WALoffset + "</td><td>" +SFT07PERSISToffset +"</td><td>" +SFT07OFFoffset + "</td><tr>")
html_file.write("<tr><td>"+title7+"Recovered Row - Table Name</td><td>" +SFT07WALrrtname + "</td><td>" +SFT07PERSISTrrtname + "</td><td>" +SFT07OFFrrtname + "</td><tr>")
#SFT08
#html_file.write("<tr><td>"+ SFT08WALHeader + "</td></tr>")
html_file.write("<tr><td>"+title8+"Jourrnal Sequencing</td><td>" +SFT08WALjournal + "</td><td>" +SFT08PERSISTjournal +"</td><td>" +SFT08OFFjournal + "</td><tr>")
html_file.write("<tr><td>"+title8+"WAL Timelining</td><td>" +SFT08WALwaltime + "</td><td>" +SFT08PERSISTwaltime + "</td><td>" +SFT08OFFwaltime + "</td><tr>")
html_file.write('</table>')

#Test Case Notes
html_file.write('</body>' + '\n')
html_file.write('</html>')
html_file.close()
